/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.navspec;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.refactoring.RefactoringSupport;
import com.ibm.etools.references.services.providers.ProviderArguments;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.URIUtil;
import com.ibm.etools.siteedit.core.Logger;
import com.ibm.etools.siteedit.internal.builder.SiteNavBuilderLogger;
import com.ibm.etools.siteedit.internal.builder.common.HTMLConversionUtil;
import com.ibm.etools.siteedit.internal.builder.navspec.NavspecConverter;
import com.ibm.etools.siteedit.internal.builder.navspec.NavspecModel;
import com.ibm.etools.siteedit.internal.builder.navspec.impl.PageParser;
import com.ibm.etools.siteedit.internal.builder.navspec.tag.MyTagFactory;
import com.ibm.etools.webedit.core.preview.LinkUtils;
import com.ibm.etools.webedit.internal.nodemodelprovider.VirtualModelNodeProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class NavspecModelFactoryImpl {
    private static PageParser parser;
    private static MyTagFactory tagFactory;

    public static NavspecModel create(IFile file, String declaration, String publicId) {
        IStructuredDocument document;
        block9: {
            if (tagFactory == null) {
                tagFactory = new MyTagFactory();
            }
            if (parser == null) {
                parser = new PageParser(tagFactory);
            }
            if ((document = NavspecModelFactoryImpl.getNavspecStructuredDocument(file, declaration, publicId)) != null) break block9;
            return null;
        }
        try {
            if (file != null) {
                try {
                    IMarker[] markers = file.findMarkers("com.ibm.etools.siteedit.SiteNavBuilder.navspecmarker", true, 0);
                    int i = 0;
                    while (i < markers.length) {
                        markers[i].delete();
                        ++i;
                    }
                }
                catch (CoreException e) {
                    SiteNavBuilderLogger.log(e);
                }
            }
            return parser.parse(document, file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static String getAbsoluteLinkText(ILink link, IFile file) {
        EnumSet<ProviderArguments> args = EnumSet.of(ProviderArguments.FORCE_CONTRACT);
        args.add(ProviderArguments.LINKSTYLE_ABSOLUTE);
        String linkText = ReferenceManager.getReferenceManager().expandLinkText(link, args);
        String quoteChar = AbstractWebProvider.getQuoteChar((String)linkText);
        linkText = AbstractWebProvider.trimQuotes((String)linkText);
        IProject orgProject = link.getContainer().getResource().getProject();
        linkText = URIUtil.rename(args, (IProject)orgProject, (String)file.getFullPath().toString(), (String)linkText, (String)linkText, null);
        linkText = ReferenceManager.getReferenceManager().contractLinkText(link, linkText, args);
        if (quoteChar != null) {
            linkText = String.valueOf(quoteChar) + linkText + quoteChar;
        }
        return linkText;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static IStructuredDocument getNavspecStructuredDocument(IFile file, String declaration, String publicId) {
        IDOMModel m = null;
        try {
            if (file == null) return null;
            if (!file.exists()) {
                return null;
            }
            m = HTMLConversionUtil.convertHtml(file, declaration, publicId);
            if (m == null) {
                return null;
            }
            NavspecConverter.convert(m.getStructuredDocument());
            IPath virtualLocation = file.getLocation().removeLastSegments(1).append(UUID.randomUUID().toString().concat(file.getFileExtension()));
            IFile virtualFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(virtualLocation);
            VirtualModelNodeProvider.getInstance().addVirtualModel(virtualFile, (IStructuredModel)m);
            Collection links = ReferenceManager.getReferenceManager().parseLinksOnly((IResource)virtualFile, Collections.singleton("webedit.virtual.core"), null);
            RefactoringSupport support = new RefactoringSupport();
            Iterator iterator = links.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    HashMap<IFile, IStructuredDocument> nameAttributeMap = new HashMap<IFile, IStructuredDocument>();
                    nameAttributeMap.put(virtualFile, m.getStructuredDocument());
                    Change change = support.createDocumentChange("Changing Links Style ", nameAttributeMap);
                    if (change == null) break;
                    change.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
                    PerformChangeOperation op = new PerformChangeOperation(change);
                    try {
                        op.run((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                ILink link = (ILink)iterator.next();
                String analyzeText = link.getLinkText();
                if (analyzeText == null) continue;
                analyzeText = AbstractWebProvider.trimQuotes((String)analyzeText);
                if (LinkUtils.getTagOfLink((ILink)link).compareToIgnoreCase("taglib") == 0 || analyzeText.indexOf("${") != -1 && analyzeText.indexOf(125) != -1) continue;
                String linkText = NavspecModelFactoryImpl.getAbsoluteLinkText(link, file);
                support.createLinkTextReplaceEdits(link, linkText);
            }
            VirtualModelNodeProvider.getInstance().removeVirualModel(virtualFile);
            IStructuredDocument iStructuredDocument = m.getStructuredDocument();
            return iStructuredDocument;
        }
        catch (Exception e) {
            Logger.log(e);
            return null;
        }
        finally {
            if (m != null) {
                m.releaseFromEdit();
            }
        }
    }
}

