/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.navmenuscript;

import com.ibm.etools.siteedit.internal.builder.common.TagAttrImpl;
import com.ibm.etools.siteedit.internal.builder.model.NavElement;
import com.ibm.etools.siteedit.internal.builder.navmenuscript.NavMenuScriptConstants;
import com.ibm.etools.siteedit.internal.builder.site.bean.SiteNav;
import com.ibm.etools.siteedit.internal.builder.site.bean.SiteNavItem;
import com.ibm.etools.siteedit.sitetags.model.SiteTagStrings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NavMenuScriptMaker
extends NavMenuScriptConstants {
    private static String LINE_DEL = "\n";
    private static String LINE_IND = "\t\t";
    private static String ID_SEP = "-";
    private static String EMPTY = "";
    private String navMenuId;
    private String type;
    private boolean includeTop;
    private boolean keepSelection;
    private int menuDepth;
    private SiteNavItem[] navItems;
    private TagAttrImpl args;
    private List firstLevelItems;
    private List secondLevelItems;
    private String initialId;

    public NavMenuScriptMaker(NavElement node, String id, SiteNav bean, int depth) {
        this.navItems = (SiteNavItem[])bean.getItems();
        this.navMenuId = id;
        this.menuDepth = depth;
        this.keepSelection = false;
        this.args = new TagAttrImpl();
        this.setScriptArgument(node);
        this.firstLevelItems = new ArrayList();
        this.secondLevelItems = new ArrayList();
    }

    private void setScriptArgument(NavElement node) {
        if (node == null) {
            return;
        }
        this.includeTop = node.getAttr("includeTop").equals(SiteTagStrings.TRUE);
        this.type = node.getAttr("type");
        if (this.type.equals("verticalMenu")) {
            this.args.put("vertical", JS_VAL_TRUE);
        } else {
            this.args.put("vertical", JS_VAL_FALSE);
        }
        if (this.type.equals("tabbedMenu")) {
            this.args.put("vertical-body", JS_VAL_FALSE);
        } else {
            this.args.put("vertical-body", JS_VAL_TRUE);
        }
        String attrVal = node.getAttr("keepSelection");
        if (attrVal.equals(SiteTagStrings.TRUE)) {
            this.keepSelection = true;
            this.args.put("open-sticky", JS_VAL_TRUE);
        } else if (attrVal.equals(SiteTagStrings.FALSE)) {
            this.args.put("open-sticky", JS_VAL_FALSE);
        } else if (this.type.equals("tabbedMenu")) {
            this.args.put("open-sticky", JS_VAL_TRUE);
            this.keepSelection = true;
        } else {
            this.args.put("open-sticky", JS_VAL_FALSE);
        }
    }

    public List getMenuItems(int level) {
        if (level == 1) {
            return this.firstLevelItems;
        }
        if (level == 2) {
            return this.secondLevelItems;
        }
        return null;
    }

    public int getInitialIdx() {
        int initialIdx;
        if (this.initialId == null) {
            return 1;
        }
        this.initialId = this.initialId.trim();
        String idx = this.initialId.substring(this.initialId.length() - 1);
        try {
            initialIdx = Integer.parseInt(idx);
        }
        catch (NumberFormatException numberFormatException) {
            initialIdx = 1;
        }
        return initialIdx;
    }

    public String eval() {
        StringBuffer script = new StringBuffer();
        if (this.menuDepth > 0 || this.includeTop) {
            StringBuffer firstLevel = new StringBuffer();
            StringBuffer firstMenuItems = new StringBuffer();
            StringBuffer lowerLevel = new StringBuffer();
            String itemId = String.valueOf(this.navMenuId) + ID_SEP + "0";
            this.initialId = this.makeNewId(this.navMenuId);
            boolean setInitialId = false;
            int begin = 0;
            firstLevel.append(this.replaceArgs("hX_4.addS(\"${ITEMID}\", \"${ITEMID}-F\", new hX_4.J_MI(\"separator\"));", this.navMenuId));
            if (this.includeTop) {
                if (this.navItems[0] != null) {
                    firstMenuItems.append(this.addFirstLevelMenuItem(this.navItems[0]));
                    itemId = this.addId(itemId);
                }
                begin = 1;
            }
            if (this.menuDepth > 0) {
                while (begin < this.navItems.length && this.navItems[begin] == null) {
                    ++begin;
                }
                if (begin < this.navItems.length) {
                    int prev = begin;
                    int startDepth = this.navItems[begin].getDepth();
                    int i = begin;
                    while (i < this.navItems.length) {
                        if (this.navItems[i] == null) {
                            lowerLevel.append(this.generateSubMenuScript(prev + 1, i - 1, startDepth, itemId));
                            startDepth = this.navItems[++i].getDepth();
                            prev = i;
                        }
                        if (this.navItems[i].getDepth() == startDepth) {
                            lowerLevel.append(this.generateSubMenuScript(prev + 1, i - 1, startDepth, itemId));
                            if (!this.type.equals("tabbedMenu") || !this.navItems[i].isGroup()) {
                                itemId = this.addId(itemId);
                                firstMenuItems.append(this.addFirstLevelMenuItem(this.navItems[i]));
                                if (!setInitialId && this.navItems[i].isAncestor() && !this.navItems[i].isGroup()) {
                                    this.initialId = itemId;
                                    setInitialId = true;
                                }
                            }
                            prev = i;
                        }
                        ++i;
                    }
                    lowerLevel.append(this.generateSubMenuScript(prev + 1, this.navItems.length - 1, startDepth, itemId));
                }
            }
            firstLevel.append(this.createSubMenuFunc(firstMenuItems, this.navMenuId));
            firstLevel.append(this.replaceArgs("hX_4.addS(\"${ITEMID}\", \"${ITEMID}-L\", new hX_4.J_MI(\"separator\"));", this.navMenuId));
            this.setInitialId();
            String initializeMenu = this.replaceArgs("hX_4.add(\"${MENUID}\", new hX_4.J_M(${ARG}));");
            script.append(this.replaceArgs("document.getElementById(\"${MENUID}\").innerHTML=\" \";"));
            if (this.type.equals("tabbedMenu") && this.keepSelection && this.menuDepth > 1) {
                script.append(this.replaceArgs("document.getElementById(\"${MENUID}_2\").innerHTML=\" \";"));
            }
            script.append(initializeMenu);
            script.append(firstLevel);
            script.append(lowerLevel);
        }
        return script.toString();
    }

    private String addFirstLevelMenuItem(SiteNavItem navItem) {
        this.firstLevelItems.add(navItem);
        return this.createMenuItemFunc(navItem);
    }

    private String generateSubMenuScript(int beginIdx, int endIdx, int initialDepth, String itemId) {
        if (beginIdx > endIdx) {
            return EMPTY;
        }
        int previousDepth = 0;
        boolean isInitialSel = itemId.equals(this.initialId);
        String countId = itemId;
        String[] id = new String[this.menuDepth];
        id[0] = itemId;
        StringBuffer[] items = new StringBuffer[this.menuDepth];
        StringBuffer subMenuScript = new StringBuffer();
        if (isInitialSel) {
            this.secondLevelItems.clear();
        }
        int i = beginIdx;
        while (i <= endIdx) {
            int depth = this.navItems[i].getDepth() - initialDepth;
            if (depth > previousDepth) {
                id[depth] = this.makeNewId(id[previousDepth]);
                items[depth] = new StringBuffer();
                this.addLowerLevelMenuItems(items, depth, i, isInitialSel);
            } else if (depth == previousDepth) {
                id[depth] = this.addId(id[depth]);
                this.addLowerLevelMenuItems(items, depth, i, isInitialSel);
            } else {
                int j = depth + 1;
                while (j <= previousDepth) {
                    String subMenuFunc = this.createSubMenuFunc(items[j], id[j - 1]);
                    if (countId.length() > id[j - 1].length()) {
                        subMenuScript.insert(0, subMenuFunc);
                    } else {
                        subMenuScript.append(subMenuFunc);
                    }
                    countId = id[j - 1];
                    ++j;
                }
                id[depth] = this.addId(id[depth]);
                this.addLowerLevelMenuItems(items, depth, i, isInitialSel);
            }
            previousDepth = depth;
            ++i;
        }
        i = this.navItems[endIdx].getDepth() - initialDepth;
        while (i > 0) {
            subMenuScript.insert(0, this.createSubMenuFunc(items[i], id[i - 1]));
            --i;
        }
        return subMenuScript.toString();
    }

    private void addLowerLevelMenuItems(StringBuffer[] items, int depth, int index, boolean isInitialSel) {
        items[depth].append(this.createMenuItemFunc(this.navItems[index]));
        if (isInitialSel && depth == 1) {
            this.secondLevelItems.add(this.navItems[index]);
        }
    }

    private String createMenuItemFunc(SiteNavItem navItem) {
        String replacement = EMPTY;
        if (navItem != null) {
            if (navItem.isGroup()) {
                replacement = "sep:" + navItem.getLabel();
            } else {
                replacement = "lab:" + navItem.getLabel();
                String href = navItem.getHref();
                if (!href.equals("#")) {
                    replacement = String.valueOf(replacement) + this.replaceString("\",\"action:goto\",\"target:url('${URL}')", "${URL}", href);
                }
            }
        }
        return this.replaceString(" new hX_4.J_MI(\"${LABEL}\"),", "${LABEL}", replacement);
    }

    private String createSubMenuFunc(StringBuffer items, String parentId) {
        if ((items = this.exceptComma(items)).length() > 0) {
            String function = this.replaceString("hX_4.addS(\"${ITEMID}\", [${ITEM}]);", "${ITEM}", items.toString());
            function = this.replaceArgs(function, parentId);
            return function;
        }
        return EMPTY;
    }

    private StringBuffer exceptComma(StringBuffer items) {
        if (items.length() > 0) {
            items.deleteCharAt(items.length() - 1);
        }
        return items;
    }

    private String makeNewId(String oldId) {
        oldId = String.valueOf(oldId) + ID_SEP + "1";
        return oldId;
    }

    private String addId(String id) {
        int idx = id.lastIndexOf(ID_SEP) + 1;
        String prefix = id.substring(0, idx);
        String suffix = id.substring(idx);
        int count = Integer.parseInt(suffix) + 1;
        return String.valueOf(prefix) + Integer.toString(count);
    }

    private void setInitialId() {
        if (this.args.get("open-sticky").equals(JS_VAL_TRUE)) {
            this.args.put("initial-selection", this.initialId);
        } else {
            this.initialId = "1";
        }
    }

    private String replaceArgs(String funcName) {
        return this.replaceArgs(funcName, EMPTY);
    }

    private String replaceArgs(String funcName, String itemId) {
        int contIdx = 0;
        int startIdx = funcName.indexOf("${");
        while (startIdx > -1) {
            startIdx = contIdx + startIdx;
            int endIdx = funcName.indexOf("}");
            if (endIdx < startIdx) {
                return funcName;
            }
            String key = funcName.substring(startIdx, endIdx + 1);
            String replacement = EMPTY;
            if (key.equals("${MENUID}")) {
                replacement = this.navMenuId;
            }
            if (key.equals("${ARG}")) {
                Collection coll = this.args.getNames();
                for (String arg : coll) {
                    String val = this.args.get(arg);
                    replacement = String.valueOf(replacement) + "\"" + arg + ":" + val + "\",";
                }
                if (replacement.endsWith(",")) {
                    replacement = replacement.substring(0, replacement.length() - 1);
                }
            }
            if (key.equals("${ITEMID}")) {
                replacement = itemId;
            }
            if (!replacement.equals(EMPTY)) {
                funcName = String.valueOf(funcName.substring(0, startIdx)) + replacement + funcName.substring(endIdx + 1);
                contIdx = startIdx + replacement.length();
            } else {
                contIdx = endIdx + 1;
            }
            startIdx = funcName.substring(contIdx).indexOf("${");
        }
        return String.valueOf(LINE_IND) + funcName + LINE_DEL;
    }

    private String replaceString(String source, String before, String after) {
        int startIdx = source.indexOf(before);
        int contIdx = startIdx + before.length();
        return String.valueOf(source.substring(0, startIdx)) + after + source.substring(contIdx);
    }
}

