/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.model;

import com.ibm.etools.siteedit.internal.builder.SiteNavBuilderLogger;
import com.ibm.etools.siteedit.internal.builder.SiteNavException;
import com.ibm.etools.siteedit.internal.builder.SiteNavMessages;
import com.ibm.etools.siteedit.internal.builder.model.NavElement;
import com.ibm.etools.siteedit.internal.builder.model.SitePageContext;
import com.ibm.etools.siteedit.internal.builder.model.SitePageModelTaglibSupport;
import com.ibm.etools.siteedit.internal.builder.model.SitePageModelUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class SitePageStructuredModel
extends SitePageModelTaglibSupport {
    protected IStructuredModel strucModel;
    private IFile file;
    protected ArrayList tagReplacer;
    protected ArrayList customTagReplacer;

    public SitePageStructuredModel(IStructuredModel strucModel, IFile file) {
        this.strucModel = strucModel;
        this.file = file;
        this.load();
    }

    private void load() {
        NavElement.Factory navElementFactory = NavElement.getFactory(this.file);
        if (this.tagReplacer != null && this.customTagReplacer != null) {
            throw new RuntimeException();
        }
        this.tagReplacer = new ArrayList();
        this.customTagReplacer = new ArrayList();
        try {
            Node node;
            IDOMModel xml = (IDOMModel)this.strucModel;
            IDOMDocument doc = xml.getDocument();
            NodeIterator it = ((DocumentTraversal)doc).createNodeIterator((Node)doc, 1, null, true);
            while ((node = it.nextNode()) != null) {
                Element elm;
                NavElement ne;
                if (node.getNodeType() != 1 || (ne = navElementFactory.create(elm = (Element)node)) == null) continue;
                this.tagReplacer.add(new NavTagReplacer(elm, ne));
            }
        }
        catch (ClassCastException classCastException) {}
    }

    @Override
    public SitePageContext.Writer getWriter() {
        return new MyWriter();
    }

    public int getLength() {
        return this.tagReplacer.size();
    }

    @Override
    public NavElement commentTagItem(int i) throws IndexOutOfBoundsException {
        return ((NavTagReplacer)this.tagReplacer.get(i)).getNavTag();
    }

    @Override
    public NavElement customTagItem(int i) throws IndexOutOfBoundsException {
        return ((NavTagReplacer)this.customTagReplacer.get(i)).getNavTag();
    }

    @Override
    public int getCommentTagLength() {
        if (this.tagReplacer != null) {
            return this.tagReplacer.size();
        }
        return 0;
    }

    @Override
    public int getCustomTagLength() {
        if (this.customTagReplacer != null) {
            return this.customTagReplacer.size();
        }
        return 0;
    }

    @Override
    public boolean write() throws SiteNavException {
        SitePageStructuredModel.execUpdate(this);
        return true;
    }

    @Override
    public void dispose() {
        this.strucModel.releaseFromEdit();
        this.strucModel = null;
    }

    private static void execUpdate(SitePageStructuredModel model) {
        SitePageStructuredModel mySiteModel = model;
        Display dsp = Display.getCurrent();
        if (dsp == null) {
            dsp = Display.getDefault();
        }
        dsp.syncExec(new Runnable(){

            @Override
            public void run() {
                SitePageStructuredModel.this.update();
            }
        });
    }

    protected synchronized void update() {
        boolean isModified = false;
        this.strucModel.aboutToChangeModel();
        int i = 0;
        while (i < this.getLength()) {
            boolean result = ((NavTagReplacer)this.tagReplacer.get(i)).replace();
            if (result) {
                isModified = true;
            }
            ++i;
        }
        this.strucModel.changedModel();
        if (!isModified) {
            return;
        }
        IDOMModel model = (IDOMModel)this.strucModel;
        ByteArrayOutputStream os = new ByteArrayOutputStream(model.getStructuredDocument().getLength());
        try {
            model.save((OutputStream)os);
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            os.close();
            if (this.file.exists()) {
                this.file.setContents((InputStream)is, true, false, null);
            } else {
                this.file.create((InputStream)is, true, null);
            }
            is.close();
        }
        catch (Exception e) {
            SiteNavBuilderLogger.log(SiteNavMessages.format1(SiteNavMessages.ERROR_CONTENT_NOT_SET1, this.file.getFullPath().toString()));
            SiteNavBuilderLogger.log(e);
            SitePageModelUtil.recoverErrorInSavingModel(this.file, model.getStructuredDocument());
        }
    }

    @Override
    public String getBaseHref() {
        throw new RuntimeException();
    }

    @Override
    public String getDeclaration() {
        throw new RuntimeException();
    }

    @Override
    public String getPublicId() {
        throw new RuntimeException();
    }

    @Override
    public boolean hasNavbar() {
        throw new RuntimeException();
    }

    @Override
    public String getPageTemplate() {
        throw new RuntimeException();
    }

    @Override
    public boolean isTemplate() {
        throw new RuntimeException();
    }

    @Override
    protected IStructuredDocument getFlatModelForTaglib() {
        return this.strucModel.getStructuredDocument();
    }

    static class MyNodeListImpl
    implements NodeList {
        private ArrayList nodes = new ArrayList();

        MyNodeListImpl() {
        }

        public void append(Node node) {
            this.nodes.add(node);
        }

        @Override
        public Node item(int index) {
            return (Node)this.nodes.get(index);
        }

        @Override
        public int getLength() {
            return this.nodes.size();
        }
    }

    class MyWriter
    implements SitePageContext.Writer {
        private MyNodeListImpl current;

        MyWriter() {
        }

        @Override
        public void out(String s) {
            throw new RuntimeException("Not Implemented.");
        }

        @Override
        public void commit(int index) {
            ((NavTagReplacer)SitePageStructuredModel.this.tagReplacer.get(index)).setReplaceNodes(this.current);
            this.current = null;
        }

        @Override
        public void refresh() {
            this.current = null;
        }

        @Override
        public boolean isDirty() {
            return this.current != null;
        }
    }

    static class NavTagReplacer {
        private NavElement element;
        private Element targetElement;
        private NodeList toReplace;

        public NavTagReplacer(Element target, NavElement elm) {
            this.element = elm;
            this.targetElement = target;
        }

        public NavElement getNavTag() {
            return this.element;
        }

        /*
         * Unable to fully structure code
         */
        public boolean replace() {
            if (this.toReplace != null && this.toReplace.getLength() != 0) ** GOTO lbl5
            return false;
lbl-1000:
            // 1 sources

            {
                this.targetElement.removeChild(this.targetElement.getFirstChild());
lbl5:
                // 2 sources

                ** while (this.targetElement.hasChildNodes())
            }
lbl6:
            // 1 sources

            nNode = this.toReplace.getLength();
            i = 0;
            while (i < nNode) {
                this.targetElement.appendChild(this.toReplace.item(i));
                ++i;
            }
            return true;
        }

        public void setReplaceNodes(NodeList nodes) {
            this.toReplace = nodes;
        }
    }
}

