/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.model;

import com.ibm.etools.siteedit.core.Logger;
import com.ibm.etools.siteedit.internal.builder.SiteNavException;
import com.ibm.etools.siteedit.internal.builder.model.SitePageCachedModel;
import com.ibm.etools.siteedit.internal.builder.model.SitePageCachedModelEntry;
import com.ibm.etools.siteedit.internal.builder.model.SitePageFlatModel;
import com.ibm.etools.siteedit.internal.builder.model.SitePageModel;
import com.ibm.etools.siteedit.internal.builder.model.SitePageModelTaglibSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public final class SitePageModelFactory
implements Serializable {
    private static final long serialVersionUID = -6473750725585658420L;
    private InstanceCache instanceCache = new InstanceCache();

    public SitePageModel crate(IFile file) {
        return this.crate(file, false);
    }

    public SitePageModel crate(IFile file, boolean ignoreCache) {
        SitePageCachedModelEntry cachedItem;
        SitePageModelTaglibSupport result;
        block7: {
            try {
                result = null;
                if (file.exists()) break block7;
                this.instanceCache.remove(file);
                return null;
            }
            catch (SiteNavException siteNavException) {
                return null;
            }
        }
        if (!ignoreCache && (cachedItem = this.instanceCache.get(file)) != null && cachedItem.isValid()) {
            try {
                result = new SitePageCachedModel(cachedItem, this);
            }
            catch (IllegalStateException e) {
                this.instanceCache.remove(file);
                Logger.log(e);
            }
        }
        if (result == null) {
            result = new SitePageFlatModel(file, this);
        }
        return result;
    }

    public boolean hasNav(IFile file) {
        SitePageCachedModelEntry cachedItem = this.instanceCache.get(file);
        if (cachedItem != null && cachedItem.isValid()) {
            return cachedItem.hasNav;
        }
        boolean result = false;
        SitePageModel pageModel = this.crate(file, true);
        if (pageModel != null) {
            result = pageModel.hasNavbar();
            pageModel.dispose();
        }
        return result;
    }

    public String internalGetPageTemplate(IFile file) {
        SitePageCachedModelEntry cachedItem = this.instanceCache.get(file);
        if (cachedItem != null && cachedItem.isValid()) {
            return cachedItem.pageTemplate;
        }
        String result = "";
        SitePageModel pageModel = this.crate(file, true);
        if (pageModel != null) {
            result = pageModel.getPageTemplate();
            pageModel.dispose();
        }
        return result;
    }

    public boolean internalIsTemplate(IFile file) {
        SitePageCachedModelEntry cachedItem = this.instanceCache.get(file);
        if (cachedItem != null && cachedItem.isValid()) {
            return cachedItem.isTemplate;
        }
        boolean result = false;
        SitePageModel pageModel = this.crate(file, true);
        if (pageModel != null) {
            result = pageModel.isTemplate();
            pageModel.dispose();
        }
        return result;
    }

    public void clear(IProject project) {
        this.instanceCache.clear(project);
    }

    public void clear() {
        this.instanceCache.clear();
    }

    public int getSize() {
        return this.instanceCache.getSize();
    }

    public void refine() {
        this.instanceCache.refine();
    }

    void setCache(SitePageCachedModelEntry entry) {
        this.instanceCache.setCache(entry);
    }

    private static final class InstanceCache
    implements Serializable {
        private static final long serialVersionUID = 419842790679525140L;
        private transient Map instanceCache = Collections.synchronizedMap(new HashMap());

        private InstanceCache() {
        }

        public void setCache(SitePageCachedModelEntry e) {
            this.instanceCache.put(e.getFile(), e);
        }

        public void remove(IFile file) {
            this.instanceCache.remove(file);
        }

        public SitePageCachedModelEntry get(IFile file) {
            return (SitePageCachedModelEntry)this.instanceCache.get(file);
        }

        public void clear() {
            this.instanceCache.clear();
        }

        public void clear(IProject project) {
            Map.Entry[] entries = this.getItems();
            int i = 0;
            while (i < entries.length) {
                Map.Entry entry = entries[i];
                if (project.equals((Object)((IFile)entry.getKey()).getProject())) {
                    this.instanceCache.remove(entry.getKey());
                }
                ++i;
            }
        }

        public void refine() {
            Map.Entry[] entries = this.getItems();
            int i = 0;
            while (i < entries.length) {
                Map.Entry entry = entries[i];
                SitePageCachedModelEntry e = (SitePageCachedModelEntry)entry.getValue();
                if (!e.isValid()) {
                    this.instanceCache.remove(entry.getKey());
                }
                ++i;
            }
        }

        private Map.Entry[] getItems() {
            Set entrySet = this.instanceCache.entrySet();
            return entrySet.toArray(new Map.Entry[entrySet.size()]);
        }

        private void writeObject(ObjectOutputStream os) throws IOException {
            os.defaultWriteObject();
            os.writeInt(this.instanceCache.size());
            for (SitePageCachedModelEntry entry : this.instanceCache.values()) {
                os.writeObject(entry);
            }
        }

        private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
            is.defaultReadObject();
            if (this.instanceCache == null) {
                this.instanceCache = new HashMap();
            }
            int size = is.readInt();
            int i = 0;
            while (i < size) {
                this.setCache((SitePageCachedModelEntry)is.readObject());
                ++i;
            }
        }

        public int getSize() {
            return this.instanceCache == null ? 0 : this.instanceCache.size();
        }
    }
}

