/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.model;

import com.ibm.etools.siteedit.core.Logger;
import com.ibm.etools.siteedit.internal.builder.SiteNavException;
import com.ibm.etools.siteedit.internal.builder.common.TagParser;
import com.ibm.etools.siteedit.internal.builder.model.NavElement;
import com.ibm.etools.siteedit.internal.builder.model.SiteNavReadOnlyException;
import com.ibm.etools.siteedit.internal.builder.model.SitePageCachedModelEntry;
import com.ibm.etools.siteedit.internal.builder.model.SitePageContext;
import com.ibm.etools.siteedit.internal.builder.model.SitePageModel;
import com.ibm.etools.siteedit.internal.builder.model.SitePageModelFactory;
import com.ibm.etools.siteedit.internal.builder.model.SitePageModelTaglibSupport;
import com.ibm.etools.siteedit.internal.core.util.SiteModelUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.utils.StringUtils;

public class SitePageCachedModel
extends SitePageModelTaglibSupport {
    static final int READ_BUFFER_SIZE = 4096;
    static final String XML_COMMENT_START = "<!--";
    static final String XML_COMMENT_END = "-->";
    static final int XML_COMMENT_START_LENGTH = "<!--".length();
    static final int XML_COMMENT_END_LENGTH = "-->".length();
    private final SitePageModelFactory modelFactorty;
    private final SitePageCachedModelEntry cachedData;
    private final String currentFileContent;
    final ArrayList tagReplacer;
    final ArrayList customTagReplacer;
    private SitePageModel flatModel;
    private String newContent;
    SitePageCachedModelEntry.NavTagItem[] tagCache;
    SitePageCachedModelEntry.CustomNavTagItem[] customTagCache;

    public SitePageCachedModel(SitePageCachedModelEntry cachedData, SitePageModelFactory modelFactory) throws IllegalStateException, SiteNavException {
        this.modelFactorty = modelFactory;
        if (cachedData == null || !cachedData.isValid()) {
            throw new IllegalStateException("Given cached data is obsolete.");
        }
        this.cachedData = cachedData;
        this.currentFileContent = this.loadContent();
        this.tagReplacer = new ArrayList();
        this.customTagReplacer = new ArrayList();
        this.load();
    }

    private void load() {
        IFile file = this.cachedData.getFile();
        NavElement.Factory elementFactory = new NavElement.Factory(file);
        int navTagSize = this.cachedData.navTags.length;
        if (this.cachedData.navTags != null) {
            int i = 0;
            while (i < navTagSize) {
                SitePageCachedModelEntry.NavTagItem item = this.cachedData.navTags[i];
                String contents = item.getInnerText();
                NavElement element = elementFactory.create(contents, item.getStartStartPosition(), item.getLineNum(), item.getLength());
                if (element == null || element.getAllAttr().isEmpty()) {
                    return;
                }
                String innerText = null;
                innerText = item.startstart == item.endstart ? TagParser.getCommentTagContents(contents) : this.currentFileContent.substring(item.getStartEndPosition(), item.getEndStartPosition());
                this.tagReplacer.add(new NavTagReplacer(innerText, element));
                if (!(this.currentFileContent.startsWith(XML_COMMENT_START, item.startstart) && this.currentFileContent.startsWith(XML_COMMENT_END, item.startend - XML_COMMENT_END_LENGTH) && this.currentFileContent.startsWith(XML_COMMENT_START, item.endstart) && this.currentFileContent.startsWith(XML_COMMENT_END, item.endend - XML_COMMENT_END_LENGTH))) {
                    throw new IllegalStateException();
                }
                ++i;
            }
        }
        int customTagSize = this.cachedData.customNavTags.length;
        if (this.cachedData.customNavTags != null) {
            int i = 0;
            while (i < customTagSize) {
                SitePageCachedModelEntry.CustomNavTagItem item = this.cachedData.customNavTags[i];
                String innerText = item.getInnerText();
                NavElement element = elementFactory.createJspnav(this.getJspnavPrefix(), innerText, item.startstart, item.getLineNum(), item.getLength());
                this.customTagReplacer.add(new NavTagReplacer(innerText, element));
                ++i;
            }
        }
    }

    private ArrayList sortOneArray(SitePageCachedModelEntry.NavTagItem[] commentItems, SitePageCachedModelEntry.CustomNavTagItem[] customItems) {
        int commentItemNum = commentItems.length;
        int customItemNum = customItems.length;
        ArrayList<NavTagItems> list = new ArrayList<NavTagItems>();
        if (commentItemNum == 0) {
            if (customItemNum == 0) {
                return list;
            }
            int i = 0;
            while (i < customItemNum) {
                list.add(new NavTagItems(i, 0, customItems[i]));
                ++i;
            }
            return list;
        }
        if (customItemNum == 0) {
            int i = 0;
            while (i < commentItemNum) {
                list.add(new NavTagItems(i, 1, commentItems[i]));
                ++i;
            }
            return list;
        }
        int[] commentPosition = this.createPositionArray(commentItems);
        int[] customPosition = this.createPositionArray(customItems);
        int j = 0;
        int i = 0;
        while (i < commentItemNum && j < customItemNum) {
            if (commentPosition[i] < customPosition[j]) {
                list.add(new NavTagItems(i, 1, commentItems[i]));
                ++i;
                continue;
            }
            list.add(new NavTagItems(j, 0, customItems[j]));
            ++j;
        }
        while (i < commentItemNum) {
            list.add(new NavTagItems(i, 1, commentItems[i]));
            ++i;
        }
        while (j < customItemNum) {
            list.add(new NavTagItems(j, 0, customItems[j]));
            ++j;
        }
        return list;
    }

    private int[] createPositionArray(Object[] items) {
        int[] positions = new int[items.length];
        if (items[0] instanceof SitePageCachedModelEntry.NavTagItem) {
            int i = 0;
            while (i < items.length) {
                positions[i] = ((SitePageCachedModelEntry.NavTagItem)items[i]).startstart;
                ++i;
            }
            return positions;
        }
        if (items[0] instanceof SitePageCachedModelEntry.CustomNavTagItem) {
            int i = 0;
            while (i < items.length) {
                positions[i] = ((SitePageCachedModelEntry.CustomNavTagItem)items[i]).startstart;
                ++i;
            }
            return positions;
        }
        return new int[0];
    }

    private String loadContent() throws SiteNavException {
        String string;
        StringBuffer content = new StringBuffer();
        InputStream is = this.cachedData.getFile().getContents();
        try {
            int nBuf;
            if (this.cachedData.encoding.useUTF83BytesBOM) {
                is.skip(3L);
            }
            InputStreamReader reader = new InputStreamReader(is, this.cachedData.encoding.javaEncoding);
            char[] buf = new char[4096];
            while (-1 != (nBuf = reader.read(buf, 0, buf.length))) {
                content.append(buf, 0, nBuf);
            }
            reader.close();
            string = content.toString();
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (CoreException e) {
                throw new SiteNavException(e.getLocalizedMessage());
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e.getLocalizedMessage());
            }
            catch (IOException e) {
                throw new SiteNavException(e.getLocalizedMessage());
            }
        }
        is.close();
        return string;
    }

    @Override
    public String getBaseHref() {
        return this.cachedData.baseHref;
    }

    @Override
    public String getDeclaration() {
        return this.cachedData.declaration;
    }

    @Override
    public String getPublicId() {
        return this.cachedData.publicId;
    }

    @Override
    public boolean hasNavbar() {
        return this.cachedData.hasNav;
    }

    @Override
    public String getPageTemplate() {
        return this.cachedData.pageTemplate;
    }

    @Override
    public boolean isTemplate() {
        return this.cachedData.isTemplate;
    }

    @Override
    public NavElement commentTagItem(int i) throws IndexOutOfBoundsException {
        NavTagReplacer repl = (NavTagReplacer)this.tagReplacer.get(i);
        return repl.getNavTag();
    }

    @Override
    public NavElement customTagItem(int i) throws IndexOutOfBoundsException {
        NavTagReplacer repl = (NavTagReplacer)this.customTagReplacer.get(i);
        return repl.getNavTag();
    }

    @Override
    public int getCommentTagLength() {
        if (this.tagReplacer != null) {
            return this.tagReplacer.size();
        }
        return 0;
    }

    @Override
    public int getCustomTagLength() {
        if (this.customTagReplacer != null) {
            return this.customTagReplacer.size();
        }
        return 0;
    }

    @Override
    public void dispose() {
        if (this.flatModel != null) {
            this.flatModel.dispose();
            this.flatModel = null;
        }
    }

    @Override
    public SitePageContext.Writer getWriter() {
        return new MyWriter(this.cachedData.lineDelimiter);
    }

    @Override
    public boolean write() throws SiteNavException {
        SitePageCachedModel.execUpdate(this);
        if (this.newContent == null) {
            return false;
        }
        if (this.cachedData.getFile().isReadOnly()) {
            throw new SiteNavReadOnlyException();
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)bos, this.cachedData.encoding.javaEncoding);
            osw.write(this.newContent);
            osw.close();
            byte[] content = bos.toByteArray();
            if (this.cachedData.encoding.useUTF83BytesBOM) {
                byte[] rawContent = content;
                content = new byte[rawContent.length + 3];
                content[0] = -17;
                content[1] = -69;
                content[2] = -65;
                System.arraycopy(rawContent, 0, content, 3, rawContent.length);
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(content);
            this.cachedData.getFile().setContents((InputStream)bis, false, false, null);
            this.modelFactorty.setCache(this.cachedData.update(this.tagCache, this.customTagCache));
            return true;
        }
        catch (UnsupportedEncodingException e) {
            Logger.log(e);
            throw new RuntimeException(e.getLocalizedMessage());
        }
        catch (IOException e) {
            Logger.log(e);
            throw new RuntimeException(e.getLocalizedMessage());
        }
        catch (CoreException e) {
            Logger.log(e);
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    protected void doGetNewContent() {
        StringBuffer newFileContent = null;
        SitePageCachedModelEntry.NavTagItem[] commentItems = this.cachedData.navTags;
        SitePageCachedModelEntry.CustomNavTagItem[] customItems = this.cachedData.customNavTags;
        this.tagCache = new SitePageCachedModelEntry.NavTagItem[commentItems.length];
        this.customTagCache = new SitePageCachedModelEntry.CustomNavTagItem[customItems.length];
        ArrayList list = this.sortOneArray(commentItems, customItems);
        int bookmark = 0;
        int diff = 0;
        int addedLineNum = 0;
        int i = 0;
        while (i < list.size()) {
            NavTagItems item = (NavTagItems)list.get(i);
            NavTagReplacer repl = this.findReplacer(item);
            SitePageCachedModelEntry.NavTag navTag = this.findNavTag(item);
            int pos = item.arrayPosition;
            if (repl.isModified()) {
                if (newFileContent == null) {
                    newFileContent = new StringBuffer();
                }
                newFileContent.append(this.currentFileContent.substring(bookmark, navTag.getStartEndPosition()));
                String newGeneratedContent = repl.toReplace;
                newFileContent.append(newGeneratedContent);
                bookmark = navTag.getEndStartPosition();
                int newDiff = newFileContent.length() - bookmark;
                String oldGeneratedContent = this.currentFileContent.substring(navTag.getStartEndPosition(), navTag.getEndStartPosition());
                if (navTag instanceof SitePageCachedModelEntry.NavTagItem) {
                    this.tagCache[pos] = (SitePageCachedModelEntry.NavTagItem)navTag.offsetBy(diff, newDiff, addedLineNum);
                    repl.updateReplacer(this.tagCache[pos]);
                } else {
                    this.customTagCache[pos] = (SitePageCachedModelEntry.CustomNavTagItem)navTag.offsetBy(diff, newDiff, addedLineNum);
                    repl.updateReplacer(this.customTagCache[pos]);
                }
                diff = newDiff;
                addedLineNum += this.findLineNum(newGeneratedContent, oldGeneratedContent);
            } else if (navTag instanceof SitePageCachedModelEntry.NavTagItem) {
                this.tagCache[pos] = (SitePageCachedModelEntry.NavTagItem)navTag.offsetBy(diff, addedLineNum);
                repl.updateReplacer(this.tagCache[pos]);
            } else {
                this.customTagCache[pos] = (SitePageCachedModelEntry.CustomNavTagItem)navTag.offsetBy(diff, addedLineNum);
                repl.updateReplacer(this.customTagCache[pos]);
            }
            ++i;
        }
        if (newFileContent != null) {
            newFileContent.append(this.currentFileContent.substring(bookmark));
        }
        if (newFileContent == null) {
            return;
        }
        this.newContent = newFileContent.toString();
    }

    private int findLineNum(String newContent, String oldContent) {
        int oldLineNum = oldContent.split("\n").length;
        int newLineNum = newContent.split("\n").length;
        if (newLineNum > 1 && oldLineNum == 1) {
            ++newLineNum;
        } else if (oldLineNum > 1 && newLineNum == 1) {
            ++oldLineNum;
        }
        return newLineNum - oldLineNum;
    }

    private NavTagReplacer findReplacer(NavTagItems item) {
        if (item.type == 1) {
            return (NavTagReplacer)this.tagReplacer.get(item.arrayPosition);
        }
        return (NavTagReplacer)this.customTagReplacer.get(item.arrayPosition);
    }

    private SitePageCachedModelEntry.NavTag findNavTag(NavTagItems item) {
        return item.item;
    }

    private static void execUpdate(SitePageCachedModel model) {
        SitePageCachedModel mySiteModel = model;
        mySiteModel.doGetNewContent();
    }

    @Override
    protected IStructuredDocument getFlatModelForTaglib() {
        IModelManager mm = SiteModelUtil.getModelManager();
        try {
            return mm.createStructuredDocumentFor(this.cachedData.getFile());
        }
        catch (IOException e) {
            Logger.log(e);
        }
        catch (CoreException e) {
            Logger.log(e);
        }
        return null;
    }

    class MyWriter
    implements SitePageContext.Writer {
        private final String eol;
        private StringBuffer current;

        public MyWriter(String lineDelimiter) {
            this.eol = lineDelimiter;
        }

        @Override
        public void out(String string) {
            if (this.current == null) {
                this.current = new StringBuffer();
            }
            if (string != null) {
                this.current.append(string);
            }
        }

        @Override
        public void commit(int index) {
            String toSet = this.current == null ? "" : this.current.toString();
            String toSetAdjusted = StringUtils.convertLineDelimiters((String)toSet, (String)this.eol);
            ((NavTagReplacer)SitePageCachedModel.this.tagReplacer.get(index)).setReplaceText(toSetAdjusted);
            this.current = null;
        }

        @Override
        public void refresh() {
            this.current = null;
        }

        @Override
        public boolean isDirty() {
            return this.current != null;
        }
    }

    static final class NavTagItems {
        int arrayPosition;
        int type;
        SitePageCachedModelEntry.NavTag item;
        static final int CUSTOM_TAG = 0;
        static final int COMMENT_TAG = 1;

        public NavTagItems(int arrayPosition, int type, SitePageCachedModelEntry.NavTag item) {
            this.arrayPosition = arrayPosition;
            this.type = type;
            this.item = item;
        }
    }

    class NavTagReplacer {
        private final String innerText;
        private final NavElement element;
        public String toReplace;

        public NavTagReplacer(String innerText, NavElement navNode) {
            this.innerText = innerText;
            this.element = navNode;
        }

        public NavElement getNavTag() {
            return this.element;
        }

        public void setReplaceText(String s) {
            this.toReplace = s;
        }

        public boolean isModified() {
            return this.toReplace != null && !this.innerText.equals(this.toReplace);
        }

        public void updateReplacer(SitePageCachedModelEntry.NavTag item) {
            this.element.updateErrorReporter(item);
        }
    }
}

