/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.common;

import com.ibm.etools.siteedit.internal.builder.common.StringUtil;
import com.ibm.etools.siteedit.internal.builder.common.TagAttrImpl;
import com.ibm.etools.siteedit.internal.builder.common.TagNode;
import com.ibm.etools.siteedit.internal.builder.common.TagNodeFactory;
import com.ibm.etools.siteedit.internal.builder.model.NavElement;
import java.util.Locale;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.text.MinimalDocument;
import org.eclipse.wst.xml.core.internal.commentelement.util.TagScanner;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public final class TagParser {
    private static final int STARTPOSITION = 0;
    private static final int TEXT = 1;
    private static final int LINENUMBER = 2;
    static final int DEF_VALUE = 0;
    static final String DEF_SVALUE = "";

    public static TagNode parse(String prefix, TagNodeFactory factory, IStructuredDocumentRegion region) {
        return TagParser.parse(prefix, true, factory, region);
    }

    public static TagNode parse(String prefix, boolean ignoreCase, TagNodeFactory factory, IStructuredDocumentRegion region) {
        String[] nodeValue = TagParser.findTagNodePositions(region);
        return TagParser.parse(nodeValue[1], prefix, ignoreCase, factory, Integer.parseInt(nodeValue[0]), Integer.parseInt(nodeValue[2]));
    }

    public static TagNode parse(String content, String prefix, boolean ignoreCase, TagNodeFactory factory, int startPosition, int lineNumber) {
        String innerValue = TagParser.getCommentTagContents(content);
        return TagParser.createTagNode(content, prefix, ignoreCase, factory, startPosition, lineNumber, innerValue);
    }

    private static TagNode createTagNode(String content, String prefix, boolean ignoreCase, TagNodeFactory factory, int startPosition, int lineNumber, String innerValue) {
        if (innerValue.length() <= 0) {
            return null;
        }
        if (innerValue.charAt(0) == '/') {
            TagScanner scanner = new TagScanner(innerValue, 1);
            String name = scanner.nextName();
            if (TagParser.startsWith(name, prefix, ignoreCase)) {
                return factory.create(2, name, null, startPosition, lineNumber, content);
            }
        } else {
            TagScanner scanner = new TagScanner(innerValue, 0);
            String name = scanner.nextName();
            if (TagParser.startsWith(name, prefix, ignoreCase)) {
                if (innerValue.charAt(innerValue.length() - 1) == '/') {
                    return factory.create(3, name, TagParser.getAttrValue(scanner, ignoreCase), startPosition, lineNumber, content);
                }
                return factory.create(1, name, TagParser.getAttrValue(scanner, ignoreCase), startPosition, lineNumber, content);
            }
        }
        return null;
    }

    public static String getCommentTagContents(String text) {
        return TagParser.getTagContents(text, "<!--", "-->");
    }

    public static String getCustomTagContents(String text) {
        return TagParser.getTagContents(text, "<", ">");
    }

    public static String getTagContents(String text, String startTag, String endTag) {
        String contents = text.trim();
        if (contents.startsWith(startTag)) {
            contents = contents.substring(startTag.length(), contents.length() - endTag.length());
        }
        return contents.trim();
    }

    public static TagNode parseComment(IStructuredDocumentRegion node, String prefix, TagNodeFactory factory) {
        if (node.getType() != "XML_COMMENT_TEXT") {
            return null;
        }
        boolean isInComment = false;
        ITextRegionList regions = node.getRegions();
        for (ITextRegion r : regions) {
            String type = r.getType();
            if ("XML_COMMENT_OPEN" == type) {
                isInComment = true;
                continue;
            }
            if ("XML_COMMENT_CLOSE" == type) {
                isInComment = false;
                continue;
            }
            if ("XML_COMMENT_TEXT" != type || !isInComment) continue;
            return TagParser.parse(prefix, factory, node);
        }
        return null;
    }

    public static TagNode parseXMLJSPComment(IStructuredDocumentRegion node, String prefix, TagNodeFactory factory) {
        String commentOpen = null;
        String commentText = null;
        String commentClose = null;
        String nodeType = node.getType();
        if (nodeType == "XML_COMMENT_TEXT") {
            commentOpen = "XML_COMMENT_OPEN";
            commentText = "XML_COMMENT_TEXT";
            commentClose = "XML_COMMENT_CLOSE";
        } else if (nodeType == "JSP_COMMENT_TEXT") {
            commentOpen = "JSP_COMMENT_OPEN";
            commentText = "JSP_COMMENT_TEXT";
            commentClose = "JSP_COMMENT_CLOSE";
        }
        if (commentText == null) {
            return null;
        }
        boolean isInComment = false;
        ITextRegionList regions = node.getRegions();
        for (ITextRegion r : regions) {
            String type = r.getType();
            if (commentOpen == type) {
                isInComment = true;
                continue;
            }
            if (commentClose == type) {
                isInComment = false;
                continue;
            }
            if (commentText != type || !isInComment) continue;
            String[] nodeValue = TagParser.findTagNodePositions(node);
            return TagParser.parse(node.getText(r), prefix, false, factory, Integer.parseInt(nodeValue[0]), Integer.parseInt(nodeValue[2]));
        }
        return null;
    }

    public static boolean isXMLJSPCommentType(String type) {
        return type == "XML_COMMENT_TEXT" || type == "JSP_COMMENT_TEXT";
    }

    public static TagNode parseNormal(IStructuredDocumentRegion node, String prefix, TagNodeFactory factory) {
        return TagParser.parseNormal(node, prefix, false, factory);
    }

    /*
     * Unable to fully structure code
     */
    public static TagNode parseNormal(IStructuredDocumentRegion node, String prefix, boolean ignoreCase, TagNodeFactory factory) {
        fEndTag = false;
        fEmptyTag = false;
        tagName = null;
        attrs = null;
        attrName = null;
        it = node.getRegions().iterator();
        while (it.hasNext()) {
            r = (ITextRegion)it.next();
            type = r.getType();
            if ("XML_TAG_OPEN" == type) break;
            if ("XML_END_TAG_OPEN" != type) continue;
            fEndTag = true;
            break;
        }
        if (it.hasNext()) ** GOTO lbl35
        return null;
lbl-1000:
        // 1 sources

        {
            r = (ITextRegion)it.next();
            type = r.getType();
            if ("XML_TAG_NAME" == type) {
                tagName = node.getText(r);
                if (!TagParser.startsWith(tagName, prefix, ignoreCase)) {
                    return null;
                }
                attrs = new TagAttrImpl();
            }
            if ("XML_TAG_CLOSE" == type) break;
            if ("XML_EMPTY_TAG_CLOSE" == type) {
                fEmptyTag = true;
                break;
            }
            if ("XML_TAG_ATTRIBUTE_NAME" == type) {
                attrName = node.getText(r);
                continue;
            }
            if ("XML_TAG_ATTRIBUTE_VALUE" != type || attrName == null || attrs == null) continue;
            if (ignoreCase) {
                attrName = attrName.toLowerCase(Locale.US);
            }
            attrs.put(attrName, node.getText(r));
            attrName = null;
lbl35:
            // 4 sources

            ** while (it.hasNext())
        }
lbl36:
        // 3 sources

        nodeValue = TagParser.findTagNodePositions(node);
        if (tagName != null) {
            if (fEmptyTag) {
                return factory.create(3, tagName, attrs, Integer.parseInt(nodeValue[0]), Integer.parseInt(nodeValue[2]), nodeValue[1]);
            }
            if (fEndTag) {
                return factory.create(2, tagName, null, Integer.parseInt(nodeValue[0]), Integer.parseInt(nodeValue[2]), nodeValue[1]);
            }
            return factory.create(1, tagName, attrs, Integer.parseInt(nodeValue[0]), Integer.parseInt(nodeValue[2]), nodeValue[1]);
        }
        return null;
    }

    public static TagNode parseNormal(String prefix, NavElement.Factory factory, String content, boolean ignoreCase, int startPosition, int lineNum, int length) {
        String innerContent = TagParser.getCustomTagContents(content);
        return TagParser.createTagNode(content, prefix, ignoreCase, factory, startPosition, lineNum, innerContent);
    }

    public static TagNode parse(Element elm, String prefix, TagNodeFactory factory) {
        return TagParser.parse(elm, prefix, true, factory);
    }

    public static TagNode parse(Element elm, String prefix, boolean ignoreCase, TagNodeFactory factory) {
        if (!TagParser.startsWith(elm.getTagName(), prefix, ignoreCase)) {
            return null;
        }
        TagAttrImpl attrs = new TagAttrImpl();
        NamedNodeMap attrSrc = elm.getAttributes();
        int i = 0;
        while (i < attrSrc.getLength()) {
            Attr a = (Attr)attrSrc.item(i);
            String attrName = a.getName();
            if (attrName != null) {
                if (ignoreCase) {
                    attrName = attrName.toLowerCase(Locale.US);
                }
                attrs.put(attrName, a.getValue());
            }
            ++i;
        }
        IStructuredDocumentRegion region = null;
        if (elm instanceof IDOMElement) {
            IDOMElement e = (IDOMElement)elm;
            region = e.getStartStructuredDocumentRegion();
        }
        String[] nodeValue = TagParser.findTagNodePositions(region);
        return factory.create(3, elm.getTagName(), attrs, Integer.parseInt(nodeValue[0]), Integer.parseInt(nodeValue[2]), nodeValue[1]);
    }

    public static int getOffsetAttrValue(String innerText, String targetAttr) {
        if (innerText.length() <= 0) {
            return -1;
        }
        String content = innerText.trim();
        int result = innerText.indexOf(content);
        if ((content = TagParser.getInnerText(content)) == null) {
            return -1;
        }
        TagScanner scanner = new TagScanner(content, 0);
        String name = scanner.nextName();
        if (name != null) {
            String attrName = scanner.nextName();
            while (attrName != null) {
                scanner.nextValue();
                if (attrName.equals(targetAttr)) {
                    return result + scanner.getOffset();
                }
                attrName = scanner.nextName();
                scanner.getOffset();
            }
        }
        return -1;
    }

    public static int getAttrValueStartOffset(String innerText, String targetAttr) {
        if (innerText.length() <= 0) {
            return -1;
        }
        String content = innerText.trim();
        int result = innerText.indexOf(content);
        if ((content = TagParser.getInnerText(content)) == null) {
            return -1;
        }
        TagScanner scanner = new TagScanner(content, 0);
        String name = scanner.nextName();
        if (name != null) {
            String attrName = scanner.nextName();
            while (attrName != null) {
                if (attrName.equals(targetAttr)) {
                    scanner.nextValue();
                    return result + scanner.getOffset();
                }
                scanner.nextValue();
                attrName = scanner.nextName();
            }
        }
        return -1;
    }

    public static int getAttrValueEndOffset(String innerText, String targetAttr) {
        if (innerText.length() <= 0) {
            return -1;
        }
        String content = innerText.trim();
        int result = innerText.indexOf(content);
        if ((content = TagParser.getInnerText(content)) == null) {
            return -1;
        }
        TagScanner scanner = new TagScanner(content, 0);
        String name = scanner.nextName();
        if (name != null) {
            String attrName = scanner.nextName();
            while (attrName != null) {
                String attrValue = scanner.nextValue();
                if (attrName.equals(targetAttr)) {
                    return result + scanner.getOffset() + attrValue.length();
                }
                attrName = scanner.nextName();
            }
        }
        return -1;
    }

    public static int getOffsetAttrValue(IStructuredDocumentRegion node, String targetAttr) {
        if (node == null) {
            return -1;
        }
        String commentOpen = null;
        String commentText = null;
        String commentClose = null;
        if (node.getType() == "XML_COMMENT_TEXT") {
            commentOpen = "XML_COMMENT_OPEN";
            commentText = "XML_COMMENT_TEXT";
            commentClose = "XML_COMMENT_CLOSE";
        } else if (node.getType() == "JSP_COMMENT_TEXT") {
            commentOpen = "JSP_COMMENT_OPEN";
            commentText = "JSP_COMMENT_TEXT";
            commentClose = "JSP_COMMENT_CLOSE";
        }
        if (commentText == null) {
            return -1;
        }
        boolean isInComment = false;
        ITextRegionList regions = node.getRegions();
        for (ITextRegion r : regions) {
            String type = r.getType();
            if (commentOpen == type) {
                isInComment = true;
                continue;
            }
            if (commentClose == type) {
                isInComment = false;
                continue;
            }
            if (commentText != type || !isInComment) continue;
            int result = TagParser.getOffsetAttrValue(node.getText(r), targetAttr);
            if (result == -1) {
                return -1;
            }
            return node.getStartOffset(r) + result;
        }
        return -1;
    }

    private static String getInnerText(String content) {
        if (content == null || content.length() <= 0) {
            return null;
        }
        if (content.charAt(0) == '/') {
            return null;
        }
        if (content.charAt(content.length() - 1) == '/') {
            return content.substring(0, content.length() - 1);
        }
        return content;
    }

    public static int getAttrValueLength(String tagInnerText, String targetAttr) {
        if (tagInnerText.length() <= 0) {
            return -1;
        }
        String content = tagInnerText.trim();
        if ((content = TagParser.getInnerText(content)) == null) {
            return -1;
        }
        TagScanner scanner = new TagScanner(content, 0);
        String name = scanner.nextName();
        if (name != null) {
            String attrName = scanner.nextName();
            while (attrName != null) {
                String attrValue = scanner.nextValue();
                if (attrName.equals(targetAttr)) {
                    return attrValue != null ? attrValue.length() : 0;
                }
                attrName = scanner.nextName();
            }
        }
        return -1;
    }

    private static boolean startsWith(String left, String prefix, boolean ignoreCase) {
        if (left == null) {
            return false;
        }
        if (!ignoreCase) {
            return left.startsWith(prefix);
        }
        return left.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    private static String[] findTagNodePositions(IStructuredDocumentRegion node) {
        String startPos = String.valueOf(0);
        String lineNum = String.valueOf(0);
        String innerText = DEF_SVALUE;
        if (node != null && !(node.getParentDocument() instanceof MinimalDocument)) {
            startPos = String.valueOf(node.getStart());
            lineNum = String.valueOf(node.getParentDocument().getLineOfOffset(Integer.parseInt(startPos)) + 1);
            innerText = node.getFullText();
        }
        return new String[]{startPos, innerText, lineNum};
    }

    private static TagAttrImpl getAttrValue(TagScanner scanner, boolean ignoreCase) {
        TagAttrImpl attrs = new TagAttrImpl();
        String attrName = scanner.nextName();
        while (attrName != null) {
            String attrValue = StringUtil.unescapeXml(scanner.nextValue());
            if (ignoreCase) {
                attrName = attrName.toLowerCase(Locale.US);
            }
            attrs.put(attrName, attrValue);
            attrName = scanner.nextName();
        }
        return attrs;
    }
}

