/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.common;

import com.ibm.etools.siteedit.internal.builder.common.ErrorReporter;
import com.ibm.etools.siteedit.internal.builder.common.ErrorReporterTagNode;
import com.ibm.etools.siteedit.internal.builder.common.TagAttr;
import java.util.ArrayList;
import java.util.Collection;

public class TagNode {
    private static final TagAttr NULL_ATTR = new NullAttr();
    protected static final int TAG_FLAG_START = 1;
    protected static final int TAG_FLAG_END = 2;
    public static final int TAG_TYPE_START = 1;
    public static final int TAG_TYPE_END = 2;
    public static final int TAG_TYPE_EMPTY = 3;
    private final int type;
    private final String tagName;
    private final TagAttr tagAttr;
    private ErrorReporterTagNode errorReporter;

    protected TagNode(int type, String tagName, TagAttr attr, ErrorReporterTagNode errorReporterTagNode) {
        this.type = type;
        this.tagName = tagName;
        this.tagAttr = attr;
        this.errorReporter = errorReporterTagNode;
    }

    public int getType() {
        return this.type;
    }

    public boolean isStart() {
        return this.type == 1;
    }

    public boolean isEnd() {
        return this.type == 2;
    }

    public boolean isEmpty() {
        return this.type == 3;
    }

    public boolean hasStart() {
        return (this.type & 1) != 0;
    }

    public boolean hasEnd() {
        return (this.type & 2) != 0;
    }

    public String getTagName() {
        return this.tagName;
    }

    public TagAttr getAllAttr() {
        if (this.tagAttr == null) {
            return NULL_ATTR;
        }
        return this.tagAttr;
    }

    public String getAttr(String name) {
        if (this.tagAttr == null) {
            return "";
        }
        return this.tagAttr.get(name);
    }

    public boolean containsAttr(String name) {
        return this.tagAttr != null && this.tagAttr.contains(name);
    }

    public String getTagInnerText() {
        StringBuffer sb = new StringBuffer();
        if (this.isEnd()) {
            sb.append('/');
        }
        sb.append(this.getTagName());
        for (String name : this.tagAttr.getNames()) {
            sb.append(' ');
            sb.append(name);
            sb.append("=\"");
            sb.append(this.getAttr(name));
            sb.append('\"');
        }
        if (this.isEmpty()) {
            sb.append('/');
        }
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TagNode)) {
            return false;
        }
        TagNode o = (TagNode)other;
        return this.type == o.type && (this.tagName == null ? o.tagName == null : this.tagName.equals(o.tagName)) && (this.tagAttr == null ? o.tagAttr == null : this.tagAttr.equals(o.tagAttr));
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.type;
        result = 37 * result + (this.tagName == null ? 0 : this.tagName.hashCode());
        result = 37 * result + (this.tagAttr == null ? 0 : this.tagAttr.hashCode());
        return result;
    }

    public ErrorReporterTagNode getErrorReporter() {
        return this.errorReporter;
    }

    public ErrorReporter getErrorReporterForAttr(String attr) {
        if (this.errorReporter == null) {
            return null;
        }
        return this.errorReporter.getAttr(attr);
    }

    public void setErrorReporter(ErrorReporterTagNode r) {
        this.errorReporter = r;
    }

    private static class NullAttr
    implements TagAttr {
        private NullAttr() {
        }

        @Override
        public String get(String name) {
            return "";
        }

        @Override
        public Collection getNames() {
            return new ArrayList(0);
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(String name) {
            return false;
        }
    }
}

