/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.common;

import org.eclipse.wst.sse.core.utils.StringUtils;

public final class StringUtil {
    private static final String[] xmlSrc = new String[]{"&", "<", ">", "'", "\"", "\""};
    private static final String[] xmlDst = new String[]{"&amp;", "&lt;", "&gt;", "&#039;", "&#034;", "&quot;"};

    private StringUtil() {
    }

    public static String escapeXml(String xml) {
        int i = 0;
        while (i < xmlSrc.length) {
            xml = StringUtils.replace((String)xml, (String)xmlSrc[i], (String)xmlDst[i]);
            ++i;
        }
        return xml;
    }

    public static String unescapeXml(String xml) {
        int i = xmlSrc.length - 1;
        while (i >= 0) {
            xml = StringUtils.replace((String)xml, (String)xmlDst[i], (String)xmlSrc[i]);
            --i;
        }
        return xml;
    }

    public static String removeEmptyLine(String src) {
        char[] in = src.toCharArray();
        char[] out = new char[src.length()];
        int pOut = 0;
        boolean fBlankLine = true;
        int pPrevBOL = 0;
        int i = 0;
        while (i < in.length) {
            char c = in[i];
            if (c == '\n') {
                if (fBlankLine) {
                    pOut = pPrevBOL;
                } else {
                    out[pOut++] = c;
                    pPrevBOL = pOut;
                }
                fBlankLine = true;
            } else {
                switch (c) {
                    case '\t': 
                    case '\r': 
                    case ' ': {
                        out[pOut++] = c;
                        break;
                    }
                    default: {
                        out[pOut++] = c;
                        fBlankLine = false;
                    }
                }
            }
            ++i;
        }
        if (fBlankLine) {
            pOut = pPrevBOL;
        }
        return in.length == pOut ? src : String.valueOf(out, 0, pOut);
    }

    public static int getIndexOfTextPos(String s, int line, int pos) {
        int base = 0;
        while (line > 0) {
            switch (s.charAt(base++)) {
                case '\r': {
                    if (base < s.length() && s.charAt(base) == '\n') {
                        ++base;
                    }
                    --line;
                    break;
                }
                case '\n': {
                    --line;
                }
            }
        }
        return base + pos;
    }

    public static int getLineOfTextIndex(String s, int index) {
        int line = 0;
        int i = 0;
        while (i < index) {
            switch (s.charAt(i)) {
                case '\r': {
                    if (i < s.length() && s.charAt(i) == '\n') {
                        ++i;
                    }
                    ++line;
                    break;
                }
                case '\n': {
                    ++line;
                }
            }
            ++i;
        }
        return line;
    }
}

