/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.common;

import com.ibm.etools.siteedit.core.Logger;
import com.ibm.etools.siteedit.internal.core.util.SiteModelUtil;
import com.ibm.etools.webedit.util.HTMLTaglibDirectiveUtil;
import com.ibm.etools.webedit.util.ITaglibDirective;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.html.core.internal.document.HTMLConverter;
import org.eclipse.wst.html.core.internal.validate.HTMLValidationAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.validate.ErrorInfo;
import org.eclipse.wst.sse.core.internal.validate.ValidationAdapter;
import org.eclipse.wst.sse.core.internal.validate.ValidationMessage;
import org.eclipse.wst.sse.core.internal.validate.ValidationReporter;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeAdapter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public final class HTMLConversionUtil {
    static final String[] IGNORE_URI = new String[]{"http://java.sun.com/jsf/core", "http://java.sun.com/jsf/html", "http://www.ibm.com/jsf/html_extended", "http://java.sun.com/jstl/core", "http://java.sun.com/jsp/jstl/core"};
    static final String NAME_SCRIPT_COLLECTOR = "script_collector";

    public static IDOMModel convertHtml(IFile file, String declareation, String publicId) {
        IDOMModel result = null;
        try {
            result = HTMLConversionUtil.getModelFromFile(file);
        }
        catch (ClassCastException classCastException) {
        }
        catch (CoreException coreException) {
        }
        catch (IOException iOException) {}
        if (result != null) {
            HTMLConversionUtil.removeFacesScriptCollectorTag(result);
            HTMLConversionUtil.convertHtml(result, declareation, publicId);
        }
        return result;
    }

    private static IDOMModel getModelFromFile(IFile file) throws IOException, CoreException {
        IStructuredModel m;
        IModelManager mm = SiteModelUtil.getModelManager();
        IDOMModel result = null;
        if (file != null && file.exists() && (m = mm.getModelForRead(file)) != null) {
            result = (IDOMModel)m.newInstance();
            HTMLConversionUtil.loadFileToModel(file.getLocation(), result);
            m.releaseFromRead();
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidNavspecFor(IPath path, IDOMModel model) {
        try {
            IDOMModel tmpModel = (IDOMModel)model.newInstance();
            try {
                HTMLConversionUtil.loadFileToModel(path, tmpModel);
                IDOMDocument document = model.getDocument();
                if (document == null) {
                    return false;
                }
                HTMLConversionUtil.convertHtml(tmpModel, HTMLConversionUtil.getDeclaration((Document)document), HTMLConversionUtil.getPublicId((Document)document));
                boolean bl = HTMLConversionUtil.isValidHtml(tmpModel, new CustomTagNodeFilter(tmpModel, IGNORE_URI));
                return bl;
            }
            finally {
                if (tmpModel != null) {
                    tmpModel.releaseFromEdit();
                }
            }
        }
        catch (IOException e) {
            Logger.log(e);
            return false;
        }
    }

    private static void loadFileToModel(IPath path, IDOMModel model) throws IOException {
        if (path == null || model == null) {
            throw new IOException();
        }
        InputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(path.toFile()));
            IModelManager mm = SiteModelUtil.getModelManager();
            IStructuredDocument navspec = mm.createStructuredDocumentFor(path.toString(), is, null, null);
            if (navspec == null) {
                throw new IOException();
            }
            model.aboutToChangeModel();
            model.getStructuredDocument().replaceText((Object)navspec, 0, model.getStructuredDocument().getLength(), navspec.get());
            model.changedModel();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    private static void convertHtml(IDOMModel xml, String declearation, String publicId) {
        if (HTMLConversionUtil.equalsStringEx(publicId, HTMLConversionUtil.getPublicId((Document)xml.getDocument())) && HTMLConversionUtil.equalsStringEx(declearation, HTMLConversionUtil.getDeclaration((Document)xml.getDocument()))) {
            return;
        }
        try {
            StyleAttrEncoder encoder = new StyleAttrEncoder();
            xml.aboutToChangeModel();
            encoder.encode((Document)xml.getDocument());
            xml.changedModel();
            HTMLConverter conv = new HTMLConverter();
            conv.convert(xml, declearation, publicId);
            conv.cleanupModel(xml);
            xml.aboutToChangeModel();
            encoder.decode((Document)xml.getDocument());
            xml.changedModel();
        }
        catch (Exception exception) {}
    }

    private static boolean equalsStringEx(String left, String right) {
        return left == null ? right == null || right.length() == 0 : right == null && left.length() == 0 || left.equals(right);
    }

    private static void removeFacesScriptCollectorTag(IDOMModel xml) {
        Node node;
        if (xml == null) {
            return;
        }
        if (HTMLTaglibDirectiveUtil.isJSPDocuments((IDOMModel)xml)) {
            return;
        }
        String prefix = HTMLConversionUtil.getTaglibPrefix(xml, "http://www.ibm.com/jsf/html_extended");
        if (prefix == null) {
            return;
        }
        final String tagname = String.valueOf(prefix) + ":" + NAME_SCRIPT_COLLECTOR;
        NodeFilter filter = new NodeFilter(){

            @Override
            public short acceptNode(Node node) {
                if (tagname.equals(node.getNodeName())) {
                    return 1;
                }
                return 2;
            }
        };
        xml.aboutToChangeModel();
        NodeIterator it = ((DocumentTraversal)xml.getDocument()).createNodeIterator((Node)xml.getDocument(), 1, filter, false);
        while ((node = it.nextNode()) != null) {
            NodeList children = node.getChildNodes();
            Node[] nodes = new Node[children.getLength()];
            int i = 0;
            while (i < children.getLength()) {
                nodes[i] = children.item(i);
                ++i;
            }
            i = nodes.length - 1;
            while (i >= 0) {
                node.removeChild(nodes[i]);
                --i;
            }
            i = 0;
            while (i < nodes.length) {
                node.getParentNode().insertBefore(nodes[i], node);
                ++i;
            }
            node.getParentNode().removeChild(node);
        }
        xml.changedModel();
    }

    private static String getTaglibPrefix(IDOMModel model, String uri) {
        Object[] o = HTMLTaglibDirectiveUtil.getTaglibDirectivesEx((IDOMModel)model);
        int i = 0;
        while (i < o.length) {
            ITaglibDirective td = (ITaglibDirective)o[i];
            if (uri.equals(td.getURI())) {
                return td.getPrefix();
            }
            ++i;
        }
        return null;
    }

    private static boolean isValidHtml(final IDOMModel xml, final NodeFilter filter) {
        DocumentTypeAdapter adapter;
        IDOMDocument document = xml.getDocument();
        DocumentTypeAdapter documentTypeAdapter = adapter = document != null ? (DocumentTypeAdapter)document.getAdapterFor(DocumentTypeAdapter.class) : null;
        if (adapter == null || !adapter.hasFeature("HTML")) {
            return false;
        }
        HTMLValidationAdapterFactory factory = HTMLValidationAdapterFactory.getInstance();
        ValidationAdapter adapter2 = (ValidationAdapter)factory.adapt((INodeNotifier)document);
        if (adapter2 == null) {
            return false;
        }
        final boolean[] hasError = new boolean[1];
        adapter2.setReporter(new ValidationReporter(){

            public void report(ValidationMessage message) {
                if (filter != null && filter.acceptNode((Node)((IDOMNode)xml.getIndexedRegion(message.getOffset()))) != 1) {
                    return;
                }
                switch (message.getSeverity()) {
                    case 1: 
                    case 2: {
                        hasError[0] = true;
                    }
                }
            }

            public void report(ErrorInfo info) {
            }
        });
        adapter2.validate((IndexedRegion)document);
        return !hasError[0];
    }

    private static String getDeclaration(Document doc) {
        Node node;
        if (doc == null) {
            return null;
        }
        ProcessingInstruction pi = null;
        NodeIterator it = ((DocumentTraversal)((Object)doc)).createNodeIterator(doc, 64, null, true);
        while ((node = it.nextNode()) != null) {
            if (node.getNodeType() != 7 || !"xml".equals(node.getNodeName())) continue;
            pi = (ProcessingInstruction)node;
            break;
        }
        return pi == null ? null : pi.getData();
    }

    private static String getPublicId(Document doc) {
        DocumentType docType = doc.getDoctype();
        return docType == null ? null : docType.getPublicId();
    }

    static class CustomTagNodeFilter
    implements NodeFilter {
        private final String[] uris;
        private final String[] prefixes;

        public CustomTagNodeFilter(IDOMModel model, String[] taglibURIs) {
            this.uris = taglibURIs == null ? new String[]{} : taglibURIs;
            this.prefixes = new String[this.uris.length];
            Object[] o = HTMLTaglibDirectiveUtil.getTaglibDirectivesEx((IDOMModel)model);
            int i = 0;
            while (i < o.length) {
                ITaglibDirective td = (ITaglibDirective)o[i];
                int j = 0;
                while (j < this.uris.length) {
                    if (this.uris[j].equals(td.getURI())) {
                        this.prefixes[j] = td.getPrefix();
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }

        @Override
        public short acceptNode(Node node) {
            if (node.getNodeType() != 1) {
                return 1;
            }
            String prefix = node.getPrefix();
            if (prefix == null || prefix.length() == 0) {
                return 1;
            }
            int i = 0;
            while (i < this.prefixes.length) {
                if (prefix.equals(this.prefixes[i])) {
                    return 3;
                }
                ++i;
            }
            return 1;
        }
    }

    private static class StyleAttrEncoder {
        private static final String PREFIX = "sitenav_encoded: ";
        private static final String SUFFIX = "_encoded_end";
        private static final String STYLE = "style";

        private StyleAttrEncoder() {
        }

        public void encode(Document doc) {
            this.convertDoc(doc, new Converter("${", "}", PREFIX, SUFFIX){

                @Override
                public String convertCore(String input) {
                    StringBuffer sb = new StringBuffer(4 * input.length());
                    int i = 0;
                    while (i < input.length()) {
                        String r = Integer.toHexString(input.charAt(i));
                        switch (r.length()) {
                            case 0: {
                                sb.append("0000");
                                break;
                            }
                            case 1: {
                                sb.append("000");
                                break;
                            }
                            case 2: {
                                sb.append("00");
                                break;
                            }
                            case 3: {
                                sb.append("0");
                                break;
                            }
                            case 4: {
                                sb.append(r);
                                break;
                            }
                            default: {
                                sb.append(r.substring(r.length() - 4));
                            }
                        }
                        sb.append(r);
                        ++i;
                    }
                    return sb.toString();
                }
            });
        }

        public void decode(Document doc) {
            this.convertDoc(doc, new Converter(PREFIX, SUFFIX, "${", "}"){

                @Override
                public String convertCore(String input) {
                    StringBuffer sb = new StringBuffer(input.length() / 4);
                    int i = 0;
                    while (i < input.length() / 4) {
                        sb.append((char)Integer.parseInt(input.substring(i * 4, (i + 1) * 4), 16));
                        ++i;
                    }
                    return sb.toString();
                }
            });
        }

        private void convertDoc(Document doc, Converter conv) {
            Node n;
            NodeIterator ni = ((DocumentTraversal)((Object)doc)).createNodeIterator(doc, 1, null, false);
            while ((n = ni.nextNode()) != null) {
                String converted;
                Element e = (Element)n;
                String style = e.getAttribute(STYLE);
                if (style == null || style.length() == 0 || (converted = conv.convert(style)) == null) continue;
                e.setAttribute(STYLE, converted);
            }
        }

        private abstract class Converter {
            final String prefix;
            final String suffix;
            final String toPrefix;
            final String toSuffix;
            final StringBuffer result = new StringBuffer();

            public abstract String convertCore(String var1);

            public Converter(String prefix, String suffix, String toPrefix, String toSuffix) {
                this.prefix = prefix;
                this.suffix = suffix;
                this.toPrefix = toPrefix;
                this.toSuffix = toSuffix;
            }

            public String convert(String input) {
                int startPos;
                StringBuffer result = null;
                int currentPos = 0;
                while ((startPos = input.indexOf(this.prefix, currentPos)) != -1) {
                    int endPos = input.indexOf(this.suffix, startPos + this.prefix.length());
                    if (endPos == -1) break;
                    if (result == null) {
                        result = new StringBuffer();
                    }
                    if (currentPos < startPos) {
                        result.append(input.substring(currentPos, startPos));
                    }
                    result.append(this.toPrefix);
                    result.append(this.convertCore(input.substring(startPos + this.prefix.length(), endPos)));
                    result.append(this.toSuffix);
                    currentPos = endPos + this.suffix.length();
                }
                if (result == null) {
                    return null;
                }
                result.append(input.substring(currentPos));
                return result.toString();
            }
        }
    }
}

