/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder;

import com.ibm.etools.siteedit.internal.builder.NewlyPageManager;
import com.ibm.etools.siteedit.internal.builder.SitePageInfo;
import com.ibm.etools.siteedit.internal.builder.util.BuildContext;
import com.ibm.etools.siteedit.internal.builder.util.BuildFileCollector;
import com.ibm.etools.siteedit.internal.builder.util.GlobalContext;
import com.ibm.etools.siteedit.internal.core.util.SiteResourceUtil;
import com.ibm.etools.siteedit.internal.core.util.WebComponentUtil;
import com.ibm.etools.siteedit.nature.WebSiteNatureRuntime;
import com.ibm.etools.webedit.common.utils.FileTypeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class SiteUpdateBuilder
extends IncrementalProjectBuilder {
    private static final String[] INSTANCE_EXT = new String[]{"html", "htm", "jsp", "jspf", "jsf"};
    private static ArrayList projectNames = null;
    private static int init = 0;
    private Set allFilesInSite = null;

    protected void startupOnInitialize() {
        if (init != 0) {
            return;
        }
        IProject project = this.getProject();
        if (project == null) {
            return;
        }
        String name = project.getName();
        if (name == null) {
            return;
        }
        if (projectNames == null) {
            projectNames = new ArrayList();
        }
        projectNames.add(name);
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        long siteXmlNewTimeStamp;
        long siteXmlBaseTimeStamp;
        IProject project = this.getProject();
        IVirtualComponent component = this.getComponent();
        IFile siteXml = WebComponentUtil.getActiveWebSiteConfigFile(component);
        if (!WebSiteNatureRuntime.hasWebSiteNatureRuntime(project)) {
            throw new RuntimeException();
        }
        WebComponentUtil.ensureWebsiteConfig(component);
        GlobalContext gc = GlobalContext.getInstance();
        BuildContext bc = gc.getBuildContext(component);
        try {
            this.allFilesInSite = bc.getAllFilesInSite();
        }
        finally {
            bc.dispose();
        }
        long l = siteXmlBaseTimeStamp = siteXml == null ? -1L : siteXml.getModificationStamp();
        if (kind == 6) {
            this.fullBuild();
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild();
            } else {
                this.incrementalBuild(delta);
            }
        }
        long l2 = siteXmlNewTimeStamp = siteXml == null ? -1L : siteXml.getModificationStamp();
        if (siteXmlBaseTimeStamp != siteXmlNewTimeStamp) {
            gc.notifySiteConfigUpdatedBySiteUpdateBuilder(component, siteXmlBaseTimeStamp, siteXmlNewTimeStamp);
        }
        return null;
    }

    private void incrementalBuild(IResourceDelta delta) throws CoreException {
        SitePageInfo pageInfo = new SitePageInfo(this.getComponent());
        NewlyPageManager npm = NewlyPageManager.getInstance(this.getComponent());
        if (projectNames != null) {
            pageInfo.refineProjects(projectNames);
            projectNames = null;
            init = 1;
        }
        DeltaVisitor deltaVisitor = new DeltaVisitor(pageInfo, npm);
        delta.accept((IResourceDeltaVisitor)deltaVisitor);
        npm.save();
        pageInfo.save();
        pageInfo.release();
    }

    private void addPagesForNewlyCreatedPagePane(IFile file, NewlyPageManager npm) {
        int filetype = FileTypeUtil.whatKindOfFile((IPath)file.getFullPath());
        if (filetype == 1) {
            String src = SiteResourceUtil.getProjectRelativePathString(this.getProject(), (IResource)file);
            npm.addNewPage(src);
        }
    }

    private void removePagesForNewlyCreatedPagePane(IFile file, NewlyPageManager npm) {
        int filetype = FileTypeUtil.whatKindOfFile((IPath)file.getFullPath());
        if (filetype == 1) {
            String src = SiteResourceUtil.getProjectRelativePathString(this.getProject(), (IResource)file);
            npm.remove(src);
        }
    }

    private void movePagesForNewlyCreatedPagePane(IFile from, IPath to, NewlyPageManager npm) {
        int filetype = FileTypeUtil.whatKindOfFile((IPath)from.getFullPath());
        if (filetype == 1) {
            String fromSrc = SiteResourceUtil.getProjectRelativePathString(this.getProject(), (IResource)from);
            npm.remove(fromSrc);
            String toSrc = SiteResourceUtil.getProjectRelativePathString(this.getProject(), to);
            npm.addNewPage(toSrc);
        }
    }

    private void fullBuild() throws CoreException {
        IProject project = this.getProject();
        SitePageInfo pageInfo = new SitePageInfo(this.getComponent());
        NewlyPageManager npm = NewlyPageManager.getInstance(this.getComponent());
        if (projectNames != null) {
            pageInfo.refineProjects(projectNames);
            projectNames = null;
            init = 1;
        }
        pageInfo.initProject();
        FullVisitor fullVisitor = new FullVisitor(pageInfo, npm);
        project.accept((IResourceVisitor)fullVisitor);
        npm.save();
        pageInfo.save();
        pageInfo.release();
    }

    private boolean isValidExtention(IResource src, String[] exts) {
        String ext = src.getFileExtension();
        return Arrays.asList(exts).contains(ext);
    }

    IVirtualComponent getComponent() {
        return WebComponentUtil.getFirstComponent(this.getProject());
    }

    private class DeltaVisitor
    implements IResourceDeltaVisitor {
        private SitePageInfo pageInfo;
        private NewlyPageManager npm;
        final boolean siteDesignerOpened;

        private DeltaVisitor(SitePageInfo pi, NewlyPageManager npm) {
            this.pageInfo = pi;
            this.npm = npm;
            this.siteDesignerOpened = pi.isSiteEditorPartOpened(npm.getComponent());
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource res = delta.getResource();
            if (res.getType() == 4) {
                if (delta.getKind() == 2) {
                    this.pageInfo.removeProject();
                    return false;
                }
                return true;
            }
            if (WebComponentUtil.findComponent(res) == null) {
                return false;
            }
            if (res.getType() != 1) {
                return true;
            }
            if (!BuildFileCollector.isInComponentSiteFile((IFile)res, SiteUpdateBuilder.this.getComponent(), SiteUpdateBuilder.this.allFilesInSite)) {
                this.updateNewlyPages(delta, this.npm);
                return true;
            }
            if (!SiteUpdateBuilder.this.isValidExtention(res, INSTANCE_EXT)) {
                return true;
            }
            int kind = delta.getKind();
            switch (kind) {
                case 1: 
                case 4: {
                    this.pageInfo.updatePageInfo(res);
                    break;
                }
                case 2: {
                    this.pageInfo.removePageInfo(res);
                }
            }
            return true;
        }

        private void updateNewlyPages(IResourceDelta delta, NewlyPageManager npm) {
            IResource res = delta.getResource();
            int kind = delta.getKind();
            int flag = delta.getFlags();
            switch (kind) {
                case 1: {
                    if (!(res instanceof IFile) || this.siteDesignerOpened) break;
                    SiteUpdateBuilder.this.addPagesForNewlyCreatedPagePane((IFile)res, npm);
                    break;
                }
                case 2: {
                    if (!(res instanceof IFile) || this.siteDesignerOpened) break;
                    if ((flag & 0x2000) != 0) {
                        IPath toPath = delta.getMovedToPath();
                        if (toPath == null) break;
                        SiteUpdateBuilder.this.movePagesForNewlyCreatedPagePane((IFile)res, toPath, npm);
                        break;
                    }
                    SiteUpdateBuilder.this.removePagesForNewlyCreatedPagePane((IFile)res, npm);
                }
            }
        }
    }

    private class FullVisitor
    implements IResourceVisitor {
        private final SitePageInfo pageInfo;
        private final NewlyPageManager npm;

        private FullVisitor(SitePageInfo pi, NewlyPageManager npm) {
            this.pageInfo = pi;
            this.npm = npm;
        }

        public boolean visit(IResource res) {
            IVirtualComponent component = WebComponentUtil.findComponent(res);
            if (component == null) {
                return false;
            }
            if (res.getType() != 1) {
                return true;
            }
            if (!BuildFileCollector.isInComponentSiteFile((IFile)res, SiteUpdateBuilder.this.getComponent(), SiteUpdateBuilder.this.allFilesInSite)) {
                if (!this.pageInfo.isSiteEditorPartOpened(component)) {
                    if (res.exists()) {
                        SiteUpdateBuilder.this.addPagesForNewlyCreatedPagePane((IFile)res, this.npm);
                    } else {
                        SiteUpdateBuilder.this.removePagesForNewlyCreatedPagePane((IFile)res, this.npm);
                    }
                }
                return true;
            }
            if (!SiteUpdateBuilder.this.isValidExtention(res, INSTANCE_EXT)) {
                return true;
            }
            this.pageInfo.updatePageInfo(res);
            return true;
        }
    }
}

