/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder;

import com.ibm.etools.siteedit.core.Logger;
import com.ibm.etools.siteedit.core.SiteCorePlugin;
import com.ibm.etools.siteedit.internal.builder.util.BuildUtil;
import com.ibm.etools.siteedit.internal.builder.util.ui.DirtyEditorUtil;
import com.ibm.etools.siteedit.internal.core.util.EstimatePageSize;
import com.ibm.etools.siteedit.internal.core.util.SiteModelUtil;
import com.ibm.etools.siteedit.internal.core.util.SitePageInfoUtil;
import com.ibm.etools.siteedit.internal.core.util.SiteResourceUtil;
import com.ibm.etools.siteedit.internal.core.util.SiteRestorableXmlDocumentUtil;
import com.ibm.etools.siteedit.internal.core.util.WebComponentUtil;
import com.ibm.etools.siteedit.site.model.PageModel;
import com.ibm.etools.siteedit.site.model.SiteModel;
import com.ibm.etools.siteedit.site.model.SiteModelContainer;
import com.ibm.etools.siteedit.site.model.SiteModelUtil2;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SitePageInfo {
    private static final String PAGEINFO_FILE = ".sitepageinfo";
    private static final String PAGEINFO_ELEM = "pageinfo";
    private static final String PROJECT_ELEM = "project";
    private static final String PROJECT_ATTR_NAME = "name";
    private static final String PAGE_ELEM_NAME = "page";
    private static final String PAGE_ATTR_SRC = "src";
    private static final String PAGE_ATTR_SIZE = "size";
    private static final String PAGE_ATTR_TITLE = "title";
    private static final String PAGE_ATTR_LAST_MODIFIED = "lastmodified";
    private static final String PAGE_ATTR_META_DESCRIPTION = "meta_desc";
    private static final String PAGE_ATTR_META_KEYWORDS = "meta_key";
    private static final String PAGE_ATTR_META_AUTHOR = "meta_author";
    private static final String PAGE_ATTR_META_ABSTRACT = "meta_abstract";
    private static final String PAGE_ATTR_LINKED_CSS = "linked_css";
    private static SiteRestorableXmlDocumentUtil docUtil = null;
    private static String fileName = null;
    private static int referenceCount = 0;
    private String encodedName;
    IVirtualComponent component;
    private Node root;
    private SiteModelSession siteModelSession;

    public SitePageInfo(IVirtualComponent component) {
        this.component = component;
        String name = WebComponentUtil.encodeComponentToText(component);
        if (docUtil == null) {
            SiteCorePlugin plugin = SiteCorePlugin.getDefault();
            if (plugin != null) {
                fileName = plugin.getStateLocation().append(PAGEINFO_FILE).toString();
            }
            docUtil = new SiteRestorableXmlDocumentUtil();
            docUtil.setRootElementName(PAGEINFO_ELEM);
            docUtil.load(fileName);
        }
        this.encodedName = name;
        ++referenceCount;
    }

    public void save() {
        if (docUtil != null) {
            docUtil.save(fileName);
        }
    }

    public void reload() {
        if (docUtil != null) {
            docUtil.restoreNodes();
        }
    }

    public void release() {
        if (--referenceCount == 0) {
            docUtil = null;
            fileName = null;
        }
        this.releaseSiteModelSession();
    }

    public Element getPage(String src) {
        return this.getPageByAttr(PAGE_ELEM_NAME, PAGE_ATTR_SRC, src);
    }

    public Element addPage(String src) {
        return this.addPageByAttr(PAGE_ELEM_NAME, PAGE_ATTR_SRC, src);
    }

    public Element removePage(String src) {
        Element page = this.getPageByAttr(PAGE_ELEM_NAME, PAGE_ATTR_SRC, src);
        if (page == null) {
            return null;
        }
        return (Element)this.root.removeChild(page);
    }

    public NodeList getAllFiles() {
        this.root = docUtil.getElementByAttr(PROJECT_ELEM, PROJECT_ATTR_NAME, this.encodedName);
        if (this.root == null) {
            return null;
        }
        return this.root.getChildNodes();
    }

    public Element getPageByAttr(String elemName, String attrName, String attrValue) {
        this.root = docUtil.getElementByAttr(PROJECT_ELEM, PROJECT_ATTR_NAME, this.encodedName);
        if (this.root == null) {
            return null;
        }
        Element page = null;
        Node node = this.root.getFirstChild();
        while (node != null) {
            String value;
            if (node.getNodeType() == 1 && ((Element)node).getTagName().equals(elemName) && (value = ((Element)node).getAttribute(attrName)) != null && value.equals(attrValue)) {
                page = (Element)node;
                break;
            }
            node = node.getNextSibling();
        }
        return page;
    }

    public Element addPageByAttr(String elemName, String attrName, String attrValue) {
        this.root = docUtil.getElementByAttr(PROJECT_ELEM, PROJECT_ATTR_NAME, this.encodedName);
        if (this.root == null) {
            return null;
        }
        Element page = docUtil.getDocument().createElement(elemName);
        if (page == null) {
            return null;
        }
        page.setAttribute(attrName, attrValue);
        this.root.appendChild(page);
        return page;
    }

    public String getSrc(Element page) {
        return this.getInfo(page, PAGE_ATTR_SRC);
    }

    public String getSize(Element page) {
        return this.getInfo(page, PAGE_ATTR_SIZE);
    }

    public void setSize(Element page, String value) {
        this.setInfo(page, PAGE_ATTR_SIZE, value);
    }

    public String getTitle(Element page) {
        return this.getInfo(page, PAGE_ATTR_TITLE);
    }

    public void setTitle(Element page, String value) {
        this.setInfo(page, PAGE_ATTR_TITLE, value);
    }

    public String getLastModified(Element page) {
        return this.getInfo(page, PAGE_ATTR_LAST_MODIFIED);
    }

    public void setLastModified(Element page, String value) {
        this.setInfo(page, PAGE_ATTR_LAST_MODIFIED, value);
    }

    public String getMetaDescription(Element page) {
        return this.getInfo(page, PAGE_ATTR_META_DESCRIPTION);
    }

    public void setMetaDescription(Element page, String value) {
        this.setInfo(page, PAGE_ATTR_META_DESCRIPTION, value);
    }

    public String getMetaKeywords(Element page) {
        return this.getInfo(page, PAGE_ATTR_META_KEYWORDS);
    }

    public void setMetaKeywords(Element page, String value) {
        this.setInfo(page, PAGE_ATTR_META_KEYWORDS, value);
    }

    public String getMetaAuthor(Element page) {
        return this.getInfo(page, PAGE_ATTR_META_AUTHOR);
    }

    public void setMetaAuthor(Element page, String value) {
        this.setInfo(page, PAGE_ATTR_META_AUTHOR, value);
    }

    public String getMetaAbstract(Element page) {
        return this.getInfo(page, PAGE_ATTR_META_ABSTRACT);
    }

    public void setMetaAbstract(Element page, String value) {
        this.setInfo(page, PAGE_ATTR_META_ABSTRACT, value);
    }

    public String getLinkedCSS(Element page) {
        return this.getInfo(page, PAGE_ATTR_LINKED_CSS);
    }

    public void setLinkedCSS(Element page, String value) {
        this.setInfo(page, PAGE_ATTR_LINKED_CSS, value);
    }

    public String getInfo(Element page, String attrName) {
        if (page == null || attrName == null) {
            return null;
        }
        return page.getAttribute(attrName);
    }

    public void setInfo(Element page, String attrName, String attrValue) {
        if (page == null || attrName == null || attrValue == null) {
            return;
        }
        page.setAttribute(attrName, attrValue);
    }

    public void updatePageInfo(IResource res) {
        IStructuredDocument flatModel;
        IPath path = res.getLocation();
        if (path == null) {
            return;
        }
        Element page = this.getPageByAttr(PAGE_ELEM_NAME, PAGE_ATTR_SRC, path.toString());
        if (page == null && (page = this.addPageByAttr(PAGE_ELEM_NAME, PAGE_ATTR_SRC, path.toString())) == null) {
            return;
        }
        IFile file = (IFile)res;
        try {
            IModelManager mm = SiteModelUtil.getModelManager();
            flatModel = mm.createStructuredDocumentFor(file);
        }
        catch (Exception exception) {
            return;
        }
        String str = this.estimatePageSize(file, flatModel);
        if (str != null) {
            page.setAttribute(PAGE_ATTR_SIZE, str);
        } else {
            page.removeAttribute(PAGE_ATTR_SIZE);
        }
        ArrayList title = new ArrayList();
        ArrayList linkedCSS = new ArrayList();
        ArrayList keywords = new ArrayList();
        ArrayList description = new ArrayList();
        ArrayList author = new ArrayList();
        ArrayList abst = new ArrayList();
        ArrayList<String> appliedTemplate = new ArrayList<String>();
        SitePageInfoUtil.getPageInfo(flatModel, file, title, linkedCSS, keywords, description, author, abst);
        appliedTemplate.add(BuildUtil.getPageTemplate(file));
        str = null;
        if (title.size() > 0) {
            str = (String)title.get(0);
        }
        if (str != null) {
            page.setAttribute(PAGE_ATTR_TITLE, str);
        } else {
            page.removeAttribute(PAGE_ATTR_TITLE);
        }
        str = SitePageInfoUtil.getUnformatedDate(path);
        if (str != null) {
            page.setAttribute(PAGE_ATTR_LAST_MODIFIED, str);
        } else {
            page.removeAttribute(PAGE_ATTR_LAST_MODIFIED);
        }
        str = null;
        if (linkedCSS.size() > 0) {
            int size = linkedCSS.size();
            int i = 0;
            while (i < size) {
                String s = (String)linkedCSS.get(i);
                if (s != null) {
                    str = str == null ? s : String.valueOf(str) + "," + s;
                }
                ++i;
            }
        }
        if (str != null) {
            page.setAttribute(PAGE_ATTR_LINKED_CSS, str);
        } else {
            page.removeAttribute(PAGE_ATTR_LINKED_CSS);
        }
        this.updateTemplateToWebsiteconfig(file, appliedTemplate);
        str = null;
        if (description.size() > 0) {
            str = (String)description.get(0);
        }
        if (str != null) {
            page.setAttribute(PAGE_ATTR_META_DESCRIPTION, str);
        } else {
            page.removeAttribute(PAGE_ATTR_META_DESCRIPTION);
        }
        str = null;
        if (keywords.size() > 0) {
            str = (String)keywords.get(0);
        }
        if (str != null) {
            page.setAttribute(PAGE_ATTR_META_KEYWORDS, str);
        } else {
            page.removeAttribute(PAGE_ATTR_META_KEYWORDS);
        }
        str = null;
        if (author.size() > 0) {
            str = (String)author.get(0);
        }
        if (str != null) {
            page.setAttribute(PAGE_ATTR_META_AUTHOR, str);
        } else {
            page.removeAttribute(PAGE_ATTR_META_AUTHOR);
        }
        str = null;
        if (abst.size() > 0) {
            str = (String)abst.get(0);
        }
        if (str != null) {
            page.setAttribute(PAGE_ATTR_META_ABSTRACT, str);
        } else {
            page.removeAttribute(PAGE_ATTR_META_ABSTRACT);
        }
    }

    private String estimatePageSize(IFile file, IStructuredDocument flatModel) {
        try {
            EstimatePageSize eps = new EstimatePageSize(file);
            return eps.getPageSize();
        }
        catch (Exception e) {
            Logger.log(e);
            return null;
        }
    }

    public void removePageInfo(IResource res) {
        IPath path = res.getLocation();
        if (path == null) {
            return;
        }
        this.removePage(path.toString());
    }

    public void initProject() {
        this.removeProject();
        this.root = docUtil.getElementByAttr(PROJECT_ELEM, PROJECT_ATTR_NAME, this.encodedName);
    }

    public void removeProject() {
        this.root = docUtil.getElementByAttr(PROJECT_ELEM, PROJECT_ATTR_NAME, this.encodedName);
        if (this.root != null) {
            docUtil.getRootElement().removeChild(this.root);
        }
    }

    private boolean isValidProject(ArrayList projectNames, String proj) {
        return projectNames.contains(proj);
    }

    public void refineProjects(ArrayList projectNames) {
        Element rootElement = docUtil.getRootElement();
        if (rootElement == null) {
            return;
        }
        Node node = rootElement.getFirstChild();
        while (node != null) {
            String value;
            Node next = node.getNextSibling();
            if (node.getNodeType() == 1 && ((Element)node).getTagName().equals(PROJECT_ELEM) && ((value = ((Element)node).getAttribute(PROJECT_ATTR_NAME)) == null || !this.isValidProject(projectNames, value))) {
                rootElement.removeChild(node);
            }
            node = next;
        }
    }

    boolean setTemplateToWebsiteconfig(IFile pageFile, String s, SiteModel siteModel) {
        final String rtn = s == null || s.length() == 0 ? "" : s;
        String src = SiteResourceUtil.getProjectRelativePathString(this.component, pageFile.getLocation());
        final PageModel page = SiteModelUtil2.findPageModelBySRC(siteModel, src);
        if (page != null) {
            if (page.getTemplate().equals(rtn)) {
                return false;
            }
            if (PlatformUI.isWorkbenchRunning()) {
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        page.setTemplate(rtn);
                    }
                });
            } else {
                page.setTemplate(rtn);
            }
            return true;
        }
        return false;
    }

    boolean isSiteEditorPartOpened(IVirtualComponent component) {
        IFile siteconfig = WebComponentUtil.getWebSiteConfigFile(component);
        DirtyEditorUtil util = DirtyEditorUtil.Factory.create();
        IAdaptable editor = util.getEditor(siteconfig);
        return editor != null && editor.getAdapter(SiteModelContainer.class) != null;
    }

    private void updateTemplateToWebsiteconfig(IFile file, ArrayList appliedTemplate) {
        if (appliedTemplate.size() > 0) {
            for (String e : appliedTemplate) {
                this.getSiteModelSession().setTemplateToWebsiteconfig(file, e);
            }
        } else {
            this.getSiteModelSession().setTemplateToWebsiteconfig(file, null);
        }
    }

    private SiteModelSession getSiteModelSession() {
        if (this.siteModelSession == null) {
            this.siteModelSession = new SiteModelSession();
        }
        return this.siteModelSession;
    }

    private void releaseSiteModelSession() {
        if (this.siteModelSession != null) {
            this.siteModelSession.release();
            this.siteModelSession = null;
        }
    }

    private class SiteModelSession {
        private SiteModel siteModel;
        private SiteModelContainer smc;
        private boolean modified;
        private boolean initialized;
        private boolean readyToWrite;

        private SiteModelSession() {
        }

        private void init() {
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            if (SitePageInfo.this.isSiteEditorPartOpened(SitePageInfo.this.component)) {
                return;
            }
            this.smc = SiteCorePlugin.getDefault().getSiteModelManager().getModelContainerForEdit(SitePageInfo.this.component);
            if (this.smc != null && this.smc.getSiteModel() != null) {
                this.siteModel = this.smc.getSiteModel();
                this.readyToWrite = true;
            }
            if (!this.readyToWrite) {
                this.release();
                return;
            }
        }

        public void setTemplateToWebsiteconfig(IFile file, String s) {
            if (!this.initialized) {
                this.init();
            }
            if (this.readyToWrite) {
                this.modified |= SitePageInfo.this.setTemplateToWebsiteconfig(file, s, this.siteModel);
            }
        }

        public void release() {
            if (this.smc != null) {
                if (this.modified && !this.smc.isSharedForEdit()) {
                    this.smc.save(null);
                }
                this.smc.release();
            }
        }
    }
}

