/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder;

import com.ibm.etools.siteedit.core.ResourceHandler;
import com.ibm.etools.siteedit.core.SiteCorePlugin;
import com.ibm.etools.siteedit.internal.builder.SiteNavBuilderLogger;
import com.ibm.etools.siteedit.internal.builder.SiteNavException;
import com.ibm.etools.siteedit.internal.builder.SiteNavMessages;
import com.ibm.etools.siteedit.internal.builder.model.SitePageBuildOperator;
import com.ibm.etools.siteedit.internal.builder.util.BuildContext;
import com.ibm.etools.siteedit.internal.builder.util.BuildFileCollector;
import com.ibm.etools.siteedit.internal.builder.util.GlobalContext;
import com.ibm.etools.siteedit.internal.builder.util.ui.ReadOnlyFailureHelper;
import com.ibm.etools.siteedit.internal.core.preference.SitePreferenceManager;
import com.ibm.etools.siteedit.internal.core.util.WebComponentUtil;
import com.ibm.etools.siteedit.nature.WebSiteNatureRuntime;
import com.ibm.etools.siteedit.sitelib.util.SitelibHelper;
import com.ibm.etools.siteedit.util.NavigationTagUtil;
import com.ibm.etools.webpage.template.TemplateNature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class SiteNavBuilder
extends IncrementalProjectBuilder {
    private static final QualifiedName QNAME_DEFERRED_UPDATE = new QualifiedName(SiteCorePlugin.getDefault().getBundle().getSymbolicName(), "NO");

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (!this.isValidTargetProject()) {
            return null;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(SiteNavMessages.MONITOR_TITLE, -1);
        IProject project = this.getProject();
        IVirtualComponent component = WebComponentUtil.getFirstComponent(project);
        if (!WebComponentUtil.hasWebSiteFeature(component) || !WebComponentUtil.isWebComponent(component)) {
            return null;
        }
        GlobalContext gc = GlobalContext.getInstance();
        BuildContext bc = gc.getBuildContext(component);
        ArrayList changedFileSet = null;
        HashSet<IProject> resultProjectSet = null;
        try {
            Collection readOnlyFiles;
            boolean r;
            BuildFileCollector bfc = new BuildFileCollector(bc);
            bfc.setDeferredTarget(this.getDeferredTarget());
            bfc.setShowSaveForDirtyInstance(bc.isSiteXmlUpdated() && kind != 9);
            if (kind == 6) {
                bfc.handleAll();
            } else {
                IResourceDelta delta = this.getDelta(project);
                if (delta == null) {
                    bfc.handleAll();
                } else {
                    bfc.handleDelta(delta, bc.isSiteXmlUpdated());
                }
            }
            if (!bfc.getSaveTargetFiles().isEmpty()) {
                bfc.scheduleDeferredDirtyFileSave();
            }
            this.setDeferringTarget(bfc.getNextTarget());
            Collection target = bfc.getBuildTargetFiles();
            SitePageBuildOperator so = bc.getPageBuildOperator();
            monitor.done();
            changedFileSet = new ArrayList(target.size());
            this.internalBuildFiles(target, so, bc, monitor, changedFileSet);
            IFile sitelibConfig = SitelibHelper.getSiteLibConfigFile(component);
            if ((kind == 6 || bc.isSiteXmlUpdated() || this.isWebSettingsFileInDelta(bc)) && !(r = SitelibHelper.updateSitelibConfigFile(component)) && sitelibConfig.isReadOnly()) {
                bc.addReadonlyFile(sitelibConfig);
            }
            if ((readOnlyFiles = bc.getReadOnlyFiles()) != null && !readOnlyFiles.isEmpty()) {
                Collection availableFiles = SiteNavBuilder.getWritableFiles(readOnlyFiles);
                readOnlyFiles.removeAll(availableFiles);
                if (availableFiles.contains(sitelibConfig)) {
                    availableFiles.remove(sitelibConfig);
                    SitelibHelper.updateSitelibConfigFile(component);
                }
                if (!availableFiles.isEmpty()) {
                    this.internalBuildFiles(availableFiles, so, bc, monitor, changedFileSet);
                }
                if ((readOnlyFiles = bc.getReadOnlyFiles()) != null && !readOnlyFiles.isEmpty() && SitePreferenceManager.isBuilderShowReadOnlyPrompt()) {
                    ReadOnlyFailureHelper.Factory.create().showWarning(readOnlyFiles);
                }
            }
        }
        finally {
            bc.dispose();
        }
        if (!(changedFileSet.isEmpty() || monitor.isCanceled() || this.isInterrupted())) {
            monitor.subTask(ResourceHandler._UI_BUILDER_2_SiteNavBuilder_0);
            if (project.hasNature("com.ibm.etools.webpage.template.templatenature")) {
                TemplateNature tmplNature = (TemplateNature)project.getNature("com.ibm.etools.webpage.template.templatenature");
                tmplNature.updateMarkers(changedFileSet);
            }
        }
        resultProjectSet = new HashSet<IProject>();
        for (IVirtualComponent c : bc.getRelatedComponents()) {
            if (c.getProject().equals((Object)project)) continue;
            resultProjectSet.add(c.getProject());
        }
        return resultProjectSet.isEmpty() ? null : resultProjectSet.toArray(new IProject[resultProjectSet.size()]);
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        IVirtualComponent component = WebComponentUtil.getFirstComponent(this.getProject());
        if (!WebComponentUtil.hasWebSiteFeature(component) || !WebComponentUtil.isWebComponent(component)) {
            return;
        }
        GlobalContext gc = GlobalContext.getInstance();
        BuildContext bc = gc.getBuildContext(component);
        try {
            bc.clean();
        }
        finally {
            bc.dispose();
        }
    }

    private void internalBuildFiles(Collection target, SitePageBuildOperator so, BuildContext bc, IProgressMonitor monitor, Collection dirtyFileSet) {
        monitor.beginTask(SiteNavMessages.MONITOR_TITLE, target.size());
        String monitorSubTitle = SiteNavMessages.MONITOR_SUB_TITLE1;
        Iterator it = target.iterator();
        while (it.hasNext() && !monitor.isCanceled()) {
            IFile file = (IFile)it.next();
            if (this.isSpecFile(file)) continue;
            try {
                monitor.subTask(SiteNavMessages.format1(monitorSubTitle, file.getFullPath().toString()));
                boolean fDirty = so.build(bc.getFileContext(file));
                if (fDirty) {
                    dirtyFileSet.add(file);
                }
                monitor.worked(1);
            }
            catch (SiteNavException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                SiteNavBuilderLogger.log(e);
                e.printStackTrace();
            }
        }
        monitor.done();
    }

    protected boolean isValidTargetProject() {
        IProject project;
        block6: {
            block5: {
                project = this.getProject();
                try {
                    if (WebComponentUtil.isFlexibleProject(project)) break block5;
                    return false;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            if (WebSiteNatureRuntime.hasWebSiteNatureRuntime(project)) break block6;
            return false;
        }
        if (((WebSiteNatureRuntime)project.getNature("com.ibm.etools.siteedit.WebSiteNature")).reconfigure()) {
            this.needRebuild();
            return false;
        }
        return true;
    }

    private boolean isSpecFile(IFile file) {
        return NavigationTagUtil.getInstance().isSpecFile(file);
    }

    private static Collection getWritableFiles(Collection c) {
        ArrayList<IFile> result = new ArrayList<IFile>(c.size());
        for (IFile file : c) {
            if (file.isReadOnly()) continue;
            result.add(file);
        }
        return result;
    }

    private boolean isWebSettingsFileInDelta(BuildContext bc) {
        Collection relatedComponents = bc.getRelatedComponents();
        for (IVirtualComponent component : relatedComponents) {
            IResourceDelta delta = this.getDelta(component.getProject());
            if (delta == null) {
                return true;
            }
            if (delta.findMember((IPath)new Path("settings/.component")) == null) continue;
            return true;
        }
        return false;
    }

    private void setDeferringTarget(Collection targets) throws CoreException {
        this.getProject().setSessionProperty(QNAME_DEFERRED_UPDATE, (Object)targets);
        this.getProject().setPersistentProperty(QNAME_DEFERRED_UPDATE, this.encodeFileCollection(targets));
    }

    private Collection getDeferredTarget() throws CoreException {
        String s;
        Collection result = (Collection)this.getProject().getSessionProperty(QNAME_DEFERRED_UPDATE);
        if (result == null && (s = this.getProject().getPersistentProperty(QNAME_DEFERRED_UPDATE)) != null) {
            result = this.decodeFileCollection(s);
        }
        return result;
    }

    String encodeFileCollection(Collection targets) {
        char sep = ':';
        StringBuffer result = new StringBuffer();
        Iterator iter = targets.iterator();
        while (iter.hasNext()) {
            if (result.length() > 0) {
                result.append(sep);
            }
            IFile file = (IFile)iter.next();
            result.append(file.getProjectRelativePath().toString());
        }
        return result.toString();
    }

    Collection decodeFileCollection(String str) {
        char sep = ':';
        ArrayList<IFile> result = new ArrayList<IFile>(8);
        StringTokenizer tk = new StringTokenizer(str, Character.toString(sep));
        while (tk.hasMoreTokens()) {
            String t = tk.nextToken();
            IFile file = this.getProject().getFile((IPath)new Path(t));
            if (file == null || !file.exists()) continue;
            result.add(file);
        }
        return result;
    }
}

