/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder;

import com.ibm.etools.siteedit.core.SiteCorePlugin;
import com.ibm.etools.siteedit.internal.core.util.SiteResourceUtil;
import com.ibm.etools.siteedit.internal.core.util.SiteXmlDocumentUtil;
import com.ibm.etools.siteedit.internal.core.util.WebComponentUtil;
import com.ibm.etools.siteedit.sitelib.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NewlyPageManager {
    private static final String FILE_NEWPAGES = ".newpages";
    private static final String ELEM_NEWPAGES = "newpages";
    private static final String ELEM_PROJECT = "project";
    private static final String ATTR_PROJECTNAME = "name";
    private static final String ATTR_PINOPEN = "pinopen";
    private static final String ATTR_SORT = "sort";
    private static final String ELEM_ITEM = "item";
    private static final String ATTR_SRC = "src";
    private static final String ELEM_SASHINFO = "sashinfo";
    private static final String ATTR_CLOSED = "closed";
    private static final String ATTR_WEIGHT1 = "weight1";
    private static final String ATTR_WEIGHT2 = "weight2";
    private static final boolean PINOPEN_DEFAULT = true;
    private static final boolean SASHSTATE_DEFAULT = false;
    private IVirtualComponent component = null;
    private List loadedItems = null;
    private ArrayList allWebPages = null;
    private final Element root;

    public NewlyPageManager(IVirtualComponent component, Element root) {
        this.component = component;
        this.root = root;
        this.allWebPages = new ArrayList();
        this.allWebPages = this.getWebPagesInProject(component.getProject());
        int i = 0;
        while (i < this.allWebPages.size()) {
            String fileName = SiteResourceUtil.getProjectRelativePathString(component, (IResource)((IFile)this.allWebPages.toArray()[i]));
            this.addNewPage(fileName);
            ++i;
        }
        this.loadItems();
    }

    private ArrayList getWebPagesInProject(IProject project) {
        if (project == null) {
            return null;
        }
        IFolder webContentFolder = project.getFolder("WebContent");
        this.allWebPages = new ArrayList();
        this.getAllChildren(webContentFolder);
        return this.allWebPages;
    }

    private void getAllChildren(IFolder folder) {
        WorkbenchContentProvider fProvider = new WorkbenchContentProvider();
        Object[] children = fProvider.getElements((Object)folder);
        int i = 0;
        while (i < children.length) {
            if (children[i] != null) {
                String fileExt;
                if (children[i] instanceof IFolder) {
                    this.getAllChildren((IFolder)children[i]);
                } else if (children[i] instanceof IFile && (fileExt = ((IFile)children[i]).getFileExtension()) != null && (fileExt.equals("htm") || fileExt.equals("html") || fileExt.equals("xhtml") || fileExt.equals("jsp"))) {
                    this.allWebPages.add(children[i]);
                }
            }
            ++i;
        }
    }

    public List getItems() {
        return this.loadedItems;
    }

    public List loadItems() {
        ArrayList<IFile> items = new ArrayList<IFile>(0);
        if (this.root == null || this.component == null) {
            return items;
        }
        Node node = this.root.getFirstChild();
        while (node != null) {
            Element elem;
            String src;
            IFile file;
            if (node.getNodeType() == 1 && node.getNodeName().equals(ELEM_ITEM) && (file = SiteResourceUtil.fileForProjectRelative(this.component, src = (elem = (Element)node).getAttribute(ATTR_SRC))) != null && file.exists()) {
                items.add(file);
            }
            node = node.getNextSibling();
        }
        this.loadedItems = items;
        return items;
    }

    public void save() {
        NewPageFile.getInstance().save();
    }

    public static NewlyPageManager getInstance(IVirtualComponent component) {
        return NewPageFile.getInstance().get(component);
    }

    public void addNewPage(String url) {
        Document doc;
        if (this.root == null || url == null || url.length() == 0) {
            return;
        }
        boolean found = false;
        Node node = this.root.getFirstChild();
        while (node != null) {
            Element elem;
            String src;
            if (node.getNodeType() == 1 && node.getNodeName().equals(ELEM_ITEM) && (src = (elem = (Element)node).getAttribute(ATTR_SRC)).equals(url)) {
                found = true;
                break;
            }
            node = node.getNextSibling();
        }
        if (!found && (doc = this.root.getOwnerDocument()) != null) {
            Element child = doc.createElement(ELEM_ITEM);
            child.setAttribute(ATTR_SRC, url);
            Node first = this.root.getFirstChild();
            if (first != null) {
                this.root.insertBefore(child, first);
            } else {
                this.root.appendChild(child);
            }
        }
    }

    public boolean remove(String url) {
        boolean ret = false;
        if (this.root == null) {
            return ret;
        }
        Node node = this.root.getFirstChild();
        while (node != null) {
            Element elem;
            String src;
            if (node.getNodeType() == 1 && node.getNodeName().equals(ELEM_ITEM) && (src = (elem = (Element)node).getAttribute(ATTR_SRC)).equals(url)) {
                this.root.removeChild(node);
                ret = true;
                break;
            }
            node = node.getNextSibling();
        }
        return ret;
    }

    public void setSashInfo(int[] weights) {
        Document doc;
        if (this.root == null || weights == null || weights.length < 2) {
            return;
        }
        boolean found = false;
        Node node = this.root.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1 && node.getNodeName().equals(ELEM_SASHINFO)) {
                Element elem = (Element)node;
                elem.setAttribute(ATTR_WEIGHT1, String.valueOf(weights[0]));
                elem.setAttribute(ATTR_WEIGHT2, String.valueOf(weights[1]));
                found = true;
                break;
            }
            node = node.getNextSibling();
        }
        if (!found && (doc = this.root.getOwnerDocument()) != null) {
            Element child = doc.createElement(ELEM_SASHINFO);
            child.setAttribute(ATTR_WEIGHT1, String.valueOf(weights[0]));
            child.setAttribute(ATTR_WEIGHT2, String.valueOf(weights[1]));
            this.root.appendChild(child);
        }
    }

    public void setSortState(boolean sort) {
        if (this.root == null) {
            return;
        }
        this.root.setAttribute(ATTR_SORT, String.valueOf(sort));
    }

    public boolean getSortState() {
        if (this.root == null) {
            return false;
        }
        String strVal = this.root.getAttribute(ATTR_SORT);
        return Boolean.valueOf(strVal);
    }

    public void setPinState(boolean pinOpen) {
        if (this.root == null) {
            return;
        }
        this.root.setAttribute(ATTR_PINOPEN, String.valueOf(pinOpen));
    }

    public boolean getPinState() {
        if (this.root == null) {
            return true;
        }
        return StringUtils.getBoolean((String)this.root.getAttribute(ATTR_PINOPEN), (boolean)true);
    }

    public void setSashState(boolean closed) {
        Document doc;
        if (this.root == null) {
            return;
        }
        boolean found = false;
        Node node = this.root.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1 && node.getNodeName().equals(ELEM_SASHINFO)) {
                ((Element)node).setAttribute(ATTR_CLOSED, String.valueOf(closed));
                found = true;
                break;
            }
            node = node.getNextSibling();
        }
        if (!found && (doc = this.root.getOwnerDocument()) != null) {
            Element child = doc.createElement(ELEM_SASHINFO);
            child.setAttribute(ATTR_CLOSED, String.valueOf(closed));
            this.root.appendChild(child);
        }
    }

    public int[] getSashInfo() {
        if (this.root != null) {
            Node node = this.root.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1 && node.getNodeName().equals(ELEM_SASHINFO)) {
                    Element elem = (Element)node;
                    int[] weights = new int[2];
                    int val = this.getIntValue(elem.getAttribute(ATTR_WEIGHT1));
                    if (val >= 0) {
                        weights[0] = val;
                    }
                    if ((val = this.getIntValue(elem.getAttribute(ATTR_WEIGHT2))) >= 0) {
                        weights[1] = val;
                    }
                    return weights;
                }
                node = node.getNextSibling();
            }
        }
        return null;
    }

    private int getIntValue(String strVal) {
        int val = 0;
        if (strVal == null) {
            return -1;
        }
        try {
            val = Integer.parseInt(strVal);
        }
        catch (NumberFormatException numberFormatException) {
            val = -1;
        }
        return val;
    }

    public boolean getSashState() {
        boolean ret = false;
        Node node = this.root.getFirstChild();
        while (node != null) {
            String strVal;
            if (node.getNodeType() == 1 && node.getNodeName().equals(ELEM_SASHINFO) && (strVal = ((Element)node).getAttribute(ATTR_CLOSED)) != null) {
                ret = Boolean.valueOf(strVal);
            }
            node = node.getNextSibling();
        }
        return ret;
    }

    Element getProjectElement() {
        return this.root;
    }

    public IVirtualComponent getComponent() {
        return this.component;
    }

    public void dispose() {
        NewPageFile.getInstance().release(this.root.getAttribute(ATTR_PROJECTNAME));
    }

    static class NewPageFile {
        private final SiteXmlDocumentUtil docUtil;
        private final String fileName;
        private final HashMap map = new HashMap();
        private static NewPageFile instance;

        private NewPageFile() {
            SiteCorePlugin plugin = SiteCorePlugin.getDefault();
            this.fileName = plugin != null ? plugin.getStateLocation().append(NewlyPageManager.FILE_NEWPAGES).toString() : null;
            this.docUtil = new SiteXmlDocumentUtil();
            this.docUtil.setRootElementName(NewlyPageManager.ELEM_NEWPAGES);
            this.docUtil.load(this.fileName);
        }

        static NewPageFile getInstance() {
            if (instance == null) {
                instance = new NewPageFile();
            }
            return instance;
        }

        public NewlyPageManager get(IVirtualComponent component) {
            List items;
            if (component == null) {
                return null;
            }
            String encodedName = WebComponentUtil.encodeComponentToText(component);
            NewlyPageManager setting = (NewlyPageManager)this.map.get(encodedName);
            if (setting == null) {
                Element root = this.docUtil.getElementByAttr(NewlyPageManager.ELEM_PROJECT, NewlyPageManager.ATTR_PROJECTNAME, encodedName);
                setting = new NewlyPageManager(component, root);
                this.map.put(encodedName, setting);
            }
            if ((items = setting.getItems()) == null || items.isEmpty()) {
                setting.loadItems();
            }
            return setting;
        }

        public void release(String projectName) {
            this.map.remove(projectName);
            this.save();
        }

        public void remove(String projectName) {
            NewlyPageManager setting = (NewlyPageManager)this.map.get(projectName);
            if (setting != null) {
                Element e = setting.getProjectElement();
                e.getParentNode().removeChild(e);
            }
            this.release(projectName);
        }

        void save() {
            if (this.docUtil != null) {
                this.docUtil.save(this.fileName);
            }
        }
    }
}

