/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder;

import com.ibm.etools.common.migration.framework.AbstractMigration;
import com.ibm.etools.common.migration.framework.IMigrationStatus;
import com.ibm.etools.common.migration.framework.MigrationStatus;
import com.ibm.etools.siteedit.core.Logger;
import com.ibm.etools.siteedit.internal.builder.ISiteCoreConstants;
import com.ibm.etools.siteedit.internal.core.util.SiteModelUtil;
import com.ibm.etools.siteedit.internal.core.util.SiteXmlDocumentUtil;
import com.ibm.etools.siteedit.internal.core.util.WebComponentUtil;
import com.ibm.etools.siteedit.nature.WebSiteNatureRuntime;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.jsp.core.internal.domdocument.CommentImplForJSP;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class Migrator
extends AbstractMigration
implements ISiteCoreConstants {
    public IMigrationStatus migrate(IProject project, IProgressMonitor monitor) {
        try {
            boolean bWebsiteNatureFound = project.hasNature("com.ibm.etools.siteedit.WebSiteNature");
            IVirtualComponent component = WebComponentUtil.getFirstComponent(project);
            if (bWebsiteNatureFound) {
                String nodeName;
                Element topNode = null;
                boolean bsiteStructureEmpty = true;
                IFile file = WebComponentUtil.getWebSiteConfigFile(component);
                SiteXmlDocumentUtil docUtil = new SiteXmlDocumentUtil();
                String filePath = file.getLocation().toString();
                docUtil.load(filePath);
                if (docUtil != null) {
                    topNode = docUtil.getRootElement();
                }
                if (topNode != null && topNode.getNodeType() == 1 && (nodeName = topNode.getNodeName()).equalsIgnoreCase("website")) {
                    NodeList children = topNode.getChildNodes();
                    int index = 0;
                    while (index < children.getLength()) {
                        NodeList childrenOfStructure;
                        Node aNode = children.item(index);
                        nodeName = aNode.getNodeName();
                        if (nodeName.equalsIgnoreCase("structure") && (childrenOfStructure = aNode.getChildNodes()).getLength() > 0) {
                            bsiteStructureEmpty = false;
                            break;
                        }
                        ++index;
                    }
                }
                if (bsiteStructureEmpty) {
                    WebSiteNatureRuntime.removeWebSiteNature(project);
                }
            }
        }
        catch (Exception e) {
            Logger.log(e);
            e.printStackTrace();
        }
        try {
            if (WebComponentUtil.getServletVersion(WebComponentUtil.getFirstComponent(project)) <= 23) {
                this.migrateV512Spec(project);
            }
        }
        catch (Exception e) {
            Logger.log(e);
            e.printStackTrace();
        }
        return new MigrationStatus(Status.OK_STATUS);
    }

    private List<IFile> getFilesInFolder(IFolder folder) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        try {
            IResource[] resourceArray = folder.members();
            int i = 0;
            while (i < resourceArray.length) {
                if (resourceArray[i] instanceof IFile) {
                    files.add((IFile)resourceArray[i]);
                } else if (resourceArray[i] instanceof IFolder) {
                    List<IFile> folderFiles = this.getFilesInFolder((IFolder)resourceArray[i]);
                    files.addAll(folderFiles);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            Logger.log(e);
        }
        return files;
    }

    private List<IFile> getFilesInProject(IProject project) {
        List<IFile> files = new ArrayList<IFile>();
        IFolder dummyFolder = project.getFolder("WebContent");
        try {
            IResource[] resourcesArray = null;
            if (!dummyFolder.exists()) {
                resourcesArray = dummyFolder.getParent().members();
                int i = 0;
                while (i < resourcesArray.length) {
                    if (resourcesArray[i] instanceof IFile && resourcesArray[i].getFileExtension().trim().toLowerCase().equals("jsp")) {
                        files.add((IFile)resourcesArray[i]);
                    } else if (resourcesArray[i] instanceof IFolder) {
                        List<IFile> folderFiles = this.getFilesInFolder((IFolder)resourcesArray[i]);
                        files.addAll(folderFiles);
                    }
                    ++i;
                }
            } else {
                resourcesArray = dummyFolder.members();
                files = this.getFilesInFolder(dummyFolder);
            }
        }
        catch (CoreException e) {
            Logger.log(e);
        }
        return files;
    }

    private List<IFile> getSpecFilesToModify(IProject project) {
        ArrayList<IFile> specFiles = new ArrayList<IFile>();
        try {
            boolean bWebsiteNatureFound = project.hasNature("com.ibm.etools.siteedit.WebSiteNature");
            if (bWebsiteNatureFound) {
                IFolder webcontentFolder = project.getFolder("WebContent");
                String[] strSpecArray = new String[]{"vertical-tab", "vertical-sep", "vertical-button", "horizontal-tab", "horizontal-button", "horizontal-sep", "trail", "trail-horizontal", "trail-vertical", "sitemap", "sitemap_vertical"};
                List<Object> resourceList = new ArrayList();
                resourceList = webcontentFolder.exists() ? this.getFilesInFolder(webcontentFolder) : this.getFilesInProject(project);
                int ispec = 0;
                while (ispec < strSpecArray.length) {
                    int i = 0;
                    while (i < resourceList.size()) {
                        IFile iFile;
                        if (((IFile)resourceList.get(i)).getFileExtension() != null && ((IFile)resourceList.get(i)).getName().trim().toLowerCase().indexOf(strSpecArray[ispec].trim()) != -1 && ((IFile)resourceList.get(i)).getFileExtension().trim().toLowerCase().equals("jsp") && this.needsMigration(iFile = webcontentFolder.getFile(((IFile)resourceList.get(i)).getName())) && !specFiles.contains(iFile)) {
                            specFiles.add(iFile);
                        }
                        ++i;
                    }
                    ++ispec;
                }
            }
        }
        catch (CoreException e) {
            Logger.log(e);
            e.printStackTrace();
        }
        return specFiles;
    }

    private void migrateModelV512Spec(IDOMModel model) {
        IDOMDocument document = model.getDocument();
        NodeListImpl nodeList = new NodeListImpl();
        NodeIterator iter = ((DocumentTraversal)document).createNodeIterator((Node)document, 1, null, false);
        Node n = iter.nextNode();
        boolean startAttributeSearch = false;
        while (n != null) {
            String nodeName = n.getNodeName();
            if (!startAttributeSearch && nodeName.equalsIgnoreCase("BODY")) {
                startAttributeSearch = true;
            }
            if (!startAttributeSearch) {
                n = iter.nextNode();
                continue;
            }
            if (nodeName != null) {
                IDOMElement domElement = (IDOMElement)n;
                NamedNodeMap map = domElement.getAttributes();
                int i = 0;
                while (i < map.getLength()) {
                    Node item = map.item(i);
                    String itemContent = item.getNodeValue();
                    if (itemContent.equals("${siteid.id}")) {
                        if (n == null) break;
                        nodeList.addNode(n);
                        break;
                    }
                    ++i;
                }
            }
            n = iter.nextNode();
        }
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node != null) {
                Comment endComment;
                IDOMElement domElement = (IDOMElement)node;
                String elementContents = domElement.getSource();
                Comment comment = document.createComment(" siteedit:out value=\"" + elementContents + "\" ");
                if (comment instanceof CommentImplForJSP) {
                    ((CommentImplForJSP)comment).setJSPTag(true);
                }
                if ((endComment = document.createComment("/siteedit:out")) instanceof CommentImplForJSP) {
                    ((CommentImplForJSP)comment).setJSPTag(true);
                }
                domElement.getParentNode().insertBefore(comment, (Node)domElement);
                domElement.getParentNode().insertBefore(endComment, (Node)domElement);
                domElement.getParentNode().removeChild((Node)domElement);
            }
            ++i;
        }
        try {
            model.save();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void migrateV512Spec(IProject project) {
        IDOMModel model = null;
        try {
            try {
                List<IFile> specFiles = this.getSpecFilesToModify(project);
                Iterator<IFile> iterator = specFiles.iterator();
                while (iterator.hasNext()) {
                    SiteModelUtil smu = new SiteModelUtil();
                    IFile iFile = iterator.next();
                    model = smu.getModelForEdit(iFile);
                    if (model == null || !this.isJsfPage((Document)model.getDocument())) continue;
                    this.migrateModelV512Spec(model);
                }
            }
            catch (Exception e) {
                Logger.log(e);
                e.printStackTrace();
                if (model != null) {
                    model.releaseFromEdit();
                }
            }
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    private boolean isJsfPage(Document d) {
        NodeIterator iter = ((DocumentTraversal)((Object)d)).createNodeIterator(d, 1, null, false);
        Node node = iter.nextNode();
        while (node != null) {
            if ("jsp:directive.taglib".equalsIgnoreCase(node.getNodeName()) && "http://java.sun.com/jsf/core".equals(((Element)node).getAttribute("uri"))) {
                return true;
            }
            if ("jsp:root".equalsIgnoreCase(node.getNodeName())) {
                NamedNodeMap attrs = ((Element)node).getAttributes();
                int i = 0;
                while (i < attrs.getLength()) {
                    if ("http://java.sun.com/jsf/core".equals(attrs.item(i).getNodeValue())) {
                        return true;
                    }
                    ++i;
                }
            }
            if ("BODY".equalsIgnoreCase(node.getNodeName())) break;
            node = iter.nextNode();
        }
        return false;
    }

    public List<IFile> getResourcesToChange(IProject project, IProgressMonitor monitor) {
        ArrayList<IFile> filesList = new ArrayList<IFile>();
        filesList.addAll(this.getSpecFilesToModify(project));
        return filesList;
    }

    private boolean needsMigration(IFile specFile) {
        boolean isJSFPage;
        if (!specFile.exists()) {
            return false;
        }
        SiteModelUtil smu = new SiteModelUtil();
        IDOMModel model = smu.getModelForRead(specFile, false);
        boolean bl = isJSFPage = model == null ? false : this.isJsfPage((Document)model.getDocument());
        if (!isJSFPage) {
            return false;
        }
        String fileContents = model.getStructuredDocument().get();
        model.releaseFromRead();
        int indexSiteID = fileContents.indexOf("${siteid.id}");
        return isJSFPage && indexSiteID >= 0;
    }

    class NodeListImpl
    implements NodeList {
        List<Node> nodeList = new ArrayList<Node>();

        NodeListImpl() {
        }

        public void addNode(Node node) {
            if (!this.nodeList.contains(node)) {
                this.nodeList.add(node);
            }
        }

        @Override
        public int getLength() {
            return this.nodeList.size();
        }

        @Override
        public Node item(int index) {
            return this.nodeList.get(index);
        }
    }
}

