/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.core.internal.el.node;

import com.ibm.etools.siteedit.core.internal.el.node.Cast;
import com.ibm.etools.siteedit.core.internal.el.node.NoCast;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

public class TypedLinkedList
extends LinkedList {
    private static final long serialVersionUID = 1L;
    Cast cast;

    public TypedLinkedList() {
        this.cast = NoCast.instance;
    }

    public TypedLinkedList(Collection c) {
        super(c);
        this.cast = NoCast.instance;
    }

    public TypedLinkedList(Cast cast) {
        this.cast = cast;
    }

    public TypedLinkedList(Collection c, Cast cast) {
        super(c);
        this.cast = cast;
    }

    public Cast getCast() {
        return this.cast;
    }

    @Override
    public void add(int index, Object element) {
        super.add(index, this.cast.cast(element));
    }

    @Override
    public boolean add(Object o) {
        return super.add(this.cast.cast(o));
    }

    @Override
    public boolean addAll(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            super.add(this.cast.cast(i.next()));
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection c) {
        int pos = index;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            super.add(pos++, this.cast.cast(i.next()));
        }
        return true;
    }

    @Override
    public void addFirst(Object o) {
        super.addFirst(this.cast.cast(o));
    }

    @Override
    public void addLast(Object o) {
        super.addLast(this.cast.cast(o));
    }

    @Override
    public ListIterator listIterator(int index) {
        return new TypedLinkedListIterator(super.listIterator(index));
    }

    private class TypedLinkedListIterator
    implements ListIterator {
        ListIterator iterator;

        TypedLinkedListIterator(ListIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Object next() {
            return this.iterator.next();
        }

        @Override
        public boolean hasPrevious() {
            return this.iterator.hasPrevious();
        }

        public Object previous() {
            return this.iterator.previous();
        }

        @Override
        public int nextIndex() {
            return this.iterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.iterator.previousIndex();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        public void set(Object o) {
            this.iterator.set(TypedLinkedList.this.cast.cast(o));
        }

        public void add(Object o) {
            this.iterator.add(TypedLinkedList.this.cast.cast(o));
        }
    }
}

