/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.core.internal.el.lexer;

import com.ibm.etools.siteedit.core.internal.el.lexer.LexerException;
import com.ibm.etools.siteedit.core.internal.el.node.EOF;
import com.ibm.etools.siteedit.core.internal.el.node.TBlank;
import com.ibm.etools.siteedit.core.internal.el.node.TBooleanLiteral;
import com.ibm.etools.siteedit.core.internal.el.node.TDiv;
import com.ibm.etools.siteedit.core.internal.el.node.TDot;
import com.ibm.etools.siteedit.core.internal.el.node.TElEnd;
import com.ibm.etools.siteedit.core.internal.el.node.TElStart;
import com.ibm.etools.siteedit.core.internal.el.node.TEmpty;
import com.ibm.etools.siteedit.core.internal.el.node.TEq;
import com.ibm.etools.siteedit.core.internal.el.node.TFloatLiteral;
import com.ibm.etools.siteedit.core.internal.el.node.TGe;
import com.ibm.etools.siteedit.core.internal.el.node.TGt;
import com.ibm.etools.siteedit.core.internal.el.node.TIdentifier;
import com.ibm.etools.siteedit.core.internal.el.node.TIntegerLiteral;
import com.ibm.etools.siteedit.core.internal.el.node.TLBracket;
import com.ibm.etools.siteedit.core.internal.el.node.TLPar;
import com.ibm.etools.siteedit.core.internal.el.node.TLe;
import com.ibm.etools.siteedit.core.internal.el.node.TLogicalAnd;
import com.ibm.etools.siteedit.core.internal.el.node.TLogicalOr;
import com.ibm.etools.siteedit.core.internal.el.node.TLt;
import com.ibm.etools.siteedit.core.internal.el.node.TMinus;
import com.ibm.etools.siteedit.core.internal.el.node.TMod;
import com.ibm.etools.siteedit.core.internal.el.node.TMulti;
import com.ibm.etools.siteedit.core.internal.el.node.TNe;
import com.ibm.etools.siteedit.core.internal.el.node.TNot;
import com.ibm.etools.siteedit.core.internal.el.node.TNullLiteral;
import com.ibm.etools.siteedit.core.internal.el.node.TPlus;
import com.ibm.etools.siteedit.core.internal.el.node.TRBracket;
import com.ibm.etools.siteedit.core.internal.el.node.TRPar;
import com.ibm.etools.siteedit.core.internal.el.node.TString;
import com.ibm.etools.siteedit.core.internal.el.node.TStringLiteral;
import com.ibm.etools.siteedit.core.internal.el.node.Token;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PushbackReader;

public class Lexer {
    protected Token token;
    protected State state = State.NM;
    private PushbackReader in;
    private int line;
    private int pos;
    private boolean cr;
    private boolean eof;
    private final StringBuffer text = new StringBuffer();
    private static int[][][][] gotoTable;
    private static int[][] accept;

    protected void filter() throws LexerException, IOException {
    }

    public Lexer(PushbackReader in) {
        this.in = in;
        if (gotoTable == null) {
            try {
                int j;
                DataInputStream s = new DataInputStream(new BufferedInputStream(Lexer.class.getResourceAsStream("lexer.dat")));
                int length = s.readInt();
                gotoTable = new int[length][][][];
                int i = 0;
                while (i < gotoTable.length) {
                    length = s.readInt();
                    Lexer.gotoTable[i] = new int[length][][];
                    j = 0;
                    while (j < gotoTable[i].length) {
                        length = s.readInt();
                        Lexer.gotoTable[i][j] = new int[length][3];
                        int k = 0;
                        while (k < gotoTable[i][j].length) {
                            int l = 0;
                            while (l < 3) {
                                Lexer.gotoTable[i][j][k][l] = s.readInt();
                                ++l;
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                length = s.readInt();
                accept = new int[length][];
                i = 0;
                while (i < accept.length) {
                    length = s.readInt();
                    Lexer.accept[i] = new int[length];
                    j = 0;
                    while (j < accept[i].length) {
                        Lexer.accept[i][j] = s.readInt();
                        ++j;
                    }
                    ++i;
                }
                s.close();
            }
            catch (Exception exception) {
                throw new RuntimeException("The file \"lexer.dat\" is either missing or corrupted.");
            }
        }
    }

    public Token peek() throws LexerException, IOException {
        while (this.token == null) {
            this.token = this.getToken();
            this.filter();
        }
        return this.token;
    }

    public Token next() throws LexerException, IOException {
        while (this.token == null) {
            this.token = this.getToken();
            this.filter();
        }
        Token result = this.token;
        this.token = null;
        return result;
    }

    protected Token getToken() throws IOException, LexerException {
        int dfa_state = 0;
        int start_pos = this.pos;
        int start_line = this.line;
        int accept_state = -1;
        int accept_token = -1;
        int accept_length = -1;
        int accept_pos = -1;
        int accept_line = -1;
        int[][][] gotoTable = Lexer.gotoTable[this.state.id()];
        int[] accept = Lexer.accept[this.state.id()];
        this.text.setLength(0);
        while (true) {
            int c;
            if ((c = this.getChar()) != -1) {
                switch (c) {
                    case 10: {
                        if (this.cr) {
                            this.cr = false;
                            break;
                        }
                        ++this.line;
                        this.pos = 0;
                        break;
                    }
                    case 13: {
                        ++this.line;
                        this.pos = 0;
                        this.cr = true;
                        break;
                    }
                    default: {
                        ++this.pos;
                        this.cr = false;
                    }
                }
                this.text.append((char)c);
                block127: do {
                    int oldState = dfa_state < -1 ? -2 - dfa_state : dfa_state;
                    dfa_state = -1;
                    int[][] tmp1 = gotoTable[oldState];
                    int low = 0;
                    int high = tmp1.length - 1;
                    while (low <= high) {
                        int middle = (low + high) / 2;
                        int[] tmp2 = tmp1[middle];
                        if (c < tmp2[0]) {
                            high = middle - 1;
                            continue;
                        }
                        if (c > tmp2[1]) {
                            low = middle + 1;
                            continue;
                        }
                        dfa_state = tmp2[2];
                        continue block127;
                    }
                } while (dfa_state < -1);
            } else {
                dfa_state = -1;
            }
            if (dfa_state >= 0) {
                if (accept[dfa_state] == -1) continue;
                accept_state = dfa_state;
                accept_token = accept[dfa_state];
                accept_length = this.text.length();
                accept_pos = this.pos;
                accept_line = this.line;
                continue;
            }
            if (accept_state == -1) break;
            switch (accept_token) {
                case 0: {
                    Token token = this.new0(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NM;
                        }
                    }
                    return token;
                }
                case 1: {
                    Token token = this.new1(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.EL;
                        }
                    }
                    return token;
                }
                case 2: {
                    Token token = this.new2(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.NM;
                        }
                    }
                    return token;
                }
                case 3: {
                    Token token = this.new3(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.EL;
                        }
                    }
                    return token;
                }
                case 4: {
                    Token token = this.new4(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.EL;
                        }
                    }
                    return token;
                }
                case 5: {
                    Token token = this.new5(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.EL;
                        }
                    }
                    return token;
                }
                case 6: {
                    Token token = this.new6(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.EL;
                        }
                    }
                    return token;
                }
                case 7: {
                    Token token = this.new7(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.EL;
                        }
                    }
                    return token;
                }
                case 8: {
                    Token token = this.new8(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.EL;
                        }
                    }
                    return token;
                }
                case 9: {
                    Token token = this.new9(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.EL;
                        }
                    }
                    return token;
                }
                case 10: {
                    Token token = this.new10(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.EL;
                        }
                    }
                    return token;
                }
                case 11: {
                    Token token = this.new11(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.EL;
                        }
                    }
                    return token;
                }
                case 12: {
                    Token token = this.new12(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.EL;
                        }
                    }
                    return token;
                }
                case 13: {
                    Token token = this.new13(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.EL;
                        }
                    }
                    return token;
                }
                case 14: {
                    Token token = this.new14(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.EL;
                        }
                    }
                    return token;
                }
                case 15: {
                    Token token = this.new15(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.EL;
                        }
                    }
                    return token;
                }
                case 16: {
                    Token token = this.new16(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.EL;
                        }
                    }
                    return token;
                }
                case 17: {
                    Token token = this.new17(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.EL;
                        }
                    }
                    return token;
                }
                case 18: {
                    Token token = this.new18(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.EL;
                        }
                    }
                    return token;
                }
                case 19: {
                    Token token = this.new19(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.EL;
                        }
                    }
                    return token;
                }
                case 20: {
                    Token token = this.new20(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.EL;
                        }
                    }
                    return token;
                }
                case 21: {
                    Token token = this.new21(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.EL;
                        }
                    }
                    return token;
                }
                case 22: {
                    Token token = this.new22(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.EL;
                        }
                    }
                    return token;
                }
                case 23: {
                    Token token = this.new23(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.EL;
                        }
                    }
                    return token;
                }
                case 24: {
                    Token token = this.new24(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.EL;
                        }
                    }
                    return token;
                }
                case 25: {
                    Token token = this.new25(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.EL;
                        }
                    }
                    return token;
                }
                case 26: {
                    Token token = this.new26(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.EL;
                        }
                    }
                    return token;
                }
                case 27: {
                    Token token = this.new27(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.EL;
                        }
                    }
                    return token;
                }
                case 28: {
                    Token token = this.new28(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.EL;
                        }
                    }
                    return token;
                }
                case 29: {
                    Token token = this.new29(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.EL;
                        }
                    }
                    return token;
                }
            }
        }
        if (this.text.length() > 0) {
            throw new LexerException("[" + (start_line + 1) + "," + (start_pos + 1) + "]" + " Unknown token: " + this.text, start_line, start_pos);
        }
        EOF token = new EOF(start_line + 1, start_pos + 1);
        return token;
    }

    Token new0(String text, int line, int pos) {
        return new TString(text, line, pos);
    }

    Token new1(int line, int pos) {
        return new TElStart(line, pos);
    }

    Token new2(int line, int pos) {
        return new TElEnd(line, pos);
    }

    Token new3(String text, int line, int pos) {
        return new TBlank(text, line, pos);
    }

    Token new4(String text, int line, int pos) {
        return new TLogicalAnd(text, line, pos);
    }

    Token new5(String text, int line, int pos) {
        return new TLogicalOr(text, line, pos);
    }

    Token new6(int line, int pos) {
        return new TPlus(line, pos);
    }

    Token new7(int line, int pos) {
        return new TMinus(line, pos);
    }

    Token new8(int line, int pos) {
        return new TMulti(line, pos);
    }

    Token new9(String text, int line, int pos) {
        return new TDiv(text, line, pos);
    }

    Token new10(String text, int line, int pos) {
        return new TMod(text, line, pos);
    }

    Token new11(String text, int line, int pos) {
        return new TGt(text, line, pos);
    }

    Token new12(String text, int line, int pos) {
        return new TLt(text, line, pos);
    }

    Token new13(String text, int line, int pos) {
        return new TGe(text, line, pos);
    }

    Token new14(String text, int line, int pos) {
        return new TLe(text, line, pos);
    }

    Token new15(String text, int line, int pos) {
        return new TEq(text, line, pos);
    }

    Token new16(String text, int line, int pos) {
        return new TNe(text, line, pos);
    }

    Token new17(String text, int line, int pos) {
        return new TNot(text, line, pos);
    }

    Token new18(int line, int pos) {
        return new TEmpty(line, pos);
    }

    Token new19(int line, int pos) {
        return new TLPar(line, pos);
    }

    Token new20(int line, int pos) {
        return new TRPar(line, pos);
    }

    Token new21(int line, int pos) {
        return new TDot(line, pos);
    }

    Token new22(int line, int pos) {
        return new TLBracket(line, pos);
    }

    Token new23(int line, int pos) {
        return new TRBracket(line, pos);
    }

    Token new24(String text, int line, int pos) {
        return new TBooleanLiteral(text, line, pos);
    }

    Token new25(String text, int line, int pos) {
        return new TStringLiteral(text, line, pos);
    }

    Token new26(String text, int line, int pos) {
        return new TIntegerLiteral(text, line, pos);
    }

    Token new27(String text, int line, int pos) {
        return new TFloatLiteral(text, line, pos);
    }

    Token new28(int line, int pos) {
        return new TNullLiteral(line, pos);
    }

    Token new29(String text, int line, int pos) {
        return new TIdentifier(text, line, pos);
    }

    private int getChar() throws IOException {
        if (this.eof) {
            return -1;
        }
        int result = this.in.read();
        if (result == -1) {
            this.eof = true;
        }
        return result;
    }

    private void pushBack(int acceptLength) throws IOException {
        int length = this.text.length();
        int i = length - 1;
        while (i >= acceptLength) {
            this.eof = false;
            this.in.unread(this.text.charAt(i));
            --i;
        }
    }

    protected void unread(Token token) throws IOException {
        String text = token.getText();
        int length = text.length();
        int i = length - 1;
        while (i >= 0) {
            this.eof = false;
            this.in.unread(text.charAt(i));
            --i;
        }
        this.pos = token.getPos() - 1;
        this.line = token.getLine() - 1;
    }

    private String getText(int acceptLength) {
        StringBuffer s = new StringBuffer(acceptLength);
        int i = 0;
        while (i < acceptLength) {
            s.append(this.text.charAt(i));
            ++i;
        }
        return s.toString();
    }

    public static class State {
        public static final State NM = new State(0);
        public static final State EL = new State(1);
        private int id;

        private State(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }
    }
}

