/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.core.internal.el.impl;

import com.ibm.etools.siteedit.core.internal.el.ELErrorException;
import com.ibm.etools.siteedit.core.internal.el.VariableResolver;
import com.ibm.etools.siteedit.core.internal.el.error.PropertyNotFoundException;
import com.ibm.etools.siteedit.core.internal.el.impl.CourseUtil;
import com.ibm.etools.siteedit.core.internal.el.impl.Evalable;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

public class PropertyOperator
implements Evalable {
    private Evalable expA;
    private Evalable expB;

    public PropertyOperator(Evalable expA, Evalable expB) {
        this.expA = expA;
        this.expB = expB;
    }

    @Override
    public Object eval(VariableResolver env) throws ELErrorException {
        Object valueA = this.expA.eval(env);
        if (valueA == null) {
            return null;
        }
        Object valueB = this.expB.eval(env);
        if (valueB == null) {
            return null;
        }
        if (valueA instanceof Map) {
            Map map = (Map)valueA;
            if (!map.containsKey(valueB)) {
                return null;
            }
            return map.get(valueB);
        }
        if (valueA instanceof List) {
            int index = CourseUtil.toLong(valueB).intValue();
            try {
                return ((List)valueA).get(index);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
            catch (Exception e) {
                throw new ELErrorException(e);
            }
        }
        if (valueA.getClass().isArray()) {
            int index = CourseUtil.toLong(valueB).intValue();
            try {
                return Array.get(valueA, index);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
            catch (Exception e) {
                throw new ELErrorException(e);
            }
        }
        String name = CourseUtil.toString(valueB);
        if (name != null) {
            name = name.trim();
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(valueA.getClass());
            PropertyDescriptor[] pd = beanInfo.getPropertyDescriptors();
            int i = 0;
            while (i < pd.length) {
                Method m;
                if (pd[i].getName().equals(name) && (m = pd[i].getReadMethod()) != null) {
                    return m.invoke(valueA, null);
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new ELErrorException(e.getMessage());
        }
        String cname = valueA.getClass().getName();
        cname = cname.substring(cname.lastIndexOf(46) + 1);
        throw new PropertyNotFoundException(cname, name);
    }
}

