/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.core.internal.el.impl;

import com.ibm.etools.siteedit.core.internal.el.ELErrorException;
import com.ibm.etools.siteedit.core.internal.el.error.TypeCannotConvertException;

public final class CourseUtil {
    static final Long LONG_ZERO = new Long(0L);
    static final Double DOUBLE_ZERO = new Double(0.0);

    private CourseUtil() {
    }

    public static String toString(Object a) throws ELErrorException {
        if (a instanceof String) {
            return (String)a;
        }
        if (a == null) {
            return "";
        }
        try {
            return a.toString();
        }
        catch (Exception e) {
            throw new ELErrorException(e.getMessage());
        }
    }

    public static Long toLong(Object a) throws ELErrorException {
        if (a instanceof Long) {
            return (Long)a;
        }
        if (a == null || a.equals("")) {
            return LONG_ZERO;
        }
        if (a instanceof Character) {
            a = new Short((short)((Character)a).charValue());
        }
        try {
            if (a instanceof Number) {
                return new Long(((Number)a).longValue());
            }
            if (a instanceof String) {
                return Long.valueOf((String)a);
            }
        }
        catch (Exception e) {
            throw new ELErrorException(e.getMessage());
        }
        throw new TypeCannotConvertException(CourseUtil.getClassName(a), "Integer");
    }

    public static Double toDouble(Object a) throws ELErrorException {
        if (a instanceof Double) {
            return (Double)a;
        }
        if (a == null || a.equals("")) {
            return DOUBLE_ZERO;
        }
        if (a instanceof Character) {
            a = new Short((short)((Character)a).charValue());
        }
        try {
            if (a instanceof Number) {
                return new Double(((Number)a).doubleValue());
            }
            if (a instanceof String) {
                return Double.valueOf((String)a);
            }
        }
        catch (Exception e) {
            throw new ELErrorException(e.getMessage());
        }
        throw new TypeCannotConvertException(CourseUtil.getClassName(a), "Float");
    }

    public static Boolean toBoolean(Object a) throws ELErrorException {
        if (a == null || a.equals("")) {
            return Boolean.FALSE;
        }
        if (a instanceof Boolean) {
            return (Boolean)a;
        }
        try {
            if (a instanceof String) {
                return Boolean.valueOf((String)a);
            }
        }
        catch (Exception e) {
            throw new ELErrorException(e.toString());
        }
        throw new TypeCannotConvertException(CourseUtil.getClassName(a), "Boolean");
    }

    public static String getClassName(Object o) {
        if (o == null) {
            return "(null)";
        }
        String cname = o.getClass().getName();
        return cname.substring(cname.lastIndexOf(46) + 1);
    }
}

