/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.sitelib.emitter;

import com.ibm.etools.siteedit.sitelib.util.SitelibConstants;
import com.ibm.etools.siteedit.sitelib.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ScriptWriter
implements SitelibConstants {
    protected final String HX4 = "hX_4.";
    protected String menuId;
    protected List lines;

    public ScriptWriter(String menuId, Map attr) {
        this.menuId = menuId;
        this.lines = new ArrayList();
        this.clearInnerHTML();
        this.createMenu(attr);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator iter = this.lines.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            sb.append('\n');
        }
        return sb.toString();
    }

    private void clearInnerHTML() {
        StringBuffer sb = new StringBuffer();
        sb.append("document.getElementById(");
        sb.append(ScriptWriter.qq(this.menuId));
        sb.append(").innerHTML = " + ScriptWriter.qq(""));
        sb.append(';');
        this.lines.add(sb);
    }

    private void createMenu(Map attr) {
        StringBuffer sb = new StringBuffer();
        sb.append("hX_4.add(");
        sb.append(ScriptWriter.qq(this.menuId));
        sb.append(',');
        sb.append("new hX_4.J_M(");
        sb.append(new MenuArgs(attr));
        sb.append("));");
        this.lines.add(sb);
    }

    public void addMenuItem(String parentId, String selfId, MenuItem menuItem) {
        this.addMenuItem(parentId, selfId, menuItem, -1);
    }

    public void addMenuItem(String parentId, String selfId, MenuItem menuItem, int pos) {
        StringBuffer sb = new StringBuffer();
        sb.append("hX_4.addS(");
        sb.append(ScriptWriter.qq(parentId));
        sb.append(',');
        sb.append(ScriptWriter.qq(selfId));
        sb.append(',');
        sb.append("new hX_4.J_MI(");
        sb.append(menuItem);
        sb.append(')');
        if (pos >= 0) {
            sb.append(',');
            sb.append(pos);
        }
        sb.append(");");
        this.lines.add(sb);
    }

    public void addMenuItems(String itemId, MenuItem[] menuItems) {
        StringBuffer sb = new StringBuffer();
        sb.append("hX_4.addS(");
        sb.append(ScriptWriter.qq(itemId));
        sb.append(',');
        sb.append('[');
        int i = 0;
        while (i < menuItems.length) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append("new hX_4.J_MI(");
            sb.append(menuItems[i]);
            sb.append(')');
            ++i;
        }
        sb.append(']');
        sb.append(");");
        this.lines.add(sb);
    }

    protected static String sq(Object s) {
        return "'" + s.toString() + "'";
    }

    protected static String qq(Object s) {
        return String.valueOf('\"') + s.toString() + '\"';
    }

    public static class Link
    extends MenuItem {
        protected String label;
        protected String href;

        public Link(String label, String href) {
            this.label = label;
            this.href = href;
        }

        protected String getItemValue() {
            StringBuffer sb = new StringBuffer();
            sb.append(ScriptWriter.qq("lab:" + this.label));
            if (!this.href.equals("#")) {
                sb.append(',');
                sb.append(ScriptWriter.qq("action:goto"));
                sb.append(',');
                sb.append(ScriptWriter.qq("target:url(" + ScriptWriter.sq(this.href) + ")"));
            }
            return sb.toString();
        }
    }

    protected class MenuArgs
    implements SitelibConstants {
        private Map args = new HashMap();

        public MenuArgs(Map attr) {
            boolean keepSelection = StringUtils.getBoolean("keepSelection", "tabbedMenu".equals(attr.get("type")));
            if (keepSelection) {
                this.setValue("initial-selection", String.valueOf(ScriptWriter.this.menuId) + "-" + StringUtils.getInteger((String)attr.get("__initialIndex"), 1));
            }
            this.setValue("open-sticky", keepSelection);
            this.setValue("vertical", "verticalMenu".equals(attr.get("type")));
            this.setValue("vertical-body", !"tabbedMenu".equals(attr.get("type")));
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            Iterator iter = this.args.keySet().iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                sb.append(ScriptWriter.qq(String.valueOf(String.valueOf(key)) + ':' + this.args.get(key)));
                if (!iter.hasNext()) continue;
                sb.append(',');
            }
            return sb.toString();
        }

        private void setValue(String key, boolean value) {
            this.args.put(key, Boolean.toString(value));
        }

        private void setValue(String key, String value) {
            if (value != null) {
                this.args.put(key, value);
            }
        }
    }

    public static abstract class MenuItem {
        public String toString() {
            return this.getItemValue();
        }

        protected abstract String getItemValue();
    }

    public static class Separator
    extends MenuItem {
        private String label;

        public Separator() {
            this(null);
        }

        public Separator(String label) {
            this.label = label;
        }

        protected String getItemValue() {
            String s = "sep";
            if (this.label != null) {
                s = String.valueOf(s) + ':' + this.label;
            }
            return ScriptWriter.qq(s);
        }
    }
}

