/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.sitelib.core;

import com.ibm.etools.siteedit.sitelib.core.SiteItem;
import com.ibm.etools.siteedit.sitelib.util.SitelibConstants;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.w3c.dom.Element;

public abstract class SiteNode
extends DefaultMutableTreeNode
implements SitelibConstants {
    String name;
    String nid;

    protected SiteNode(Element elm) {
        this.name = elm.getNodeName();
        this.nid = elm.getAttribute("nid");
    }

    public abstract boolean isEntityNode();

    protected Map getAttributes() {
        HashMap<String, String> attr = new HashMap<String, String>();
        attr.put("nid", this.nid);
        return attr;
    }

    void setItem(SiteItem item) {
        this.setUserObject(item);
    }

    public SiteItem getItem() {
        return (SiteItem)this.getUserObject();
    }

    public SiteNode findNavRoot() {
        SiteNode p = this;
        while (!p.getItem().navroot && !p.isRoot()) {
            p = (SiteNode)p.getParent();
        }
        return p;
    }

    public List getChildren() {
        return this.children;
    }

    public SiteNode getFirstChildOfEntity() {
        SiteNode c = null;
        Enumeration<TreeNode> enumer = this.children();
        while (enumer.hasMoreElements()) {
            c = (SiteNode)enumer.nextElement();
            if (c.isEntityNode()) break;
        }
        return c;
    }

    public SiteNode getPreviousSiblingOfEntity() {
        SiteNode c = (SiteNode)this.getPreviousSibling();
        while (c != null) {
            if (c.isEntityNode()) break;
            c = (SiteNode)c.getPreviousSibling();
        }
        return c;
    }

    public SiteNode getNextSiblingOfEntity() {
        SiteNode c = (SiteNode)this.getNextSibling();
        while (c != null) {
            if (c.isEntityNode()) break;
            c = (SiteNode)c.getNextSibling();
        }
        return c;
    }

    public List getDescendantAt(int level) {
        ArrayList list = new ArrayList();
        this.getDescendantAt(list, this, level);
        return list;
    }

    private void getDescendantAt(List list, SiteNode node, int level) {
        if (node.getLevel() < level) {
            Enumeration<TreeNode> enumer = node.children();
            while (enumer.hasMoreElements()) {
                this.getDescendantAt(list, (SiteNode)enumer.nextElement(), level);
            }
        } else if (node.getLevel() == level) {
            list.add(node);
        }
    }

    public int getItemDepth() {
        int depth = 0;
        SiteNode p = this;
        while (p != null) {
            if (p.isEntityNode()) {
                ++depth;
            }
            p = (SiteNode)p.getParent();
        }
        return depth;
    }
}

