/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.sitelib.core;

import com.ibm.etools.siteedit.sitelib.core.SiteNode;
import com.ibm.etools.siteedit.sitelib.util.Counter;
import com.ibm.etools.siteedit.sitelib.util.SitelibConstants;
import com.ibm.etools.siteedit.sitelib.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SiteItem
implements SitelibConstants,
Cloneable {
    public static Counter counter = new Counter(0);
    public int uid = counter.getValue();
    public String src;
    public String servleturl;
    public String href;
    public String label;
    public boolean self;
    public boolean ancestor;
    public boolean group;
    public boolean navroot;
    public boolean navigation;
    public boolean sitemap;
    public boolean visible;
    SiteNode sitenode;

    SiteItem(Element e, SiteNode sitenodeofthisitem) {
        counter.incr();
        this.src = e.getAttribute("src");
        this.servleturl = e.getAttribute("servleturl");
        String string = this.href = this.servleturl.length() > 0 ? this.servleturl : this.src;
        if (e.hasChildNodes()) {
            NodeList nl = e.getChildNodes();
            int i = 0;
            block0: while (i < nl.getLength()) {
                Node n = nl.item(i);
                if (n.getNodeType() == 1 && "title".equals(n.getNodeName())) {
                    Node c = n.getFirstChild();
                    while (c != null) {
                        if (c.getNodeType() == 3) {
                            this.label = c.getNodeValue().trim();
                            break block0;
                        }
                        c = c.getNextSibling();
                    }
                    break;
                }
                ++i;
            }
        }
        this.navroot = StringUtils.getBoolean(e.getAttribute("navroot"), false);
        this.navigation = StringUtils.getBoolean(e.getAttribute("navigation"), true);
        this.sitemap = StringUtils.getBoolean(e.getAttribute("sitemap"), true);
        this.visible = true;
        this.sitenode = sitenodeofthisitem;
    }

    public boolean showIn(String family) {
        return "navigation".equals(family) && this.navigation || "sitemap".equals(family) && this.sitemap;
    }

    public boolean same(SiteItem item) {
        return this.uid == item.uid;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    Map getAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.src != null && this.src.length() > 0) {
            attrs.put("src", this.src);
        }
        if (this.servleturl != null && this.servleturl.length() > 0) {
            attrs.put("servleturl", this.servleturl);
        }
        if (this.label != null && this.label.length() > 0) {
            attrs.put("title", this.label);
        }
        if (this.navroot) {
            attrs.put("navroot", String.valueOf(this.navroot));
        }
        if (!this.navigation) {
            attrs.put("navigation", String.valueOf(this.navigation));
        }
        if (!this.sitemap) {
            attrs.put("sitemap", String.valueOf(this.sitemap));
        }
        return attrs;
    }

    public int getDepth() {
        int depth = 0;
        try {
            depth = this.sitenode.getItemDepth();
        }
        catch (Exception exception) {}
        return depth;
    }

    public int getLevel() {
        int depth = 0;
        int baseDepth = 0;
        try {
            depth = this.sitenode.getItemDepth();
            baseDepth = this.sitenode.findNavRoot().getItemDepth();
        }
        catch (Exception exception) {}
        return depth - baseDepth >= 0 ? depth - baseDepth : 0;
    }
}

