/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.search;

import com.ibm.etools.references.internal.search.AndPattern;
import com.ibm.etools.references.internal.search.BasicPattern;
import com.ibm.etools.references.internal.search.InternalSearchPattern;
import com.ibm.etools.references.internal.search.NullPattern;
import com.ibm.etools.references.internal.search.OrPattern;
import com.ibm.etools.references.internal.search.WildcardPattern;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.search.SearchType;
import org.eclipse.core.runtime.Assert;

public abstract class SearchPattern
extends InternalSearchPattern {
    public static final int R_EXACT_MATCH = 0;
    public static final int R_PREFIX_MATCH = 1;
    public static final int R_PATTERN_MATCH = 2;
    public static final int R_REGEXP_MATCH = 4;
    public static final int R_CASE_SENSITIVE = 8;

    public static SearchPattern createOrPattern(SearchPattern leftPattern, SearchPattern rightPattern) {
        if (leftPattern == null && rightPattern == null) {
            return SearchPattern.createNullPattern();
        }
        if (leftPattern == null) {
            return rightPattern;
        }
        if (rightPattern == null) {
            return leftPattern;
        }
        return new OrPattern(leftPattern, rightPattern);
    }

    public static SearchPattern createAndPattern(SearchPattern leftPattern, SearchPattern rightPattern) {
        if (leftPattern == null && rightPattern == null) {
            return SearchPattern.createNullPattern();
        }
        if (leftPattern == null) {
            return rightPattern;
        }
        if (rightPattern == null) {
            return leftPattern;
        }
        return new AndPattern(leftPattern, rightPattern);
    }

    public static SearchPattern createPattern(String searchString, SearchType searchType, IReferenceElement.ElementType limitTo, int matchRule) {
        Assert.isNotNull((Object)searchString);
        return new BasicPattern(searchString, searchType, limitTo, matchRule);
    }

    public static SearchPattern createWildcardPattern() {
        return new WildcardPattern();
    }

    public static SearchPattern createNullPattern() {
        return new NullPattern();
    }

    public SearchPattern or(SearchPattern other) {
        return SearchPattern.createOrPattern(this, other);
    }

    public SearchPattern and(SearchPattern other) {
        return SearchPattern.createAndPattern(this, other);
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();
}

