/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.search;

import com.ibm.etools.references.internal.search.BasicSearchScope;
import com.ibm.etools.references.internal.search.InternalSearchEngine;
import com.ibm.etools.references.internal.search.NullSearchScope;
import com.ibm.etools.references.internal.search.WorkspaceSearchScope;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.search.SearchPattern;
import com.ibm.etools.references.search.SearchRequestor;
import com.ibm.etools.references.search.SearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class SearchEngine
extends InternalSearchEngine {
    public SearchEngine() {
        super(false);
    }

    public SearchEngine(boolean ignoreParticipants) {
        super(ignoreParticipants);
    }

    public static void setSearchHint(EnumSet<SearchHint> nowait) {
        InternalSearchEngine.setSearchHint(nowait);
    }

    public static void clearSearchHint(EnumSet<SearchHint> nowait) {
        InternalSearchEngine.clearSearchHint(nowait);
    }

    public static SearchScope createSearchScope(Collection<? extends IResource> elements) {
        IResource r;
        if (elements.size() == 1 && (r = elements.iterator().next()) != null && r.getType() == 8) {
            return SearchEngine.createWorkspaceScope();
        }
        ArrayList<IPath> paths = new ArrayList<IPath>(elements.size());
        for (IResource iResource : elements) {
            if (iResource == null) continue;
            if (iResource.getType() == 4 || iResource.getType() == 2) {
                paths.add(iResource.getFullPath().addTrailingSeparator());
                continue;
            }
            paths.add(iResource.getFullPath());
        }
        if (paths.isEmpty()) {
            return new NullSearchScope();
        }
        return SearchEngine.createSearchScope(paths.toArray(new IPath[paths.size()]));
    }

    public static SearchScope createSearchScope(IResource ... elements) {
        if (elements.length == 1 && elements[0] != null && elements[0].getType() == 8) {
            return SearchEngine.createWorkspaceScope();
        }
        ArrayList<IPath> paths = new ArrayList<IPath>(elements.length);
        IResource[] iResourceArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource != null) {
                if (resource.getType() == 4 || resource.getType() == 2) {
                    paths.add(resource.getFullPath().addTrailingSeparator());
                } else {
                    paths.add(resource.getFullPath());
                }
            }
            ++n2;
        }
        if (paths.isEmpty()) {
            return new NullSearchScope();
        }
        return SearchEngine.createSearchScope(paths.toArray(new IPath[paths.size()]));
    }

    public static SearchScope createSearchScope(IPath ... elements) {
        if (elements == null || elements.length == 0) {
            return new NullSearchScope();
        }
        IPath[] iPathArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path = iPathArray[n2];
            if (path == null) {
                return new NullSearchScope();
            }
            ++n2;
        }
        return new BasicSearchScope(elements);
    }

    public static SearchScope createSearchScope(List<IPath> elements) {
        if (elements == null || elements.size() == 0) {
            return new NullSearchScope();
        }
        for (IPath path : elements) {
            if (path != null) continue;
            return new NullSearchScope();
        }
        return new BasicSearchScope(elements.toArray(new IPath[elements.size()]));
    }

    public static SearchScope createWorkspaceScope() {
        return new WorkspaceSearchScope();
    }

    @Override
    public <R extends IReferenceElement, SR extends SearchRequestor<R>> void search(SearchPattern pattern, SearchScope scope, SR requestor, IProgressMonitor monitor) throws ReferenceException {
        try {
            super.search(pattern, scope, requestor, monitor);
        }
        catch (RuntimeException e) {
            boolean cfr_ignored_0 = e instanceof OperationCanceledException;
            throw e;
        }
    }

    public static enum SearchHint {
        NOWAIT;

    }
}

