/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.refactoring;

import com.ibm.etools.references.internal.index.IndexConstants;
import com.ibm.etools.references.internal.management.ResolvedReference;
import com.ibm.etools.references.internal.nls.Messages;
import com.ibm.etools.references.internal.search.InternalSearchPattern;
import com.ibm.etools.references.internal.services.LinkTransformerService;
import com.ibm.etools.references.internal.services.LinkTypeRegistry;
import com.ibm.etools.references.internal.services.ReferenceGeneratorService;
import com.ibm.etools.references.internal.services.ReferenceResolverService;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.management.SpecializedType;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.search.DefaultSearchRequestor;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.search.SearchPattern;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.references.search.SearchType;
import com.ibm.etools.references.services.providers.CheckedReferenceRename;
import com.ibm.etools.references.services.providers.ProviderArguments;
import com.ibm.etools.references.services.providers.RefactoringGeneratorParameters;
import com.ibm.etools.references.services.providers.RefactoringResolverParameters;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.FileStatusContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class RefactoringSupport {
    private final LinkTransformerService TRANSFORMER = LinkTransformerService.getInstance();
    private final ReferenceGeneratorService GENERATOR = ReferenceGeneratorService.getInstance();
    private final ReferenceResolverService RESOLVER = ReferenceResolverService.getInstance();
    private final SearchEngine SEARCHER = new SearchEngine();
    private final Map<IFile, MultiTextEdit> fileEdits;
    private final Set<ILink> processedLinks;
    private final RefactoringStatus status = RefactoringStatus.create((IStatus)Status.OK_STATUS);

    public RefactoringSupport() {
        this.fileEdits = new TreeMap<IFile, MultiTextEdit>(new FileSorter());
        this.processedLinks = new HashSet<ILink>();
    }

    public final ILink getNodeIdLink(LinkNode<? extends IResource> node, IProgressMonitor monitor) throws ReferenceException {
        SearchPattern filePattern = SearchPattern.createPattern("builtin.file.nodeid", SearchType.BY_TYPE, IReferenceElement.ElementType.LINK, 0);
        SearchPattern folderPattern = SearchPattern.createPattern("builtin.folder.nodeid", SearchType.BY_TYPE, IReferenceElement.ElementType.LINK, 0);
        SearchPattern projectPattern = SearchPattern.createPattern("builtin.project.nodeid", SearchType.BY_TYPE, IReferenceElement.ElementType.LINK, 0);
        SearchScope scope = SearchEngine.createSearchScope(node.getResource());
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor);
        ReferenceManager.getReferenceManager().waitForIndexing((IProgressMonitor)sub.newChild(1), scope);
        DefaultSearchRequestor req = new DefaultSearchRequestor();
        this.SEARCHER.search(filePattern.or(folderPattern).or(projectPattern), scope, req, (IProgressMonitor)sub.newChild(1, 7));
        Set links = req.getMatches();
        if (links.size() >= 1) {
            return (ILink)links.iterator().next();
        }
        return null;
    }

    private static RefactoringStatus create(IStatus status, IFile file, IRegion region) {
        if (status.isOK()) {
            return new RefactoringStatus();
        }
        FileStatusContext context = new FileStatusContext(file, region);
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            RefactoringStatus result = new RefactoringStatus();
            int i = 0;
            while (i < children.length) {
                result.merge(RefactoringStatus.create((IStatus)children[i]));
                ++i;
            }
            return result;
        }
        switch (status.getSeverity()) {
            case 0: {
                return new RefactoringStatus();
            }
            case 1: {
                return RefactoringStatus.createWarningStatus((String)status.getMessage(), (RefactoringStatusContext)context);
            }
            case 2: {
                return RefactoringStatus.createErrorStatus((String)status.getMessage(), (RefactoringStatusContext)context);
            }
            case 4: {
                return RefactoringStatus.createFatalErrorStatus((String)status.getMessage(), (RefactoringStatusContext)context);
            }
            case 8: {
                return RefactoringStatus.createFatalErrorStatus((String)status.getMessage(), (RefactoringStatusContext)context);
            }
        }
        return RefactoringStatus.createFatalErrorStatus((String)status.getMessage(), (RefactoringStatusContext)context);
    }

    private static IRegion convert(Reference ref) {
        TextRange range = ref.getFragmentLocation();
        return new Region(ref.getSource().getLinkLocation().getOffset() + range.getOffset(), range.getLength());
    }

    public final void createLinkTextReplaceEdits(ILink linkToChange, String newLinkText) {
        ILink sourceLink = linkToChange;
        TextRange range = sourceLink.getLinkLocation();
        if (newLinkText != null && range != null) {
            this.createLinkTextReplaceEdits((IFile)sourceLink.getContainer().getResource(), range.getOffset(), range.getLength(), newLinkText);
        }
    }

    public final void createLinkTextReplaceEdits(IFile file, int offset, int length, String newLinkText) {
        if (newLinkText != null) {
            MultiTextEdit edit = this.fileEdits.get(file);
            if (edit == null) {
                edit = new MultiTextEdit();
                this.fileEdits.put(file, edit);
            }
            ReplaceEdit replaceEdit = new ReplaceEdit(offset, length, newLinkText);
            edit.addChild((TextEdit)replaceEdit);
        }
    }

    public final void createEdits(IResolvedReference resolvedReference, Map<String, Object> targetDescription, Set<ProviderArguments> args) {
        ILink linkToChange = resolvedReference.getSource();
        this.doCreateEdits(null, null, targetDescription, args, resolvedReference, linkToChange, null);
    }

    @Deprecated
    public final void createEdits(IResolvedReference resolvedReference, Map<String, Object> targetDescription) {
        this.createEdits(resolvedReference, targetDescription, Collections.<ProviderArguments>emptySet());
    }

    public final void createEdits(ILink linkToChange, Map<String, Object> targetDescription, Set<ProviderArguments> providerArguments, IProgressMonitor monitor) {
        this.createEdits(linkToChange, null, targetDescription, providerArguments, monitor);
    }

    public final void createEdits(ILink linkToChange, ILink targetLink, Map<String, Object> targetDescription, Set<ProviderArguments> providerArguments, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor);
        sub.beginTask("", 2);
        sub.subTask(linkToChange.getPath().toOSString());
        Set<IResolvedReference> incomingRRs = this.getResolvedReferences(linkToChange, (IProgressMonitor)sub.newChild(1, 7));
        sub.setWorkRemaining(incomingRRs.size());
        for (IResolvedReference resolvedReference : incomingRRs) {
            Reference ref = ((ResolvedReference)resolvedReference).getReference();
            this.doCreateEdits(null, targetLink, targetDescription, providerArguments, resolvedReference, ref.getSource(), null);
            sub.worked(1);
        }
    }

    public final void createEdits(IResource subject, IContainer newContainer, ILink linkToChange, LinkNode<? extends IResource> targetNode, boolean renameRefactoring, Set<ProviderArguments> providerArguments, boolean includeIncoming, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor);
        sub.beginTask("", 3);
        ReferenceManager.getReferenceManager().waitForIndexing((IProgressMonitor)sub.newChild(1), SearchEngine.createWorkspaceScope());
        if (linkToChange != null) {
            sub.subTask(linkToChange.getPath().toOSString());
        }
        IPath subjectPath = null;
        subjectPath = subject.getType() == 1 ? subject.getParent().getFullPath() : subject.getFullPath();
        if (includeIncoming) {
            Set<IResolvedReference> incomingRRs = this.getResolvedReferences(linkToChange, (IProgressMonitor)sub.newChild(1, 7));
            sub.setWorkRemaining(incomingRRs.size());
            for (IResolvedReference resolvedReference : incomingRRs) {
                Reference ref = ((ResolvedReference)resolvedReference).getReference();
                ILink source = ref.getSource();
                if (this.processedLinks.contains(source)) continue;
                LinkNode<IResource> newReferenceTargetContainer = null;
                if (subject == null) {
                    newReferenceTargetContainer = source.getContainer();
                } else {
                    IPath newSourcePath = source.getContainer().getResource().getFullPath();
                    if (subjectPath.isPrefixOf(newSourcePath) && subject.getType() != 1) {
                        Path partB = renameRefactoring ? new Path("") : new Path(subject.getFullPath().lastSegment());
                        int b = newSourcePath.matchingFirstSegments(subject.getFullPath());
                        IPath partC = newSourcePath.removeFirstSegments(b);
                        IPath path = partB.append(partC);
                        IPath newSourceTarget = newContainer.getFullPath().append(path);
                        newReferenceTargetContainer = ReferenceManager.getReferenceManager().getLinkNode(ResourcesPlugin.getWorkspace().getRoot().getFile(newSourceTarget));
                    }
                }
                this.doCreateEdits(targetNode, null, Collections.<String, Object>emptyMap(), providerArguments, resolvedReference, source, newReferenceTargetContainer);
                this.processedLinks.add(source);
                sub.worked(1);
            }
        }
        if (linkToChange != null) {
            Collection<IResolvedReference> outgoing = linkToChange.resolveReference(null, (IProgressMonitor)sub.newChild(1, 7));
            for (IResolvedReference reference : outgoing) {
                ILink source;
                if (reference.getTarget() == null || this.processedLinks.contains(source = reference.getSource())) continue;
                LinkNode<? extends IResource> newReferenceTargetContainer = targetNode;
                LinkNode<IResource> outTargetNode = reference.getTarget().getContainer();
                if (outTargetNode == null) continue;
                if (outTargetNode.equals(source.getContainer())) {
                    outTargetNode = targetNode;
                } else if (subjectPath.isPrefixOf(outTargetNode.getResource().getFullPath()) && subject != null && subject.getType() != 1) {
                    Path partB = renameRefactoring ? new Path("") : new Path(subjectPath.lastSegment());
                    int b = outTargetNode.getResource().getFullPath().matchingFirstSegments(subjectPath);
                    IPath partC = outTargetNode.getResource().getFullPath().removeFirstSegments(b);
                    IPath path = partB.append(partC);
                    IPath newSourceTarget = newContainer.getFullPath().append(path);
                    outTargetNode = ReferenceManager.getReferenceManager().getLinkNode(ResourcesPlugin.getWorkspace().getRoot().getFile(newSourceTarget));
                }
                this.doCreateEdits(outTargetNode, null, Collections.<String, Object>emptyMap(), providerArguments, reference, source, newReferenceTargetContainer);
                this.processedLinks.add(source);
            }
        }
        this.processedLinks.add(linkToChange);
    }

    public final void createEdits(IResource subject, IContainer newContainer, ILink linkToChange, LinkNode<? extends IResource> targetNode, boolean renameRefactoring, Set<ProviderArguments> providerArguments, IProgressMonitor monitor) {
        this.createEdits(subject, newContainer, linkToChange, targetNode, renameRefactoring, providerArguments, true, monitor);
    }

    private void doCreateEdits(LinkNode<? extends IResource> targetNode, ILink targetLink, Map<String, Object> targetDescription, Set<ProviderArguments> providerArguments, IResolvedReference resolvedReference, ILink source, LinkNode<? extends IResource> newReferenceTargetContainer) {
        LinkTransformerService.TransformerCache transformerCache = LinkTransformerService.getInstance().newCache();
        RefactoringResolverParameters resolverParams = new RefactoringResolverParameters(resolvedReference, targetNode, targetLink, targetDescription, providerArguments);
        CheckedReferenceRename renameStatus = this.RESOLVER.checkRenameReference(resolverParams);
        if (renameStatus == null) {
            return;
        }
        IStatus resolvedStatus = renameStatus.getRenameValidationStatus();
        if (resolvedStatus == null || resolvedStatus.getSeverity() == 8) {
            return;
        }
        Reference reference = resolvedReference.getReference();
        RefactoringStatus refResolvedtatus = RefactoringSupport.create(resolvedStatus, (IFile)source.getContainer().getResource(), RefactoringSupport.convert(reference));
        this.status.merge(refResolvedtatus);
        Map<String, Object> paramMap = this.RESOLVER.renameReference(resolverParams);
        if (paramMap == null) {
            return;
        }
        HashMap<String, Object> merged = new HashMap<String, Object>();
        merged.putAll(targetDescription);
        merged.putAll(paramMap);
        String expanded = this.TRANSFORMER.expand(source, source.getLinkText(), providerArguments, transformerCache);
        RefactoringGeneratorParameters genParams = new RefactoringGeneratorParameters(newReferenceTargetContainer, reference, expanded, merged, providerArguments);
        IStatus generatorStatus = this.GENERATOR.checkRenameReference(genParams);
        if (generatorStatus == null || generatorStatus.getSeverity() == 8) {
            return;
        }
        RefactoringStatus genStatus = RefactoringSupport.create(generatorStatus, (IFile)source.getContainer().getResource(), RefactoringSupport.convert(reference));
        this.status.merge(genStatus);
        String newText = this.GENERATOR.renameReference(genParams);
        String contracted = this.TRANSFORMER.contract(source, newText, providerArguments, transformerCache);
        if (contracted == null || !contracted.equals(reference.getFragmentText())) {
            ILink sourceLink = reference.getSource();
            TextRange range = reference.getFragmentLocation();
            if (newText != null && contracted != null && range != null) {
                MultiTextEdit edit = this.fileEdits.get(source.getContainer().getResource());
                if (edit == null) {
                    IFile file = (IFile)source.getContainer().getResource();
                    edit = new MultiTextEdit();
                    this.fileEdits.put(file, edit);
                }
                ReplaceEdit replaceEdit = new ReplaceEdit(sourceLink.getLinkLocation().getOffset() + range.getOffset(), range.getLength(), contracted);
                edit.addChild((TextEdit)replaceEdit);
            }
        }
    }

    public Change createMergedChange(String name, RefactoringParticipant renameParticipant, IProgressMonitor monitor) {
        if (this.fileEdits.isEmpty()) {
            return null;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor);
        sub.beginTask("", this.fileEdits.size());
        CompositeChange change = new CompositeChange(name);
        for (Map.Entry<IFile, MultiTextEdit> entry : this.fileEdits.entrySet()) {
            sub.subTask(entry.getKey().getFullPath().toOSString());
            TextChange textChange = null;
            if (renameParticipant != null) {
                textChange = renameParticipant.getTextChange((Object)entry.getKey());
            }
            if (textChange == null) {
                textChange = new TextFileChange(Messages.refactoring_update_text_in_file, entry.getKey());
                textChange.setEdit((TextEdit)entry.getValue());
                change.add((Change)textChange);
            } else {
                textChange.addEdit((TextEdit)entry.getValue());
            }
            sub.worked(1);
        }
        if (monitor != null) {
            monitor.done();
        }
        if (change.getChildren().length == 0) {
            return null;
        }
        return change;
    }

    public Change createMergedChange(String name, RefactoringProcessor renameParticipant, IProgressMonitor monitor) {
        if (this.fileEdits.isEmpty()) {
            return null;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor);
        sub.beginTask("", this.fileEdits.size());
        CompositeChange change = new CompositeChange(name);
        for (Map.Entry<IFile, MultiTextEdit> entry : this.fileEdits.entrySet()) {
            sub.subTask(entry.getKey().getFullPath().toOSString());
            TextChange textChange = null;
            if (renameParticipant != null) {
                textChange = renameParticipant.getRefactoring().getTextChange((Object)entry.getKey());
            }
            if (textChange == null) {
                textChange = new TextFileChange(Messages.refactoring_update_text_in_file, entry.getKey());
                textChange.setEdit((TextEdit)entry.getValue());
                change.add((Change)textChange);
            } else {
                textChange.addEdit((TextEdit)entry.getValue());
            }
            sub.worked(1);
        }
        if (monitor != null) {
            monitor.done();
        }
        if (change.getChildren().length == 0) {
            return null;
        }
        return change;
    }

    @Deprecated
    public final Change createChange(String name) {
        return this.createMergedChange(name, (RefactoringProcessor)null, (IProgressMonitor)null);
    }

    public final Change createChange(String name, IProgressMonitor monitor) {
        return this.createMergedChange(name, (RefactoringProcessor)null, monitor);
    }

    @Deprecated
    public final Change createDocumentChange(String name, Map<IFile, IDocument> docMap) {
        return this.createDocumentChange(name, docMap, null);
    }

    public final Change createDocumentChange(String name, Map<IFile, IDocument> docMap, IProgressMonitor monitor) {
        if (this.fileEdits.isEmpty()) {
            return null;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor);
        sub.beginTask("", this.fileEdits.size());
        CompositeChange change = new CompositeChange(name);
        for (Map.Entry<IFile, MultiTextEdit> entry : this.fileEdits.entrySet()) {
            IFile file = entry.getKey();
            sub.subTask(file.getFullPath().toString());
            IDocument doc = docMap.get(file);
            if (doc == null) {
                sub.worked(1);
                continue;
            }
            DocumentChange docChange = new DocumentChange(Messages.refactoring_update_text_in_doc, doc);
            docChange.setEdit((TextEdit)entry.getValue());
            change.add((Change)docChange);
            sub.worked(1);
        }
        if (monitor != null) {
            monitor.done();
        }
        return change;
    }

    protected final IResolvedReference searchForResolvedReference(Reference reference, IProgressMonitor monitor) throws ReferenceException {
        SearchPattern pattern = InternalSearchPattern.createPattern(Integer.toString(reference.getId()), IndexConstants.BY_REFERENCE_ID, IReferenceElement.ElementType.RESOLVED_REFERENCE, 0);
        SearchScope scope = SearchEngine.createWorkspaceScope();
        DefaultSearchRequestor req = new DefaultSearchRequestor();
        this.SEARCHER.search(pattern, scope, req, monitor);
        Set refs = req.getMatches();
        if (refs.isEmpty()) {
            return null;
        }
        return (IResolvedReference)refs.iterator().next();
    }

    protected Set<IResolvedReference> getResolvedReferences(ILink link, IProgressMonitor monitor) throws ReferenceException {
        if (link == null) {
            return Collections.emptySet();
        }
        String linkId = Integer.toString(link.getId());
        IndexConstants constant = IndexConstants.BY_TARGETLINKID;
        SearchPattern pattern = InternalSearchPattern.createPattern(linkId, constant, IReferenceElement.ElementType.RESOLVED_REFERENCE, 0);
        SearchScope scope = SearchEngine.createWorkspaceScope();
        DefaultSearchRequestor req = new DefaultSearchRequestor();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor);
        sub.beginTask("", 1);
        this.SEARCHER.search(pattern, scope, req, (IProgressMonitor)sub.newChild(1, 7));
        Set<IResolvedReference> matches = req.getMatches();
        return matches;
    }

    public RefactoringStatus getStatus() {
        return this.status;
    }

    public Set<ILink> getPathDependentLinks(LinkNode<IFile> linkNode, IProgressMonitor monitor) throws ReferenceException {
        List<SpecializedType> pathDependenLinks = LinkTypeRegistry.getInstance().getPathDependentLinks();
        SearchPattern pattern = null;
        for (SpecializedType stype : pathDependenLinks) {
            SearchPattern p = SearchPattern.createPattern(stype.getId(), SearchType.BY_TYPE, IReferenceElement.ElementType.LINK, 0);
            pattern = pattern == null ? p : pattern.or(p);
        }
        if (pattern != null) {
            SearchScope scope = SearchEngine.createSearchScope(new IResource[]{linkNode.getResource()});
            DefaultSearchRequestor req = new DefaultSearchRequestor();
            this.SEARCHER.search(pattern, scope, req, monitor);
            Set<ILink> links = req.getMatches();
            return links;
        }
        return Collections.emptySet();
    }

    private static class FileSorter
    implements Comparator<IFile> {
        private FileSorter() {
        }

        @Override
        public int compare(IFile o1, IFile o2) {
            return o1.getFullPath().toString().compareTo(o2.getFullPath().toString());
        }
    }
}

