/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.management;

import com.ibm.etools.references.internal.management.InternalSpecializedType;
import java.util.Collections;
import java.util.Map;

public final class SpecializedType
extends InternalSpecializedType
implements Comparable<SpecializedType> {
    private final String id;
    private final SpecializedType parent;
    private final boolean pathDependent;
    private final boolean internal;
    private final Map<String, String> properties;

    public SpecializedType(String id, SpecializedType parent, boolean pathDependent, boolean internal, Map<String, String> properties) {
        this.id = id;
        this.parent = parent;
        this.pathDependent = pathDependent;
        this.internal = internal;
        this.properties = Collections.unmodifiableMap(properties);
    }

    public boolean isInternal() {
        return this.internal;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public int compareTo(SpecializedType o) {
        return this.id.compareTo(o.id);
    }

    public String getId() {
        return this.id;
    }

    public SpecializedType getParent() {
        return this.parent;
    }

    public boolean isSubType(SpecializedType specializedType) {
        SpecializedType p = this.getParent();
        while (p != null) {
            if (p.equals(specializedType)) {
                return true;
            }
            p = p.getParent();
        }
        return false;
    }

    public boolean isPathDependent() {
        return this.pathDependent;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpecializedType other = (SpecializedType)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return this.getId();
    }

    public static enum Depth {
        ZERO,
        ONE,
        INFINITE;

    }
}

