/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.management;

import org.eclipse.core.resources.IResource;

public final class ResourceChange {
    public static final int ADD = 1;
    public static final int REMOVE = 2;
    public static final int CHANGE = 4;
    public static final int TRIGGER = 8;
    private int type;
    private final IResource resource;

    public ResourceChange(IResource resource, int type) {
        this.resource = resource;
        this.type = type;
    }

    public IResource getResource() {
        return this.resource;
    }

    public int getType() {
        return this.type;
    }

    public boolean isAdd() {
        return this.getBoolean(1);
    }

    public boolean isRemove() {
        return this.getBoolean(2);
    }

    public boolean isChange() {
        return this.getBoolean(4);
    }

    public boolean isTrigger() {
        return this.getBoolean(8);
    }

    public void setTrigger(boolean newValue) {
        if (newValue) {
            this.setTrue(8);
        } else {
            this.setFalse(8);
        }
    }

    public String toString() {
        String s = "Indexer resource change: " + this.getResource() + " : ";
        if (this.getBoolean(1)) {
            s = String.valueOf(s) + "ADD";
        }
        if (this.getBoolean(2)) {
            s = String.valueOf(s) + "REMOVE";
        }
        if (this.getBoolean(4)) {
            s = String.valueOf(s) + "CHANGE";
        }
        if (this.getBoolean(8)) {
            s = String.valueOf(s) + "TRIGGER";
        }
        return s;
    }

    private boolean getBoolean(int mask) {
        return (this.type & mask) == mask;
    }

    private void setTrue(int mask) {
        this.type |= mask;
    }

    private void setFalse(int mask) {
        this.type &= ~mask;
    }
}

