/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.management;

import com.ibm.etools.references.internal.index.ReferenceDatabase;
import com.ibm.etools.references.internal.management.Link;
import com.ibm.etools.references.internal.management.ResolvedReference;
import com.ibm.etools.references.internal.services.LinkTypeRegistry;
import com.ibm.etools.references.management.BrokenStatus;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.management.TextRange;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;

public class ReferenceElementFactory {
    private final int linkProviderId;
    private final int resolverProviderId;
    private final LinkNode<IResource> linkNode;

    public ReferenceElementFactory(int linkProviderId, int resolverProviderId, LinkNode<IResource> linkNode) {
        this.linkProviderId = linkProviderId;
        this.resolverProviderId = resolverProviderId;
        this.linkNode = linkNode;
    }

    public ILink createLink(String linkType, String name, String contextText, TextRange contextRange, String linkText, TextRange linkRange, boolean endpoint) {
        Link link = ReferenceDatabase.getDefault().createNewLink();
        if (this.linkNode != null) {
            link.setContainer(this.linkNode);
        }
        link.setSpecializedType(LinkTypeRegistry.getInstance().getLinkType(linkType));
        link.setContextText(contextText);
        link.setContextLocation(contextRange);
        link.setText(linkText);
        link.setLocation(linkRange);
        link.setEndpoint(endpoint);
        link.setName(name);
        link.setProviderId(this.linkProviderId);
        return link;
    }

    public void setCrossProjectAddressable(ILink link, boolean crossProjectAddressable) {
        Assert.isNotNull((Object)link);
        ((Link)link).setCrossProjectAddressable(crossProjectAddressable);
    }

    public void addParam(ILink link, String key, String value) {
        Assert.isNotNull((Object)key);
        Assert.isNotNull((Object)value);
        ((Link)link).addParameter(key, value);
    }

    public IResolvedReference createResolvedReference(BrokenStatus status, Reference source, ILink target, String brokenLinkInfo) {
        return this.createResolvedReference(status, source, target, brokenLinkInfo, true);
    }

    public IResolvedReference createResolvedReference(BrokenStatus status, Reference source, ILink target, String brokenLinkInfo, boolean nodeIdLinkTarget) {
        ResolvedReference ref = ReferenceDatabase.getDefault().createNewResolvedReference();
        ref.setProviderId(this.resolverProviderId);
        ref.setBrokenStatus(status);
        ref.setNodeIdLinkTarget(nodeIdLinkTarget);
        Assert.isTrue((source != null ? 1 : 0) != 0, (String)"Reference cannot be null");
        ref.setReference(source);
        ref.setTarget(target);
        ref.setBrokenLinkInfo(brokenLinkInfo);
        ref.freeze();
        return ref;
    }
}

