/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.services;

import com.ibm.etools.references.Logger;
import com.ibm.etools.references.internal.bplustree.tree.ByteUtils;
import com.ibm.etools.references.internal.services.ProviderClassDescriptorComparator;
import com.ibm.etools.references.internal.services.ProviderIdDescriptorComparator;
import com.ibm.etools.references.internal.services.SafeRun;
import com.ibm.etools.references.services.providers.IProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.Adler32;
import org.eclipse.core.expressions.ElementHandler;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.osgi.util.NLS;

public abstract class Service<P extends IProvider> {
    private static final AtomicInteger typeIdCount = new AtomicInteger(0);
    private static final List<ProviderDescriptor<? extends IProvider>> descriptors = new ArrayList<ProviderDescriptor<? extends IProvider>>();
    private List<ProviderDescriptor<P>> providerDescriptors;

    protected ProviderDescriptor<P> newProviderDescriptor(IConfigurationElement configurationElement) {
        return new ProviderDescriptor(configurationElement);
    }

    public final void configureProviders(String namespace, String extensionPointName) {
        this.configureProviders(Platform.getExtensionRegistry().getExtensionPoint(namespace, extensionPointName).getConfigurationElements());
        if (this.hasUniqueIds()) {
            ArrayList<ProviderDescriptor<P>> providers = new ArrayList<ProviderDescriptor<P>>(this.getAllProviders());
            int i = 0;
            while (i < providers.size()) {
                ((ProviderDescriptor)providers.get(i)).setTypeId(typeIdCount.incrementAndGet());
                ++i;
            }
        }
    }

    protected boolean hasUniqueIds() {
        return false;
    }

    public final void configureProviders(IConfigurationElement[] elements) {
        Assert.isNotNull((Object)elements);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            this.addProvider(this.newProviderDescriptor(element));
            ++i;
        }
        if (this.hasUniqueIds()) {
            if (this.providerDescriptors != null) {
                Collections.sort(this.providerDescriptors, new ProviderIdDescriptorComparator());
            }
        } else if (this.providerDescriptors != null) {
            Collections.sort(this.providerDescriptors, new ProviderClassDescriptorComparator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addProvider(ProviderDescriptor<P> provider) {
        Assert.isTrue((provider != null ? 1 : 0) != 0, (String)"null ProviderDescriptor");
        if (this.providerDescriptors == null) {
            this.providerDescriptors = new ArrayList<ProviderDescriptor<P>>();
        }
        this.providerDescriptors.add(provider);
        List<ProviderDescriptor<? extends IProvider>> list = descriptors;
        synchronized (list) {
            descriptors.add(provider);
        }
    }

    protected final List<ProviderDescriptor<P>> getAllProviders() {
        if (this.providerDescriptors == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.providerDescriptors);
    }

    protected List<P> getApplicableProviders(Object context) {
        ArrayList<P> providers = new ArrayList<P>();
        for (ProviderDescriptor<P> desc : this.getAllProviders()) {
            if (!desc.isApplicable(context)) continue;
            providers.add(desc.getProvider());
        }
        return Collections.unmodifiableList(providers);
    }

    protected List<ProviderDescriptor<P>> getApplicableProviderDescriptors(Object context) {
        ArrayList<ProviderDescriptor<P>> providers = new ArrayList<ProviderDescriptor<P>>();
        for (ProviderDescriptor<P> desc : this.getAllProviders()) {
            if (!desc.isApplicable(context)) continue;
            providers.add(desc);
        }
        return Collections.unmodifiableList(providers);
    }

    protected final P getFirstProvider(Object context) {
        List<P> list = this.getApplicableProviders(context);
        if (list.size() > 0) {
            return (P)((IProvider)list.get(0));
        }
        return null;
    }

    public final long checksum() {
        Adler32 checksum = new Adler32();
        List<ProviderDescriptor<P>> providers = this.getAllProviders();
        for (ProviderDescriptor<P> providerDescriptor : providers) {
            IConfigurationElement element = providerDescriptor.configurationElement;
            Service.getChecksum(element, checksum);
        }
        return checksum.getValue();
    }

    public static final void getChecksum(IConfigurationElement element, Adler32 adler) {
        IConfigurationElement[] children;
        String[] attributeNames;
        String name = element.getName();
        adler.update(ByteUtils.stringToBytes(name).array());
        String namespace = element.getNamespaceIdentifier();
        adler.update(ByteUtils.stringToBytes(namespace).array());
        String value = element.getValue();
        if (value != null) {
            adler.update(ByteUtils.stringToBytes(value).array());
        }
        String[] stringArray = attributeNames = element.getAttributeNames();
        int n = attributeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String attributeName = stringArray[n2];
            String attributeValue = element.getAttribute(attributeName);
            adler.update(ByteUtils.stringToBytes(attributeName).array());
            adler.update(ByteUtils.stringToBytes(attributeValue).array());
            ++n2;
        }
        IConfigurationElement[] iConfigurationElementArray = children = element.getChildren();
        int n3 = children.length;
        n = 0;
        while (n < n3) {
            IConfigurationElement child = iConfigurationElementArray[n];
            Service.getChecksum(child, adler);
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getProviderType(int providerId) {
        List<ProviderDescriptor<? extends IProvider>> list = descriptors;
        synchronized (list) {
            List<ProviderDescriptor<? extends IProvider>> descList = descriptors;
            for (ProviderDescriptor<? extends IProvider> desc : descList) {
                if (desc.getTypeId() != providerId) continue;
                return desc.getId().getLocalName();
            }
        }
        return "<unknown>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ProviderDescriptor<? extends IProvider> getProvider(String qualifiedName) {
        List<ProviderDescriptor<? extends IProvider>> list = descriptors;
        synchronized (list) {
            String[] split = qualifiedName.split(":");
            List<ProviderDescriptor<? extends IProvider>> descList = descriptors;
            for (ProviderDescriptor<? extends IProvider> desc : descList) {
                if (desc.getId() == null || !desc.getId().getQualifier().equals(split[0]) || !desc.getId().getLocalName().equals(split[1])) continue;
                return desc;
            }
        }
        return null;
    }

    public List<Integer> getIds() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        List<ProviderDescriptor<P>> allProviders = this.getAllProviders();
        for (ProviderDescriptor<P> providerDescriptor : allProviders) {
            ids.add(providerDescriptor.getTypeId());
        }
        return ids;
    }

    public List<String> getTypeIds() {
        ArrayList<String> ids = new ArrayList<String>();
        List<ProviderDescriptor<P>> allProviders = this.getAllProviders();
        for (ProviderDescriptor<P> providerDescriptor : allProviders) {
            ids.add(String.valueOf(providerDescriptor.getId().getQualifier()) + ":" + providerDescriptor.getId().getLocalName());
        }
        return ids;
    }

    public ProviderDescriptor<P> getProvider(int id) {
        List<ProviderDescriptor<P>> allProviders = this.getAllProviders();
        for (ProviderDescriptor<P> providerDescriptor : allProviders) {
            if (providerDescriptor.getTypeId() != id) continue;
            return providerDescriptor;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IProvider getProviderByTypeId(int typeId) {
        List<ProviderDescriptor<? extends IProvider>> list = descriptors;
        synchronized (list) {
            for (ProviderDescriptor<? extends IProvider> providerDescriptor : descriptors) {
                if (providerDescriptor.getTypeId() != typeId) continue;
                return providerDescriptor.getProvider();
            }
            return null;
        }
    }

    public static class ProviderDescriptor<P extends IProvider> {
        private final HashMap<IConfigurationElement, Expression> expressionsCache = new HashMap();
        protected final IConfigurationElement configurationElement;
        protected P provider;
        private QualifiedName name;
        protected int typeId;
        private boolean providerClassInstantiationFailed;
        protected static final String A_CLASS = "class";
        protected static final String E_ENABLEMENT = "enablement";
        protected static final String E_ENABLEMENT_TRIGGER = "enablementTrigger";
        protected static final String A_ID = "id";
        private final HashMap<IConfigurationElement, HashMap<String, List<IConfigurationElement>>> cache = new HashMap();

        public ProviderDescriptor(IConfigurationElement configurationElement) {
            this.configurationElement = configurationElement;
        }

        protected IConfigurationElement getEnablement(IConfigurationElement element) {
            return this.getSingleChild(element, E_ENABLEMENT);
        }

        protected IConfigurationElement getEnablementTrigger(IConfigurationElement element) {
            return this.getSingleChild(element, E_ENABLEMENT_TRIGGER);
        }

        protected boolean isTriggered(IConfigurationElement element, String triggerPoint, Map<String, String> arguments) {
            String attribute;
            boolean triggered = false;
            IConfigurationElement trigger = this.getEnablementTrigger(element);
            if (trigger != null && triggerPoint.equals(attribute = trigger.getAttribute("triggerRef"))) {
                List<IConfigurationElement> args = this.getChildren(trigger, "arg");
                triggered = args.isEmpty();
                for (IConfigurationElement configurationElement : args) {
                    List<String> argList;
                    String argValues;
                    String value;
                    String name = configurationElement.getAttribute("name");
                    if (name == null || (value = configurationElement.getAttribute("value")) == null || (argValues = arguments.get(name)) == null || !(argList = Arrays.asList(argValues.split(","))).contains(value)) continue;
                    triggered = true;
                    break;
                }
            }
            return triggered;
        }

        protected final String getClassName() {
            return this.configurationElement.getAttribute(A_CLASS);
        }

        protected IConfigurationElement getSingleChild(IConfigurationElement element, String childElementName) {
            List<IConfigurationElement> children = this.getChildren(element, childElementName);
            if (!children.isEmpty()) {
                return children.iterator().next();
            }
            return null;
        }

        protected List<IConfigurationElement> getChildren(IConfigurationElement element, String childElementName) {
            List<IConfigurationElement> children = Collections.emptyList();
            HashMap<String, List<Object>> nameToChildren = this.cache.get(element);
            if (nameToChildren == null) {
                nameToChildren = new HashMap();
                this.cache.put(element, nameToChildren);
            }
            if ((children = nameToChildren.get(childElementName)) == null) {
                children = Arrays.asList(element.getChildren(childElementName));
                nameToChildren.put(childElementName, children);
            }
            return children;
        }

        protected boolean expressionEnabled(final Object context, final IConfigurationElement element) {
            if (this.getEnablement(element) != null) {
                EvaluationResult result = SafeRun.run(this, new SafeRun.IRunnableWithResult<EvaluationResult>(){

                    @Override
                    public EvaluationResult run() throws Exception {
                        EvaluationContext econtext = new EvaluationContext(null, context);
                        econtext.setAllowPluginActivation(true);
                        return ProviderDescriptor.this.getEnablementExpression(element).evaluate((IEvaluationContext)econtext);
                    }

                    @Override
                    protected String getFriendlyMsg(Object delegateCode) {
                        String id = "Plugin id: {0}, contributing plugin: {1}";
                        QualifiedName name = ProviderDescriptor.this.getId();
                        if (name == null) {
                            try {
                                id = NLS.bind((String)id, (Object)"none", (Object)ProviderDescriptor.this.configurationElement.getContributor().getName());
                            }
                            catch (InvalidRegistryObjectException e) {
                                id = NLS.bind((String)id, (Object)"none", (Object)NLS.bind((String)"Unknown: {0}", (Object)e.getMessage()));
                            }
                        } else {
                            try {
                                id = NLS.bind((String)id, (Object)name.toString(), (Object)ProviderDescriptor.this.configurationElement.getContributor().getName());
                            }
                            catch (InvalidRegistryObjectException e) {
                                id = NLS.bind((String)id, (Object)name.toString(), (Object)NLS.bind((String)"Unknown: {0}", (Object)e.getMessage()));
                            }
                        }
                        return NLS.bind((String)"Error in {0} during enablement testing of extension point: {1}", (Object)this.getPluginId(delegateCode), (Object)id);
                    }
                });
                return EvaluationResult.TRUE.equals(result);
            }
            return true;
        }

        protected Expression getEnablementExpression(IConfigurationElement element) {
            Expression exp = this.expressionsCache.get(element);
            if (exp == null) {
                try {
                    exp = ElementHandler.getDefault().create(ExpressionConverter.getDefault(), this.getEnablement(element));
                    if (exp != null) {
                        this.expressionsCache.put(element, exp);
                    }
                }
                catch (CoreException e) {
                    Logger.log(e.getStatus());
                }
            }
            return exp;
        }

        public boolean isApplicable(Object context) {
            return true;
        }

        public P getProvider() {
            if (this.provider == null && !this.providerClassInstantiationFailed) {
                try {
                    this.provider = (IProvider)this.configurationElement.createExecutableExtension(A_CLASS);
                }
                catch (CoreException ce) {
                    if (this.provider == null) {
                        this.providerClassInstantiationFailed = true;
                    }
                    Logger.log(ce.getStatus());
                }
            }
            return this.provider;
        }

        public QualifiedName getId() {
            String id = this.configurationElement.getAttribute(A_ID);
            if (id == null) {
                return null;
            }
            if (this.name == null) {
                this.name = new QualifiedName(this.configurationElement.getNamespaceIdentifier(), id);
            }
            return this.name;
        }

        public void setTypeId(int typeId) {
            this.typeId = typeId;
        }

        public int getTypeId() {
            return this.typeId;
        }
    }
}

