/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.services;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.events.ErrorEvent;
import com.ibm.etools.references.internal.Activator;
import com.ibm.etools.references.internal.nls.Messages;
import com.ibm.etools.references.internal.services.ProviderPerformanceTracker;
import java.util.Collections;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.osgi.util.NLS;

public final class SafeRun {
    public static final <E> E run(Object code, IRunnableWithResult<E> runnable) {
        return SafeRun.run(true, code, runnable);
    }

    public static final <E> E run(boolean time, Object code, IRunnableWithResult<E> runnable) {
        if (code == null) {
            return null;
        }
        SafeRunnableWithResult<E> delegating = new SafeRunnableWithResult<E>(code, runnable);
        boolean enabled = ProviderPerformanceTracker.ENABLED;
        long start = 0L;
        if (enabled) {
            start = System.nanoTime();
        }
        delegating.run();
        if (enabled) {
            long end = System.nanoTime();
            long lengthN = end - start;
            ProviderPerformanceTracker.addExecution(code, lengthN);
        }
        return delegating.getResult();
    }

    public static abstract class IRunnableWithResult<T> {
        public abstract T run() throws Exception;

        public void handleException(Object delegateCode, Throwable e) {
            this.logException(delegateCode, e);
        }

        protected String getMsg() {
            return Messages.SafeRun_ErrorWhenExecuting;
        }

        protected final void logException(Object delegateCode, Throwable e) {
            String friendlyMsg = this.getFriendlyMsg(delegateCode);
            String pluginId = this.getPluginId(delegateCode);
            InternalAPI.handleContributionException(friendlyMsg, pluginId, e, Collections.singleton(ErrorEvent.PresentationHints.LOG));
        }

        protected String getFriendlyMsg(Object delegateCode) {
            return NLS.bind((String)this.getMsg(), (Object)delegateCode.getClass().getName());
        }

        protected String getPluginId(Object delegateCode) {
            return Activator.getBundleId(delegateCode);
        }
    }

    private static class SafeRunnableWithResult<T>
    implements ISafeRunnable {
        private final Object delegateCode;
        private T result;
        private final IRunnableWithResult<T> runnable;

        public SafeRunnableWithResult(Object delegateCode, IRunnableWithResult<T> runnable) {
            this.runnable = runnable;
            Assert.isNotNull((Object)delegateCode);
            this.delegateCode = delegateCode;
        }

        public final void run() {
            try {
                this.result = this.runnable.run();
            }
            catch (Exception e) {
                this.handleException(e);
            }
            catch (LinkageError e) {
                this.handleException(e);
            }
            catch (VirtualMachineError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Error e) {
                this.handleException(e);
            }
        }

        public T getResult() {
            return this.result;
        }

        public void handleException(Throwable exception) {
            this.runnable.handleException(this.delegateCode, exception);
        }
    }
}

