/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.services;

import com.ibm.etools.references.internal.services.SafeRun;
import com.ibm.etools.references.internal.services.Service;
import com.ibm.etools.references.services.providers.AbstractResourceApprover;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;

public class ResourceApproverService
extends Service<AbstractResourceApprover> {
    private static ResourceApproverService service = null;

    @Override
    protected Service.ProviderDescriptor<AbstractResourceApprover> newProviderDescriptor(IConfigurationElement configurationElement) {
        return new ResourceApproverDescriptor(configurationElement);
    }

    public boolean isTargettable(final IResource resource, List<String> enabledIds) {
        boolean targettable = true;
        List applicableProviderDescriptors = this.getApplicableProviderDescriptors(resource);
        for (Service.ProviderDescriptor providerDescriptor : applicableProviderDescriptors) {
            AbstractResourceApprover approver;
            String id;
            if (providerDescriptor.getId() != null && enabledIds.contains(id = String.valueOf(providerDescriptor.getId().getQualifier()) + ":" + providerDescriptor.getId().getLocalName()) && !(targettable = SafeRun.run(approver = (AbstractResourceApprover)providerDescriptor.getProvider(), new SafeRun.IRunnableWithResult<Boolean>(){

                @Override
                public Boolean run() throws Exception {
                    return approver.isTargettable(resource);
                }
            }).booleanValue())) break;
        }
        return targettable;
    }

    public boolean containsLinks(final IResource resource, List<String> enabledIds) {
        boolean containsLinks = true;
        List applicableProviderDescriptors = this.getApplicableProviderDescriptors(resource);
        for (Service.ProviderDescriptor providerDescriptor : applicableProviderDescriptors) {
            AbstractResourceApprover approver;
            String id;
            if (providerDescriptor.getId() != null && enabledIds.contains(id = String.valueOf(providerDescriptor.getId().getQualifier()) + ":" + providerDescriptor.getId().getLocalName()) && !(containsLinks = SafeRun.run(approver = (AbstractResourceApprover)providerDescriptor.getProvider(), new SafeRun.IRunnableWithResult<Boolean>(){

                @Override
                public Boolean run() throws Exception {
                    return approver.containsLinks(resource);
                }
            }).booleanValue())) break;
        }
        return containsLinks;
    }

    public static final synchronized ResourceApproverService getInstance() {
        if (service == null) {
            service = new ResourceApproverService();
            service.configureProviders("com.ibm.etools.references", "resourceApprover");
        }
        return service;
    }

    @Override
    protected boolean hasUniqueIds() {
        return true;
    }

    @Override
    public List<Integer> getIds() {
        return super.getIds();
    }

    @Override
    public List<String> getTypeIds() {
        return super.getTypeIds();
    }

    public String getName(String id) {
        ResourceApproverDescriptor provider = (ResourceApproverDescriptor)this.getProvider(id);
        if (provider != null) {
            return provider.getName();
        }
        return null;
    }

    public String getDescription(String id) {
        ResourceApproverDescriptor provider = (ResourceApproverDescriptor)this.getProvider(id);
        if (provider != null) {
            return provider.getDescription();
        }
        return null;
    }

    public class ResourceApproverDescriptor
    extends Service.ProviderDescriptor<AbstractResourceApprover> {
        public ResourceApproverDescriptor(IConfigurationElement configurationElement) {
            super(configurationElement);
            Assert.isLegal((this.getName() != null ? 1 : 0) != 0, (String)"name attribute must be present");
            Assert.isLegal((this.getDescription() != null ? 1 : 0) != 0, (String)"description attribute must be present");
        }

        public String getName() {
            return this.configurationElement.getAttribute("name");
        }

        public String getDescription() {
            return this.configurationElement.getAttribute("description");
        }

        @Override
        public boolean isApplicable(Object context) {
            return true;
        }
    }
}

