/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.services;

import com.ibm.etools.references.InternalAPI;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public class ProviderPerformanceTracker {
    public static final boolean ENABLED = InternalAPI.Tweaks.SHOULD_TRACK_EXTENSION_PERFORMANCE;
    private static ConcurrentMap<Object, Stat> stats;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConcurrentMap<Object, Stat> getStats() {
        Class<ProviderPerformanceTracker> clazz = ProviderPerformanceTracker.class;
        synchronized (ProviderPerformanceTracker.class) {
            if (stats == null) {
                stats = new ConcurrentHashMap<Object, Stat>();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return stats;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addExecution(Object code, long lengthN) {
        if (ENABLED) {
            Stat newStats = new Stat();
            newStats.number = 1;
            newStats.totalN = lengthN;
            newStats.code = code;
            Stat existing = ProviderPerformanceTracker.getStats().putIfAbsent(code, newStats);
            if (existing != null) {
                Stat stat = existing;
                synchronized (stat) {
                    ++existing.number;
                    existing.totalN += lengthN;
                }
            }
        }
    }

    public static void print() {
        ProviderPerformanceTracker.print(System.out);
    }

    public static void print(PrintStream stream) {
        if (ENABLED) {
            ArrayList stats = new ArrayList(ProviderPerformanceTracker.getStats().values());
            ArrayList<Stat> copy = new ArrayList<Stat>(stats.size());
            for (Stat stat : stats) {
                copy.add(stat.copy());
            }
            Collections.sort(copy, new Comparator<Stat>(){

                @Override
                public int compare(Stat o1, Stat o2) {
                    if (o1.totalN < o2.totalN) {
                        return 1;
                    }
                    if (o1.totalN > o2.totalN) {
                        return -1;
                    }
                    return 0;
                }
            });
            for (Stat stat : copy) {
                stream.println("Code: " + stat.code);
                stream.println("Total count: " + stat.number);
                stream.println("Total ns: " + stat.totalN);
                stream.println("Avg ns/invocation: " + stat.totalN / (long)stat.number);
                long lengthM = TimeUnit.MILLISECONDS.convert(stat.totalN, TimeUnit.NANOSECONDS);
                stream.println("Total ms: " + lengthM);
                stream.println("Avg ms/invocation: " + lengthM / (long)stat.number);
                stream.println();
            }
        } else {
            stream.println("Not enabled");
        }
    }

    private static class Stat {
        Object code;
        int number;
        long totalN;

        private Stat() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Stat copy() {
            Stat stat = this;
            synchronized (stat) {
                Stat s = new Stat();
                s.code = this.code;
                s.number = this.number;
                s.totalN = this.totalN;
                return s;
            }
        }
    }
}

