/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.services;

import com.ibm.etools.references.internal.services.Dependency;
import com.ibm.etools.references.internal.services.SafeRun;
import com.ibm.etools.references.internal.services.Service;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.services.providers.ILinkTransformerProvider;
import com.ibm.etools.references.services.providers.ProviderArguments;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;

public final class LinkTransformerService
extends Service<ILinkTransformerProvider> {
    private static LinkTransformerService service = null;
    Map<String, List<DepInfo>> linkIdToDependencyMap;

    public static final synchronized LinkTransformerService getInstance() {
        if (service == null) {
            service = new LinkTransformerService();
            service.configureProviders("com.ibm.etools.references", "linkTransformerProvider");
        }
        return service;
    }

    public TransformerCache newCache() {
        return new TransformerCache();
    }

    @Override
    protected Service.ProviderDescriptor<ILinkTransformerProvider> newProviderDescriptor(IConfigurationElement configurationElement) {
        return new LinkTransformerDescriptor(configurationElement);
    }

    public List<Dependency> getDependentLinkIds(String linkId, IProject project, TransformerCache transformerCache) {
        List<Dependency> deps;
        if (this.linkIdToDependencyMap == null) {
            this.linkIdToDependencyMap = new HashMap<String, List<DepInfo>>();
            List providers = this.getAllProviders();
            for (Service.ProviderDescriptor providerDescriptor : providers) {
                LinkTransformerDescriptor desc = (LinkTransformerDescriptor)providerDescriptor;
                Map<String, List<Dependency>> deps2 = desc.getDependentLinks();
                for (Map.Entry<String, List<Dependency>> entries : deps2.entrySet()) {
                    String lId = entries.getKey();
                    List<Dependency> types = entries.getValue();
                    DepInfo info = new DepInfo();
                    info.dependencies = types;
                    info.descriptor = desc;
                    List<DepInfo> depsList = this.linkIdToDependencyMap.get(lId);
                    if (depsList == null) {
                        depsList = new ArrayList<DepInfo>();
                        this.linkIdToDependencyMap.put(lId, depsList);
                    }
                    depsList.add(info);
                }
            }
        }
        if ((deps = transformerCache.transformerCache.get(project)) == null) {
            List<DepInfo> result = this.linkIdToDependencyMap.get(linkId);
            if (result == null) {
                deps = Collections.emptyList();
            } else {
                deps = new ArrayList<Dependency>(result.size());
                for (DepInfo depInfo : result) {
                    if (!depInfo.descriptor.isApplicable(project)) continue;
                    deps.addAll(depInfo.dependencies);
                }
            }
            transformerCache.transformerCache.put(project, deps);
        }
        return deps;
    }

    private List<Service.ProviderDescriptor<ILinkTransformerProvider>> getApplicable(IProject project, String linkId, TransformerCache transformerCache) {
        ArrayList providers = new ArrayList();
        for (Service.ProviderDescriptor desc : this.getAllProviders()) {
            if (!((LinkTransformerDescriptor)desc).getApplicableLinkTypes().contains(linkId)) continue;
            providers.add(desc);
        }
        Iterator iterator = providers.iterator();
        while (iterator.hasNext()) {
            Service.ProviderDescriptor providerDescriptor = (Service.ProviderDescriptor)iterator.next();
            String key = String.valueOf(project.getName()) + "|" + linkId + "|" + providerDescriptor.getClassName();
            Boolean applicable = transformerCache.transformerDescCache.get(key);
            if (applicable == null) {
                applicable = providerDescriptor.isApplicable(project);
                transformerCache.transformerDescCache.put(key, applicable);
            }
            if (applicable.booleanValue()) continue;
            iterator.remove();
        }
        return Collections.unmodifiableList(providers);
    }

    public String expand(final ILink link, String prevResult, Set<ProviderArguments> providerArguments, TransformerCache transformerCache) {
        Assert.isNotNull((Object)link, (String)"Parameter link can not be null");
        List<Service.ProviderDescriptor<ILinkTransformerProvider>> providers = this.getApplicable(link.getContainer().getResource().getProject(), link.getSpecializedType().getId(), transformerCache);
        String prev = prevResult;
        for (Service.ProviderDescriptor<ILinkTransformerProvider> desc : providers) {
            String tmpfinal;
            String p;
            final ILinkTransformerProvider transformer = desc.getProvider();
            if (transformer == null || (p = SafeRun.run(transformer, new SafeRun.IRunnableWithResult<String>(tmpfinal = prev, providerArguments){
                private final /* synthetic */ String val$tmpfinal;
                private final /* synthetic */ Set val$providerArguments;
                {
                    this.val$tmpfinal = string;
                    this.val$providerArguments = set;
                }

                @Override
                public String run() throws Exception {
                    return transformer.expand(link, this.val$tmpfinal, this.val$providerArguments);
                }
            })) == null) continue;
            prev = p;
        }
        return prev;
    }

    public String contract(final ILink link, String prevResult, Set<ProviderArguments> providerArguments, TransformerCache transformerCache) {
        Assert.isNotNull((Object)link, (String)"Parameter link can not be null");
        List<Service.ProviderDescriptor<ILinkTransformerProvider>> providers = this.getApplicable(link.getContainer().getResource().getProject(), link.getSpecializedType().getId(), transformerCache);
        String prev = prevResult;
        for (Service.ProviderDescriptor<ILinkTransformerProvider> desc : providers) {
            String tmpfinal;
            final ILinkTransformerProvider transformer = desc.getProvider();
            String p = SafeRun.run(transformer, new SafeRun.IRunnableWithResult<String>(tmpfinal = prev, providerArguments){
                private final /* synthetic */ String val$tmpfinal;
                private final /* synthetic */ Set val$providerArguments;
                {
                    this.val$tmpfinal = string;
                    this.val$providerArguments = set;
                }

                @Override
                public String run() throws Exception {
                    return transformer.contract(link, this.val$tmpfinal, this.val$providerArguments);
                }
            });
            if (p == null) continue;
            prev = p;
        }
        return prev;
    }

    public Set<String> getTriggeredLinkTypes(String triggerPoint, Map<String, String> arguments) {
        HashSet<String> triggeredLinks = new HashSet<String>();
        List allProviders = this.getAllProviders();
        for (LinkTransformerDescriptor linkTransformerDescriptor : allProviders) {
            triggeredLinks.addAll(linkTransformerDescriptor.getTriggeredLinkTypes(triggerPoint, arguments));
        }
        return triggeredLinks;
    }

    private class DepInfo {
        List<Dependency> dependencies;
        LinkTransformerDescriptor descriptor;

        private DepInfo() {
        }

        public String toString() {
            String s = "Deps=";
            if (this.dependencies != null) {
                for (Dependency dep : this.dependencies) {
                    s = String.valueOf(s) + dep.toString() + ",";
                }
            }
            return s;
        }
    }

    private static class LinkTransformerDescriptor
    extends Service.ProviderDescriptor<ILinkTransformerProvider> {
        private Set<String> applicableLinks = null;

        public LinkTransformerDescriptor(IConfigurationElement configurationElement) {
            super(configurationElement);
        }

        public Map<String, List<Dependency>> getDependentLinks() {
            HashMap<String, List<Dependency>> detectsMap = new HashMap<String, List<Dependency>>();
            List<IConfigurationElement> elements = this.getChildren(this.configurationElement, "transforms");
            for (IConfigurationElement configurationElement : elements) {
                List<IConfigurationElement> linkTypeRefs = this.getChildren(configurationElement, "linkTypeRef");
                for (IConfigurationElement linkTypeRef : linkTypeRefs) {
                    Dependency dep;
                    String ref;
                    if (linkTypeRef == null || (ref = linkTypeRef.getAttribute("ref")) == null || (dep = Dependency.parse(linkTypeRef)) == null) continue;
                    List<Dependency> deps = detectsMap.get(dep.linkid);
                    if (deps == null) {
                        deps = new ArrayList<Dependency>();
                        detectsMap.put(ref, deps);
                    }
                    deps.add(dep);
                }
            }
            return detectsMap;
        }

        public Set<String> getApplicableLinkTypes() {
            if (this.applicableLinks == null) {
                this.applicableLinks = new HashSet<String>();
                List<IConfigurationElement> elements = this.getChildren(this.configurationElement, "transforms");
                for (IConfigurationElement tranformElement : elements) {
                    List<IConfigurationElement> linkTypeRefs = this.getChildren(tranformElement, "linkTypeRef");
                    for (IConfigurationElement linkTypeRef : linkTypeRefs) {
                        String ref;
                        if (linkTypeRef == null || (ref = linkTypeRef.getAttribute("ref")) == null) continue;
                        this.applicableLinks.add(ref);
                    }
                }
            }
            return this.applicableLinks;
        }

        @Override
        public boolean isApplicable(Object context) {
            List<IConfigurationElement> elements = this.getChildren(this.configurationElement, "transforms");
            boolean applicable = false;
            for (IConfigurationElement transformElement : elements) {
                applicable = this.expressionEnabled(context, transformElement);
                if (applicable) break;
            }
            return applicable;
        }

        public Set<String> getTriggeredLinkTypes(String triggerPoint, Map<String, String> arguments) {
            HashSet<String> triggered = new HashSet<String>();
            List<IConfigurationElement> elements = this.getChildren(this.configurationElement, "transforms");
            for (IConfigurationElement transformsElement : elements) {
                if (!this.isTriggered(transformsElement, triggerPoint, arguments)) continue;
                List<IConfigurationElement> linkTypeRefs = this.getChildren(transformsElement, "linkTypeRef");
                for (IConfigurationElement linkTypeRef : linkTypeRefs) {
                    String ref;
                    if (linkTypeRef == null || (ref = linkTypeRef.getAttribute("ref")) == null) continue;
                    this.applicableLinks.add(ref);
                }
            }
            return triggered;
        }
    }

    public static final class TransformerCache {
        Map<String, Boolean> transformerDescCache = new HashMap<String, Boolean>();
        Map<IProject, List<Dependency>> transformerCache = new HashMap<IProject, List<Dependency>>();
    }
}

