/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.services;

import com.ibm.etools.references.Logger;
import com.ibm.etools.references.internal.management.ResolvedReference;
import com.ibm.etools.references.internal.services.SafeRun;
import com.ibm.etools.references.internal.services.Service;
import com.ibm.etools.references.management.BrokenStatus;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.services.providers.ILinkNodeModelProvider;
import com.ibm.etools.references.services.providers.SharedModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.expressions.ElementHandler;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.expressions.IVariableResolver;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class LinkNodeModelService
extends Service<ILinkNodeModelProvider> {
    private static LinkNodeModelService service = null;
    private HashMap<String, List<TargetRefIdEnablementPair>> linkIdToNodeListMap = null;
    private HashMap<String, NodeProviderDescriptor> modelIdToDescriptor;
    private HashSet<String> ids;

    @Override
    protected Service.ProviderDescriptor<ILinkNodeModelProvider> newProviderDescriptor(IConfigurationElement configurationElement) {
        return new NodeProviderDescriptor(configurationElement);
    }

    public static final synchronized LinkNodeModelService getInstance() {
        if (service == null) {
            service = new LinkNodeModelService();
            service.configureProviders("com.ibm.etools.references", "nodeProvider");
        }
        return service;
    }

    public SharedModel getSharedModels(String modelId, IResource resource, Set<IResolvedReference> incomingRefs) {
        final NodeProviderDescriptor descriptor = this.getDescriptor(modelId);
        if (descriptor != null) {
            boolean proceed = true;
            Map<String, List<TargetRefIdEnablementPair>> nodeToTargets = descriptor.getTargetOfs();
            if (!nodeToTargets.isEmpty()) {
                proceed = false;
                if (!incomingRefs.isEmpty()) {
                    for (IResolvedReference element : incomingRefs) {
                        IResolvedReference ref = element;
                        if (ref.getBrokenStatus() == BrokenStatus.NOTBROKEN) {
                            proceed = this.evaluate(nodeToTargets, ref);
                        } else {
                            String data = ref.getModelInstanceIdReference();
                            if (data != null && resource.getFullPath().toString().equals(data)) {
                                proceed = this.evaluate(nodeToTargets, ref);
                            }
                        }
                        if (proceed) break;
                    }
                }
            }
            if (proceed) {
                final LinkNode<IResource> linkNode = ReferenceManager.getReferenceManager().getLinkNode(resource);
                final ILinkNodeModelProvider provider = (ILinkNodeModelProvider)descriptor.getProvider();
                SharedModel model = SafeRun.run(provider, new SafeRun.IRunnableWithResult<SharedModel>(){

                    @Override
                    public SharedModel run() throws Exception {
                        SharedModel model = provider.getSharedModel(linkNode);
                        if (model != null) {
                            List<String> modelIds = descriptor.getNodeModelIds();
                            boolean assertion = modelIds.contains(model.getNodeId());
                            if (!assertion) {
                                try {
                                    model.release();
                                }
                                catch (RuntimeException runtimeException) {}
                            }
                            Assert.isTrue((boolean)assertion, (String)("Provider returned a model with an id that it doesn't provide: " + model.getNodeId()));
                        }
                        return model;
                    }
                });
                if (model != null) {
                    return model;
                }
            }
        }
        return null;
    }

    public Set<String> getModelInstanceIds(final LinkNode<IResource> linkNode) {
        if (linkNode == null) {
            return Collections.emptySet();
        }
        HashSet<String> mIds = new HashSet<String>();
        List providersDescriptors = this.getAllProviders();
        for (NodeProviderDescriptor nodeProviderDescriptor : providersDescriptors) {
            String modelInstanceId;
            ILinkNodeModelProvider provider;
            if (!nodeProviderDescriptor.isApplicable(linkNode.getResource()) || (provider = (ILinkNodeModelProvider)nodeProviderDescriptor.getProvider()) == null || (modelInstanceId = SafeRun.run(provider, new SafeRun.IRunnableWithResult<String>(){

                @Override
                public String run() throws Exception {
                    return provider.getModelInstanceId(linkNode);
                }
            })) == null) continue;
            mIds.add(modelInstanceId);
        }
        return mIds;
    }

    public List<SharedModel> getSharedModels(IResource resource, Set<IReferenceElement> incomingRefs) {
        ArrayList<SharedModel> models = new ArrayList<SharedModel>();
        List providersDescriptors = this.getAllProviders();
        for (NodeProviderDescriptor nodeProviderDescriptor : providersDescriptors) {
            SharedModel model;
            if (!nodeProviderDescriptor.isApplicable(resource)) continue;
            boolean proceed = true;
            Map<String, List<TargetRefIdEnablementPair>> nodeToTargets = nodeProviderDescriptor.getTargetOfs();
            if (!nodeToTargets.isEmpty()) {
                proceed = false;
                if (!incomingRefs.isEmpty()) {
                    for (IReferenceElement element : incomingRefs) {
                        IResolvedReference ref = (IResolvedReference)element;
                        if (ref.getBrokenStatus() == BrokenStatus.NOTBROKEN) {
                            proceed = this.evaluate(nodeToTargets, ref);
                        } else {
                            String data = ref.getModelInstanceIdReference();
                            if (data != null && resource.getFullPath().toPortableString().equals(data)) {
                                proceed = this.evaluate(nodeToTargets, ref);
                            }
                        }
                        if (proceed) break;
                    }
                }
            }
            if (!proceed) continue;
            final LinkNode<IResource> linkNode = ReferenceManager.getReferenceManager().getLinkNode(resource);
            final ILinkNodeModelProvider provider = (ILinkNodeModelProvider)nodeProviderDescriptor.getProvider();
            if (provider == null || (model = SafeRun.run(provider, new SafeRun.IRunnableWithResult<SharedModel>(){

                @Override
                public SharedModel run() throws Exception {
                    return provider.getSharedModel(linkNode);
                }
            })) == null) continue;
            models.add(model);
        }
        return models;
    }

    private NodeProviderDescriptor getDescriptor(String modelId) {
        if (this.modelIdToDescriptor == null) {
            this.modelIdToDescriptor = new HashMap();
            List providersDescriptors = this.getAllProviders();
            for (NodeProviderDescriptor nodeProviderDescriptor : providersDescriptors) {
                List<String> ids = nodeProviderDescriptor.getNodeModelIds();
                for (String id : ids) {
                    this.modelIdToDescriptor.put(id, nodeProviderDescriptor);
                }
            }
        }
        return this.modelIdToDescriptor.get(modelId);
    }

    private boolean evaluate(Map<String, List<TargetRefIdEnablementPair>> nodeToTargets, IResolvedReference ref) {
        boolean proceed = false;
        for (List<TargetRefIdEnablementPair> targetIds : nodeToTargets.values()) {
            boolean bl = proceed = !this.eval(((ResolvedReference)ref).getReference(), targetIds, true).isEmpty();
            if (proceed) break;
        }
        return proceed;
    }

    private List<TargetRefIdEnablementPair> eval(Reference ref, List<TargetRefIdEnablementPair> targetIds, boolean stopAfterFirst) {
        ArrayList<TargetRefIdEnablementPair> result = new ArrayList<TargetRefIdEnablementPair>();
        for (TargetRefIdEnablementPair pair : targetIds) {
            if (!ref.getReferenceType().equals(pair.targetReferenceId)) continue;
            EvaluationContext context = new EvaluationContext(null, (Object)ref, new IVariableResolver[]{new VarResolver(ref)});
            try {
                if (pair.expression.evaluate((IEvaluationContext)context) != EvaluationResult.TRUE) continue;
                result.add(pair);
                if (!stopAfterFirst) continue;
                return result;
            }
            catch (CoreException coreException) {}
        }
        return result;
    }

    public Set<String> getNodeModelIds(IResource resource) {
        HashSet<String> modelIds = new HashSet<String>(4);
        List providersDescriptors = this.getAllProviders();
        for (NodeProviderDescriptor nodeProviderDescriptor : providersDescriptors) {
            modelIds.addAll(nodeProviderDescriptor.getApplicableNodeIds(resource));
        }
        return modelIds;
    }

    public Set<String> getDependentNodes(Reference ref) {
        if (ref == null) {
            return Collections.emptySet();
        }
        this.buildMap();
        List<TargetRefIdEnablementPair> nodeIds = this.linkIdToNodeListMap.get(ref.getReferenceType());
        if (nodeIds == null) {
            return Collections.emptySet();
        }
        List<TargetRefIdEnablementPair> applicableNodes = this.eval(ref, nodeIds, false);
        HashSet<String> strings = new HashSet<String>();
        for (TargetRefIdEnablementPair pair : applicableNodes) {
            strings.add(pair.nodeId);
        }
        return strings;
    }

    private HashMap<String, List<TargetRefIdEnablementPair>> buildMap() {
        if (this.linkIdToNodeListMap == null) {
            this.linkIdToNodeListMap = new HashMap();
            List providersDescriptors = this.getAllProviders();
            for (NodeProviderDescriptor nodeProviderDescriptor : providersDescriptors) {
                Map<String, List<TargetRefIdEnablementPair>> nodeToId = nodeProviderDescriptor.getTargetOfs();
                for (Map.Entry<String, List<TargetRefIdEnablementPair>> entry : nodeToId.entrySet()) {
                    List<TargetRefIdEnablementPair> linkIds = entry.getValue();
                    for (TargetRefIdEnablementPair lId : linkIds) {
                        List<TargetRefIdEnablementPair> nIds = this.linkIdToNodeListMap.get(entry.getKey());
                        if (nIds == null) {
                            nIds = new ArrayList<TargetRefIdEnablementPair>(1);
                            this.linkIdToNodeListMap.put(lId.targetReferenceId, nIds);
                        }
                        nIds.add(lId);
                    }
                }
            }
        }
        return this.linkIdToNodeListMap;
    }

    public Set<String> getAllRegisteredNodeModelIds() {
        if (this.ids == null) {
            this.ids = new HashSet();
            List providersDescriptors = this.getAllProviders();
            for (NodeProviderDescriptor nodeProviderDescriptor : providersDescriptors) {
                this.ids.addAll(nodeProviderDescriptor.getNodeModelIds());
            }
        }
        return this.ids;
    }

    public Set<String> getTriggerReferenceTypes() {
        this.buildMap();
        return this.linkIdToNodeListMap.keySet();
    }

    public boolean isTargetOfTypeModel(String modelId) {
        List providersDescriptors = this.getAllProviders();
        for (NodeProviderDescriptor nodeProviderDescriptor : providersDescriptors) {
            Map<String, List<TargetRefIdEnablementPair>> targetOfs = nodeProviderDescriptor.getTargetOfs();
            if (!targetOfs.containsKey(modelId)) continue;
            return true;
        }
        return false;
    }

    public List<String> getTriggeredIds(String triggerPoint, Map<String, String> arguments) {
        if (triggerPoint == null) {
            return Collections.emptyList();
        }
        ArrayList<String> triggeredIds = new ArrayList<String>();
        List allProviders = this.getAllProviders();
        for (NodeProviderDescriptor nodeProviderDescriptor : allProviders) {
            triggeredIds.addAll(nodeProviderDescriptor.getTriggeredNodeIds(triggerPoint, arguments));
        }
        return triggeredIds;
    }

    private static class NodeProviderDescriptor
    extends Service.ProviderDescriptor<ILinkNodeModelProvider> {
        private HashMap<String, List<TargetRefIdEnablementPair>> nodeToTargetOfsMap;

        public NodeProviderDescriptor(IConfigurationElement configurationElement) {
            super(configurationElement);
        }

        public List<String> getNodeModelIds() {
            ArrayList<String> ids = new ArrayList<String>();
            List<IConfigurationElement> elements = this.getChildren(this.configurationElement, "nodeModel");
            for (IConfigurationElement configElement : elements) {
                String id = configElement.getAttribute("id");
                ids.add(id);
            }
            return ids;
        }

        public Map<String, List<TargetRefIdEnablementPair>> getTargetOfs() {
            if (this.nodeToTargetOfsMap == null) {
                this.nodeToTargetOfsMap = new HashMap();
                List<IConfigurationElement> elements = this.getChildren(this.configurationElement, "nodeModel");
                for (IConfigurationElement configElement : elements) {
                    String depId;
                    IConfigurationElement linkRef;
                    String id = configElement.getAttribute("id");
                    if (id == null) continue;
                    ArrayList<TargetRefIdEnablementPair> targetLinkIds = new ArrayList<TargetRefIdEnablementPair>();
                    IConfigurationElement dependency = this.getSingleChild(configElement, "isTargetOf");
                    if (dependency != null && (linkRef = this.getSingleChild(dependency, "referenceTypeRef")) != null && (depId = linkRef.getAttribute("ref")) != null) {
                        TargetRefIdEnablementPair pair = new TargetRefIdEnablementPair();
                        pair.targetReferenceId = depId;
                        pair.nodeId = id;
                        IConfigurationElement enablement = this.getSingleChild(linkRef, "enablement");
                        if (enablement == null) {
                            pair.expression = Expression.TRUE;
                        } else {
                            try {
                                Expression expression;
                                pair.expression = expression = ElementHandler.getDefault().create(ExpressionConverter.getDefault(), enablement);
                            }
                            catch (CoreException e) {
                                Status status = new Status(4, "com.ibm.etools.references", "Error creating expression object for contributor: " + id, (Throwable)e);
                                Logger.log((IStatus)status);
                                pair.expression = Expression.FALSE;
                            }
                        }
                        targetLinkIds.add(pair);
                    }
                    if (targetLinkIds.isEmpty()) continue;
                    List<TargetRefIdEnablementPair> ids = this.nodeToTargetOfsMap.get(id);
                    if (ids == null) {
                        this.nodeToTargetOfsMap.put(id, targetLinkIds);
                        continue;
                    }
                    ids.addAll(targetLinkIds);
                }
            }
            return this.nodeToTargetOfsMap;
        }

        @Override
        protected boolean expressionEnabled(Object context, IConfigurationElement element) {
            if (this.getEnablement(element) != null) {
                return super.expressionEnabled(context, element);
            }
            IConfigurationElement targetOf = this.getSingleChild(element, "isTargetOf");
            return targetOf == null;
        }

        @Override
        public boolean isApplicable(Object context) {
            List<IConfigurationElement> elements = this.getChildren(this.configurationElement, "nodeModel");
            if (elements.size() > 0) {
                boolean enabled = false;
                int i = 0;
                while (i < elements.size()) {
                    IConfigurationElement element = elements.get(i);
                    enabled = this.expressionEnabled(context, element);
                    if (enabled) break;
                    ++i;
                }
                return enabled;
            }
            return true;
        }

        public List<String> getTriggeredNodeIds(String triggerPoint, Map<String, String> arguments) {
            ArrayList<String> triggeredIds = new ArrayList<String>();
            List<IConfigurationElement> elements = this.getChildren(this.configurationElement, "nodeModel");
            for (IConfigurationElement configurationElement : elements) {
                String id = configurationElement.getAttribute("id");
                if (id == null || !this.isTriggered(configurationElement, triggerPoint, arguments)) continue;
                triggeredIds.add(id);
            }
            return triggeredIds;
        }

        public List<String> getApplicableNodeIds(IResource context) {
            ArrayList<String> ids = new ArrayList<String>();
            List<IConfigurationElement> elements = this.getChildren(this.configurationElement, "nodeModel");
            for (IConfigurationElement element : elements) {
                String id = element.getAttribute("id");
                boolean enabled = this.expressionEnabled(context, element);
                if (!enabled) continue;
                ids.add(id);
            }
            return ids;
        }
    }

    private static class TargetRefIdEnablementPair {
        String nodeId;
        String targetReferenceId;
        Expression expression;

        private TargetRefIdEnablementPair() {
        }
    }

    private static class VarResolver
    implements IVariableResolver {
        private final Reference reference;

        public VarResolver(Reference reference) {
            this.reference = reference;
        }

        public Object resolve(String name, Object[] args) throws CoreException {
            if ("parameter".equals(name) && args.length == 1) {
                String value = this.reference.getParameter((String)args[0]);
                return Boolean.parseBoolean(value);
            }
            return null;
        }
    }
}

