/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.services;

import com.ibm.etools.references.Logger;
import com.ibm.etools.references.internal.index.InternalReferenceObject;
import com.ibm.etools.references.internal.management.Link;
import com.ibm.etools.references.internal.services.Dependency;
import com.ibm.etools.references.internal.services.LinkTypeRegistry;
import com.ibm.etools.references.internal.services.SafeRun;
import com.ibm.etools.references.internal.services.Service;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.LinkPositionInfo;
import com.ibm.etools.references.management.ReferenceElementFactory;
import com.ibm.etools.references.management.SpecializedType;
import com.ibm.etools.references.services.providers.ILinkDetectorProvider;
import com.ibm.etools.references.services.providers.SharedModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;

public final class LinkDetectorService
extends Service<ILinkDetectorProvider> {
    private static LinkDetectorService service = null;
    Map<String, List<SpecializedType>> modelIdToLinkIdMap;
    Map<String, Map<SpecializedType, Dependency>> modelIdToDependenciesMap;
    Map<String, Map<String, SpecializedType>> reverseMap;

    public static final synchronized LinkDetectorService getInstance() {
        if (service == null) {
            service = new LinkDetectorService();
            service.configureProviders("com.ibm.etools.references", "linkDetectorProvider");
        }
        return service;
    }

    @Override
    protected Service.ProviderDescriptor<ILinkDetectorProvider> newProviderDescriptor(IConfigurationElement configurationElement) {
        return new LinkDectorDescriptor(configurationElement);
    }

    @Override
    protected boolean hasUniqueIds() {
        return true;
    }

    public List<ILink> detectLinks(SharedModel sharedModel, Set<IResolvedReference> incomingReferences, Set<LinkPositionInfo> positionInfo) {
        return this.detectLinks(sharedModel, incomingReferences, positionInfo, false);
    }

    public List<ILink> detectLinks(final SharedModel sharedModel, final Set<IResolvedReference> incomingReferences, Set<LinkPositionInfo> positionInfo, boolean parseLinksOnly) {
        ArrayList<ILink> descriptors = new ArrayList<ILink>();
        List providers = this.getApplicableProviderDescriptors(sharedModel);
        for (final Service.ProviderDescriptor linkDetectorProviderDesc : providers) {
            final ILinkDetectorProvider linkDetectorProvider = (ILinkDetectorProvider)linkDetectorProviderDesc.getProvider();
            if (linkDetectorProvider == null) continue;
            LinkNode<IResource> node = sharedModel.getLinkNode();
            node.setParseLinksOnly(parseLinksOnly);
            final ReferenceElementFactory factory = new ReferenceElementFactory(linkDetectorProviderDesc.getTypeId(), -1, sharedModel.getLinkNode());
            List<ILink> links = SafeRun.run(linkDetectorProvider, new SafeRun.IRunnableWithResult<List<ILink>>(){

                @Override
                public List<ILink> run() throws Exception {
                    List<ILink> links = linkDetectorProvider.detectLinks(factory, sharedModel, incomingReferences);
                    Assert.isNotNull(links);
                    List<SpecializedType> types = ((LinkDectorDescriptor)linkDetectorProviderDesc).getDetectables().get(sharedModel.getNodeId());
                    HashSet<SpecializedType> linkTypes = new HashSet<SpecializedType>();
                    for (ILink link : links) {
                        linkTypes.add(link.getSpecializedType());
                    }
                    linkTypes.removeAll(types);
                    if (!linkTypes.isEmpty()) {
                        String linkTypesString = "";
                        for (SpecializedType linkType : linkTypes) {
                            linkTypesString = String.valueOf(linkTypesString) + linkType.getId() + ", ";
                        }
                        Assert.isLegal((boolean)false, (String)("Link detector is returning links with ids that it isn't registered to provide: " + linkTypesString));
                    }
                    return links;
                }
            });
            if (links == null) continue;
            for (ILink link : links) {
                if (link == null) continue;
                ((Link)link).setContainer(sharedModel.getLinkNode());
                ((InternalReferenceObject)((Object)link)).freeze();
                descriptors.add(link);
            }
        }
        return descriptors;
    }

    public List<SpecializedType> getLinksAvailableForLinkModel(String modelId) {
        List<SpecializedType> result;
        if (this.modelIdToLinkIdMap == null) {
            this.modelIdToLinkIdMap = new HashMap<String, List<SpecializedType>>();
            List providers = this.getAllProviders();
            for (Service.ProviderDescriptor providerDescriptor : providers) {
                Map<String, List<SpecializedType>> detectables = ((LinkDectorDescriptor)providerDescriptor).getDetectables();
                for (Map.Entry<String, List<SpecializedType>> entries : detectables.entrySet()) {
                    String mod = entries.getKey();
                    List<SpecializedType> types = entries.getValue();
                    List<SpecializedType> mergedTypes = this.modelIdToLinkIdMap.get(mod);
                    if (mergedTypes == null) {
                        this.modelIdToLinkIdMap.put(mod, types);
                        continue;
                    }
                    mergedTypes.addAll(types);
                }
            }
        }
        if ((result = this.modelIdToLinkIdMap.get(modelId)) == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    public Map<SpecializedType, Dependency> getDependencies(String modelId) {
        Map<SpecializedType, Dependency> result;
        if (this.modelIdToDependenciesMap == null) {
            this.modelIdToDependenciesMap = new HashMap<String, Map<SpecializedType, Dependency>>();
            List providers = this.getAllProviders();
            for (Service.ProviderDescriptor providerDescriptor : providers) {
                Map<String, Map<SpecializedType, Dependency>> detectables = ((LinkDectorDescriptor)providerDescriptor).getDependencies();
                for (Map.Entry<String, Map<SpecializedType, Dependency>> entries : detectables.entrySet()) {
                    String mod = entries.getKey();
                    Map<SpecializedType, Dependency> types = entries.getValue();
                    Map<SpecializedType, Dependency> mergedTypes = this.modelIdToDependenciesMap.get(mod);
                    if (mergedTypes == null) {
                        this.modelIdToDependenciesMap.put(mod, types);
                        continue;
                    }
                    mergedTypes.putAll(types);
                }
            }
        }
        if ((result = this.modelIdToDependenciesMap.get(modelId)) == null) {
            result = Collections.emptyMap();
        }
        return result;
    }

    public SpecializedType getDependentLink(String dependentLink, String modelId) {
        Map<String, SpecializedType> rev = null;
        if (this.reverseMap == null) {
            this.reverseMap = new HashMap<String, Map<String, SpecializedType>>();
            rev = this.addInfoForModel(modelId);
        } else {
            rev = this.reverseMap.get(modelId);
            if (rev == null) {
                rev = this.addInfoForModel(modelId);
            }
        }
        return rev.get(dependentLink);
    }

    private Map<String, SpecializedType> addInfoForModel(String modelId) {
        HashMap<String, SpecializedType> rev = new HashMap<String, SpecializedType>();
        Map<SpecializedType, Dependency> depedencies = this.getDependencies(modelId);
        for (Map.Entry<SpecializedType, Dependency> entry : depedencies.entrySet()) {
            SpecializedType key = entry.getKey();
            Dependency dep = entry.getValue();
            rev.put(dep.linkid, key);
        }
        Map<String, SpecializedType> existing = this.reverseMap.get(modelId);
        if (existing == null) {
            this.reverseMap.put(modelId, rev);
            return rev;
        }
        existing.putAll(rev);
        return existing;
    }

    public Set<String> getTriggeredLinkTypes(String triggerPoint, Map<String, String> arguments) {
        HashSet<String> triggeredIds = new HashSet<String>();
        List allProviders = this.getAllProviders();
        for (LinkDectorDescriptor linkDectorDescriptor : allProviders) {
            triggeredIds.addAll(linkDectorDescriptor.getTriggeredLinkTypes(triggerPoint, arguments));
        }
        return triggeredIds;
    }

    public Set<String> getModelProvidersIds(Collection<String> linkTypes) {
        HashSet<String> modelIds = new HashSet<String>();
        List allProviders = this.getAllProviders();
        for (LinkDectorDescriptor linkDectorDescriptor : allProviders) {
            modelIds.addAll(linkDectorDescriptor.getModelIdsForLinkTypes(linkTypes));
        }
        return modelIds;
    }

    public int getProviderId(String linkProviderId) {
        List descriptors = this.getAllProviders();
        for (Service.ProviderDescriptor providerDescriptor : descriptors) {
            if (!providerDescriptor.getId().getLocalName().equals(linkProviderId)) continue;
            return providerDescriptor.getTypeId();
        }
        return -1;
    }

    private static class LinkDectorDescriptor
    extends Service.ProviderDescriptor<ILinkDetectorProvider> {
        public LinkDectorDescriptor(IConfigurationElement configurationElement) {
            super(configurationElement);
        }

        public Map<String, List<SpecializedType>> getDetectables() {
            HashMap<String, List<SpecializedType>> detectsMap = new HashMap<String, List<SpecializedType>>();
            List<IConfigurationElement> detects = this.getChildren(this.configurationElement, "detects");
            for (IConfigurationElement detectElement : detects) {
                IConfigurationElement nodeModel = this.getSingleChild(detectElement, "nodeModelRef");
                String nodeType = nodeModel.getAttribute("ref");
                if (nodeType == null) continue;
                List<SpecializedType> linkTypes = detectsMap.get(nodeType);
                if (linkTypes == null) {
                    linkTypes = new ArrayList<SpecializedType>();
                }
                List<IConfigurationElement> linkTypesConfig = this.getChildren(detectElement, "linkTypeRef");
                for (IConfigurationElement configurationElement : linkTypesConfig) {
                    String linkTypeId = configurationElement.getAttribute("ref");
                    try {
                        SpecializedType type = LinkTypeRegistry.getInstance().getLinkType(linkTypeId);
                        linkTypes.add(type);
                    }
                    catch (Exception exception) {
                        Logger.logWarning(Logger.Category.DEBUG, Logger.Mode.DEV_MANDATORY, "Error getting specified type id: " + linkTypeId + " contribution id " + this.getId());
                    }
                }
                if (linkTypes.isEmpty()) continue;
                detectsMap.put(nodeType, linkTypes);
            }
            return detectsMap;
        }

        public Map<String, Map<SpecializedType, Dependency>> getDependencies() {
            HashMap<String, Map<SpecializedType, Dependency>> detectsMap = new HashMap<String, Map<SpecializedType, Dependency>>();
            List<IConfigurationElement> detects = this.getChildren(this.configurationElement, "detects");
            for (IConfigurationElement detectElement : detects) {
                IConfigurationElement nodeModel = this.getSingleChild(detectElement, "nodeModelRef");
                String nodeType = nodeModel.getAttribute("ref");
                if (nodeType == null) continue;
                Map<SpecializedType, Dependency> linkTypes = detectsMap.get(nodeType);
                if (linkTypes == null) {
                    linkTypes = new HashMap<SpecializedType, Dependency>();
                }
                List<IConfigurationElement> linkTypesConfig = this.getChildren(detectElement, "linkTypeRef");
                for (IConfigurationElement configurationElement : linkTypesConfig) {
                    String linkTypeId = configurationElement.getAttribute("ref");
                    SpecializedType type = LinkTypeRegistry.getInstance().getLinkType(linkTypeId);
                    Dependency dep = Dependency.parse(configurationElement);
                    if (dep == null) continue;
                    linkTypes.put(type, dep);
                }
                if (linkTypes.isEmpty()) continue;
                detectsMap.put(nodeType, linkTypes);
            }
            return detectsMap;
        }

        @Override
        public boolean isApplicable(Object context) {
            SharedModel sharedModel = (SharedModel)context;
            List<IConfigurationElement> detects = this.getChildren(this.configurationElement, "detects");
            for (IConfigurationElement detectElement : detects) {
                IConfigurationElement nodeModelRefElement = this.getSingleChild(detectElement, "nodeModelRef");
                String applicableNodeType = nodeModelRefElement.getAttribute("ref");
                if (applicableNodeType == null || !applicableNodeType.equals(sharedModel.getNodeId())) continue;
                return this.expressionEnabled(context, this.configurationElement);
            }
            return false;
        }

        public Set<String> getTriggeredLinkTypes(String triggerPoint, Map<String, String> arguments) {
            HashSet<String> triggeredLinkTypes = new HashSet<String>();
            if (this.isTriggered(this.configurationElement, triggerPoint, arguments)) {
                List<IConfigurationElement> detects = this.getChildren(this.configurationElement, "detects");
                for (IConfigurationElement detectElement : detects) {
                    List<IConfigurationElement> linkTypeRefs = this.getChildren(detectElement, "linkTypeRef");
                    for (IConfigurationElement linkTypeRef : linkTypeRefs) {
                        String idref;
                        if (linkTypeRef == null || (idref = linkTypeRef.getAttribute("ref")) == null) continue;
                        triggeredLinkTypes.add(idref);
                    }
                }
            }
            return triggeredLinkTypes;
        }

        public Set<String> getModelIdsForLinkTypes(Collection<String> linkTypes) {
            HashSet<String> modelIds = new HashSet<String>();
            List<IConfigurationElement> detects = this.getChildren(this.configurationElement, "detects");
            for (IConfigurationElement detectElement : detects) {
                List<IConfigurationElement> linkTypeRefs = this.getChildren(detectElement, "linkTypeRef");
                block1: for (IConfigurationElement linkTypeRef : linkTypeRefs) {
                    if (linkTypeRef == null) continue;
                    String idref = linkTypeRef.getAttribute("ref");
                    for (String linkType : linkTypes) {
                        IConfigurationElement nodeModelRefElement;
                        String applicableNodeType;
                        if (!linkType.equals(idref) || (applicableNodeType = (nodeModelRefElement = this.getSingleChild(detectElement, "nodeModelRef")).getAttribute("ref")) == null) continue;
                        modelIds.add(applicableNodeType);
                        continue block1;
                    }
                }
            }
            return modelIds;
        }
    }
}

