/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.services;

import com.ibm.etools.references.Logger;
import org.eclipse.core.expressions.ElementHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class Dependency {
    public final String linkid;
    public final Scope scope;
    public final Expression expression;

    public Dependency(String linkid, Scope scope, Expression expression) {
        this.linkid = linkid;
        this.scope = scope;
        this.expression = expression;
    }

    public static Dependency parse(IConfigurationElement depHolder) {
        IConfigurationElement[] linkDep = depHolder.getChildren("linkDependency");
        if (linkDep.length > 0) {
            IConfigurationElement dep = linkDep[0];
            String linkId = dep.getAttribute("ref");
            String valueScope = dep.getAttribute("scope");
            if (valueScope != null) {
                Scope scope = Scope.valueOf(valueScope.toUpperCase());
                IConfigurationElement[] enablement = dep.getChildren("enablement");
                Expression exp = null;
                if (enablement.length > 0) {
                    try {
                        exp = ElementHandler.getDefault().create(ExpressionConverter.getDefault(), enablement[0]);
                    }
                    catch (CoreException e) {
                        Logger.log(e.getStatus());
                        exp = Expression.FALSE;
                    }
                } else {
                    exp = Expression.TRUE;
                }
                return new Dependency(linkId, scope, exp);
            }
        }
        return null;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.linkid == null ? 0 : this.linkid.hashCode());
        result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dependency other = (Dependency)obj;
        if (this.linkid == null ? other.linkid != null : !this.linkid.equals(other.linkid)) {
            return false;
        }
        return !(this.scope == null ? other.scope != null : !this.scope.equals((Object)other.scope));
    }

    public String toString() {
        return "LinkId=" + this.linkid + " scope=" + this.scope.name();
    }

    public static enum Scope {
        LINK,
        FILE,
        FOLDER,
        PROJECT,
        WORKSPACE;

    }
}

