/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.services;

import com.ibm.etools.references.internal.services.SafeRun;
import com.ibm.etools.references.internal.services.Service;
import com.ibm.etools.references.management.BrokenReference;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.services.providers.IBrokenReferenceStrategyProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;

public final class BrokenReferenceStrategyService
extends Service<IBrokenReferenceStrategyProvider> {
    private static BrokenReferenceStrategyService service = null;

    public static final synchronized BrokenReferenceStrategyService getInstance() {
        if (service == null) {
            service = new BrokenReferenceStrategyService();
            service.configureProviders("com.ibm.etools.references", "brokenReferenceStrategyProvider");
        }
        return service;
    }

    @Override
    protected Service.ProviderDescriptor<IBrokenReferenceStrategyProvider> newProviderDescriptor(IConfigurationElement configurationElement) {
        return new BrokenReferenceSrategyProviderDescriptor(configurationElement);
    }

    @Override
    protected boolean hasUniqueIds() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public Collection<BrokenReference> findBrokenReferences(final ILink link, final Set<IResolvedReference> references) {
        Service.ProviderDescriptor bestMatch = null;
        int numMatched = -1;
        List descriptors = this.getAllProviders();
        for (BrokenReferenceSrategyProviderDescriptor brokenReferenceSrategyProviderDescriptor : descriptors) {
            List<String> matchesLinks = brokenReferenceSrategyProviderDescriptor.getLinkTypes();
            if (matchesLinks.isEmpty()) {
                bestMatch = brokenReferenceSrategyProviderDescriptor;
                numMatched = 0;
                continue;
            }
            if (!matchesLinks.contains(link.getSpecializedType().getId()) || matchesLinks.size() < numMatched) continue;
            bestMatch = brokenReferenceSrategyProviderDescriptor;
            numMatched = matchesLinks.size();
        }
        if (bestMatch != null) {
            void var7_10;
            final IBrokenReferenceStrategyProvider provider = (IBrokenReferenceStrategyProvider)bestMatch.getProvider();
            Collection<BrokenReference> collection = SafeRun.run(provider, new SafeRun.IRunnableWithResult<Collection<BrokenReference>>(){

                @Override
                public Collection<BrokenReference> run() throws Exception {
                    Collection<BrokenReference> refs = provider.findBrokenReferences(link, references);
                    return refs;
                }
            });
            if (collection == null) {
                List list = Collections.emptyList();
            }
            return var7_10;
        }
        return Collections.emptyList();
    }

    public class BrokenReferenceSrategyProviderDescriptor
    extends Service.ProviderDescriptor<IBrokenReferenceStrategyProvider> {
        public BrokenReferenceSrategyProviderDescriptor(IConfigurationElement configurationElement) {
            super(configurationElement);
        }

        @Override
        public boolean isApplicable(Object context) {
            return true;
        }

        public List<String> getLinkTypes() {
            ArrayList<String> linkTypes = new ArrayList<String>();
            List<IConfigurationElement> elements = this.getChildren(this.configurationElement, "linkTypeRef");
            for (IConfigurationElement configurationElement : elements) {
                String ref = configurationElement.getAttribute("ref");
                if (ref == null) continue;
                linkTypes.add(ref);
            }
            return linkTypes;
        }
    }
}

