/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.search;

import com.ibm.etools.references.internal.search.ICompoundPattern;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.search.SearchPattern;
import com.ibm.etools.references.search.SearchRequestor;
import com.ibm.etools.references.search.SearchScope;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class OrPattern
extends ICompoundPattern {
    public OrPattern(SearchPattern leftPattern, SearchPattern rightPattern) {
        super(leftPattern, rightPattern);
    }

    @Override
    public String getSearchTypeValue() {
        String leftValue = this.leftPattern.getSearchTypeValue();
        String rightValue = this.rightPattern.getSearchTypeValue();
        if (leftValue != null && leftValue.equals(rightValue)) {
            return leftValue;
        }
        if (leftValue != null && rightValue == null) {
            return leftValue;
        }
        if (rightValue != null && leftValue == null) {
            return rightValue;
        }
        return null;
    }

    @Override
    public boolean isScopeAware(SearchScope scope) {
        return this.leftPattern.isScopeAware(scope) || this.rightPattern.isScopeAware(scope);
    }

    @Override
    public void findIndexMatches(SearchScope scope, SearchRequestor<? extends IReferenceElement> requestor, IProgressMonitor progressMonitor) {
        try {
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)4);
            if (this.leftPattern.isScopeAware(scope)) {
                this.leftPattern.findIndexMatches(scope, requestor, (IProgressMonitor)sub.newChild(2));
            } else {
                this.leftPattern.findIndexMatches(scope.getLinkIdsInScope((IProgressMonitor)sub.newChild(1)), requestor, (IProgressMonitor)sub.newChild(1));
            }
            if (this.rightPattern.isScopeAware(scope)) {
                this.rightPattern.findIndexMatches(scope, requestor, (IProgressMonitor)sub.newChild(2));
            } else {
                this.rightPattern.findIndexMatches(scope.getLinkIdsInScope((IProgressMonitor)sub.newChild(1)), requestor, (IProgressMonitor)sub.newChild(1));
            }
        }
        finally {
            if (progressMonitor != null) {
                progressMonitor.done();
            }
        }
    }

    @Override
    protected void findIndexMatches(Set<Integer> scopeIds, SearchRequestor<? extends IReferenceElement> requestor, IProgressMonitor progressMonitor) throws ReferenceException {
        try {
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)2);
            this.leftPattern.findIndexMatches(scopeIds, requestor, (IProgressMonitor)sub.newChild(1));
            this.rightPattern.findIndexMatches(scopeIds, requestor, (IProgressMonitor)sub.newChild(1));
        }
        finally {
            if (progressMonitor != null) {
                progressMonitor.done();
            }
        }
    }

    @Override
    protected <R extends IReferenceElement, SR extends SearchRequestor<R>> void findMatchesForParticipants(String searchTypeValue, SearchScope scope, SR requestor, IProgressMonitor progressMonitor) throws ReferenceException {
        if (this.getSearchTypeValue() != null) {
            try {
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)2);
                this.leftPattern.findMatchesForParticipants(searchTypeValue, scope, requestor, (IProgressMonitor)sub.newChild(1));
                this.rightPattern.findMatchesForParticipants(searchTypeValue, scope, requestor, (IProgressMonitor)sub.newChild(1));
            }
            finally {
                if (progressMonitor != null) {
                    progressMonitor.done();
                }
            }
        }
    }

    @Override
    public String toString(int indent) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.leftPattern.toString(indent + 1));
        builder.append("\r");
        builder.append((CharSequence)this.getIndent(indent));
        builder.append("OR\r");
        builder.append(this.rightPattern.toString(indent + 1));
        return builder.toString();
    }
}

