/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.search;

import com.ibm.etools.references.internal.index.IndexConstants;
import com.ibm.etools.references.internal.index.IndexManager;
import com.ibm.etools.references.internal.index.keys.LinkKey;
import com.ibm.etools.references.internal.search.WorkspaceSearchScope;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class InternalSearchScope {
    private static Object s = new Object();
    private static InternalSearchScope scope;
    private static Set<Integer> ids;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<Integer> getLinkIdsInScope(IProgressMonitor monitor) {
        if (this instanceof WorkspaceSearchScope) {
            return null;
        }
        Object object = s;
        synchronized (object) {
            if (this.equals(scope)) {
                return ids;
            }
            GetIds i = new GetIds();
            try {
                ids = i.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            scope = this;
            return ids;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Object object = s;
        synchronized (object) {
            ids = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLink(ILink link) {
        Object object = s;
        synchronized (object) {
            if (scope != null && scope.encloses(link.getPath().toString())) {
                if (ids == null) {
                    ids = new HashSet<Integer>();
                }
                ids.add(link.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLink(ILink link) {
        Object object = s;
        synchronized (object) {
            if (scope != null && scope.encloses(link.getPath().toString()) && ids != null) {
                ids.remove(link.getId());
            }
        }
    }

    public abstract boolean encloses(String var1);

    public abstract IPath[] getEnclosingProjects();

    public abstract IPath[] getPaths();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract String toString();

    private class GetIds
    implements Callable<Set<Integer>> {
        private GetIds() {
        }

        @Override
        public Set<Integer> call() throws Exception {
            HashSet<Integer> ids2 = new HashSet<Integer>();
            IPath[] paths = InternalSearchScope.this.getPaths();
            if (paths != null) {
                IPath[] iPathArray = paths;
                int n = paths.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath path = iPathArray[n2];
                    Collection<LinkKey> starts = IndexManager.createKey(IndexConstants.BY_SOURCEPATH, IReferenceElement.ElementType.LINK, path.toString());
                    for (LinkKey linkKey : starts) {
                        ids2.addAll(IndexManager.search(linkKey, linkKey.getMaximumPrefixKey()));
                    }
                    ++n2;
                }
            }
            return ids2;
        }
    }
}

