/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.search;

import com.ibm.etools.references.internal.index.IndexConstants;
import com.ibm.etools.references.internal.search.BasicPattern;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.search.SearchPattern;
import com.ibm.etools.references.search.SearchRequestor;
import com.ibm.etools.references.search.SearchScope;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class InternalSearchPattern {
    protected <R extends IReferenceElement, SR extends SearchRequestor<R>> void findMatchesForParticipants(String searchTypeValue, SearchScope scope, SR requestor, IProgressMonitor progressMonitor) throws ReferenceException {
    }

    protected void findIndexMatches(Set<Integer> scopeIds, SearchRequestor<? extends IReferenceElement> requestor, IProgressMonitor progressMonitor) throws ReferenceException {
    }

    public void findIndexMatches(SearchScope scope, SearchRequestor<? extends IReferenceElement> requestor, IProgressMonitor progressMonitor) {
    }

    public static SearchPattern createPattern(String pattern, IndexConstants indexConstants, IReferenceElement.ElementType limitTo, int matchRule) {
        return new BasicPattern(pattern, indexConstants, limitTo, matchRule);
    }

    public abstract String getSearchTypeValue();

    public boolean isScopeAware(SearchScope scope) {
        return false;
    }

    protected StringBuilder getIndent(int indent) {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < indent) {
            b.append("\t");
            ++i;
        }
        return b;
    }

    public abstract String toString(int var1);
}

