/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.search;

import com.ibm.etools.references.Logger;
import com.ibm.etools.references.internal.index.IndexConstants;
import com.ibm.etools.references.internal.index.IndexManager;
import com.ibm.etools.references.internal.index.keys.LinkKey;
import com.ibm.etools.references.internal.management.MonitorPolicy;
import com.ibm.etools.references.internal.management.ResolvedReference;
import com.ibm.etools.references.internal.nls.Messages;
import com.ibm.etools.references.internal.search.BasicPattern;
import com.ibm.etools.references.internal.search.ICompoundPattern;
import com.ibm.etools.references.internal.search.InternalSearchScope;
import com.ibm.etools.references.internal.search.WorkspaceSearchScope;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.search.SearchPattern;
import com.ibm.etools.references.search.SearchRequestor;
import com.ibm.etools.references.search.SearchScope;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class InternalSearchEngine {
    public static final AtomicInteger COUNT = new AtomicInteger();
    protected boolean ignoreParticipants;
    protected static final ThreadLocal<Map<SearchEngine.SearchHint, Integer>> hintCount = new ThreadLocal();

    public InternalSearchEngine(boolean ignoreParticipants) {
        this.ignoreParticipants = ignoreParticipants;
    }

    public void setIgnoreParticipants(boolean ignoreParticipants) {
        this.ignoreParticipants = ignoreParticipants;
    }

    private String getDebugQueryString(SearchPattern pattern, SearchScope scope) {
        StringBuilder context = new StringBuilder("SEARCH:\n");
        context.append(pattern);
        context.append("\rSCOPE: ");
        context.append(scope == null ? "null" : scope.toString());
        return context.toString();
    }

    public <R extends IReferenceElement, SR extends SearchRequestor<R>> void search(SearchPattern pattern, SearchScope scope, SR requestor, IProgressMonitor monitor) throws ReferenceException {
        PerformanceStats stats = null;
        if (Logger.PERF_SEARCH) {
            stats = PerformanceStats.getStats((String)"com.ibm.etools.references/perf/search", (Object)this);
            stats.startRun(this.getDebugQueryString(pattern, scope));
        }
        int searchNo = 0;
        if (Logger.SHOULD_TRACE_QUERY || Logger.SHOULD_TRACE_QUERY_TIMING || Logger.SHOULD_TRACE_SLOWQUERY) {
            searchNo = COUNT.getAndAdd(1);
        }
        if (Logger.SHOULD_TRACE_QUERY) {
            Logger.trace(Logger.Category.QUERY, "SID: " + searchNo + " " + this.getDebugQueryString(pattern, scope), new Throwable[]{null});
        }
        long start = 0L;
        if (Logger.SHOULD_TRACE_QUERY_TIMING || Logger.SHOULD_TRACE_SLOWQUERY) {
            start = System.nanoTime();
        }
        InterceptingSearchRequestor req = new InterceptingSearchRequestor(requestor);
        if (pattern instanceof BasicPattern) {
            req.setMatchType(((BasicPattern)pattern).getLimitTo());
        } else {
            ICompoundPattern p = (ICompoundPattern)pattern;
            req.setMatchType(p.getLimitTo().iterator().next());
        }
        try {
            req.beginReporting();
            ReferenceManager manager = ReferenceManager.getReferenceManager();
            if ((manager.isShutdown() || manager.hasFatalError()) && manager.hasFatalError()) {
                Status status = new Status(4, "com.ibm.etools.references", "Attempt was made to search on database that has been disabled. Please rebuild the database before attempting this again. NOTE: In the future this message will be an exception.");
                Logger.log(Logger.Category.DEBUG, Logger.Severity.ERROR, Logger.Mode.DEV_MANDATORY, (IStatus)status);
            }
            SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor);
            mon.beginTask("Searching", 3);
            if (scope == null) {
                manager.waitForIndexing(MonitorPolicy.monitorFor(monitor, (IProgressMonitor)mon.newChild(1)), new WorkspaceSearchScope());
            } else {
                manager.waitForIndexing(MonitorPolicy.monitorFor(monitor, (IProgressMonitor)mon.newChild(1)), scope);
            }
            if (manager.isShutdown()) {
                return;
            }
            boolean skip = false;
            if (pattern.isScopeAware(scope)) {
                pattern.findIndexMatches(scope, req, (IProgressMonitor)mon.newChild(2));
            } else {
                Set<Integer> scopeIds;
                mon.subTask(Messages.searchpreparing_search_scope);
                if (scope == null || scope instanceof WorkspaceSearchScope) {
                    scopeIds = null;
                    mon.worked(1);
                } else if (pattern instanceof ICompoundPattern) {
                    scopeIds = null;
                    Set<IReferenceElement.ElementType> types = ((ICompoundPattern)pattern).getLimitTo();
                    if (types.size() > 1) {
                        Assert.isTrue((boolean)false, (String)"Scoped search on compound patterns not supported");
                    } else if (types.iterator().next() != IReferenceElement.ElementType.RESOLVED_REFERENCE) {
                        Assert.isTrue((boolean)false, (String)"Scoped search on compound patterns not supported");
                    } else {
                        HashSet<Integer> ids2 = new HashSet<Integer>();
                        IPath[] paths = scope.getPaths();
                        if (paths != null) {
                            IPath[] iPathArray = paths;
                            int n = paths.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IPath path = iPathArray[n2];
                                Collection<LinkKey> starts = IndexManager.createKey(IndexConstants.BY_SOURCEPATH, IReferenceElement.ElementType.RESOLVED_REFERENCE, path.toString());
                                for (LinkKey linkKey : starts) {
                                    ids2.addAll(IndexManager.search(linkKey, linkKey.getMaximumPrefixKey()));
                                }
                                ++n2;
                            }
                        }
                        if (ids2.isEmpty()) {
                            skip = true;
                        }
                        req.addResolvedLinkFilter(ids2);
                    }
                } else {
                    BasicPattern bp = (BasicPattern)pattern;
                    if (bp.getLimitTo() == IReferenceElement.ElementType.LINK) {
                        scopeIds = scope.getLinkIdsInScope((IProgressMonitor)mon.newChild(1));
                    } else {
                        req.useTargetLinkID(bp.getIndexConstants() != IndexConstants.BY_TARGETLINKID);
                        if (bp.getIndexConstants() == IndexConstants.BY_MODELINSTANCEID_REF) {
                            req.useTargetLinkID(false);
                            HashSet<Integer> ids2 = new HashSet<Integer>();
                            IPath[] paths = scope.getPaths();
                            if (paths != null) {
                                IPath[] iPathArray = paths;
                                int n = paths.length;
                                int n3 = 0;
                                while (n3 < n) {
                                    IPath path = iPathArray[n3];
                                    Collection<LinkKey> starts = IndexManager.createKey(IndexConstants.BY_SOURCEPATH, IReferenceElement.ElementType.RESOLVED_REFERENCE, path.toString());
                                    for (LinkKey linkKey : starts) {
                                        ids2.addAll(IndexManager.search(linkKey, linkKey.getMaximumPrefixKey()));
                                    }
                                    ++n3;
                                }
                            }
                            req.addResolvedLinkFilter(ids2);
                            if (ids2.isEmpty()) {
                                skip = true;
                            }
                        }
                        req.addLinkScopeFilter(scope.getLinkIdsInScope((IProgressMonitor)mon.newChild(1)));
                        scopeIds = null;
                    }
                }
                if (scopeIds == null || !scopeIds.isEmpty() && !skip) {
                    pattern.findIndexMatches(scopeIds, req, (IProgressMonitor)mon.newChild(1));
                }
            }
            if (manager.isShutdown()) {
                return;
            }
            if (!this.ignoreParticipants) {
                pattern.findMatchesForParticipants(pattern.getSearchTypeValue(), scope, req, (IProgressMonitor)mon.newChild(1));
            } else {
                mon.newChild(1).done();
            }
            if (manager.isShutdown()) {
                return;
            }
        }
        finally {
            req.endReporting();
            if (monitor != null) {
                monitor.done();
            }
            if (stats != null) {
                stats.endRun();
            }
            if (Logger.SHOULD_TRACE_QUERY_TIMING || Logger.SHOULD_TRACE_SLOWQUERY) {
                long end = System.nanoTime();
                long lengthN = end - start;
                long lengthM = TimeUnit.MILLISECONDS.convert(lengthN, TimeUnit.NANOSECONDS);
                if (Logger.SHOULD_TRACE_SLOWQUERY) {
                    if (lengthM > 0L) {
                        Logger.trace(Logger.Category.SLOWQUERY, "Search " + searchNo + " completed: " + lengthM + "ms (total nanos=" + lengthN + ")\r" + this.getDebugQueryString(pattern, scope), new Throwable[0]);
                    }
                } else {
                    Logger.trace(Logger.Category.QUERY_TIMING, "Search " + searchNo + " completed: " + lengthM + "ms (total nanos=" + lengthN + ")", new Throwable[0]);
                }
            }
        }
    }

    protected static synchronized void setSearchHint(Set<SearchEngine.SearchHint> nowait) {
        Map<SearchEngine.SearchHint, Integer> map = hintCount.get();
        if (map == null) {
            map = new EnumMap<SearchEngine.SearchHint, Integer>(SearchEngine.SearchHint.class);
            hintCount.set(map);
        }
        for (SearchEngine.SearchHint searchHint : nowait) {
            Integer count = map.get((Object)searchHint);
            count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
            map.put(searchHint, count);
        }
    }

    protected static synchronized void clearSearchHint(Set<SearchEngine.SearchHint> nowait) {
        Map<SearchEngine.SearchHint, Integer> map = hintCount.get();
        if (map != null) {
            for (SearchEngine.SearchHint searchHint : nowait) {
                Integer count = map.get((Object)searchHint);
                if (count == null) continue;
                count = count - 1;
                map.put(searchHint, count);
                if (count > 0) continue;
                map.remove((Object)searchHint);
            }
        }
    }

    public static synchronized Set<SearchEngine.SearchHint> getHint() {
        Map<SearchEngine.SearchHint, Integer> map = hintCount.get();
        if (map != null) {
            return map.keySet();
        }
        return EnumSet.noneOf(SearchEngine.SearchHint.class);
    }

    public static void removeCache() {
        InternalSearchScope.clear();
    }

    private static class InterceptingSearchRequestor<RE extends IReferenceElement>
    extends SearchRequestor<RE> {
        private final SearchRequestor<RE> wrapped;
        private Set<Integer> linkIds;
        private Set<Integer> resolvedrefids;
        private boolean useTarget;
        private IReferenceElement.ElementType limitTo;

        <R extends RE, SR extends SearchRequestor<RE>> InterceptingSearchRequestor(SR wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        protected void acceptSearchMatch(int id) {
            if (this.linkIds == null) {
                super.acceptSearchMatch(id);
            } else if (this.limitTo == IReferenceElement.ElementType.REFERENCE) {
                int sourceId;
                ILink s;
                Reference r = (Reference)this.getElement(id);
                if (r != null && (s = r.getSource()) != null && this.linkIds.contains(sourceId = s.getId())) {
                    this.wrapped.acceptSearchMatch(id);
                }
            } else if (this.limitTo == IReferenceElement.ElementType.RESOLVED_REFERENCE) {
                if (this.resolvedrefids != null) {
                    if (this.resolvedrefids.contains(id)) {
                        this.wrapped.acceptSearchMatch(id);
                    }
                } else {
                    ILink link;
                    ResolvedReference r = (ResolvedReference)this.getElement(id);
                    ILink iLink = link = this.useTarget ? r.getTarget() : r.getSource();
                    if (link != null && this.linkIds.contains(link.getId())) {
                        this.wrapped.acceptSearchMatch(id);
                    }
                }
            }
        }

        @Override
        public void acceptSearchMatch(RE match) {
            this.wrapped.acceptSearchMatch(match);
        }

        public void addLinkScopeFilter(Set<Integer> linkIds) {
            this.linkIds = linkIds;
        }

        public void addResolvedLinkFilter(Set<Integer> resolvedrefids) {
            this.resolvedrefids = resolvedrefids;
        }

        @Override
        public void beginReporting() {
            this.wrapped.beginReporting();
        }

        @Override
        public void endReporting() {
            this.wrapped.endReporting();
        }

        public void useTargetLinkID(boolean useTarget) {
            this.useTarget = useTarget;
        }

        public void setMatchType(IReferenceElement.ElementType limitTo) {
            this.limitTo = limitTo;
        }
    }
}

