/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.search;

import com.ibm.etools.references.internal.nls.Messages;
import com.ibm.etools.references.search.SearchScope;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class BasicSearchScope
extends SearchScope {
    private final IPath[] resources;
    private final IPath[] projects;

    public BasicSearchScope(IPath[] resources) {
        Assert.isNotNull((Object)resources, (String)Messages.BasicSearchScope_0);
        int i = 0;
        while (i < resources.length) {
            Assert.isLegal((resources[i] != null ? 1 : 0) != 0, (String)Messages.BasicSearchScope_1);
            ++i;
        }
        this.resources = resources;
        HashSet<Path> s = new HashSet<Path>();
        IPath[] iPathArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path = iPathArray[n2];
            if (path.segmentCount() > 0) {
                s.add(new Path("/" + path.segment(0)));
            }
            ++n2;
        }
        this.projects = s.toArray(new IPath[s.size()]);
        Arrays.sort(this.resources, new PathComparator());
        Arrays.sort(this.projects, new PathComparator());
    }

    @Override
    public boolean encloses(String resourcePath) {
        if (resourcePath == null) {
            return false;
        }
        if ((resourcePath = resourcePath.trim()).length() == 0) {
            return false;
        }
        IPath[] iPathArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            IPath res = iPathArray[n2];
            if (res.hasTrailingSeparator() ? resourcePath.startsWith(res.toString()) : resourcePath.equals(res.toString())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public IPath[] getEnclosingProjects() {
        return this.projects;
    }

    @Override
    public IPath[] getPaths() {
        return this.resources;
    }

    @Override
    public int hashCode() {
        IPath path;
        assert (this.projects != null);
        assert (this.resources != null);
        int result = 1;
        IPath[] iPathArray = this.projects;
        int n = this.projects.length;
        int n2 = 0;
        while (n2 < n) {
            path = iPathArray[n2];
            result += path.toString().hashCode();
            ++n2;
        }
        iPathArray = this.resources;
        n = this.resources.length;
        n2 = 0;
        while (n2 < n) {
            path = iPathArray[n2];
            result += path.toString().hashCode();
            ++n2;
        }
        return result *= 31;
    }

    @Override
    public boolean equals(Object obj) {
        assert (this.projects != null);
        assert (this.resources != null);
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicSearchScope other = (BasicSearchScope)obj;
        assert (other.projects != null);
        assert (other.resources != null);
        if (this.projects.length != other.projects.length || this.resources.length != other.resources.length) {
            return false;
        }
        int i = 0;
        while (i < this.projects.length) {
            if (!this.projects[i].toString().equals(other.projects[i].toString())) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.resources.length) {
            if (!this.resources[i].toString().equals(other.resources[i].toString())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        Iterator<IPath> iterator = Arrays.asList(this.getPaths()).iterator();
        while (iterator.hasNext()) {
            IPath path = iterator.next();
            builder.append(path.removeTrailingSeparator().toString());
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    static class PathComparator
    implements Comparator<IPath> {
        PathComparator() {
        }

        @Override
        public int compare(IPath o1, IPath o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }
}

