/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.search;

import com.ibm.etools.references.StringMatcher;
import com.ibm.etools.references.internal.bplustree.tree.Key;
import com.ibm.etools.references.internal.index.IndexConstants;
import com.ibm.etools.references.internal.index.IndexManager;
import com.ibm.etools.references.internal.index.keys.LinkKey;
import com.ibm.etools.references.internal.nls.Messages;
import com.ibm.etools.references.internal.search.AndScope;
import com.ibm.etools.references.internal.search.InternalSearchRequestor;
import com.ibm.etools.references.internal.services.SearchParticipantService;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.search.SearchPattern;
import com.ibm.etools.references.search.SearchRequestor;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.references.search.SearchType;
import com.ibm.etools.references.services.providers.ISearchParticipant;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

public class BasicPattern
extends SearchPattern {
    private final IReferenceElement.ElementType limitTo;
    private final int matchRule;
    private final String pattern;
    private final IndexConstants indexConstants;
    private final SearchType searchType;

    public BasicPattern(String pattern, IndexConstants constants, IReferenceElement.ElementType limitTo, int matchRule) {
        this.searchType = null;
        this.pattern = pattern;
        this.indexConstants = constants;
        this.limitTo = limitTo;
        this.matchRule = matchRule;
    }

    public BasicPattern(String pattern, SearchType searchType, IReferenceElement.ElementType limitTo, int matchRule) {
        this.searchType = searchType;
        this.pattern = pattern;
        this.indexConstants = IndexManager.convertSearchTypeInIndex(searchType, limitTo);
        this.limitTo = limitTo;
        this.matchRule = matchRule;
    }

    public String getPattern() {
        return this.pattern;
    }

    boolean isCaseSensitive() {
        return false;
    }

    IReferenceElement.ElementType getLimitTo() {
        return this.limitTo;
    }

    IndexConstants getIndexConstants() {
        return this.indexConstants;
    }

    @Override
    public boolean isScopeAware(SearchScope scope) {
        return this.indexConstants == IndexConstants.BY_LINKTYPE && scope != null;
    }

    @Override
    public void findIndexMatches(SearchScope scope, SearchRequestor<? extends IReferenceElement> req, IProgressMonitor progressMonitor) {
        Collection<LinkKey> keys = IndexManager.createScopedKey(scope, this.indexConstants, this.limitTo, this.pattern);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)keys.size());
        for (LinkKey linkKey : keys) {
            this.doFind(null, req, linkKey, (IProgressMonitor)sub.newChild(1));
        }
    }

    @Override
    protected void findIndexMatches(Set<Integer> scopeIds, SearchRequestor<? extends IReferenceElement> requestor, IProgressMonitor progressMonitor) throws ReferenceException {
        Collection<LinkKey> keys = IndexManager.createKey(this.indexConstants, this.limitTo, this.pattern);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)keys.size());
        for (LinkKey linkKey : keys) {
            this.doFind(scopeIds, requestor, linkKey, (IProgressMonitor)sub.newChild(1));
        }
    }

    protected void sendIdsToRequestor(Set<Integer> scopeIds, Set<Integer> ids, InternalSearchRequestor<? extends IReferenceElement> requestor, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor);
        sub.setWorkRemaining(ids.size());
        if (scopeIds != null && scopeIds.size() == 1) {
            Integer id = scopeIds.iterator().next();
            if (ids.contains(id)) {
                requestor.acceptSearchMatch(id);
            }
            sub.worked(1);
        } else if (!ids.isEmpty()) {
            if (scopeIds != null) {
                if (scopeIds.size() > ids.size()) {
                    HashSet<Integer> copy = new HashSet<Integer>(scopeIds);
                    copy.retainAll(ids);
                    ids = copy;
                } else {
                    ids.retainAll(scopeIds);
                }
            }
            for (Integer id : ids) {
                requestor.acceptSearchMatch(id);
                sub.worked(1);
            }
        }
    }

    private void doFind(Set<Integer> scopeIds, InternalSearchRequestor<? extends IReferenceElement> requestor, LinkKey key, IProgressMonitor progressMonitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)3);
        sub.subTask(Messages.search_locating_matches);
        if (this.matchRule == 0) {
            if (key != null) {
                Set<Integer> ids = IndexManager.search(key, key.getMaximumValueKey());
                this.sendIdsToRequestor(scopeIds, ids, requestor, (IProgressMonitor)sub);
            }
        } else if (this.matchRule == 1) {
            if (key != null) {
                Set<Integer> ids = IndexManager.search(key, key.getMaximumPrefixKey());
                this.sendIdsToRequestor(scopeIds, ids, requestor, (IProgressMonitor)sub);
            }
        } else if (this.matchRule == 2) {
            if (key != null) {
                Map<Key, Integer> entries = IndexManager.entries(key, scopeIds);
                sub.setWorkRemaining(entries.entrySet().size());
                Iterator<Map.Entry<Key, Integer>> itr = entries.entrySet().iterator();
                if ("*".equals(this.pattern)) {
                    while (itr.hasNext()) {
                        Map.Entry<Key, Integer> entry = itr.next();
                        int i = entry.getValue();
                        requestor.acceptSearchMatch(i);
                        sub.worked(1);
                    }
                } else {
                    StringMatcher matcher = new StringMatcher(this.pattern);
                    while (itr.hasNext()) {
                        Map.Entry<Key, Integer> entry = itr.next();
                        Key k = entry.getKey();
                        String keyValue = ((LinkKey)k).getMatchableValue().toString();
                        int i = entry.getValue();
                        if (matcher.match(keyValue)) {
                            requestor.acceptSearchMatch(i);
                        }
                        sub.worked(1);
                    }
                }
            }
        } else {
            Assert.isTrue((boolean)false, (String)"Unsupported Match Rule");
        }
        progressMonitor.done();
    }

    @Override
    protected <R extends IReferenceElement, SR extends SearchRequestor<R>> void findMatchesForParticipants(String searchTypeValue, SearchScope scope, SR requestor, IProgressMonitor progressMonitor) throws ReferenceException {
        if (this.searchType == null) {
            if (this.indexConstants == IndexConstants.BY_SOURCEPATH) {
                SearchScope patternScope = SearchEngine.createSearchScope(new IPath[]{new Path(this.pattern)});
                AndScope adaptedSearchScope = new AndScope(scope, patternScope);
                SearchType adaptedSearchType = SearchType.BY_TYPE;
                String adaptedSearchPattern = "*";
                int adaptedMatchRule = 2;
                this.doParticipantSearch(searchTypeValue, requestor, progressMonitor, adaptedSearchScope, adaptedSearchType, adaptedSearchPattern, adaptedMatchRule);
            }
        } else {
            this.doParticipantSearch(searchTypeValue, requestor, progressMonitor, scope, this.searchType, this.pattern, this.matchRule);
        }
    }

    @Deprecated
    protected <RE extends IReferenceElement, ISR extends SearchRequestor<RE>> void doParticipantSearch(String searchTypeValue, ISR requestor, IProgressMonitor progressMonitor, SearchScope pScope, SearchType pSearchType, String pSearchPattern, int pMatchRule) {
        List<ISearchParticipant> applicableSearchParticipants = SearchParticipantService.getInstance().getSearchParticipants(searchTypeValue);
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)applicableSearchParticipants.size());
        for (ISearchParticipant participant : applicableSearchParticipants) {
            participant.search(pSearchPattern, pSearchType, this.limitTo, pMatchRule, pScope, requestor, (IProgressMonitor)monitor.newChild(1));
        }
    }

    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int indent) {
        return this.getIndent(indent) + "Pattern: " + this.pattern + ", searchType: " + (this.searchType == null ? "null" : this.searchType.name()) + ", indexConstants: " + (this.indexConstants == null ? "null" : this.indexConstants.name()) + ", limitTo: " + this.limitTo.name() + ", matchRule: " + this.matchRule;
    }

    public SearchType getSearchType() {
        return this.searchType;
    }

    @Override
    public String getSearchTypeValue() {
        if (SearchType.BY_TYPE == this.searchType) {
            return this.getPattern();
        }
        if (SearchType.BY_LINKNAME == this.searchType) {
            return null;
        }
        if (SearchType.BY_LINKTEXT == this.searchType) {
            return null;
        }
        return null;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.indexConstants == null ? 0 : this.indexConstants.hashCode());
        result = 31 * result + (this.limitTo == null ? 0 : this.limitTo.hashCode());
        result = 31 * result + this.matchRule;
        result = 31 * result + (this.pattern == null ? 0 : this.pattern.hashCode());
        result = 31 * result + (this.searchType == null ? 0 : this.searchType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicPattern other = (BasicPattern)obj;
        if (this.indexConstants == null ? other.indexConstants != null : !this.indexConstants.equals((Object)other.indexConstants)) {
            return false;
        }
        if (this.limitTo == null ? other.limitTo != null : !this.limitTo.equals((Object)other.limitTo)) {
            return false;
        }
        if (this.matchRule != other.matchRule) {
            return false;
        }
        if (this.pattern == null ? other.pattern != null : !this.pattern.equals(other.pattern)) {
            return false;
        }
        return !(this.searchType == null ? other.searchType != null : !this.searchType.equals((Object)other.searchType));
    }
}

