/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.resource;

import com.ibm.etools.references.Logger;
import com.ibm.etools.references.internal.resource.Visitor;
import com.ibm.etools.references.management.ReferenceManager;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class SavedResourceChangeListener
implements IResourceChangeListener {
    private final IProgressMonitor monitor;

    SavedResourceChangeListener(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            if (Logger.SHOULD_TRACE_REFERENCE_MANAGER) {
                Logger.trace(Logger.Category.REFERENCE_MANAGER, "Fast reactivation using delta", new Throwable[]{null});
            }
            try {
                Visitor visitor = new Visitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                ReferenceManager.getReferenceManager().requestChangeAnalysis(visitor.getChanges(), this.monitor);
            }
            catch (CoreException e) {
                Logger.log(e.getStatus());
            }
        } else {
            if (Logger.SHOULD_TRACE_REFERENCE_MANAGER) {
                Logger.trace(Logger.Category.REFERENCE_MANAGER, "Slower reactivation without delta", new Throwable[]{null});
            }
            ReferenceManager.getReferenceManager().requestRebuildIndex(this.monitor);
        }
        ReferenceManager.getReferenceManager().startQueue();
    }
}

