/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.management;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.Logger;
import com.ibm.etools.references.internal.Activator;
import com.ibm.etools.references.internal.management.IRunnableJob;
import com.ibm.etools.references.internal.management.InternalReferenceManager;
import com.ibm.etools.references.internal.management.JobRunner;
import com.ibm.etools.references.internal.management.MonitorPolicy;
import com.ibm.etools.references.internal.management.ReferenceProcessor;
import com.ibm.etools.references.internal.management.Scheduler;
import com.ibm.etools.references.internal.nls.Messages;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.search.SearchScope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class SchedulerCondition {
    private final ILock LOCK = Job.getJobManager().newLock();
    private final Map<Thread, ISchedulingRule> waitThreadsWithRules;
    private final List<Thread> waitingThreads = Collections.synchronizedList(new ArrayList());
    private final AtomicBoolean ready;
    private final ReferenceProcessor processor;
    private final WaitForConditionJob conditionJobWithRule;
    private final WaitForConditionRule conditionRule;
    private final Scheduler scheduler;
    private final Semaphore semaphore;
    private final SearchScope scope;
    final HashSet<IPath> paths;

    public SchedulerCondition(SearchScope scope, Scheduler scheduler, ReferenceProcessor processor) {
        this.waitThreadsWithRules = Collections.synchronizedMap(new HashMap());
        this.ready = new AtomicBoolean(false);
        this.scope = scope;
        this.paths = new HashSet<IPath>(Arrays.asList(scope.getPaths()));
        this.scheduler = scheduler;
        this.processor = processor;
        this.conditionJobWithRule = new WaitForConditionJob(scope);
        this.conditionRule = new WaitForConditionRule();
        this.conditionJobWithRule.setRule(this.conditionRule);
        this.semaphore = new Semaphore(0);
        if (Logger.SHOULD_TRACE_DEBUG_CONDITIONS) {
            Logger.trace(Logger.Category.DEBUG_CONDITIONS, String.valueOf(this.hashCode()) + " is " + this.toString(), new Throwable[]{null});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreWaitingrule() {
        Map<Thread, ISchedulingRule> map = this.waitThreadsWithRules;
        synchronized (map) {
            for (Map.Entry<Thread, ISchedulingRule> entry : this.waitThreadsWithRules.entrySet()) {
                ISchedulingRule rule = entry.getValue();
                Thread waitingThread = entry.getKey();
                if (waitingThread == null || rule == null) continue;
                try {
                    if (Logger.SHOULD_TRACE_REFERENCE_MANAGER) {
                        Logger.trace(Logger.Category.REFERENCE_MANAGER, "(restore) Transfer rule '" + rule + "' to thread '" + waitingThread + "'", new Throwable[]{null});
                    }
                    Job.getJobManager().transferRule(rule, waitingThread);
                }
                catch (RuntimeException e) {
                    Logger.logException("Error restoring rule to waiting thread", e);
                }
            }
        }
    }

    public void setReady() {
        try {
            this.scheduler.getLock().lock();
            if (Logger.SHOULD_TRACE_DEBUG_CONDITIONS) {
                String setReady = "READY=true for " + this.getDebugName();
                Logger.trace(Logger.Category.DEBUG_CONDITIONS, setReady, new Throwable[]{null});
            }
            this.restoreWaitingrule();
            if (this.ready.compareAndSet(false, true)) {
                this.semaphore.release();
            } else if (this.scheduler.readinessLatch.getCount() <= 0L) {
                Logger.logWarning(Logger.Category.REFERENCE_MANAGER, Logger.Mode.USER, "Condition (" + this.toString() + ") was already ready");
            }
            this.scheduler.removeCondition(this);
        }
        finally {
            this.scheduler.getLock().unlock();
        }
    }

    public boolean isReady() {
        return this.ready.get();
    }

    void setWaitThreadRule(Thread thread, ISchedulingRule rule) {
        Assert.isTrue((!this.waitingThreads.contains(thread) ? 1 : 0) != 0);
        this.waitThreadsWithRules.put(thread, rule);
    }

    String getDebugName() {
        return "Condition: " + this.hashCode();
    }

    public void waitUntilReady(IProgressMonitor monitor) {
        if (this.isReady()) {
            if (Logger.SHOULD_TRACE_DEBUG_CONDITIONS_DETAILED) {
                Logger.trace(Logger.Category.DEBUG_CONDITIONS_DETAILED, "Condition was ready without waiting (" + this.getDebugName() + ")", new Throwable[]{null});
            }
            return;
        }
        if (ReferenceManager.getReferenceManager().hasFatalError()) {
            Status status = new Status(4, "com.ibm.etools.references", "Attempt was made to wait for indexing on a database that has been disabled. Please rebuild the database before attempting this again. NOTE: In the future this message will be an exception.");
            Logger.log(Logger.Category.DEBUG, Logger.Severity.ERROR, Logger.Mode.DEV_MANDATORY, (IStatus)status);
            return;
        }
        Job currentJob = Job.getJobManager().currentJob();
        ISchedulingRule currentRule = currentJob == null ? null : currentJob.getRule();
        boolean useWaitJobWithRule = currentJob == null || currentRule == null;
        int lastRemaining = -1;
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)-1);
        sub.subTask("");
        Thread processorThread = this.processor.getActiveThread();
        Thread currentThread = Thread.currentThread();
        if (currentRule != null && processorThread != null && !this.waitingThreads.contains(currentThread)) {
            this.processor.transferRule(currentRule, this);
        }
        while (!this.isReady()) {
            boolean gotLock;
            boolean interrupted;
            block64: {
                block65: {
                    if (Logger.SHOULD_TRACE_DEBUG_CONDITIONS_DETAILED) {
                        Logger.trace(Logger.Category.DEBUG_CONDITIONS_DETAILED, "Condition is NOT ready. Waiting... (" + this.getDebugName() + ")", new Throwable[]{null});
                    }
                    this.processor.boostPriority();
                    interrupted = Thread.interrupted();
                    gotLock = false;
                    try {
                        block63: {
                            int remaining;
                            if (this.waitingThreads.contains(Thread.currentThread())) {
                                if (Logger.SHOULD_TRACE_DEBUG_CONDITIONS) {
                                    Logger.trace(Logger.Category.DEBUG_CONDITIONS, "Condition is re-entrant (" + this.getDebugName() + ")", new Throwable[]{null});
                                }
                                if (this.processor.referenceManager.hasFatalError()) {
                                    if (Logger.SHOULD_TRACE_DEBUG_CONDITIONS) {
                                        Logger.trace(Logger.Category.DEBUG_CONDITIONS, "Condition has fatal error, aborting... (" + this.getDebugName() + ")", new Throwable[]{null});
                                    }
                                    throw new OperationCanceledException();
                                }
                                remaining = this.scheduler.getItemsBeforeConditionMarker(this);
                                if (lastRemaining != remaining) {
                                    if (remaining == -1) {
                                        sub.subTask(Messages.reference_processor_unknown_file_amount);
                                    } else {
                                        sub.subTask(NLS.bind((String)Messages.reference_processor_Xfilestoindex_Y, (Object)(remaining + 1), (Object)this.processor.getCurrentIndexItemLabel()));
                                    }
                                    lastRemaining = remaining;
                                }
                                try {
                                    gotLock = this.tryLock();
                                }
                                catch (InterruptedException interruptedException) {
                                    interrupted = true;
                                }
                            } else {
                                try {
                                    this.waitingThreads.add(Thread.currentThread());
                                    if (useWaitJobWithRule) {
                                        if (Logger.SHOULD_TRACE_DEBUG_CONDITIONS_DETAILED) {
                                            Logger.trace(Logger.Category.DEBUG_CONDITIONS_DETAILED, "Condition spawning wait job... (" + this.getDebugName() + ")", new Throwable[]{null});
                                        }
                                        OperationCanceledException canceled = null;
                                        JobRunner runner = new JobRunner(this.conditionJobWithRule);
                                        runner.runJob();
                                        runner.waitForJobStart();
                                        try {
                                            if (Logger.SHOULD_TRACE_DEBUG_CONDITIONS_DETAILED) {
                                                Logger.trace(Logger.Category.DEBUG_CONDITIONS_DETAILED, "Condition waiting on job using conflicting scheduling rule (" + this.getDebugName() + ")", new Throwable[]{null});
                                            }
                                            Job.getJobManager().beginRule((ISchedulingRule)this.conditionRule, MonitorPolicy.monitorFor(monitor, (IProgressMonitor)sub.newChild(1)));
                                            if (this.conditionJobWithRule.getLastExecutionStatus() == Status.CANCEL_STATUS) {
                                                if (Logger.SHOULD_TRACE_DEBUG_CONDITIONS) {
                                                    Logger.trace(Logger.Category.DEBUG_CONDITIONS, "Condition job return status is canceled, aborting... (" + this.getDebugName() + ")", new Throwable[]{null});
                                                }
                                                throw new OperationCanceledException();
                                            }
                                            Assert.isTrue((boolean)this.ready.get(), (String)Messages.SchedulerCondition_0);
                                            if (Logger.SHOULD_TRACE_DEBUG_CONDITIONS) {
                                                Logger.trace(Logger.Category.DEBUG_CONDITIONS, "Condition's wait job is done. Condition is ready. (" + this.getDebugName() + ")", new Throwable[]{null});
                                            }
                                        }
                                        catch (IllegalArgumentException e) {
                                            Logger.logWarning(Logger.Category.DEBUG, Logger.Mode.DEV_MANDATORY, String.valueOf(this.getClass().getSimpleName()) + " is recovering from illegalPush: " + e.getMessage());
                                            int remaining2 = this.scheduler.getItemsBeforeConditionMarker(this);
                                            if (lastRemaining != remaining2) {
                                                if (remaining2 == -1) {
                                                    sub.subTask(Messages.reference_processor_unknown_file_amount);
                                                } else {
                                                    sub.subTask(NLS.bind((String)Messages.reference_processor_Xfilestoindex_Y, (Object)(remaining2 + 1), (Object)this.processor.getCurrentIndexItemLabel()));
                                                }
                                                remaining2 = lastRemaining;
                                            }
                                            runner.cancel();
                                            try {
                                                gotLock = this.tryLock();
                                            }
                                            catch (InterruptedException interruptedException) {
                                                interrupted = true;
                                            }
                                            Job.getJobManager().endRule((ISchedulingRule)this.conditionRule);
                                            break block63;
                                        }
                                        catch (OperationCanceledException e) {
                                            try {
                                                if (Logger.SHOULD_TRACE_DEBUG_CONDITIONS) {
                                                    Logger.trace(Logger.Category.DEBUG_CONDITIONS, "Wait has been canceled, aborting... (" + this.getDebugName() + ")", new Throwable[]{null});
                                                }
                                                canceled = e;
                                                runner.cancel();
                                                throw canceled;
                                            }
                                            catch (Throwable throwable) {
                                                Job.getJobManager().endRule((ISchedulingRule)this.conditionRule);
                                                throw throwable;
                                            }
                                        }
                                        Job.getJobManager().endRule((ISchedulingRule)this.conditionRule);
                                        break block63;
                                    }
                                    remaining = this.scheduler.getItemsBeforeConditionMarker(this);
                                    if (lastRemaining != remaining) {
                                        if (remaining == -1) {
                                            sub.subTask(Messages.reference_processor_unknown_file_amount);
                                        } else {
                                            sub.subTask(NLS.bind((String)Messages.reference_processor_Xfilestoindex_Y, (Object)(remaining + 1), (Object)this.processor.getCurrentIndexItemLabel()));
                                        }
                                        remaining = lastRemaining;
                                    }
                                    try {
                                        gotLock = this.tryLock();
                                    }
                                    catch (InterruptedException interruptedException) {
                                        interrupted = true;
                                    }
                                }
                                finally {
                                    this.waitingThreads.remove(Thread.currentThread());
                                }
                            }
                        }
                        if (!sub.isCanceled()) break block64;
                        if (!Logger.SHOULD_TRACE_DEBUG_CONDITIONS_DETAILED) break block65;
                    }
                    catch (Throwable throwable) {
                        if (Logger.SHOULD_TRACE_DEBUG_CONDITIONS_DETAILED) {
                            Logger.trace(Logger.Category.DEBUG_CONDITIONS_DETAILED, "Wait loop done (or timeout) Status: gotlock=" + gotLock + ", ready=" + this.ready.get() + "(" + this.getDebugName() + ")", new Throwable[]{null});
                        }
                        if (gotLock) {
                            while (true) {
                                try {
                                    this.scheduler.readinessLatch.await();
                                }
                                catch (InterruptedException interruptedException) {
                                    interrupted = true;
                                    continue;
                                }
                                break;
                            }
                            this.semaphore.release();
                        }
                        if (!this.processor.referenceManager.hasFatalError() && !this.ready.get() && this.processor.getActiveThread() == null) {
                            Logger.logWarning(Logger.Category.REFERENCE_MANAGER, Logger.Mode.DEV_MANDATORY, "Condition not ready and processor not active... aborting wait (" + this.getDebugName() + ")");
                            break;
                        }
                        if (interrupted) {
                            Thread.currentThread().interrupt();
                        }
                        throw throwable;
                    }
                    Logger.trace(Logger.Category.DEBUG_CONDITIONS_DETAILED, "Wait loop done (or timeout) Status: gotlock=" + gotLock + ", ready=" + this.ready.get() + "(" + this.getDebugName() + ")", new Throwable[]{null});
                }
                if (gotLock) {
                    while (true) {
                        try {
                            this.scheduler.readinessLatch.await();
                        }
                        catch (InterruptedException interruptedException) {
                            interrupted = true;
                            continue;
                        }
                        break;
                    }
                    this.semaphore.release();
                }
                if (!this.processor.referenceManager.hasFatalError() && !this.ready.get() && this.processor.getActiveThread() == null) {
                    Logger.logWarning(Logger.Category.REFERENCE_MANAGER, Logger.Mode.DEV_MANDATORY, "Condition not ready and processor not active... aborting wait (" + this.getDebugName() + ")");
                    break;
                }
                if (!interrupted) break;
                Thread.currentThread().interrupt();
                break;
            }
            if (Logger.SHOULD_TRACE_DEBUG_CONDITIONS_DETAILED) {
                Logger.trace(Logger.Category.DEBUG_CONDITIONS_DETAILED, "Wait loop done (or timeout) Status: gotlock=" + gotLock + ", ready=" + this.ready.get() + "(" + this.getDebugName() + ")", new Throwable[]{null});
            }
            if (gotLock) {
                while (true) {
                    try {
                        this.scheduler.readinessLatch.await();
                    }
                    catch (InterruptedException interruptedException) {
                        interrupted = true;
                        continue;
                    }
                    break;
                }
                this.semaphore.release();
            }
            if (!this.processor.referenceManager.hasFatalError() && !this.ready.get() && this.processor.getActiveThread() == null) {
                Logger.logWarning(Logger.Category.REFERENCE_MANAGER, Logger.Mode.DEV_MANDATORY, "Condition not ready and processor not active... aborting wait (" + this.getDebugName() + ")");
                break;
            }
            if (!interrupted) continue;
            Thread.currentThread().interrupt();
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    boolean tryLock() throws InterruptedException {
        boolean gotLock = false;
        boolean gotUIlock = false;
        try {
            gotUIlock = this.LOCK.acquire((long)InternalAPI.Tweaks.WAIT_TIME);
            gotLock = this.semaphore.tryAcquire(InternalAPI.Tweaks.WAIT_TIME, TimeUnit.MILLISECONDS);
        }
        finally {
            if (gotUIlock) {
                this.LOCK.release();
            }
        }
        return gotLock;
    }

    public String toString() {
        return "Condition: " + this.scope.toString();
    }

    public SearchScope getScope() {
        return this.scope;
    }

    static /* synthetic */ ILock access$0(SchedulerCondition schedulerCondition) {
        return schedulerCondition.LOCK;
    }

    static /* synthetic */ Scheduler access$1(SchedulerCondition schedulerCondition) {
        return schedulerCondition.scheduler;
    }

    static /* synthetic */ Semaphore access$2(SchedulerCondition schedulerCondition) {
        return schedulerCondition.semaphore;
    }

    static /* synthetic */ ReferenceProcessor access$3(SchedulerCondition schedulerCondition) {
        return schedulerCondition.processor;
    }

    static /* synthetic */ AtomicBoolean access$4(SchedulerCondition schedulerCondition) {
        return schedulerCondition.ready;
    }

    public class WaitForConditionJob
    extends Job
    implements IRunnableJob {
        private final Object sync;
        private IStatus lastStatus;
        private volatile boolean started;
        private volatile boolean finished;

        public WaitForConditionJob(SearchScope scope) {
            super(NLS.bind((String)Messages.waitingUntilThePathsXareIndexed_job0, (Object)scope.toString()));
            this.sync = new Object();
            this.lastStatus = Status.OK_STATUS;
            this.setProperty(InternalReferenceManager.ICON, Activator.getDefault().getBundle().getEntry("/icons/obj16/link_index_wait.gif"));
            this.setPriority(10);
        }

        @Override
        public boolean isStarted() {
            return this.started;
        }

        @Override
        public boolean isFinished() {
            return this.finished;
        }

        /*
         * Exception decompiling
         */
        @Override
        public IStatus run(IProgressMonitor monitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.IndexOutOfBoundsException: Index 0 out of bounds for length 0
             *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
             *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
             *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
             *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
             *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.TryRewriter.combineTryCatchEnds(TryRewriter.java:205)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.TryRewriter.combineTryCatchEnds(TryRewriter.java:154)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.combineTryCatchEnds(Op03Rewriters.java:52)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:558)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public boolean belongsTo(Object family) {
            return family == ReferenceManager.class;
        }

        public IStatus getLastExecutionStatus() {
            return this.lastStatus;
        }

        @Override
        public Object getSync() {
            return this.sync;
        }
    }

    public static class WaitForConditionRule
    implements ISchedulingRule {
        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }
    }
}

