/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.management;

import com.ibm.etools.references.internal.management.DependencyUtil;
import com.ibm.etools.references.internal.management.ItemToIndex;
import com.ibm.etools.references.internal.services.LinkTransformerService;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IPath;

public class ScheduleSorter
implements Comparator<ItemToIndex> {
    private final List<IPath> priorityList;
    private final LinkTransformerService.TransformerCache transformerCache = LinkTransformerService.getInstance().newCache();

    public ScheduleSorter(List<IPath> priorityList) {
        this.priorityList = priorityList;
    }

    public List<String> getPriorityList() {
        ArrayList<String> list = new ArrayList<String>(this.priorityList.size());
        for (IPath path : this.priorityList) {
            list.add(path.toString());
        }
        return list;
    }

    @Override
    public int compare(ItemToIndex item1, ItemToIndex item2) {
        IPath r2;
        HashSet<IPath> c1paths = null;
        HashSet<IPath> c2paths = null;
        if (item1.condition != null) {
            c1paths = item1.condition.paths;
        }
        if (item2.condition != null) {
            c2paths = item2.condition.paths;
        }
        if (item1.affectedLink == null && item2.affectedLink != null) {
            return 1;
        }
        if (item1.affectedLink != null && item2.affectedLink == null) {
            return -1;
        }
        if (item1.affectedLink != null && item2.affectedLink != null) {
            return 0;
        }
        IPath r1 = c1paths == null ? item1.change.getResource().getFullPath() : null;
        IPath iPath = r2 = c2paths == null ? item2.change.getResource().getFullPath() : null;
        if (c1paths != null && c2paths != null) {
            int c1index = -1;
            for (IPath path : c1paths) {
                c1index = Math.max(c1index, this.indexOf(path));
            }
            int c2index = -1;
            for (IPath path : c2paths) {
                c2index = Math.max(c2index, this.indexOf(path));
            }
            return c1index - c2index;
        }
        if (c1paths != null || c2paths != null) {
            HashSet<IPath> cPaths = c1paths == null ? c2paths : c1paths;
            int pathIndex = r1 == null ? this.indexOf(r2) : this.indexOf(r1);
            int condIndex = -1;
            for (IPath path : cPaths) {
                condIndex = Math.max(condIndex, this.indexOf(path));
            }
            if (pathIndex == condIndex) {
                ++condIndex;
            }
            if (pathIndex == -1 && condIndex != -1) {
                return c1paths == null ? 1 : -1;
            }
            int result = pathIndex - (c1paths == null ? condIndex : -condIndex);
            return result;
        }
        int i1 = this.indexOf(r1);
        int i2 = this.indexOf(r2);
        if (i1 == -1 && i2 != -1) {
            return 1;
        }
        if (i1 != -1 && i2 == -1) {
            return -1;
        }
        int val = i1 - i2;
        if (val == 0) {
            int dep2;
            int dep1;
            if (item1.cachedDependencies > -1) {
                dep1 = item1.cachedDependencies;
            } else {
                item1.cachedDependencies = dep1 = DependencyUtil.getDepedentLinks(item1, this.transformerCache);
            }
            if (item2.cachedDependencies > -1) {
                dep2 = item2.cachedDependencies;
            } else {
                item2.cachedDependencies = dep2 = DependencyUtil.getDepedentLinks(item2, this.transformerCache);
            }
            val = dep2 - dep1;
        }
        if (val == 0) {
            val = r1.toString().compareTo(r2.toString());
        }
        return val;
    }

    private int indexOf(IPath resource) {
        IPath child = resource;
        int index = -1;
        while (index < 0 && child.segments().length > 0) {
            index = this.priorityList.indexOf(child);
            child = child.removeLastSegments(1);
        }
        return index;
    }
}

