/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.management;

import com.ibm.etools.references.Logger;
import com.ibm.etools.references.events.ReferenceEvent;
import com.ibm.etools.references.internal.bplustree.db.DBRecord;
import com.ibm.etools.references.internal.bplustree.db.PooledByteBuffer;
import com.ibm.etools.references.internal.bplustree.tree.ByteUtils;
import com.ibm.etools.references.internal.management.InternalReferenceManager;
import com.ibm.etools.references.internal.management.ItemToIndex;
import com.ibm.etools.references.internal.management.Link;
import com.ibm.etools.references.management.ResourceChange;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class SavedLinkNodes
extends DBRecord {
    private Queue<ItemToIndex> inputReferences;
    private List<ItemToIndex> outputReferences;

    public SavedLinkNodes(int dataType, InternalReferenceManager manager) {
        super(dataType);
    }

    @Override
    public void readRecord(PooledByteBuffer bytes) {
        this.outputReferences = new ArrayList<ItemToIndex>();
        int numRecords = ByteUtils.bytesToUnsignedShort(bytes.buffer);
        int i = 0;
        while (i < numRecords) {
            ItemToIndex info = new ItemToIndex();
            boolean addedModelDeps = ByteUtils.bytesToBoolean(bytes.buffer);
            int resourceType = ByteUtils.bytesToUnsignedShort(bytes.buffer);
            int changeType = ByteUtils.bytesToUnsignedShort(bytes.buffer);
            String pathName = ByteUtils.bytesToString(bytes.buffer);
            String combined = ByteUtils.bytesToString(bytes.buffer);
            info.ignoreContainedLinks = ByteUtils.bytesToBoolean(bytes.buffer);
            int type = ByteUtils.bytesToInt(bytes.buffer);
            if (type > -1) {
                info.linkType = ReferenceEvent.Kind.values()[type];
            }
            info.modelinstanceref = ByteUtils.bytesToString(bytes.buffer);
            boolean hasAffectedLink = ByteUtils.bytesToBoolean(bytes.buffer);
            if (hasAffectedLink) {
                Link l = new Link();
                l.getRecord().doReadRecord(new PooledByteBuffer(bytes.buffer));
                info.affectedLink = l;
            }
            if (combined == null) {
                Logger.logWarning(Logger.Category.DEBUG, Logger.Mode.DEV_MANDATORY, "No saved model ids found for saved link node with path " + pathName);
            }
            HashSet<String> modelIds = combined == null ? new HashSet<String>(1) : new HashSet<String>(Arrays.asList(combined.split(",")));
            info.addedModelDeps = addedModelDeps;
            info.modelIds = modelIds;
            IFile file = null;
            if (resourceType == 1) {
                file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(pathName));
            } else if (resourceType == 2) {
                file = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(pathName));
            } else if (resourceType == 4) {
                file = ResourcesPlugin.getWorkspace().getRoot().getProject(pathName);
            } else if (resourceType != -1) {
                Assert.isLegal((boolean)false, (String)"Unknown resource type");
            }
            if (file != null) {
                info.change = new ResourceChange((IResource)file, changeType);
            }
            this.outputReferences.add(info);
            bytes.returnBuffer();
            ++i;
        }
    }

    @Override
    public PooledByteBuffer writeRecord() {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        if (this.inputReferences == null) {
            this.inputReferences = new LinkedList<ItemToIndex>();
        }
        int numLinkNodes = this.inputReferences.size();
        buffers.add(ByteUtils.unsignedShortToBytes(numLinkNodes));
        for (ItemToIndex info : this.inputReferences) {
            if (info.condition != null) continue;
            boolean addedDeps = info.addedModelDeps;
            boolean hasAffectedLink = info.affectedLink != null;
            IResource resource = info.change == null ? null : info.change.getResource();
            String path = resource == null ? null : resource.getFullPath().toPortableString();
            int resourceType = resource == null ? -1 : resource.getType();
            int changeType = info.change == null ? -1 : info.change.getType();
            Set<String> modelIds = info.modelIds;
            String combined = "";
            if (modelIds != null) {
                Iterator<String> mItr = modelIds.iterator();
                while (mItr.hasNext()) {
                    String id = mItr.next();
                    combined = String.valueOf(combined) + id;
                    if (!mItr.hasNext()) continue;
                    combined = String.valueOf(combined) + ",";
                }
            }
            buffers.add(ByteUtils.booleanToBytes(addedDeps));
            buffers.add(ByteUtils.unsignedShortToBytes(resourceType));
            buffers.add(ByteUtils.unsignedShortToBytes(changeType));
            buffers.add(ByteUtils.stringToBytes(path));
            buffers.add(ByteUtils.stringToBytes(combined));
            buffers.add(ByteUtils.booleanToBytes(info.ignoreContainedLinks));
            if (info.linkType == null) {
                buffers.add(ByteUtils.intToBytes(-1));
            } else {
                buffers.add(ByteUtils.intToBytes(info.linkType.ordinal()));
            }
            buffers.add(ByteUtils.stringToBytes(info.modelinstanceref));
            buffers.add(ByteUtils.booleanToBytes(hasAffectedLink));
            if (!hasAffectedLink) continue;
            buffers.add(((Link)info.affectedLink).getRecord().writeRecord().buffer);
        }
        int size = 0;
        for (ByteBuffer byteBuffer : buffers) {
            size += byteBuffer.limit();
        }
        PooledByteBuffer result = PooledByteBuffer.INSTANCE.leaseByteBuffer(size);
        for (ByteBuffer byteBuffer : buffers) {
            result.buffer.put(byteBuffer);
        }
        result.buffer.rewind();
        return result;
    }

    public void setLinkNodeInfos(Queue<ItemToIndex> references) {
        this.inputReferences = references;
    }

    public List<ItemToIndex> getSavedLinkNodes() {
        if (this.outputReferences == null) {
            return Collections.emptyList();
        }
        return this.outputReferences;
    }
}

