/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.management;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.internal.bplustree.db.PooledByteBuffer;
import com.ibm.etools.references.internal.bplustree.tree.ByteUtils;
import com.ibm.etools.references.internal.index.IdentityLinkedSet;
import com.ibm.etools.references.internal.index.IndexManager;
import com.ibm.etools.references.internal.index.InternalReferenceObject;
import com.ibm.etools.references.internal.index.InternalReferenceRecord;
import com.ibm.etools.references.internal.index.ReferenceDatabase;
import com.ibm.etools.references.internal.index.keys.LinkKey;
import com.ibm.etools.references.internal.nls.Messages;
import com.ibm.etools.references.internal.util.Util;
import com.ibm.etools.references.management.BrokenStatus;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.services.providers.IProvider;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;

public final class ResolvedReference
extends InternalReferenceObject
implements IResolvedReference {
    private List<LinkKey> originalKeys = null;
    private final Object marker = new Object();
    private final Record record = new Record(this);
    private boolean nodeIdLink;
    private String modelInstanceId;
    private Reference tempReference;
    private IResolvedReference tempPrevious;
    private IResolvedReference tempNext;
    BrokenStatus broken;

    public ResolvedReference() {
        this.record.dirty = true;
    }

    @Override
    public Object getAdapter(Class adapter) {
        return this.getAdapterFor(adapter);
    }

    private <T> T getAdapterFor(Class<T> adapter) {
        IProvider p;
        if (adapter.isAssignableFrom(this.getClass())) {
            return adapter.cast(this);
        }
        if (IProvider.class.isAssignableFrom(adapter) && (p = InternalAPI.getProviderById(this.getProviderId())) != null) {
            try {
                return adapter.cast(p);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return adapter.cast(Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName()));
    }

    @Override
    public int getId() {
        return super.getId();
    }

    @Override
    public final IReferenceElement.ElementType getElementType() {
        return IReferenceElement.ElementType.RESOLVED_REFERENCE;
    }

    @Override
    public BrokenStatus getBrokenStatus() {
        this.loadData();
        return this.broken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBrokenLinkInfo(String brokenLinkInfo) {
        this.loadData();
        Object object = this.marker;
        synchronized (object) {
            if (!Util.isEqualOrBothNull(this.modelInstanceId, brokenLinkInfo)) {
                this.saveOriginal();
                this.modelInstanceId = brokenLinkInfo;
                this.record.dirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReference(Reference reference) {
        this.loadData();
        Object object = this.marker;
        synchronized (object) {
            if (!Util.isEqualOrBothNull(this.getReference(), reference)) {
                this.saveOriginal();
                if (reference == null) {
                    this.tempReference = null;
                    this.record.refId = -1;
                } else if (reference.getId() >= 0) {
                    this.record.refId = reference.getId();
                } else {
                    this.tempReference = reference;
                }
                this.record.dirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodeIdLinkTarget(boolean nodeIdLinkTarget) {
        this.loadData();
        Object object = this.marker;
        synchronized (object) {
            if (this.nodeIdLink != nodeIdLinkTarget) {
                this.nodeIdLink = nodeIdLinkTarget;
                this.record.dirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setNext(IResolvedReference next) {
        this.loadData();
        Object object = this.marker;
        synchronized (object) {
            if (!Util.isEqualOrBothNull(this.getNext(), next)) {
                if (next == null) {
                    this.record.nextId = -1;
                    this.tempNext = null;
                } else if (next.getId() >= 0) {
                    this.record.nextId = next.getId();
                } else {
                    this.tempNext = next;
                }
                this.record.dirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBrokenStatus(BrokenStatus broken) {
        this.loadData();
        Object object = this.marker;
        synchronized (object) {
            if (this.getBrokenStatus() != broken) {
                this.saveOriginal();
                this.broken = broken;
                this.record.dirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IResolvedReference getNext() {
        this.loadData();
        Object object = this.marker;
        synchronized (object) {
            if (this.tempNext != null) {
                return this.tempNext;
            }
        }
        if (this.record.nextId >= 0) {
            return ReferenceDatabase.getDefault().getReferenceElement(this.record.nextId, IResolvedReference.class);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrevious(IResolvedReference previous) {
        this.loadData();
        Object object = this.marker;
        synchronized (object) {
            if (!Util.isEqualOrBothNull(this.getPrevious(), previous)) {
                if (previous == null) {
                    this.record.prevId = -1;
                    this.tempPrevious = null;
                } else if (previous.getId() >= 0) {
                    this.record.prevId = previous.getId();
                } else {
                    this.tempPrevious = previous;
                }
                this.record.dirty = true;
                if (previous != null) {
                    ((ResolvedReference)previous).setNext(this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IResolvedReference getPrevious() {
        this.loadData();
        Object object = this.marker;
        synchronized (object) {
            if (this.tempPrevious != null) {
                return this.tempPrevious;
            }
        }
        if (this.record.prevId >= 0) {
            return ReferenceDatabase.getDefault().getReferenceElement(this.record.prevId, IResolvedReference.class);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTarget(ILink target) {
        this.loadData();
        Object object = this.marker;
        synchronized (object) {
            if (target != null) {
                Assert.isLegal((target.getId() >= 0 ? 1 : 0) != 0, (String)Messages.ResolvedReference_1);
            }
            if (!Util.isEqualOrBothNull(this.getTarget(), target)) {
                this.saveOriginal();
                if (target == null) {
                    this.record.targetId = -1;
                } else {
                    this.record.targetId = target.getId();
                }
                this.record.dirty = true;
            }
        }
    }

    @Override
    public ILink getTarget() {
        this.loadData();
        if (this.record.targetId != -1 && this.record.targetId != -99) {
            return ReferenceDatabase.getDefault().getReferenceElement(this.record.targetId, ILink.class);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reference getReference() {
        this.loadData();
        Object object = this.marker;
        synchronized (object) {
            if (this.tempReference != null) {
                Assert.isTrue((boolean)this.record.dirty, (String)Messages.ResolvedReference_2);
                return this.tempReference;
            }
        }
        if (this.record.refId >= 0) {
            return ReferenceDatabase.getDefault().getReferenceElement(this.record.refId, Reference.class);
        }
        return null;
    }

    @Override
    public int getReferenceId() {
        return this.record.refId;
    }

    @Override
    protected void assignedId(int id) {
        if (this.tempReference != null) {
            Assert.isTrue((boolean)this.record.isDirty(), (String)Messages.ResolvedReference_3);
            Assert.isTrue((this.tempReference.getId() != -1 ? 1 : 0) != 0, (String)Messages.ResolvedReference_4);
            this.record.refId = this.tempReference.getId();
        }
    }

    @Override
    public TextRange getFragmentLocation() {
        Reference r = this.getReference();
        if (r == null) {
            return null;
        }
        return r.getFragmentLocation();
    }

    @Override
    public TextRange getAbsoluteFragmentLocation() {
        Reference r = this.getReference();
        if (r == null) {
            return null;
        }
        return r.getAbsoluteFragmentLocation();
    }

    @Override
    public String getFragmentText() {
        Reference r = this.getReference();
        if (r == null) {
            return null;
        }
        return r.getFragmentText();
    }

    @Override
    public InternalReferenceRecord getRecord() {
        return this.record;
    }

    @Override
    public ILink getSource() {
        Reference r = this.getReference();
        if (r == null) {
            return null;
        }
        return r.getSource();
    }

    @Override
    public String getReferenceType() {
        Reference r = this.getReference();
        if (r == null) {
            return null;
        }
        return r.getReferenceType();
    }

    @Override
    public String toString() {
        if (InternalAPI.LOAD_DATA_FOR_TO_STRING) {
            this.loadData();
        }
        if (this.record.isFullyLoaded()) {
            String toString = "";
            toString = String.valueOf(toString) + this.getElementType().name();
            toString = String.valueOf(toString) + " ";
            toString = String.valueOf(toString) + super.toString();
            toString = String.valueOf(toString) + " REF (ID: ";
            toString = String.valueOf(toString) + "NR[ " + this.record.refId + "] ";
            toString = String.valueOf(toString) + ")  TARGET: [";
            toString = String.valueOf(toString) + "NR[ " + this.record.targetId + "] ";
            toString = String.valueOf(toString) + " isBroken: ";
            toString = String.valueOf(toString) + "NR[ " + (Object)((Object)this.broken) + "] ";
            toString = String.valueOf(toString) + " next: ";
            toString = String.valueOf(toString) + "NR[ " + this.record.nextId + "] ";
            toString = String.valueOf(toString) + " prev: ";
            toString = String.valueOf(toString) + "NR[ " + this.record.prevId + "] ";
            toString = String.valueOf(toString) + " isNodeIdLinkTarget [" + this.isNodeIdLinkTarget() + "]";
            toString = String.valueOf(toString) + " brokenLinkInfo: ";
            toString = String.valueOf(toString) + "NR[ " + this.modelInstanceId + "] ";
            return toString;
        }
        String toString = "";
        toString = String.valueOf(toString) + this.getElementType().name();
        toString = String.valueOf(toString) + "Proxy object: ";
        toString = String.valueOf(toString) + super.toString();
        return toString;
    }

    public void copyFrom(ResolvedReference ref) {
        this.setBrokenStatus(ref.broken);
        this.setReference(ref.getReference());
        this.setTarget(ref.getTarget());
        this.setBrokenLinkInfo(ref.modelInstanceId);
    }

    @Override
    public String getModelInstanceIdReference() {
        this.loadData();
        return this.modelInstanceId;
    }

    private synchronized void saveOriginal() {
        this.loadData();
        if (this.frozen && this.originalKeys == null) {
            this.originalKeys = IndexManager.getKeys(this);
        }
    }

    @Override
    public void getObjectGraph(IdentityLinkedSet<InternalReferenceObject> graph, Map<Object, Object> objMarkers) {
        IResolvedReference next;
        Reference reference;
        this.loadData();
        if (graph.contains(this)) {
            return;
        }
        if (objMarkers.containsKey(this.marker)) {
            return;
        }
        objMarkers.put(this.marker, this.marker);
        ILink target = this.getTarget();
        if (target != null) {
            ((InternalReferenceObject)((Object)target)).getObjectGraph(graph, objMarkers);
            graph.add((InternalReferenceObject)((Object)target));
        }
        if ((reference = this.getReference()) != null) {
            ((InternalReferenceObject)reference).getObjectGraph(graph, objMarkers);
        }
        graph.add(reference);
        IResolvedReference previous = this.getPrevious();
        if (previous != null) {
            ((InternalReferenceObject)((Object)previous)).getObjectGraph(graph, objMarkers);
        }
        if ((next = this.getNext()) != null) {
            ((InternalReferenceObject)((Object)next)).getObjectGraph(graph, objMarkers);
        }
        graph.add(this);
    }

    @Override
    protected synchronized List<LinkKey> getOriginalKeys() {
        return this.originalKeys;
    }

    @Override
    protected synchronized void clearOriginalKeys() {
        this.originalKeys = null;
    }

    public boolean isNodeIdLinkTarget() {
        this.loadData();
        return this.nodeIdLink;
    }

    static class Record
    extends InternalReferenceRecord {
        private final ResolvedReference resolved;
        boolean dirty;
        private int targetId = -1;
        private int refId = -1;
        private int prevId = -1;
        private int nextId = -1;

        public Record(ResolvedReference resolved) {
            super(IReferenceElement.ElementType.RESOLVED_REFERENCE.ordinal());
            this.resolved = resolved;
        }

        @Override
        protected void clean() {
            this.dirty = false;
        }

        @Override
        public boolean isDirty() {
            return this.dirty;
        }

        @Override
        public void doReadRecord(PooledByteBuffer bytes) {
            this.targetId = ByteUtils.bytesToInt(bytes.buffer);
            this.refId = ByteUtils.bytesToInt(bytes.buffer);
            this.resolved.broken = BrokenStatus.values()[ByteUtils.bytesToUnsignedShort(bytes.buffer)];
            this.prevId = ByteUtils.bytesToInt(bytes.buffer);
            this.nextId = ByteUtils.bytesToInt(bytes.buffer);
            this.resolved.modelInstanceId = ByteUtils.bytesToString(bytes.buffer);
            this.resolved.providerId = ByteUtils.bytesToUnsignedShort(bytes.buffer);
            this.resolved.nodeIdLink = ByteUtils.bytesToBoolean(bytes.buffer);
            bytes.returnBuffer();
            this.clean();
            this.resolved.freeze();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PooledByteBuffer doWriteRecord() {
            ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
            Object object = this.resolved.marker;
            synchronized (object) {
                buffers.add(ByteUtils.intToBytes(this.targetId));
                if (this.resolved.tempReference != null) {
                    this.refId = this.resolved.tempReference.getId();
                    this.resolved.tempReference = null;
                }
                buffers.add(ByteUtils.intToBytes(this.refId));
                buffers.add(ByteUtils.unsignedShortToBytes(this.resolved.broken.ordinal()));
                if (this.resolved.tempPrevious != null) {
                    this.prevId = this.resolved.tempPrevious.getId();
                    this.resolved.tempPrevious = null;
                }
                buffers.add(ByteUtils.intToBytes(this.prevId));
                if (this.resolved.tempNext != null) {
                    this.nextId = this.resolved.tempNext.getId();
                    this.resolved.tempNext = null;
                }
                if (this.resolved.tempPrevious != null || this.resolved.tempNext != null) {
                    Assert.isTrue((boolean)false, (String)Messages.ResolvedReference_0);
                }
            }
            buffers.add(ByteUtils.intToBytes(this.nextId));
            buffers.add(ByteUtils.stringToBytes(this.resolved.modelInstanceId));
            buffers.add(ByteUtils.unsignedShortToBytes(this.resolved.providerId));
            buffers.add(ByteUtils.booleanToBytes(this.resolved.nodeIdLink));
            int size = 0;
            for (ByteBuffer byteBuffer : buffers) {
                size += byteBuffer.limit();
            }
            PooledByteBuffer buffer = PooledByteBuffer.INSTANCE.leaseByteBuffer(size);
            for (ByteBuffer byteBuffer : buffers) {
                buffer.buffer.put(byteBuffer);
            }
            buffer.buffer.rewind();
            return buffer;
        }

        @Override
        public int getSize() {
            int size = 18 + ByteUtils.storageSize(this.resolved.modelInstanceId);
            return size;
        }

        @Override
        protected InternalReferenceObject getLinkArtifact() {
            return this.resolved;
        }

        @Override
        protected Collection<? extends IReferenceElement> getDeleteCascade() {
            IResolvedReference next = this.resolved.getNext();
            if (next == null) {
                return Collections.emptyList();
            }
            return Collections.singleton(next);
        }
    }
}

