/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.management;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.Logger;
import com.ibm.etools.references.events.ErrorEvent;
import com.ibm.etools.references.events.ReferenceEvent;
import com.ibm.etools.references.internal.Activator;
import com.ibm.etools.references.internal.CountUpDownLatch;
import com.ibm.etools.references.internal.ProfilerProxy;
import com.ibm.etools.references.internal.ThreadPriorityPolicy;
import com.ibm.etools.references.internal.bplustree.db.FatalIOException;
import com.ibm.etools.references.internal.index.EventCollector;
import com.ibm.etools.references.internal.index.IndexConstants;
import com.ibm.etools.references.internal.index.IndexManager;
import com.ibm.etools.references.internal.index.ReferenceDatabase;
import com.ibm.etools.references.internal.management.AddToIndexJob;
import com.ibm.etools.references.internal.management.CreateOrUpdateMarkersJob;
import com.ibm.etools.references.internal.management.ErrorRecovery;
import com.ibm.etools.references.internal.management.EventNotification;
import com.ibm.etools.references.internal.management.InternalReference;
import com.ibm.etools.references.internal.management.InternalReferenceManager;
import com.ibm.etools.references.internal.management.ItemToIndex;
import com.ibm.etools.references.internal.management.Link;
import com.ibm.etools.references.internal.management.ResolvedReference;
import com.ibm.etools.references.internal.management.ResolverCache;
import com.ibm.etools.references.internal.management.Scheduler;
import com.ibm.etools.references.internal.management.SchedulerCondition;
import com.ibm.etools.references.internal.nls.Messages;
import com.ibm.etools.references.internal.search.InternalSearchEngine;
import com.ibm.etools.references.internal.search.InternalSearchPattern;
import com.ibm.etools.references.internal.services.Dependency;
import com.ibm.etools.references.internal.services.LinkDetectorService;
import com.ibm.etools.references.internal.services.LinkNodeModelService;
import com.ibm.etools.references.internal.services.LinkTransformerService;
import com.ibm.etools.references.internal.services.ReferenceGeneratorService;
import com.ibm.etools.references.internal.services.ReferenceResolverService;
import com.ibm.etools.references.internal.util.Util;
import com.ibm.etools.references.management.BrokenStatus;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.LinkPositionInfo;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.management.ResourceChange;
import com.ibm.etools.references.management.SpecializedType;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.search.DefaultSearchRequestor;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.search.SearchPattern;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.references.services.providers.ProviderArguments;
import com.ibm.etools.references.services.providers.SharedModel;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class ReferenceProcessor
extends Job {
    private static final int CREATE_MARKER_MULTIPLE = 4;
    private final LinkTransformerService TRANSFORMER = LinkTransformerService.getInstance();
    private final ReferenceGeneratorService GENERATOR = ReferenceGeneratorService.getInstance();
    private final ReferenceResolverService RESOLVER = ReferenceResolverService.getInstance();
    private final ReferenceDatabase DATABASE = ReferenceDatabase.getDefault();
    private final LinkDetectorService LINKDETECTOR = LinkDetectorService.getInstance();
    private final LinkNodeModelService MODELSERVICE = LinkNodeModelService.getInstance();
    private final InternalSearchEngine SEARCHER = new InternalSearchEngine(true);
    private final CreateOrUpdateMarkersJob markersJob;
    private volatile boolean shutdown = false;
    final AtomicBoolean ensureUpToDate = new AtomicBoolean(false);
    private final EventNotification eventsJob = new EventNotification();
    final InternalReferenceManager referenceManager;
    private final FutureTask<Scheduler> scheduler;
    private final AtomicBoolean executingNow = new AtomicBoolean(false);
    private String currentLabel = "";
    private final Pattern whiteSpacePattern = Pattern.compile("\\s");
    private ResolverCache resolverCache;
    private volatile Thread nowThread;
    private String lastTaskName;
    private final CountUpDownLatch activeLatch;

    public ReferenceProcessor(InternalReferenceManager manager) {
        super(Messages.errorMsg_reference_processor_update_link_database_job);
        this.referenceManager = manager;
        this.scheduler = new FutureTask<Scheduler>(new CreateScheduler());
        this.setSystem(true);
        this.setPriority(10);
        this.markersJob = new CreateOrUpdateMarkersJob(this);
        manager.addReferenceListener(this.markersJob);
        this.activeLatch = new CountUpDownLatch(0);
    }

    public Scheduler getScheduler() {
        this.scheduler.run();
        boolean interrupted = Thread.interrupted();
        while (true) {
            try {
                Scheduler scheduler = this.scheduler.get();
                return scheduler;
            }
            catch (InterruptedException interruptedException) {
                interrupted = true;
                continue;
            }
            catch (ExecutionException e) {
                Throwable t = e.getCause() == null ? e : e.getCause();
                throw new RuntimeException(t);
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public EventNotification getEventNotification() {
        return this.eventsJob;
    }

    public void doSchedule(boolean userJob) {
        if (Job.getJobManager().isSuspended()) {
            if (this.shouldRun()) {
                this.runNow((IProgressMonitor)new NullProgressMonitor());
            }
        } else if (!this.executingNow.get()) {
            boolean overrideUserJob = userJob;
            if (!Activator.getDefault().getStartupJob().isFinished() && Activator.getDefault().getStartupJob().isUserInitiated()) {
                overrideUserJob = true;
            }
            try {
                if (overrideUserJob) {
                    this.setUser(true);
                    this.setSystem(false);
                } else {
                    this.setUser(false);
                    this.setSystem(true);
                }
            }
            catch (RuntimeException runtimeException) {}
            this.schedule(0L);
        }
    }

    public boolean shouldSchedule() {
        boolean should = this.shouldRun();
        return should;
    }

    private String getContext(ItemToIndex indexItem) {
        if (indexItem.condition != null) {
            return indexItem.condition.toString();
        }
        ResourceChange change = indexItem.change;
        ILink affectedLink = indexItem.affectedLink;
        String context = change != null ? change.getResource().getFullPath().toString() : affectedLink.toString();
        return context;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            if (this.executingNow.compareAndSet(false, true)) {
                IStatus iStatus = this.indexLoop(monitor);
                return iStatus;
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            this.executingNow.set(false);
        }
    }

    private String updateMonitorText(IProgressMonitor sub, ItemToIndex indexItem, LinkNode<? extends IResource> node, int originalPriority) {
        String subTaskName;
        int p;
        String taskName = Messages.errorMsg_reference_processor_processing;
        if (this.isUser()) {
            taskName = Messages.errorMsg_reference_processor_processing;
        }
        int n = p = this.getThread() == null ? originalPriority : this.getThread().getPriority();
        taskName = p < 5 ? Messages.errorMsg_reference_processor_processing_in_background : (p == 5 ? Messages.errorMsg_reference_processor_processing : Messages.errorMsg_reference_processor_processing_high_priority);
        this.lastTaskName = taskName;
        sub.setTaskName(this.lastTaskName);
        if (node != null) {
            String nls;
            int remaining = this.getScheduler().getSize();
            String subTask = Messages.errorMsg_reference_processor_Xfilestoindex_Y;
            this.currentLabel = node.getResource().getFullPath().toString();
            subTaskName = nls = NLS.bind((String)subTask, (Object[])new Object[]{remaining, this.currentLabel});
        } else {
            String name = null;
            if (indexItem.condition != null) {
                name = NLS.bind((String)Messages.NotifyWaitingThreadsOn, (Object)indexItem.condition.getScope());
            } else {
                name = indexItem.affectedLink.getLinkText();
                if (name == null) {
                    name = indexItem.affectedLink.getName();
                }
            }
            if (name == null) {
                name = "";
            }
            this.currentLabel = name;
            subTaskName = Messages.errorMsg_reference_processor_updatinglink;
        }
        sub.subTask(subTaskName);
        return subTaskName;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IStatus indexLoop(IProgressMonitor monitor) {
        this.activeLatch.countUp();
        if (Logger.SHOULD_TRACE_JOB_STATE_CHANGES) {
            Logger.trace(Logger.Category.JOB_STATE_CHANGES, "ReferenceProcessor started", new Throwable[0]);
        }
        this.initLoop();
        hasUnrecoverableError = false;
        result = Status.OK_STATUS;
        originalPriority = Thread.currentThread().getPriority();
        periodic = start = System.nanoTime();
        count = 1;
        runningNotificationTab = 0;
        totalProcessingRun = this.getScheduler().getSize();
        markerCreateThreshold = totalProcessingRun / 4;
        tCache = this.TRANSFORMER.newCache();
        this.resolverCache = rCache = new ResolverCache();
        sub = SubMonitor.convert((IProgressMonitor)monitor);
        try {
            SearchEngine.setSearchHint(EnumSet.of(SearchEngine.SearchHint.NOWAIT));
            indexItem = this.getScheduler().getNextItem();
            if (true) ** GOTO lbl62
        }
        catch (Throwable var22_36) {
            this.markersJob.doSchedule();
            this.currentLabel = "";
            this.DATABASE.convertIndexes(-1, false);
            SearchEngine.clearSearchHint(EnumSet.of(SearchEngine.SearchHint.NOWAIT));
            end = System.nanoTime();
            if (Logger.SHOULD_TRACE_TIMING) {
                lengthN = end - start;
                lengthM = TimeUnit.MILLISECONDS.convert(lengthN, TimeUnit.NANOSECONDS);
                Logger.trace(Logger.Category.TIMING, "Done with this batch of " + (count - 1) + " in " + (float)lengthM / 1000.0f + "s AVG speed " + (float)count / ((float)lengthM / 1000.0f) + " files/sec", new Throwable[0]);
            }
            if (Logger.SHOULD_TRACE_CACHE_STATS) {
                bytes = new ByteArrayOutputStream();
                stream = new PrintStream(bytes);
                this.DATABASE.printCacheStats(stream);
                this.printResolverStats(stream);
                IndexManager.printIndexCacheStats(stream);
                Logger.trace(Logger.Category.CACHE_STATS, bytes.toString(), new Throwable[]{null});
            }
            this.ensureUpToDate.set(false);
            this.markersJob.cancel();
            this.markersJob.schedule();
            if (InternalAPI.Tweaks.SHOULD_FLUSH_CACHE_AFTER_INDEX) {
                InternalAPI.drainCaches(false);
            }
            rCache = null;
            if (Logger.SHOULD_TRACE_JOB_STATE_CHANGES) {
                Logger.trace(Logger.Category.JOB_STATE_CHANGES, "ReferenceProcessor ended", new Throwable[0]);
            }
            throw var22_36;
        }
        {
            block10: while (true) {
                if (Logger.PERF_INDEXFILE_ENABLED) {
                    if (stats != null) {
                        stats.endRun();
                    }
                    if (indexItem.change != null) {
                        ProfilerProxy.captureSnapshot();
                        ProfilerProxy.stop();
                    }
                }
                this.getScheduler().clearActive();
                periodic = this.logTiming(start, periodic, count);
                runningNotificationTab = this.scheduleMarkersJob(runningNotificationTab, markerCreateThreshold);
                if (indexItem.lastInProject) {
                    this.getMarkerJob().releasePendingMarkersForProject(indexItem.change.getResource().getProject());
                }
                this.referenceManager.doRateLimit(this.getActiveThread().getPriority());
                while (true) {
                    block50: {
                        block51: {
                            block48: {
                                block49: {
                                    block46: {
                                        block47: {
                                            indexItem = this.getScheduler().getNextItem();
lbl62:
                                            // 2 sources

                                            if (indexItem == null) break block10;
                                            stats = null;
                                            try {
                                                totalProcessingRun = Math.max(totalProcessingRun, this.getScheduler().getSize() + 1);
                                                markerCreateThreshold = totalProcessingRun / 4;
                                                if (Logger.PERF_INDEXFILE_ENABLED) {
                                                    stats = PerformanceStats.getStats((String)"com.ibm.etools.references/perf/indexFile", (Object)this);
                                                    stats.startRun(this.getContext(indexItem));
                                                    if (indexItem.change != null) {
                                                        ProfilerProxy.startProfiling(indexItem.change.getResource().getFullPath().toString());
                                                    }
                                                }
                                                if (this.shutdown || this.referenceManager.hasFatalError()) {
                                                    if (!Logger.PERF_INDEXFILE_ENABLED) break block46;
                                                    if (stats == null) break block47;
                                                }
                                                ** GOTO lbl-1000
                                            }
                                            catch (RuntimeException e) {
                                                this.handleUnrecoverableException(indexItem, e);
                                                hasUnrecoverableError = true;
                                                if (Logger.PERF_INDEXFILE_ENABLED) {
                                                    if (stats != null) {
                                                        stats.endRun();
                                                    }
                                                    if (indexItem.change != null) {
                                                        ProfilerProxy.captureSnapshot();
                                                        ProfilerProxy.stop();
                                                    }
                                                }
                                                this.getScheduler().clearActive();
                                                periodic = this.logTiming(start, periodic, count);
                                                runningNotificationTab = this.scheduleMarkersJob(runningNotificationTab, markerCreateThreshold);
                                                if (indexItem.lastInProject) {
                                                    this.getMarkerJob().releasePendingMarkersForProject(indexItem.change.getResource().getProject());
                                                }
                                                this.referenceManager.doRateLimit(this.getActiveThread().getPriority());
                                                break block10;
                                            }
                                            catch (Throwable var20_35) {
                                                if (Logger.PERF_INDEXFILE_ENABLED) {
                                                    if (stats != null) {
                                                        stats.endRun();
                                                    }
                                                    if (indexItem.change != null) {
                                                        ProfilerProxy.captureSnapshot();
                                                        ProfilerProxy.stop();
                                                    }
                                                }
                                                this.getScheduler().clearActive();
                                                periodic = this.logTiming(start, periodic, count);
                                                runningNotificationTab = this.scheduleMarkersJob(runningNotificationTab, markerCreateThreshold);
                                                if (indexItem.lastInProject) {
                                                    this.getMarkerJob().releasePendingMarkersForProject(indexItem.change.getResource().getProject());
                                                }
                                                this.referenceManager.doRateLimit(this.getActiveThread().getPriority());
                                                throw var20_35;
                                            }
                                            stats.endRun();
                                        }
                                        if (indexItem.change != null) {
                                            ProfilerProxy.captureSnapshot();
                                            ProfilerProxy.stop();
                                        }
                                    }
                                    this.getScheduler().clearActive();
                                    periodic = this.logTiming(start, periodic, count);
                                    runningNotificationTab = this.scheduleMarkersJob(runningNotificationTab, markerCreateThreshold);
                                    if (indexItem.lastInProject) {
                                        this.getMarkerJob().releasePendingMarkersForProject(indexItem.change.getResource().getProject());
                                    }
                                    this.referenceManager.doRateLimit(this.getActiveThread().getPriority());
                                    break block10;
lbl-1000:
                                    // 1 sources

                                    {
                                        if (!sub.isCanceled() || (listener = this.referenceManager.getListener()) == null || (canceledResult = listener.canceled()) == null) ** GOTO lbl-1000
                                        var21_19 = result = canceledResult;
                                        if (!Logger.PERF_INDEXFILE_ENABLED) break block48;
                                        if (stats == null) break block49;
                                    }
                                    stats.endRun();
                                }
                                if (indexItem.change != null) {
                                    ProfilerProxy.captureSnapshot();
                                    ProfilerProxy.stop();
                                }
                            }
                            this.getScheduler().clearActive();
                            periodic = this.logTiming(start, periodic, count);
                            runningNotificationTab = this.scheduleMarkersJob(runningNotificationTab, markerCreateThreshold);
                            if (indexItem.lastInProject) {
                                this.getMarkerJob().releasePendingMarkersForProject(indexItem.change.getResource().getProject());
                            }
                            this.referenceManager.doRateLimit(this.getActiveThread().getPriority());
                            this.markersJob.doSchedule();
                            this.currentLabel = "";
                            this.DATABASE.convertIndexes(-1, false);
                            SearchEngine.clearSearchHint(EnumSet.of(SearchEngine.SearchHint.NOWAIT));
                            end = System.nanoTime();
                            if (Logger.SHOULD_TRACE_TIMING) {
                                lengthN = end - start;
                                lengthM = TimeUnit.MILLISECONDS.convert(lengthN, TimeUnit.NANOSECONDS);
                                Logger.trace(Logger.Category.TIMING, "Done with this batch of " + (count - 1) + " in " + (float)lengthM / 1000.0f + "s AVG speed " + (float)count / ((float)lengthM / 1000.0f) + " files/sec", new Throwable[0]);
                            }
                            if (Logger.SHOULD_TRACE_CACHE_STATS) {
                                bytes = new ByteArrayOutputStream();
                                stream = new PrintStream(bytes);
                                this.DATABASE.printCacheStats(stream);
                                this.printResolverStats(stream);
                                IndexManager.printIndexCacheStats(stream);
                                Logger.trace(Logger.Category.CACHE_STATS, bytes.toString(), new Throwable[]{null});
                            }
                            this.ensureUpToDate.set(false);
                            this.markersJob.cancel();
                            this.markersJob.schedule();
                            if (InternalAPI.Tweaks.SHOULD_FLUSH_CACHE_AFTER_INDEX) {
                                InternalAPI.drainCaches(false);
                            }
                            rCache = null;
                            if (Logger.SHOULD_TRACE_JOB_STATE_CHANGES) {
                                Logger.trace(Logger.Category.JOB_STATE_CHANGES, "ReferenceProcessor ended", new Throwable[0]);
                            }
                            return var21_19;
lbl-1000:
                            // 1 sources

                            {
                                if (indexItem.condition == null) break;
                                indexItem.condition.setReady();
                                ++count;
                                if (!Logger.PERF_INDEXFILE_ENABLED) break block50;
                                if (stats == null) break block51;
                            }
                            stats.endRun();
                        }
                        if (indexItem.change != null) {
                            ProfilerProxy.captureSnapshot();
                            ProfilerProxy.stop();
                        }
                    }
                    this.getScheduler().clearActive();
                    periodic = this.logTiming(start, periodic, count);
                    runningNotificationTab = this.scheduleMarkersJob(runningNotificationTab, markerCreateThreshold);
                    if (indexItem.lastInProject) {
                        this.getMarkerJob().releasePendingMarkersForProject(indexItem.change.getResource().getProject());
                    }
                    this.referenceManager.doRateLimit(this.getActiveThread().getPriority());
                }
                {
                    this.DATABASE.convertIndexes(totalProcessingRun, true);
                    this.indexItem(originalPriority, tCache, rCache, sub, indexItem);
                    ++count;
                    continue;
                }
                break;
            }
        }
        this.markersJob.doSchedule();
        this.currentLabel = "";
        this.DATABASE.convertIndexes(-1, false);
        SearchEngine.clearSearchHint(EnumSet.of(SearchEngine.SearchHint.NOWAIT));
        end = System.nanoTime();
        if (Logger.SHOULD_TRACE_TIMING) {
            lengthN = end - start;
            lengthM = TimeUnit.MILLISECONDS.convert(lengthN, TimeUnit.NANOSECONDS);
            Logger.trace(Logger.Category.TIMING, "Done with this batch of " + (count - 1) + " in " + (float)lengthM / 1000.0f + "s AVG speed " + (float)count / ((float)lengthM / 1000.0f) + " files/sec", new Throwable[0]);
        }
        if (Logger.SHOULD_TRACE_CACHE_STATS) {
            bytes = new ByteArrayOutputStream();
            stream = new PrintStream(bytes);
            this.DATABASE.printCacheStats(stream);
            this.printResolverStats(stream);
            IndexManager.printIndexCacheStats(stream);
            Logger.trace(Logger.Category.CACHE_STATS, bytes.toString(), new Throwable[]{null});
        }
        this.ensureUpToDate.set(false);
        this.markersJob.cancel();
        this.markersJob.schedule();
        if (InternalAPI.Tweaks.SHOULD_FLUSH_CACHE_AFTER_INDEX) {
            InternalAPI.drainCaches(false);
        }
        rCache = null;
        if (Logger.SHOULD_TRACE_JOB_STATE_CHANGES) {
            Logger.trace(Logger.Category.JOB_STATE_CHANGES, "ReferenceProcessor ended", new Throwable[0]);
        }
        ErrorRecovery.processorFinished(hasUnrecoverableError);
        this.activeLatch.countDown();
        return result;
    }

    private void indexItem(int originalPriority, LinkTransformerService.TransformerCache tCache, ResolverCache rCache, SubMonitor sub, ItemToIndex indexItem) {
        LinksDelta delta;
        Set<ILink> existingLinks;
        LinkNode<IResource> node = indexItem.change == null ? null : this.referenceManager.getLinkNode(indexItem.change.getResource());
        String subTaskName = this.updateMonitorText((IProgressMonitor)sub, indexItem, node, originalPriority);
        sub.setWorkRemaining(this.getScheduler().getSize());
        SubMonitor divided = this.createMonitor(sub, subTaskName);
        EventCollector collector = new EventCollector();
        Set<IResolvedReference> incomingReferences = this.getInitialIncomingReferences(indexItem, (IProgressMonitor)divided.newChild(1, 7));
        if (indexItem.modelIds != null && indexItem.modelIds.size() == 1) {
            existingLinks = Collections.emptySet();
            delta = this.detectBuiltInDelta(indexItem, incomingReferences, node, rCache, collector);
        } else {
            existingLinks = this.retrieveExistingLinks(indexItem, node, (IProgressMonitor)divided.newChild(1, 7), collector);
            if (this.shouldAbortEarly(indexItem, existingLinks)) {
                return;
            }
            delta = this.detectLinkDeltaPhase(rCache, indexItem, node, (IProgressMonitor)divided.newChild(1, 7), collector, existingLinks, incomingReferences);
            if (delta == null) {
                return;
            }
        }
        this.updateIncomingReferences(incomingReferences, collector.getEvents());
        Map<ILink, Collection<IResolvedReference>> newResolvedReferences = this.resolveLinksPhase(tCache, rCache, indexItem, (IProgressMonitor)divided.newChild(1, 2), collector, existingLinks, incomingReferences, delta);
        this.reResolveIncomingLinksPhase(tCache, rCache, indexItem, (IProgressMonitor)divided.newChild(1, 2), collector, delta, incomingReferences, newResolvedReferences);
        this.reResolveIncomingReferenceDeps(tCache, rCache, (IProgressMonitor)divided.newChild(1, 2), collector);
        this.eventsJob.fireEvents(collector.getEvents());
    }

    private boolean shouldAbortEarly(ItemToIndex indexItem, Collection<ILink> existingLinks) {
        if (indexItem.change != null && indexItem.change.isChange() && indexItem.change.isTrigger() && existingLinks.isEmpty()) {
            if (Logger.SHOULD_TRACE_EVENT_DETAILED) {
                Logger.trace(Logger.Category.EVENT_DETAILED, "No change (TRIGGERED CHANGE ON A RESOURCE NOT INDEXED YET)", new Throwable[]{null});
            }
            return true;
        }
        return false;
    }

    private SubMonitor createMonitor(SubMonitor sub, String subTaskName) {
        SubMonitor oneChild = sub.newChild(1, 0);
        oneChild.setWorkRemaining(10000);
        SubProgressMonitor subMonitor = new SubProgressMonitor((IProgressMonitor)oneChild, 10000, 4);
        SubMonitor divided = SubMonitor.convert((IProgressMonitor)subMonitor, (String)subTaskName, (int)6);
        return divided;
    }

    private void reResolveIncomingReferenceDeps(LinkTransformerService.TransformerCache tCache, ResolverCache rCache, IProgressMonitor monitor, EventCollector collector) {
        ArrayList<IResolvedReference> refs = new ArrayList<IResolvedReference>();
        for (ReferenceEvent referenceEvent : collector.getEvents()) {
            if (referenceEvent.getKind() != ReferenceEvent.Kind.REMOVE || referenceEvent.getReferenceElement().getElementType() != IReferenceElement.ElementType.RESOLVED_REFERENCE) continue;
            ResolvedReference removed = (ResolvedReference)referenceEvent.getReferenceElement();
            refs.add(removed);
        }
        if (Logger.SHOULD_TRACE_EVENT_DETAILED) {
            Logger.trace(Logger.Category.EVENT_DETAILED, "PHASE: Re-Resolve incoming reference dependencies", new Throwable[]{null});
        }
        this.reResolveIncomingReferenceDeps(refs, collector, tCache, rCache, monitor);
    }

    private void reResolveIncomingLinksPhase(LinkTransformerService.TransformerCache tCache, ResolverCache rCache, ItemToIndex indexItem, IProgressMonitor monitor, EventCollector collector, LinksDelta delta, Set<IResolvedReference> incomingReferences, Map<ILink, Collection<IResolvedReference>> newResolvedReferences) {
        if (Logger.SHOULD_TRACE_EVENT_DETAILED) {
            Logger.trace(Logger.Category.EVENT_DETAILED, "PHASE: Re-Resolve incoming links", new Throwable[]{null});
        }
        this.reResolveIncomingLinks(indexItem, delta, incomingReferences, newResolvedReferences, collector, tCache, rCache, monitor);
    }

    private Map<ILink, Collection<IResolvedReference>> resolveLinksPhase(LinkTransformerService.TransformerCache tCache, ResolverCache rCache, ItemToIndex indexItem, IProgressMonitor monitor, EventCollector collector, Set<ILink> existingLinks, Set<IResolvedReference> incomingReferences, LinksDelta delta) {
        Map<ILink, Collection<IResolvedReference>> newResolvedReferences;
        if (indexItem.affectedLink == null) {
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor);
            sub.setWorkRemaining(4);
            if (Logger.SHOULD_TRACE_EVENT_DETAILED) {
                Logger.trace(Logger.Category.EVENT_DETAILED, "PHASE: Resolve links", new Throwable[]{null});
            }
            PerformanceStats resolveStats = null;
            if (Logger.PERF_INDEXFILE_RESOLVE) {
                resolveStats = PerformanceStats.getStats((String)"com.ibm.etools.references/perf/indexFile/resolvePhase", (Object)((Object)this));
                resolveStats.startRun(this.getContext(indexItem));
            }
            newResolvedReferences = this.resolveLinks(delta.addedLinks, null, collector, (IProgressMonitor)sub.newChild(1), tCache, rCache);
            if (indexItem.change != null && indexItem.change.isTrigger()) {
                HashSet<ILink> links = new HashSet<ILink>(existingLinks);
                links.removeAll(delta.removedLinks);
                links.addAll(delta.updatedLinks);
                ArrayList<LinkAndReferenceType> linkTypeInfo = new ArrayList<LinkAndReferenceType>();
                for (ILink link : links) {
                    linkTypeInfo.add(new LinkAndReferenceType(link, Collections.singleton(null)));
                }
                newResolvedReferences.putAll(this.regenerateAndReresolveReferences(linkTypeInfo, (IProgressMonitor)sub.newChild(1), collector, rCache, tCache));
            } else {
                sub.newChild(1);
            }
            LinkedList<IResolvedReference> rrs = new LinkedList<IResolvedReference>();
            for (Collection<IResolvedReference> refs : newResolvedReferences.values()) {
                rrs.addAll(refs);
            }
            this.reResolveIncomingReferenceDeps(rrs, collector, tCache, rCache, (IProgressMonitor)sub.newChild(1));
            this.updateIncomingReferences(incomingReferences, collector.getEvents());
            if (resolveStats != null) {
                resolveStats.endRun();
            }
            if (Logger.SHOULD_TRACE_EVENT_DETAILED) {
                Logger.trace(Logger.Category.EVENT_DETAILED, "PHASE: Re-Resolve dependent links", new Throwable[]{null});
            }
            Map<ILink, Collection<IResolvedReference>> newDependentResolvedReferences = this.reResolveLinkDependencies(newResolvedReferences, (IProgressMonitor)sub.newChild(1), collector, tCache, rCache);
            this.updateIncomingReferences(incomingReferences, collector.getEvents());
            newResolvedReferences.putAll(newDependentResolvedReferences);
        } else {
            newResolvedReferences = Collections.emptyMap();
        }
        return newResolvedReferences;
    }

    private LinksDelta detectBuiltInDelta(ItemToIndex indexItem, Collection<IResolvedReference> incoming, LinkNode<? extends IResource> node, ResolverCache rCache, EventCollector collector) {
        SharedModel model = this.MODELSERVICE.getSharedModels("builtin.node.resource", node.getResource(), Collections.<IResolvedReference>emptySet());
        LinksDelta delta = new LinksDelta();
        if (indexItem.change.isAdd()) {
            ArrayList<ILink> links = new ArrayList<ILink>();
            try {
                links.addAll(this.LINKDETECTOR.detectLinks(model, Collections.<IResolvedReference>emptySet(), Collections.<LinkPositionInfo>emptySet(), false));
            }
            finally {
                model.release();
            }
            for (ILink link : links) {
                this.DATABASE.addOrUpdateArtifact(link, collector);
            }
            delta.addedLinks = links;
            if (Logger.SHOULD_TRACE_EVENT) {
                Logger.trace(Logger.Category.EVENT, NLS.bind((String)"Indexing: {0} (ADD builtin)", (Object)node.getResource().getFullPath()), new Throwable[0]);
            }
            collector.addEvent(new ReferenceEvent(node, ReferenceEvent.Kind.ADD));
        } else if (indexItem.change.isRemove()) {
            delta.removedLinks = this.retrieveExistingLinks(indexItem, node, null, collector);
            this.removeStaleExistingLinks(delta.removedLinks, incoming, rCache, collector, null);
            if (Logger.SHOULD_TRACE_EVENT) {
                Logger.trace(Logger.Category.EVENT, NLS.bind((String)"Indexing: {0} (REMOVE builtin)", (Object)node.getResource().getFullPath()), new Throwable[0]);
            }
            collector.addEvent(new ReferenceEvent(node, ReferenceEvent.Kind.REMOVE));
        } else {
            delta.updatedLinks = this.retrieveExistingLinks(indexItem, node, null, collector);
            if (Logger.SHOULD_TRACE_EVENT) {
                Logger.trace(Logger.Category.EVENT, NLS.bind((String)"Indexing: {0} (CHANGE builtin)", (Object)node.getResource().getFullPath()), new Throwable[0]);
            }
            collector.addEvent(new ReferenceEvent(node, ReferenceEvent.Kind.CHANGE));
        }
        return delta;
    }

    private LinksDelta detectLinkDeltaPhase(ResolverCache rCache, ItemToIndex indexItem, LinkNode<? extends IResource> node, IProgressMonitor monitor, EventCollector collector, Set<ILink> existingLinks, Set<IResolvedReference> incomingReferences) {
        LinksDelta delta = new LinksDelta();
        if (node != null) {
            if (Logger.SHOULD_TRACE_EVENT_DETAILED) {
                Logger.trace(Logger.Category.EVENT_DETAILED, "PHASE: Detect new links", new Throwable[0]);
            }
            if (this.referenceManager.isTestParseSpeedOnly()) {
                for (String id : indexItem.modelIds) {
                    SharedModel model = this.MODELSERVICE.getSharedModels(id, node.getResource(), Collections.<IResolvedReference>emptySet());
                    if (model == null) continue;
                    try {
                        this.LINKDETECTOR.detectLinks(model, Collections.<IResolvedReference>emptySet(), Collections.<LinkPositionInfo>emptySet(), false);
                    }
                    finally {
                        model.release();
                    }
                }
                return null;
            }
            if (this.shouldAbortEarly(indexItem, existingLinks)) {
                return delta;
            }
            if (indexItem.change.isChange() && indexItem.change.isTrigger() && !existingLinks.isEmpty()) {
                delta.updatedLinks = existingLinks;
            }
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            if (indexItem.change.isRemove()) {
                delta.removedLinks = existingLinks;
            } else {
                Set<LinkPositionInfo> linkPositions = node.getResource().getType() == 1 ? this.referenceManager.getAnnotationModelDocumentProvider().getActivePositions((IFile)node.getResource()) : Collections.emptySet();
                delta = this.detectNewLinks(indexItem, linkPositions, node, incomingReferences, existingLinks, collector, (IProgressMonitor)sub.newChild(1));
                if (Logger.SHOULD_TRACE_EVENT_DETAILED) {
                    Logger.trace(Logger.Category.EVENT_DETAILED, "PHASE: Remove new links", new Throwable[]{null});
                }
            }
            this.removeStaleExistingLinks(delta.removedLinks, incomingReferences, rCache, collector, (IProgressMonitor)sub.newChild(1));
        } else {
            if (Logger.SHOULD_TRACE_EVENT_DETAILED) {
                Logger.trace(Logger.Category.EVENT_DETAILED, "UPDATE link: " + indexItem.affectedLink, new Throwable[]{null});
            }
            if (indexItem.linkType == ReferenceEvent.Kind.REMOVE) {
                this.removeStaleExistingLinks(Collections.singleton(indexItem.affectedLink), incomingReferences, rCache, collector, monitor);
            }
        }
        return delta;
    }

    private SearchScope getSearchScopeForIncomingReferences(ItemToIndex indexItem) {
        if (indexItem.change != null) {
            return SearchEngine.createSearchScope(new IResource[]{indexItem.change.getResource().getProject()});
        }
        if (indexItem.affectedLink != null) {
            return SearchEngine.createWorkspaceScope();
        }
        Assert.isTrue((boolean)false, (String)"Unexpected index item");
        return null;
    }

    private Set<IResolvedReference> getInitialIncomingReferences(ItemToIndex indexItem, IProgressMonitor monitor) {
        Set<IResolvedReference> incomingReferences = indexItem.affectedLink == null ? (!this.referenceManager.isTestParseSpeedOnly() ? this.gatherIncomingReferences(indexItem, monitor) : Collections.emptySet()) : (indexItem.linkType == ReferenceEvent.Kind.ADD ? this.gatherIncomingReferencesForModelInstanceRef(indexItem, monitor) : (indexItem.linkType == ReferenceEvent.Kind.REMOVE ? this.gatherIncomingReferences(indexItem, monitor) : Collections.emptySet()));
        if (indexItem.affectedLink == null && !indexItem.addedModelDeps && !indexItem.ignoreContainedLinks) {
            if (!this.referenceManager.isTestParseSpeedOnly()) {
                HashSet<String> newIds = new HashSet<String>();
                for (IResolvedReference resolvedReference : incomingReferences) {
                    newIds.addAll(this.MODELSERVICE.getDependentNodes(((ResolvedReference)resolvedReference).getReference()));
                }
                if (indexItem.modelIds == null) {
                    indexItem.modelIds = new HashSet<String>();
                }
                indexItem.modelIds.addAll(newIds);
                incomingReferences.addAll(this.getIncomingReferencesForModelIds(newIds, indexItem));
            }
            indexItem.addedModelDeps = true;
        }
        return incomingReferences;
    }

    private Set<ILink> retrieveExistingLinks(ItemToIndex indexItem, LinkNode<? extends IResource> node, IProgressMonitor monitor, EventCollector collector) {
        Set<ILink> existingLinks = Collections.emptySet();
        if (indexItem.affectedLink == null) {
            if (indexItem.change != null) {
                if (indexItem.change.isAdd()) {
                    if (Logger.SHOULD_TRACE_EVENT) {
                        Logger.trace(Logger.Category.EVENT, NLS.bind((String)"Indexing: {0} (ADD)", (Object)node.getResource().getFullPath()), new Throwable[0]);
                    }
                    collector.addEvent(new ReferenceEvent(node, ReferenceEvent.Kind.ADD));
                    if (node != null && node.getResource().getType() == 1) {
                        this.markersJob.removeMarkersFor((IFile)node.getResource());
                    }
                } else if (indexItem.change.isRemove()) {
                    if (Logger.SHOULD_TRACE_EVENT) {
                        Logger.trace(Logger.Category.EVENT, NLS.bind((String)"Indexing: {0} (REMOVE)", (Object)node.getResource().getFullPath()), new Throwable[0]);
                    }
                    existingLinks = this.searchForExistingLinks(node, monitor);
                    collector.addEvent(new ReferenceEvent(node, ReferenceEvent.Kind.REMOVE));
                } else if (indexItem.change.isChange()) {
                    existingLinks = this.searchForExistingLinks(node, monitor);
                    if (indexItem.change.isTrigger() && existingLinks.isEmpty()) {
                        if (Logger.SHOULD_TRACE_EVENT) {
                            Logger.trace(Logger.Category.EVENT, NLS.bind((String)"Indexing: {0} (NOCHANGE: HAD NO LINKS & CHANGE TRIGGER)", (Object)node.getResource().getFullPath()), new Throwable[0]);
                        }
                        collector.addEvent(new ReferenceEvent(node, ReferenceEvent.Kind.NO_CHANGE));
                    } else {
                        if (Logger.SHOULD_TRACE_EVENT) {
                            Logger.trace(Logger.Category.EVENT, NLS.bind((String)"Indexing: {0} (CHANGE)", (Object)node.getResource().getFullPath()), new Throwable[0]);
                        }
                        collector.addEvent(new ReferenceEvent(node, ReferenceEvent.Kind.CHANGE));
                    }
                } else {
                    Assert.isTrue((boolean)false, (String)Messages.ReferenceProcessor_18);
                }
            } else if (indexItem.condition == null) {
                Assert.isTrue((boolean)false, (String)"Unexpected index item state");
            }
        }
        return existingLinks;
    }

    private int scheduleMarkersJob(int runningNotificationTab, int markerCreateThreshold) {
        if (++runningNotificationTab >= markerCreateThreshold) {
            this.markersJob.doSchedule();
            runningNotificationTab = 0;
        }
        return runningNotificationTab;
    }

    private void initLoop() {
        this.DATABASE.resetStats();
        this.resetResolverCacheStats();
        IndexManager.resetCacheStats();
        if (!this.isUser()) {
            ThreadPriorityPolicy.setBackgroundProcessingPriority(this.getThread());
        }
    }

    private long logTiming(long start, long periodic, int count) {
        long end;
        long lengthN;
        long lengthS;
        if (Logger.SHOULD_TRACE_TIMING && (lengthS = TimeUnit.SECONDS.convert(lengthN = (end = System.nanoTime()) - periodic, TimeUnit.NANOSECONDS)) >= 10L) {
            lengthN = end - start;
            long lengthM = TimeUnit.MILLISECONDS.convert(lengthN, TimeUnit.NANOSECONDS);
            Logger.trace(Logger.Category.TIMING, "Processed " + (count - 1) + " in " + (float)lengthM / 1000.0f + "s AVG speed " + (float)count / ((float)lengthM / 1000.0f) + " files/sec", new Throwable[0]);
            periodic = end;
        }
        return periodic;
    }

    public void printResolverStats(PrintStream out) {
        ResolverCache rCache = this.resolverCache;
        if (rCache == null) {
            out.println("No resolver cache");
        } else {
            rCache.printCacheStats(out);
        }
    }

    public void resetResolverCacheStats() {
        ResolverCache rCache = this.resolverCache;
        if (rCache != null) {
            rCache.resetCacheStats();
        }
    }

    private void updateIncomingReferences(Set<IResolvedReference> incomingReferences, List<ReferenceEvent> events) {
        for (ReferenceEvent referenceEvent : events) {
            Reference r;
            IResolvedReference rr;
            Iterator<IResolvedReference> incomingItr;
            if (referenceEvent.getKind() != ReferenceEvent.Kind.REMOVE) continue;
            if (referenceEvent.getReferenceElement().getElementType() == IReferenceElement.ElementType.RESOLVED_REFERENCE) {
                incomingReferences.remove(referenceEvent.getReferenceElement());
                continue;
            }
            if (referenceEvent.getReferenceElement().getElementType() == IReferenceElement.ElementType.LINK) {
                int linkId = referenceEvent.getReferenceElement().getId();
                incomingItr = incomingReferences.iterator();
                while (incomingItr.hasNext()) {
                    rr = incomingItr.next();
                    r = rr.getReference();
                    if (r != null && ((InternalReference)r).getId() != linkId) continue;
                    incomingItr.remove();
                }
                continue;
            }
            if (referenceEvent.getReferenceElement().getElementType() != IReferenceElement.ElementType.REFERENCE) continue;
            int referenceId = referenceEvent.getReferenceElement().getId();
            incomingItr = incomingReferences.iterator();
            while (incomingItr.hasNext()) {
                rr = incomingItr.next();
                r = rr.getReference();
                if (r != null && ((InternalReference)r).getId() != referenceId) continue;
                incomingItr.remove();
            }
        }
    }

    private void handleUnrecoverableException(ItemToIndex indexItem, Exception e) {
        this.referenceManager.setFatalError();
        boolean interrupted = Thread.interrupted();
        while (true) {
            try {
                this.scheduler.get().notifyAllConditions();
            }
            catch (InterruptedException interruptedException) {
                interrupted = true;
                continue;
            }
            catch (ExecutionException executionException) {
                continue;
            }
            break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        String path = Messages.errorMsg_Unknown;
        if (indexItem.change != null && indexItem.change.getResource() != null) {
            IResource r = indexItem.change.getResource();
            if (r != null) {
                path = r.getFullPath().toString();
            }
        } else if (indexItem.affectedLink != null) {
            path = indexItem.affectedLink.toString();
        }
        String friendlyMsg = NLS.bind((String)Messages.errorMsg_Fatal_error_link_indexer_disabled, (Object)path);
        InternalAPI.handleFrameworkException(indexItem, friendlyMsg, e, EnumSet.of(ErrorEvent.PresentationHints.LOG, ErrorEvent.PresentationHints.BLOCK), false);
    }

    void print() {
        ReferenceDatabase.getDefault().print();
        IndexManager.printIndexes();
    }

    private Set<IResolvedReference> gatherIncomingReferences(ItemToIndex indexItem, IProgressMonitor monitor) throws ReferenceException {
        HashSet<IResolvedReference> matches = new HashSet<IResolvedReference>();
        String path = indexItem.affectedLink == null ? indexItem.change.getResource().getFullPath().toString() : indexItem.affectedLink.getPath().toString();
        SearchPattern pathPattern = InternalSearchPattern.createPattern(path, IndexConstants.BY_TARGETPATH, IReferenceElement.ElementType.RESOLVED_REFERENCE, 0);
        SearchPattern idPattern = indexItem.affectedLink == null ? this.getPatternForBrokenLinksBasedOnModelIds(null, indexItem) : InternalSearchPattern.createPattern(path, IndexConstants.BY_MODELINSTANCEID_REF, IReferenceElement.ElementType.RESOLVED_REFERENCE, 0);
        DefaultSearchRequestor requestor = new DefaultSearchRequestor();
        this.SEARCHER.search(pathPattern, SearchEngine.createWorkspaceScope(), requestor, monitor);
        matches.addAll(requestor.getMatches());
        SearchScope scope = this.getSearchScopeForIncomingReferences(indexItem);
        requestor = new DefaultSearchRequestor();
        this.SEARCHER.search(idPattern, scope, requestor, monitor);
        matches.addAll(requestor.getMatches());
        return matches;
    }

    private Set<IResolvedReference> gatherIncomingReferencesForModelInstanceRef(ItemToIndex indexItem, IProgressMonitor monitor) throws ReferenceException {
        SearchPattern pattern = InternalSearchPattern.createPattern(indexItem.modelinstanceref, IndexConstants.BY_MODELINSTANCEID_REF, IReferenceElement.ElementType.RESOLVED_REFERENCE, 1);
        SearchScope scope = this.getSearchScopeForIncomingReferences(indexItem);
        DefaultSearchRequestor requestor = new DefaultSearchRequestor();
        this.SEARCHER.search(pattern, scope, requestor, monitor);
        Set<IResolvedReference> matches = requestor.getMatches();
        return matches;
    }

    private SearchPattern getPatternForBrokenLinksBasedOnModelIds(SearchPattern startPattern, ItemToIndex indexItem) {
        HashSet<String> mIds;
        if (indexItem.ignoreContainedLinks) {
            mIds = new HashSet<String>();
            mIds.add("builtin.node.resource");
        } else {
            mIds = new HashSet<String>(indexItem.modelIds);
            mIds.addAll(this.MODELSERVICE.getModelInstanceIds(this.referenceManager.getLinkNode(indexItem.change.getResource())));
        }
        return this.createPattern(startPattern, mIds);
    }

    private SearchPattern createPattern(SearchPattern startPattern, Collection<String> ids) {
        SearchPattern pattern = startPattern;
        for (String id : ids) {
            SearchPattern p = InternalSearchPattern.createPattern(id, IndexConstants.BY_MODELINSTANCEID_REF, IReferenceElement.ElementType.RESOLVED_REFERENCE, 0);
            pattern = pattern == null ? p : pattern.or(p);
        }
        return pattern;
    }

    private Set<IResolvedReference> getIncomingReferencesForModelIds(Set<String> ids, ItemToIndex indexItem) throws ReferenceException {
        if (ids.isEmpty()) {
            return Collections.emptySet();
        }
        SearchPattern pattern = this.createPattern(null, ids);
        SearchScope scope = this.getSearchScopeForIncomingReferences(indexItem);
        DefaultSearchRequestor requestor = new DefaultSearchRequestor();
        this.SEARCHER.search(pattern, scope, requestor, null);
        Set<IResolvedReference> matches = requestor.getMatches();
        return matches;
    }

    private ILink getResourceIdLink(Collection<ILink> links) {
        if (links == null) {
            return null;
        }
        for (ILink link : links) {
            if (!"builtin.file.nodeid".equals(link.getSpecializedType().getId()) && !"builtin.folder.nodeid".equals(link.getSpecializedType().getId()) && !"builtin.project.nodeid".equals(link.getSpecializedType().getId())) continue;
            return link;
        }
        return null;
    }

    private ILink getResourceIdLink(LinksDelta delta) {
        if (delta == null) {
            return null;
        }
        ILink id = this.getResourceIdLink(delta.addedLinks);
        if (id == null) {
            id = this.getResourceIdLink(delta.updatedLinks);
        }
        return id;
    }

    private ReferenceEvent.Kind getKind(ResourceChange change) {
        if (change == null) {
            return null;
        }
        if (change.isAdd()) {
            return ReferenceEvent.Kind.ADD;
        }
        if (change.isChange()) {
            return ReferenceEvent.Kind.CHANGE;
        }
        if (change.isRemove()) {
            return ReferenceEvent.Kind.REMOVE;
        }
        throw new RuntimeException("Unsupported change kind");
    }

    private void reResolveIncomingLinks(ItemToIndex indexItem, LinksDelta delta, Collection<IResolvedReference> incomingReferences, Map<ILink, Collection<IResolvedReference>> newResolvedRefs, EventCollector collector, LinkTransformerService.TransformerCache tCache, ResolverCache rCache, IProgressMonitor monitor2) throws ReferenceException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor2);
        sub.beginTask("", incomingReferences.size() * 2);
        if (!incomingReferences.isEmpty()) {
            ArrayList<IResolvedReference> rrsToReResolve = new ArrayList<IResolvedReference>();
            ReferenceEvent.Kind linkEvent = this.getKind(indexItem.change);
            IDLinkProxy proxy = new IDLinkProxy(delta);
            for (ResolvedReference resolvedReference : incomingReferences) {
                boolean shouldContinue = false;
                for (Collection<IResolvedReference> setOfResolvedRefs : newResolvedRefs.values()) {
                    if (!setOfResolvedRefs.contains(resolvedReference)) continue;
                    shouldContinue = true;
                    break;
                }
                if (shouldContinue) {
                    sub.worked(1);
                    continue;
                }
                boolean handled = false;
                BrokenStatus beforeResolvedBrokenState = resolvedReference.getBrokenStatus();
                if (linkEvent != null && resolvedReference.isNodeIdLinkTarget()) {
                    ILink id;
                    IResource resource;
                    if (beforeResolvedBrokenState == BrokenStatus.BROKEN) {
                        resource = indexItem.change.getResource();
                        if (resource.getFullPath().toString().equals(resolvedReference.getModelInstanceIdReference())) {
                            handled = true;
                            if (linkEvent == ReferenceEvent.Kind.ADD) {
                                resolvedReference.setBrokenLinkInfo(null);
                                resolvedReference.setBrokenStatus(BrokenStatus.NOTBROKEN);
                                id = proxy.getIDLink();
                                Assert.isNotNull((Object)id, (String)"ID target was null");
                                resolvedReference.setTarget(id);
                                this.DATABASE.addOrUpdateArtifact(resolvedReference, collector);
                                rrsToReResolve.add(resolvedReference);
                            }
                        }
                    } else if (beforeResolvedBrokenState == BrokenStatus.IGNORED) {
                        if (linkEvent == ReferenceEvent.Kind.ADD || linkEvent == ReferenceEvent.Kind.CHANGE) {
                            resource = indexItem.change.getResource();
                            if (resource.getFullPath().toString().equals(resolvedReference.getModelInstanceIdReference())) {
                                resolvedReference.setBrokenLinkInfo(null);
                                id = proxy.getIDLink();
                                Assert.isNotNull((Object)id, (String)"ID target was null");
                                resolvedReference.setTarget(id);
                                this.DATABASE.addOrUpdateArtifact(resolvedReference, collector);
                                rrsToReResolve.add(resolvedReference);
                                handled = true;
                            }
                        } else if (linkEvent == ReferenceEvent.Kind.REMOVE && resolvedReference.getTarget() != null) {
                            resolvedReference.setBrokenLinkInfo(null);
                            resolvedReference.setTarget(null);
                            this.DATABASE.addOrUpdateArtifact(resolvedReference, collector);
                            rrsToReResolve.add(resolvedReference);
                            handled = true;
                        }
                    } else if (beforeResolvedBrokenState == BrokenStatus.NOTBROKEN && linkEvent != ReferenceEvent.Kind.ADD) {
                        if (linkEvent == ReferenceEvent.Kind.REMOVE) {
                            handled = false;
                        } else if (linkEvent == ReferenceEvent.Kind.CHANGE) {
                            handled = true;
                        }
                    }
                }
                if (!handled) {
                    IResolvedReference reResolved = this.reResolveReference(resolvedReference, collector, rCache, (IProgressMonitor)sub.newChild(1));
                    if (reResolved == null) {
                        rrsToReResolve.add(resolvedReference);
                        continue;
                    }
                    BrokenStatus afterResolvedBrokenState = reResolved.getBrokenStatus();
                    if (beforeResolvedBrokenState == afterResolvedBrokenState) continue;
                    rrsToReResolve.add(resolvedReference);
                    continue;
                }
                sub.newChild(1).done();
            }
            this.reResolveIncomingReferenceDeps(rrsToReResolve, collector, tCache, rCache, (IProgressMonitor)sub.newChild(incomingReferences.size()));
        }
        sub.done();
    }

    private Collection<Reference> getReferences(int linkId, String refType) throws ReferenceException {
        SearchPattern pattern = InternalSearchPattern.createPattern(Integer.toString(linkId), IndexConstants.BY_SOURCELINKID, IReferenceElement.ElementType.REFERENCE, 0);
        if (refType != null) {
            pattern = pattern.and(InternalSearchPattern.createPattern(refType, IndexConstants.BY_REFERENCETYPE, IReferenceElement.ElementType.REFERENCE, 0));
        }
        SearchScope scope = SearchEngine.createWorkspaceScope();
        DefaultSearchRequestor req = new DefaultSearchRequestor();
        this.SEARCHER.search(pattern, scope, req, null);
        return req.getMatches();
    }

    private IResolvedReference reResolveReference(ResolvedReference existingResolved, EventCollector collector, ResolverCache rCache, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        List<ResolvedReference> oldResolvedList = this.refToList(existingResolved);
        List<ResolvedReference> reResolvedList = null;
        IResolvedReference reResolved = null;
        int offset = -1;
        if (existingResolved.getPrevious() == null) {
            offset = 0;
            reResolvedList = this.resolveReference(existingResolved.getReference(), rCache, (IProgressMonitor)sub.newChild(1));
            if (!reResolvedList.isEmpty()) {
                reResolved = reResolvedList.get(0);
            }
        } else {
            ResolvedReference head = this.getHead(existingResolved);
            offset = this.getOffsetInChain(head, existingResolved);
            reResolvedList = this.resolveReference(head.getReference(), rCache, (IProgressMonitor)sub.newChild(1));
        }
        if (reResolvedList.size() == oldResolvedList.size()) {
            int i = 0;
            while (i < reResolvedList.size()) {
                ResolvedReference oldRef = oldResolvedList.get(i);
                ResolvedReference newRef = reResolvedList.get(i);
                oldRef.copyFrom(newRef);
                ++i;
            }
            if (!oldResolvedList.isEmpty()) {
                reResolved = oldResolvedList.get(offset);
                this.DATABASE.addOrUpdateArtifact(reResolved, collector);
            }
        } else {
            ArrayList<ResolvedReference> newChain = new ArrayList<ResolvedReference>();
            int reSize = reResolvedList.size();
            int oldSize = oldResolvedList.size();
            int i = 0;
            while (i < reSize) {
                if (i < oldSize) {
                    oldResolvedList.get(i).copyFrom(reResolvedList.get(i));
                    newChain.add(oldResolvedList.get(i));
                } else {
                    newChain.add(reResolvedList.get(i));
                }
                ++i;
            }
            i = 1;
            while (i < newChain.size()) {
                ((ResolvedReference)newChain.get(i)).setPrevious((IResolvedReference)newChain.get(i - 1));
                ++i;
            }
            if (!newChain.isEmpty()) {
                if (offset >= 0 && offset < newChain.size()) {
                    reResolved = (IResolvedReference)newChain.get(offset);
                    this.DATABASE.addOrUpdateArtifact(reResolved, collector);
                } else {
                    Logger.logWarning(Logger.Category.DEBUG, Logger.Mode.DEV_MANDATORY, "Offset (" + offset + ") was outside of list range. Not updating. existingResolved=" + existingResolved);
                }
            }
            if (reSize < oldSize) {
                this.DATABASE.removeReferenceElement(oldResolvedList.get(reSize), collector);
            }
        }
        sub.newChild(1).worked(1);
        return reResolved;
    }

    private int getOffsetInChain(ResolvedReference head, ResolvedReference existingResolved) {
        int count = 0;
        ResolvedReference current = head;
        while (current != null) {
            if (current == existingResolved) {
                return count;
            }
            ++count;
            current = (ResolvedReference)current.getNext();
        }
        return -1;
    }

    private Map<ILink, Collection<IResolvedReference>> reResolveLinkDependencies(Map<ILink, Collection<IResolvedReference>> newResolved, IProgressMonitor monitor, EventCollector collector, LinkTransformerService.TransformerCache tCache, ResolverCache rCache) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)6);
        HashSet<Object> depIDs = new HashSet<Object>(newResolved.size());
        HashSet<ILink> depLinks = new HashSet<ILink>();
        SubMonitor part1 = sub.newChild(1);
        part1.beginTask("", newResolved.size());
        for (ILink link : newResolved.keySet()) {
            String linkId = link.getSpecializedType().getId();
            boolean added = depIDs.add(linkId);
            if (added) {
                List<Dependency> list = this.TRANSFORMER.getDependentLinkIds(linkId, link.getContainer().getResource().getProject(), tCache);
                SubMonitor subMonitor = part1.newChild(1);
                subMonitor.beginTask("", list.size());
                for (Dependency d : list) {
                    String id = d.linkid;
                    SearchPattern pattern = InternalSearchPattern.createPattern(id, IndexConstants.BY_LINKTYPE, IReferenceElement.ElementType.LINK, 0);
                    SearchScope scope = this.getSearchScopeFrom(link, d);
                    DefaultSearchRequestor requestor = new DefaultSearchRequestor();
                    this.SEARCHER.search(pattern, scope, requestor, (IProgressMonitor)subMonitor.newChild(1));
                    depLinks.addAll(requestor.getMatches());
                }
                continue;
            }
            part1.worked(1);
        }
        SubMonitor part2 = sub.newChild(1);
        for (ILink link : newResolved.keySet()) {
            Map<Dependency, List<SpecializedType>> deps = this.GENERATOR.getDependentLinkTypes(link.getSpecializedType().getId());
            SubMonitor subMonitor = part2.newChild(1);
            subMonitor.beginTask("", deps.size());
            for (Map.Entry entry : deps.entrySet()) {
                Dependency dep = (Dependency)entry.getKey();
                SearchScope scope = this.getSearchScopeFrom(link, dep);
                List types = (List)entry.getValue();
                SearchPattern pattern = null;
                for (SpecializedType specializedType : types) {
                    SearchPattern p = InternalSearchPattern.createPattern(specializedType.getId(), IndexConstants.BY_LINKTYPE, IReferenceElement.ElementType.LINK, 0);
                    pattern = pattern == null ? p : SearchPattern.createOrPattern(pattern, p);
                }
                if (pattern != null) {
                    DefaultSearchRequestor req = new DefaultSearchRequestor();
                    this.SEARCHER.search(pattern, scope, req, (IProgressMonitor)subMonitor.newChild(1));
                    Set matches = req.getMatches();
                    matches.removeAll(newResolved.keySet());
                    depLinks.addAll(matches);
                    continue;
                }
                subMonitor.worked(1);
            }
        }
        SubMonitor part3 = sub.newChild(1);
        part3.beginTask("", depLinks.size());
        for (ILink depLink : depLinks) {
            SearchPattern searchPattern = InternalSearchPattern.createPattern(Integer.toString(depLink.getId()), IndexConstants.BY_SOURCELINKID, IReferenceElement.ElementType.REFERENCE, 0);
            SearchScope searchScope = SearchEngine.createWorkspaceScope();
            DefaultSearchRequestor req = new DefaultSearchRequestor();
            this.SEARCHER.search(searchPattern, searchScope, req, (IProgressMonitor)part3.newChild(1));
            this.DATABASE.removeReferenceElements(req.getMatches(), collector);
        }
        Map<ILink, Collection<IResolvedReference>> resolved = this.resolveLinks(depLinks, null, collector, (IProgressMonitor)sub.newChild(1), tCache, rCache);
        SubMonitor part4 = sub.newChild(1);
        part4.beginTask("", resolved.size());
        for (Collection<IResolvedReference> collection : resolved.values()) {
            depIDs.addAll(this.reResolveIncomingReferenceDeps(collection, collector, tCache, rCache, (IProgressMonitor)part4.newChild(1)));
        }
        SubMonitor subMonitor = sub.newChild(1);
        subMonitor.beginTask("", depIDs.size());
        for (String string : depIDs) {
            Map<Dependency, List<String>> depRefTypes = this.RESOLVER.getDependentReferenceType(string);
            SubMonitor partA = subMonitor.newChild(1);
            partA.beginTask("", depRefTypes.size());
            Iterator<Map.Entry<Dependency, List<String>>> itr = depRefTypes.entrySet().iterator();
            while (itr.hasNext()) {
                SubMonitor partB = partA.newChild(1);
                partB.beginTask("", 2);
                Map.Entry<Dependency, List<String>> entry = itr.next();
                List<String> refTypes = entry.getValue();
                if (refTypes.isEmpty()) continue;
                SearchScope scope = SearchEngine.createWorkspaceScope();
                SearchPattern refPattern = null;
                for (String refType : refTypes) {
                    SearchPattern pattern = InternalSearchPattern.createPattern(refType, IndexConstants.BY_REFERENCETYPE, IReferenceElement.ElementType.REFERENCE, 0);
                    refPattern = refPattern == null ? pattern : refPattern.or(pattern);
                }
                DefaultSearchRequestor req = new DefaultSearchRequestor();
                this.SEARCHER.search(refPattern, scope, req, (IProgressMonitor)partB.newChild(1));
                Set refs = req.getMatches();
                partB.setWorkRemaining(refs.size());
                for (Reference reference : refs) {
                    ResolvedReference rr = this.getResolvedReferenceFor(reference);
                    if (rr == null) continue;
                    this.reResolveReference(rr, collector, rCache, (IProgressMonitor)partB.newChild(1));
                }
            }
        }
        return resolved;
    }

    private Map<? extends ILink, ? extends Collection<IResolvedReference>> regenerateAndReresolveReferences(List<LinkAndReferenceType> linkRefTypes, IProgressMonitor monitor, EventCollector collector, ResolverCache rCache, LinkTransformerService.TransformerCache tCache) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor);
        sub.beginTask("", 3);
        HashMap<String, Reference> refsToRemove = new HashMap<String, Reference>();
        HashMap<String, Reference> refsToReResolve = new HashMap<String, Reference>();
        SubMonitor part1 = sub.newChild(linkRefTypes.size(), 7);
        for (LinkAndReferenceType linkRef : linkRefTypes) {
            for (String refType : linkRef.refTypes) {
                ILink link = linkRef.link;
                HashMap<String, Reference> dbReferences = new HashMap<String, Reference>();
                Collection<Reference> tempCollection = this.getReferences(link.getId(), refType);
                for (Reference r : tempCollection) {
                    dbReferences.put(r.getCachingKey(), r);
                }
                ArrayList<String> nonHeads = new ArrayList<String>();
                HashMap<String, Reference> newHeadRefs = new HashMap<String, Reference>();
                List<ReferenceGeneratorService.GeneratedReferenceData> newRefsRaw = this.generateReferences(link, refType, tCache);
                for (ReferenceGeneratorService.GeneratedReferenceData genData : newRefsRaw) {
                    List<Reference> refs = genData.getReferences();
                    List<Reference> newNonHeads = this.getNonHeadChains(refs);
                    for (Reference reference : newNonHeads) {
                        nonHeads.add(reference.getCachingKey());
                    }
                    Iterator<Reference> iterator = newNonHeads.iterator();
                    while (iterator.hasNext()) {
                        Reference reference = iterator.next();
                        String cacheKey = reference.getCachingKey();
                        if (!nonHeads.contains(cacheKey)) continue;
                        iterator.remove();
                    }
                    for (Reference r : refs) {
                        String ck = r.getCachingKey();
                        newHeadRefs.put(ck, r);
                        if (dbReferences.containsKey(ck) || refsToReResolve.containsKey(ck)) continue;
                        refsToReResolve.put(r.getCachingKey(), r);
                    }
                }
                for (Reference oldRef : dbReferences.values()) {
                    String key = oldRef.getCachingKey();
                    if (nonHeads.contains(key) || newHeadRefs.containsKey(key)) continue;
                    refsToRemove.put(oldRef.getCachingKey(), oldRef);
                }
            }
            part1.worked(1);
        }
        this.DATABASE.removeReferenceElements(refsToRemove.values(), collector);
        sub.newChild(1).worked(1);
        SubMonitor part3 = sub.newChild(1);
        part3.beginTask("", refsToReResolve.size());
        HashMap<ILink, List<IResolvedReference>> resolvedReferences = new HashMap<ILink, List<IResolvedReference>>();
        for (Reference reference : refsToReResolve.values()) {
            List<IResolvedReference> resolved = this.resolveReferences(collector, Collections.singletonList(reference), rCache, (IProgressMonitor)part3.newChild(1));
            resolvedReferences.put(reference.getSource(), resolved);
        }
        return resolvedReferences;
    }

    private Set<String> reResolveIncomingReferenceDeps(Collection<IResolvedReference> resolvedReferences, EventCollector collector, LinkTransformerService.TransformerCache tCache, ResolverCache rCache, IProgressMonitor monitor) throws ReferenceException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        ArrayList<LinkAndReferenceType> linkRefTypes = new ArrayList<LinkAndReferenceType>();
        HashSet<ILink> targets = new HashSet<ILink>();
        SubMonitor partA = sub.newChild(1);
        partA.beginTask("", resolvedReferences.size());
        for (IResolvedReference resolvedReference : resolvedReferences) {
            partA.newChild(1);
            ILink target = resolvedReference.getTarget();
            if (target == null) continue;
            Collection<String> refTypes = this.GENERATOR.getReferenceTypesDependentOnIncomingReferenceDependency(resolvedReference);
            targets.add(target);
            if (refTypes.isEmpty()) continue;
            linkRefTypes.add(new LinkAndReferenceType(target, refTypes));
        }
        this.regenerateAndReresolveReferences(linkRefTypes, (IProgressMonitor)sub.newChild(1), collector, rCache, tCache);
        SubMonitor part2 = sub.newChild(1);
        part2.beginTask("", targets.size());
        HashSet<ILink> linksToReResolve = new HashSet<ILink>();
        HashSet<String> depIDs = new HashSet<String>();
        for (ILink target : targets) {
            part2.newChild(1);
            Map<Dependency, List<SpecializedType>> deps = this.GENERATOR.getDependentLinkTypes(target.getSpecializedType().getId());
            for (Map.Entry<Dependency, List<SpecializedType>> entry : deps.entrySet()) {
                Dependency dep = entry.getKey();
                EvaluationContext context = new EvaluationContext(null, (Object)target);
                context.addVariable("linkName", (Object)target.getName());
                context.setAllowPluginActivation(true);
                EvaluationResult result = EvaluationResult.FALSE;
                try {
                    result = dep.expression.evaluate((IEvaluationContext)context);
                }
                catch (CoreException coreException) {}
                if (result != EvaluationResult.TRUE) continue;
                SearchScope scope = this.getSearchScopeFrom(target, dep);
                List<SpecializedType> types = entry.getValue();
                SearchPattern pattern = null;
                for (SpecializedType specializedType : types) {
                    SearchPattern p = InternalSearchPattern.createPattern(specializedType.getId(), IndexConstants.BY_LINKTYPE, IReferenceElement.ElementType.LINK, 0);
                    pattern = pattern == null ? p : pattern.or(p);
                    depIDs.add(specializedType.getId());
                }
                DefaultSearchRequestor req = new DefaultSearchRequestor();
                this.SEARCHER.search(pattern, scope, req, null);
                Set<ILink> thelinks = req.getMatches();
                if (dep.scope == Dependency.Scope.LINK) {
                    thelinks = this.rangeFilter(thelinks, target);
                }
                linksToReResolve.addAll(thelinks);
            }
        }
        SubMonitor part3 = sub.newChild(1);
        part3.beginTask("", linksToReResolve.size() * 2);
        for (ILink alink : linksToReResolve) {
            this.DATABASE.removeReferenceElements(alink.resolveReference(null, (IProgressMonitor)part3.newChild(1)), collector);
        }
        for (ILink alink : linksToReResolve) {
            this.resolveLinks(Collections.singletonList(alink), null, collector, (IProgressMonitor)part3.newChild(1), tCache, rCache);
        }
        return depIDs;
    }

    private Set<ILink> rangeFilter(Set<ILink> links, ILink enclosingLink) {
        TextRange container = enclosingLink.getContextLocation();
        Iterator<ILink> iterator = links.iterator();
        while (iterator.hasNext()) {
            ILink link = iterator.next();
            if (container.contains(link.getContextLocation())) continue;
            iterator.remove();
        }
        return links;
    }

    private ResolvedReference getResolvedReferenceFor(Reference ref) throws ReferenceException {
        SearchPattern pattern = InternalSearchPattern.createPattern(Integer.toString(ref.getId()), IndexConstants.BY_REFERENCE_ID, IReferenceElement.ElementType.RESOLVED_REFERENCE, 0);
        DefaultSearchRequestor req = new DefaultSearchRequestor();
        this.SEARCHER.search(pattern, SearchEngine.createWorkspaceScope(), req, null);
        Set rr = req.getMatches();
        if (rr.size() >= 1) {
            return (ResolvedReference)rr.iterator().next();
        }
        return null;
    }

    private SearchScope getSearchScopeFrom(ILink link, Dependency d) {
        SearchScope scope = null;
        if (d.scope == Dependency.Scope.WORKSPACE) {
            scope = SearchEngine.createWorkspaceScope();
        } else if (d.scope == Dependency.Scope.PROJECT) {
            scope = SearchEngine.createSearchScope(new IResource[]{link.getContainer().getResource().getProject()});
        } else if (d.scope == Dependency.Scope.FILE) {
            scope = SearchEngine.createSearchScope(new IResource[]{(IFile)link.getContainer().getResource()});
        } else if (d.scope == Dependency.Scope.LINK) {
            scope = SearchEngine.createSearchScope(new IResource[]{(IFile)link.getContainer().getResource()});
        } else {
            throw new RuntimeException("Unrecognized link scope ");
        }
        return scope;
    }

    private List<ReferenceGeneratorService.GeneratedReferenceData> generateReferences(ILink link, String referenceType, LinkTransformerService.TransformerCache transformerCache) {
        String expandedLinkTxt = this.TRANSFORMER.expand(link, link.getLinkText(), EnumSet.noneOf(ProviderArguments.class), transformerCache);
        List<ReferenceGeneratorService.GeneratedReferenceData> refData = this.GENERATOR.generateReferences(referenceType, link, expandedLinkTxt);
        return refData;
    }

    private Map<ILink, Collection<IResolvedReference>> resolveLinks(Collection<ILink> links, String referenceType, EventCollector collector, IProgressMonitor monitor, LinkTransformerService.TransformerCache tCache, ResolverCache rCache) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)links.size());
        HashMap<ILink, Collection<IResolvedReference>> newResolvedReferences = new HashMap<ILink, Collection<IResolvedReference>>(links.size());
        sub.beginTask("", links.size());
        for (ILink link : links) {
            SubMonitor partA = sub.newChild(1);
            if (((Link)link).isEndPoint()) continue;
            HashSet<IResolvedReference> linkResolvedReferences = new HashSet<IResolvedReference>();
            List<ReferenceGeneratorService.GeneratedReferenceData> refData = this.generateReferences(link, referenceType, tCache);
            SubMonitor partB = partA.newChild(1);
            partB.beginTask("", refData.size());
            for (ReferenceGeneratorService.GeneratedReferenceData generatedReferenceData : refData) {
                List<Reference> references = generatedReferenceData.getReferences();
                List<Reference> nonHeads = this.getNonHeadChains(references);
                references.removeAll(nonHeads);
                List<IResolvedReference> resolvedReferences = this.resolveReferences(collector, references, rCache, (IProgressMonitor)partB.newChild(1));
                linkResolvedReferences.addAll(resolvedReferences);
            }
            newResolvedReferences.put(link, linkResolvedReferences);
        }
        return newResolvedReferences;
    }

    private List<IResolvedReference> resolveReferences(EventCollector collector, List<Reference> references, ResolverCache rCache, IProgressMonitor monitor) {
        ArrayList<IResolvedReference> resolvedReferences = new ArrayList<IResolvedReference>();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)references.size());
        for (Reference ref : references) {
            String info;
            Set<String> nodeIds;
            ResolvedReference resolvedReference;
            List<ResolvedReference> resolvedReferenceChain = this.resolveReference(ref, rCache, (IProgressMonitor)sub.newChild(1));
            int i = 1;
            while (i < resolvedReferenceChain.size()) {
                resolvedReferenceChain.get(i).setPrevious(resolvedReferenceChain.get(i - 1));
                ++i;
            }
            if (resolvedReferenceChain.isEmpty() || (resolvedReference = resolvedReferenceChain.get(0)) == null) continue;
            resolvedReferences.add(resolvedReference);
            this.DATABASE.addOrUpdateArtifact(resolvedReference, collector);
            if (BrokenStatus.NOTBROKEN == resolvedReference.getBrokenStatus()) {
                nodeIds = this.MODELSERVICE.getDependentNodes(ref);
                if (nodeIds.isEmpty()) continue;
                ILink target = resolvedReference.getTarget();
                nodeIds.addAll(this.MODELSERVICE.getNodeModelIds(target.getContainer().getResource()));
                AddToIndexJob.SchedulerItem targetInfo = new AddToIndexJob.SchedulerItem(Collections.singletonList(new ResourceChange(target.getContainer().getResource(), 4)), null, null);
                targetInfo.modelIds = nodeIds;
                targetInfo.addedModelDeps = true;
                this.getScheduler().addItemToIndex(targetInfo, null);
                continue;
            }
            nodeIds = this.MODELSERVICE.getDependentNodes(ref);
            if (nodeIds.isEmpty() || (info = resolvedReference.getModelInstanceIdReference()) == null || !info.startsWith("/")) continue;
            Path path = new Path(info);
            IFile target = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            if (target == null) continue;
            nodeIds.addAll(this.MODELSERVICE.getNodeModelIds((IResource)target));
            AddToIndexJob.SchedulerItem targetInfo = new AddToIndexJob.SchedulerItem(Collections.singletonList(new ResourceChange((IResource)target, 4)), null, null);
            targetInfo.modelIds = nodeIds;
            targetInfo.addedModelDeps = true;
            this.getScheduler().addItemToIndex(targetInfo, null);
        }
        return resolvedReferences;
    }

    private List<Reference> getNonHeadChains(List<Reference> references) {
        ArrayList<Reference> nonHeads = new ArrayList<Reference>();
        for (Reference reference : references) {
            if (reference.getNextReference() == null) continue;
            nonHeads.add(reference.getNextReference());
        }
        return nonHeads;
    }

    private void removeStaleExistingLinks(Collection<ILink> existingLinks, Collection<IResolvedReference> incomingRefs, ResolverCache rCache, EventCollector collector, IProgressMonitor monitor) throws ReferenceException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        SubMonitor part1 = sub.newChild(1);
        part1.beginTask("", existingLinks.size());
        for (ILink existingLink : existingLinks) {
            HashSet<ResolvedReference> set = new HashSet<ResolvedReference>();
            for (IResolvedReference incoming : incomingRefs) {
                if (incoming.getTarget() == null || incoming.getTarget().getId() != existingLink.getId()) continue;
                set.add((ResolvedReference)incoming);
            }
            for (ResolvedReference resolvedReference : set) {
                String info = this.RESOLVER.getBrokenLinkInfo(resolvedReference.getReference());
                resolvedReference.setBrokenStatus(BrokenStatus.BROKEN);
                resolvedReference.setTarget(null);
                resolvedReference.setBrokenLinkInfo(info);
                ResolvedReference nextRR = (ResolvedReference)resolvedReference.getNext();
                while (nextRR != null) {
                    this.DATABASE.removeReferenceElement(nextRR, collector);
                    nextRR = (ResolvedReference)nextRR.getNext();
                }
                resolvedReference.setNext(null);
                this.DATABASE.addOrUpdateArtifact(resolvedReference, collector);
            }
        }
        SubMonitor part2 = sub.newChild(1);
        part2.beginTask("", existingLinks.size());
        Set<String> triggerRefTypes = this.MODELSERVICE.getTriggerReferenceTypes();
        for (ILink existingLink : existingLinks) {
            List<String> refTypes = existingLink.getReferenceTypes();
            SubMonitor subParts = part2.newChild(1);
            subParts.beginTask("", refTypes.size());
            for (String refType : refTypes) {
                if (!triggerRefTypes.contains(refType)) continue;
                Collection<IResolvedReference> refs = existingLink.resolveReference(refType, (IProgressMonitor)subParts.newChild(1));
                for (IResolvedReference rr : refs) {
                    Set<String> depModelIds;
                    ILink target = rr.getTarget();
                    if (target == null || (depModelIds = this.MODELSERVICE.getDependentNodes(rr.getReference())).isEmpty()) continue;
                    this.getScheduler().requestChangeAnalysis(Collections.singletonList(new ResourceChange(rr.getTarget().getContainer().getResource(), 4)), null);
                }
            }
            this.DATABASE.removeReferenceElement(existingLink, collector);
            rCache.removeRRforLink(existingLink);
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    private LinksDelta detectNewLinks(ItemToIndex indexItem, Set<LinkPositionInfo> linkPositions, LinkNode<? extends IResource> node, Set<IResolvedReference> incomingRefs, Set<ILink> existingLinks, EventCollector collector, IProgressMonitor subMonitor) throws ReferenceException {
        LinksDelta delta = new LinksDelta();
        delta.addedLinks = new ArrayList<ILink>();
        delta.removedLinks = new ArrayList<ILink>();
        delta.updatedLinks = new ArrayList<ILink>();
        this.updateLinkPositions(linkPositions, collector, delta);
        List<SharedModel> models = this.getSharedModels(indexItem, node, incomingRefs);
        List<LinkModelInfo> currentLinks = this.detectLinks(linkPositions, incomingRefs, subMonitor, models);
        for (SharedModel model : models) {
            model.release();
        }
        if (!currentLinks.isEmpty()) {
            HashMap<String, ILink> existingLinksKey = new HashMap<String, ILink>(existingLinks.size());
            for (ILink existingLink : existingLinks) {
                try {
                    existingLinksKey.put(((Link)existingLink).getCachingKey(), existingLink);
                }
                catch (Exception exception) {}
            }
            for (LinkModelInfo info : currentLinks) {
                ILink link = info.link;
                boolean shouldAdd = true;
                if (existingLinksKey.size() > 0) {
                    try {
                        Link similarKey = (Link)existingLinksKey.remove(((Link)link).getCachingKey());
                        if (similarKey != null) {
                            shouldAdd = false;
                        }
                    }
                    catch (Exception exception) {
                        shouldAdd = false;
                    }
                }
                if (!shouldAdd) continue;
                delta.addedLinks.add(link);
                this.DATABASE.addOrUpdateArtifact(link, collector);
            }
            delta.removedLinks = existingLinksKey.values();
            delta.updatedLinks.removeAll(delta.removedLinks);
        } else {
            delta.removedLinks = new HashSet<ILink>(existingLinks);
        }
        return delta;
    }

    private List<LinkModelInfo> detectLinks(Set<LinkPositionInfo> linkPositions, Set<IResolvedReference> incomingRefs, IProgressMonitor subMonitor, List<SharedModel> models) {
        subMonitor.beginTask("", models.size());
        ArrayList<LinkModelInfo> currentLinks = new ArrayList<LinkModelInfo>();
        for (SharedModel model : models) {
            List<ILink> links = this.LINKDETECTOR.detectLinks(model, incomingRefs, linkPositions, false);
            for (ILink detectedLink : links) {
                currentLinks.add(new LinkModelInfo(detectedLink, model.getNodeId()));
            }
            subMonitor.worked(1);
        }
        return currentLinks;
    }

    private List<SharedModel> getSharedModels(ItemToIndex indexItem, LinkNode<? extends IResource> node, Set<IResolvedReference> incomingRefs) {
        ArrayList<SharedModel> models = new ArrayList<SharedModel>();
        if (indexItem.ignoreContainedLinks) {
            SharedModel model = this.MODELSERVICE.getSharedModels("builtin.node.resource", node.getResource(), incomingRefs);
            if (model != null) {
                models.add(model);
            }
        } else {
            for (String modelId : indexItem.modelIds) {
                SharedModel model = this.MODELSERVICE.getSharedModels(modelId, node.getResource(), incomingRefs);
                if (model == null) continue;
                models.add(model);
            }
        }
        return models;
    }

    private void updateLinkPositions(Set<LinkPositionInfo> linkPositions, EventCollector collector, LinksDelta delta) {
        for (LinkPositionInfo info : linkPositions) {
            Link link = (Link)info.getLink();
            if (link.getRecord().isDeleted()) continue;
            String original = link.getLinkText();
            String newText = info.getLinkText();
            if (original != null && original.length() != 0 && (!this.whiteSpacePattern.matcher(original).replaceAll("").equals(this.whiteSpacePattern.matcher(newText).replaceAll("")) || link.getContextLocation().getOffset() <= 0 || link.getLinkLocation().getOffset() <= 0)) continue;
            boolean changed = false;
            changed |= link.setContextLocation(info.getContextLocation());
            changed |= link.setContextText(info.getContextText());
            changed |= link.setLocation(info.getLinkLocation());
            if (!(changed |= link.setText(newText))) continue;
            delta.updatedLinks.add(link);
            this.DATABASE.addOrUpdateArtifact(link, collector);
        }
    }

    private Set<ILink> searchForExistingLinks(LinkNode<? extends IResource> node, IProgressMonitor monitor) throws ReferenceException {
        SearchPattern allLinks = InternalSearchPattern.createPattern(node.getResource().getFullPath().toString(), IndexConstants.BY_SOURCEPATH, IReferenceElement.ElementType.LINK, 0);
        DefaultSearchRequestor req = new DefaultSearchRequestor();
        SearchScope workspace = SearchEngine.createWorkspaceScope();
        this.SEARCHER.search(allLinks, workspace, req, monitor);
        return req.getMatches();
    }

    private boolean isEqual(ILink existing, ILink link) {
        return existing.getSpecializedType().equals(link.getSpecializedType()) && existing.getLinkLocation().equals(link.getLinkLocation()) && existing.getContextLocation().equals(link.getContextLocation()) && Util.isEqualOrBothNull(existing.getLinkText(), link.getLinkText()) && Util.isEqualOrBothNull(existing.getContextText(), link.getContextText()) && Util.isEqualOrBothNull(existing.getName(), link.getName());
    }

    private boolean isParamsEqual(ILink existing, ILink link) {
        Map<String, String> existingParams = ((Link)existing).getParameters();
        Map<String, String> params = ((Link)link).getParameters();
        boolean equal = false;
        equal = existingParams == null && existingParams == params ? true : (existingParams == null && params != null || existingParams != null && params == null ? false : (existingParams == null ? false : existingParams.equals(params)));
        return equal;
    }

    public boolean matchNewLinkToOld(Set<ILink> existingLinks, ILink link) {
        boolean shouldAdd = true;
        Iterator<ILink> iterator2 = existingLinks.iterator();
        while (iterator2.hasNext()) {
            ILink existing = iterator2.next();
            if (!this.isEqual(existing, link) || !this.isParamsEqual(existing, link)) continue;
            iterator2.remove();
            shouldAdd = false;
            break;
        }
        return shouldAdd;
    }

    private List<Reference> refToList(Reference ref) {
        Reference head;
        ArrayList<Reference> list = new ArrayList<Reference>();
        Reference next = head = ref;
        while (next != null) {
            list.add(next);
            next = next.getNextReference();
        }
        return list;
    }

    private List<ResolvedReference> refToList(ResolvedReference ref) {
        ResolvedReference head = this.getHead(ref);
        ArrayList<ResolvedReference> list = new ArrayList<ResolvedReference>();
        ResolvedReference next = head;
        while (next != null) {
            list.add(next);
            next = (ResolvedReference)next.getNext();
        }
        return list;
    }

    private ResolvedReference getHead(ResolvedReference referenceChain) {
        ResolvedReference head = null;
        ResolvedReference tmp = referenceChain;
        while (tmp != null) {
            head = tmp;
            tmp = (ResolvedReference)tmp.getPrevious();
        }
        return head;
    }

    private List<ResolvedReference> resolveReference(Reference referenceChain, ResolverCache rCache, IProgressMonitor monitor) throws ReferenceException {
        if (referenceChain.getBrokenStatus() == BrokenStatus.BROKEN) {
            if (Logger.SHOULD_TRACE_EVENT_DETAILED) {
                Logger.trace(Logger.Category.EVENT_DETAILED, "Bypassing resolver. Reference " + referenceChain + " was broken", new Throwable[0]);
            }
            ResolvedReference broken = this.DATABASE.createNewResolvedReference();
            broken.setBrokenStatus(referenceChain.getBrokenStatus());
            int id = this.RESOLVER.getApplicableProviderId(referenceChain);
            broken.setProviderId(id);
            broken.setReference(referenceChain);
            String brokenLinkInfo = this.RESOLVER.getBrokenLinkInfo(referenceChain);
            if (brokenLinkInfo == null) {
                Logger.logWarning(Logger.Category.REFERENCE_MANAGER, Logger.Mode.DEV_MANDATORY, "Could not get brokenlinkinfo from a resolver for a broken reference");
                return Collections.emptyList();
            }
            broken.setBrokenLinkInfo(brokenLinkInfo);
            broken.freeze();
            return Collections.singletonList(broken);
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)this.refToList(referenceChain).size());
        ArrayList<ResolvedReference> resolved = new ArrayList<ResolvedReference>();
        Reference nextReference = referenceChain;
        Reference previousReference = null;
        ResolvedReference previousResult = null;
        while (nextReference != null) {
            ResolvedReference resolutionResult = null;
            ResolvedReference cached = rCache.getCachedResolvedReference(nextReference, previousReference);
            if (cached == null) {
                SubMonitor s = sub.newChild(1, 2);
                s.beginTask("", 10000);
                SubProgressMonitor subMon = new SubProgressMonitor((IProgressMonitor)s, 10000, 4);
                resolutionResult = (ResolvedReference)this.RESOLVER.resolveReference(nextReference, previousResult, (IProgressMonitor)subMon);
                rCache.addReference(nextReference, previousReference, resolutionResult);
            } else {
                if (Logger.SHOULD_TRACE_EVENT_DETAILED) {
                    Logger.trace(Logger.Category.EVENT_DETAILED, "Bypassing resolver (using cache). Reference " + referenceChain + " using cached resolution " + cached, new Throwable[0]);
                }
                ResolvedReference newRR = this.DATABASE.createNewResolvedReference();
                newRR.setBrokenStatus(cached.getBrokenStatus());
                newRR.setProviderId(cached.getProviderId());
                newRR.setReference(nextReference);
                newRR.setBrokenLinkInfo(cached.getModelInstanceIdReference());
                newRR.setTarget(cached.getTarget());
                newRR.setNodeIdLinkTarget(cached.isNodeIdLinkTarget());
                newRR.freeze();
                resolutionResult = newRR;
                sub.newChild(1).worked(1);
            }
            if (resolutionResult == null) break;
            resolved.add(resolutionResult);
            previousResult = resolutionResult;
            previousReference = nextReference;
            nextReference = nextReference.getNextReference();
            if (resolutionResult.getBrokenStatus() == BrokenStatus.BROKEN || resolutionResult.getBrokenStatus() == BrokenStatus.IGNORED && resolutionResult.getTarget() == null) break;
        }
        return resolved;
    }

    public boolean shouldRun() {
        boolean shouldRun = false;
        if (this.shutdown || this.referenceManager.hasFatalError()) {
            shouldRun = false;
        } else {
            boolean bl = shouldRun = !this.getScheduler().isEmpty();
        }
        if (!shouldRun) {
            this.ensureUpToDate.set(false);
        }
        return shouldRun;
    }

    public void reset(IProgressMonitor monitor) throws FatalIOException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor);
        mon.subTask(Messages.ReferenceManager_clear_database);
        this.cancel();
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        LinkNode<IResource> root = this.referenceManager.getLinkNode((IResource)ResourcesPlugin.getWorkspace().getRoot());
        ReferenceEvent resetEvent = new ReferenceEvent(root, ReferenceEvent.Kind.RESET);
        this.eventsJob.notifyEvents(Collections.singletonList(resetEvent));
        if (this.scheduler.isDone()) {
            this.getScheduler().reset();
        }
        this.clearResolverCache();
        this.DATABASE.reset();
        ReferenceManager.getReferenceManager().clearError();
        mon.worked(1);
        monitor.done();
    }

    public void clearResolverCache() {
        ResolverCache rCache = this.resolverCache;
        if (rCache != null) {
            rCache.reset();
        }
    }

    public boolean shutdown(IProgressMonitor monitor) {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor);
        mon.beginTask(Messages.errorMsg_ReferenceProcessor_0, 3);
        this.getScheduler().shutdown();
        boolean safeShutdown = true;
        this.cancel();
        boolean interrupted = Thread.interrupted();
        while (true) {
            try {
                boolean success = this.activeLatch.await(20L, TimeUnit.SECONDS);
                if (success) break;
                safeShutdown = false;
            }
            catch (InterruptedException interruptedException) {
                interrupted = true;
                continue;
            }
            break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        this.markersJob.shutdown();
        if (this.markersJob.getState() != 0 || this.getState() != 0) {
            safeShutdown = false;
        }
        boolean bl = safeShutdown = safeShutdown && !ReferenceManager.getReferenceManager().hasFatalError();
        if (safeShutdown) {
            try {
                this.getScheduler().persistSavedState();
            }
            catch (Exception e) {
                Logger.logException("Unsafe processor shutdown, index will be rebuilt on startup", e);
                safeShutdown = false;
            }
        } else {
            Logger.logException("Unsafe processor shutdown, index will be rebuilt on startup", null);
        }
        this.shutdown = true;
        return safeShutdown;
    }

    public boolean belongsTo(Object family) {
        return family == ReferenceManager.class;
    }

    public void setUserInitiated() {
        Activator.getDefault().getStartupJob().setUserInitiated(true);
        this.ensureUpToDate.set(true);
        this.doSchedule(true);
    }

    public CreateOrUpdateMarkersJob getMarkerJob() {
        return this.markersJob;
    }

    private void runNow(IProgressMonitor monitor) {
        if (this.executingNow.compareAndSet(false, true)) {
            this.nowThread = Thread.currentThread();
            if (Logger.SHOULD_TRACE_REFERENCE_MANAGER) {
                Logger.trace(Logger.Category.REFERENCE_MANAGER, "Job Manager was suspended. Executing processor in non-job thread. ", new Throwable[]{null});
            }
            this.cancel();
            try {
                IStatus status = this.indexLoop(monitor);
                if (!status.isOK()) {
                    Logger.log(status);
                }
            }
            catch (RuntimeException e) {
                Status status = new Status(4, "com.ibm.etools.references", "Error during Reference Processing", (Throwable)e);
                Logger.log((IStatus)status);
            }
            this.nowThread = null;
            this.executingNow.set(false);
        }
    }

    public void boostPriority() {
        ThreadPriorityPolicy.boostPriority(this.getActiveThread(), Thread.currentThread());
    }

    public String getCurrentIndexItemLabel() {
        return this.currentLabel;
    }

    public Thread getActiveThread() {
        Thread t = this.nowThread;
        if (t != null) {
            return t;
        }
        return this.getThread();
    }

    public void transferRule(ISchedulingRule waitRule, SchedulerCondition condition) {
        if (InternalAPI.Tweaks.SHOULD_TRANSFER_RULE) {
            try {
                this.getScheduler().getLock().lock();
                if (this.getScheduler().hasWaitingConditions(condition)) {
                    try {
                        if (Logger.SHOULD_TRACE_REFERENCE_MANAGER) {
                            Logger.trace(Logger.Category.REFERENCE_MANAGER, "Transfer rule '" + waitRule + "' to thread '" + this.getActiveThread() + "'", new Throwable[]{null});
                            StackTraceElement[] stack = this.getActiveThread().getStackTrace();
                            int i = 0;
                            while (i < stack.length) {
                                StackTraceElement s = stack[i];
                                Logger.trace(Logger.Category.REFERENCE_MANAGER, s.toString(), new Throwable[]{null});
                                ++i;
                            }
                        }
                        Job.getJobManager().transferRule(waitRule, this.getActiveThread());
                        condition.setWaitThreadRule(Thread.currentThread(), waitRule);
                    }
                    catch (RuntimeException e) {
                        Logger.logException("Error transfering rule from waiting thread to indexer", e);
                    }
                }
            }
            finally {
                this.getScheduler().getLock().unlock();
            }
        }
    }

    public void cancelRequestIndexing(IProgressMonitor monitor) {
        if (!this.scheduler.isDone()) {
            return;
        }
        this.getScheduler().cancelRequestIndexing(monitor);
    }

    final class CreateScheduler
    implements Callable<Scheduler> {
        CreateScheduler() {
        }

        @Override
        public Scheduler call() throws Exception {
            return new Scheduler(ReferenceProcessor.this, ReferenceProcessor.this.referenceManager);
        }
    }

    private class IDLinkProxy {
        private final LinksDelta delta;
        private ILink link;
        private boolean ran;

        public IDLinkProxy(LinksDelta delta) {
            this.delta = delta;
        }

        public ILink getIDLink() {
            if (!this.ran) {
                this.link = ReferenceProcessor.this.getResourceIdLink(this.delta);
                this.ran = true;
            }
            return this.link;
        }
    }

    static class LinkAndReferenceType {
        final ILink link;
        final Collection<String> refTypes;

        public LinkAndReferenceType(ILink link, Collection<String> refTypes) {
            Assert.isNotNull((Object)link, (String)"Link can not be null");
            Assert.isNotNull(refTypes, (String)Messages.ReferenceProcessor_10);
            this.link = link;
            this.refTypes = refTypes;
        }

        public String toString() {
            String s = "{[" + this.link + "][";
            for (String rType : this.refTypes) {
                s = String.valueOf(s) + rType + ",";
            }
            s = String.valueOf(s) + "]}";
            return s;
        }
    }

    static final class LinkModelInfo {
        ILink link;
        String forModelId;

        public LinkModelInfo(ILink detectedLink, String nodeId) {
            this.link = detectedLink;
            this.forModelId = nodeId;
        }
    }

    static final class LinksDelta {
        Collection<ILink> removedLinks = Collections.emptyList();
        Collection<ILink> addedLinks = Collections.emptyList();
        Collection<ILink> updatedLinks = Collections.emptyList();

        LinksDelta() {
        }

        public String toString() {
            String s = "REMOVED:\n";
            for (ILink link : this.removedLinks) {
                s = String.valueOf(s) + "\t" + link + "\n";
            }
            s = String.valueOf(s) + "ADDED:\n";
            for (ILink link : this.addedLinks) {
                s = String.valueOf(s) + "\t" + link + "\n";
            }
            s = String.valueOf(s) + "UPDATED:\n";
            for (ILink link : this.updatedLinks) {
                s = String.valueOf(s) + "\t" + link + "\n";
            }
            return s;
        }
    }
}

