/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.management;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.internal.bplustree.db.FatalIOException;
import com.ibm.etools.references.internal.bplustree.db.PooledByteBuffer;
import com.ibm.etools.references.internal.bplustree.tree.ByteUtils;
import com.ibm.etools.references.internal.index.IdentityLinkedSet;
import com.ibm.etools.references.internal.index.IndexConstants;
import com.ibm.etools.references.internal.index.IndexManager;
import com.ibm.etools.references.internal.index.InternalReferenceObject;
import com.ibm.etools.references.internal.index.InternalReferenceRecord;
import com.ibm.etools.references.internal.index.keys.LinkKey;
import com.ibm.etools.references.internal.search.InternalSearchPattern;
import com.ibm.etools.references.internal.services.BrokenReferenceStrategyService;
import com.ibm.etools.references.internal.services.LinkTypeRegistry;
import com.ibm.etools.references.internal.services.ReferenceGeneratorService;
import com.ibm.etools.references.internal.services.Service;
import com.ibm.etools.references.internal.util.Util;
import com.ibm.etools.references.management.BrokenReference;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.management.SpecializedType;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.search.DefaultSearchRequestor;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.search.SearchPattern;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.references.services.providers.IProvider;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.internal.filebuffers.TextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public final class Link
extends InternalReferenceObject
implements ILink {
    private FutureTask<String> docContextRetriever;
    private Map<String, String> parameters;
    LinkNode<IResource> container;
    SpecializedType specializedType;
    TextRange contextLocation;
    TextRange location;
    String linktext;
    String contextText;
    IPath path;
    boolean endpoint;
    public final Record record = new Record(this);
    private String name;
    int resourceType;
    private List<LinkKey> originalKeys;
    private boolean crossProjectAddressable = false;

    public Link() {
        this.record.dirty = true;
    }

    @Override
    public final IReferenceElement.ElementType getElementType() {
        return IReferenceElement.ElementType.LINK;
    }

    @Override
    public LinkNode<IResource> getContainer() {
        this.loadData();
        return this.container;
    }

    @Override
    public Object getAdapter(Class adapter) {
        return this.getAdapterFor(adapter);
    }

    public <T> T getAdapterFor(Class<T> adapter) {
        IProvider p;
        if (adapter.isAssignableFrom(this.getClass())) {
            return adapter.cast(this);
        }
        if (IProvider.class.isAssignableFrom(adapter) && (p = InternalAPI.getProviderById(this.getProviderId())) != null) {
            try {
                return adapter.cast(p);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return adapter.cast(Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName()));
    }

    @Override
    public TextRange getContextLocation() {
        this.loadData();
        return this.contextLocation;
    }

    @Override
    public TextRange getLinkLocation() {
        this.loadData();
        return this.location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getContextText() {
        Record record = this.record;
        synchronized (record) {
            block11: {
                block10: {
                    block9: {
                        this.loadData();
                        if (this.docContextRetriever != null) {
                            return this.getString(this.docContextRetriever);
                        }
                        if (this.container == null) {
                            return this.contextText;
                        }
                        if (this.container.getResource().getType() == 1) break block9;
                        return null;
                    }
                    if (this.contextLocation != null) break block10;
                    return null;
                }
                if (this.contextLocation.getLength() != 0) break block11;
                return "";
            }
            final TextRange cLoc = this.contextLocation;
            this.docContextRetriever = new FutureTask<String>(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    String string;
                    block7: {
                        boolean connected = false;
                        try {
                            TextFileBufferManager.DEFAULT.connect(Link.this.getPath(), LocationKind.IFILE, null);
                            connected = true;
                            ITextFileBuffer buffer = (ITextFileBuffer)TextFileBufferManager.DEFAULT.getFileBuffer(Link.this.getPath(), LocationKind.IFILE);
                            string = buffer.getDocument().get(cLoc.getOffset(), cLoc.getLength());
                            if (!connected) break block7;
                        }
                        catch (Throwable throwable) {
                            if (connected) {
                                try {
                                    TextFileBufferManager.DEFAULT.disconnect(Link.this.getPath(), LocationKind.IFILE, null);
                                }
                                catch (CoreException coreException) {}
                            }
                            throw throwable;
                        }
                        try {
                            TextFileBufferManager.DEFAULT.disconnect(Link.this.getPath(), LocationKind.IFILE, null);
                        }
                        catch (CoreException coreException) {}
                    }
                    return string;
                }
            });
        }
        if (this.docContextRetriever != null) {
            this.docContextRetriever.run();
            return this.getString(this.docContextRetriever);
        }
        return this.contextText;
    }

    private String getString(FutureTask<String> record) {
        boolean interrupted = Thread.interrupted();
        while (true) {
            try {
                String string = record.get();
                return string;
            }
            catch (InterruptedException interruptedException) {
                interrupted = true;
                continue;
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof FatalIOException) {
                    throw (FatalIOException)e.getCause();
                }
                if (e.getCause() instanceof ReferenceException) {
                    throw (ReferenceException)e.getCause();
                }
                Status status = new Status(4, "com.ibm.etools.references", "Error getting context range from document: " + this.getPath() + " range " + this.getContextLocation(), e.getCause());
                throw new ReferenceException((IStatus)status);
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public String getLinkText() {
        this.loadData();
        return this.linktext;
    }

    @Override
    public boolean isEndPoint() {
        this.loadData();
        return this.endpoint;
    }

    @Override
    public boolean isCrossProjectAddressable() {
        this.loadData();
        return this.crossProjectAddressable;
    }

    @Override
    public SpecializedType getSpecializedType() {
        this.loadData();
        return this.specializedType;
    }

    @Override
    public InternalReferenceRecord getRecord() {
        return this.record;
    }

    @Override
    public Collection<IResolvedReference> resolveReference(String referenceType, IProgressMonitor monitor) throws ReferenceException {
        return this.resolveReference(referenceType, SearchEngine.createWorkspaceScope(), monitor);
    }

    @Override
    public Collection<IResolvedReference> resolveReference(String referenceType, SearchScope scope, IProgressMonitor progressMonitor) throws ReferenceException {
        Set<IResolvedReference> matches = this.getResolvedReferences(scope, progressMonitor, false);
        if (referenceType == null) {
            return matches;
        }
        HashSet<IResolvedReference> references = new HashSet<IResolvedReference>();
        for (IResolvedReference rr : matches) {
            String refType = rr.getReferenceType();
            if (refType == null || !refType.equals(referenceType)) continue;
            references.add(rr);
        }
        return references;
    }

    @Override
    public Collection<IResolvedReference> resolveIncomingReference(String referenceType, IProgressMonitor monitor) throws ReferenceException {
        return this.resolveIncomingReference(referenceType, SearchEngine.createWorkspaceScope(), monitor);
    }

    @Override
    public Collection<IResolvedReference> resolveIncomingReference(String referenceType, SearchScope scope, IProgressMonitor progressMonitor) throws ReferenceException {
        Set<IResolvedReference> matches = this.getResolvedReferences(scope, progressMonitor, true);
        if (referenceType == null) {
            return matches;
        }
        HashSet<IResolvedReference> references = new HashSet<IResolvedReference>();
        for (IResolvedReference rr : matches) {
            String refType = rr.getReferenceType();
            if (refType == null || !refType.equals(referenceType)) continue;
            references.add(rr);
        }
        return references;
    }

    private Set<IResolvedReference> getResolvedReferences(SearchScope scope, IProgressMonitor monitor, boolean incoming) throws ReferenceException {
        if (!incoming && this.isEndPoint()) {
            return Collections.emptySet();
        }
        IndexConstants constant = incoming ? IndexConstants.BY_TARGETLINKID : IndexConstants.BY_SOURCELINKID;
        SearchPattern pattern = InternalSearchPattern.createPattern(Integer.toString(this.getId()), constant, IReferenceElement.ElementType.RESOLVED_REFERENCE, 0);
        DefaultSearchRequestor req = new DefaultSearchRequestor();
        new SearchEngine().search(pattern, scope, req, monitor);
        Set<IResolvedReference> matches = req.getMatches();
        return matches;
    }

    @Override
    public Collection<BrokenReference> findBrokenReferences(IProgressMonitor monitor) throws ReferenceException {
        Set<IResolvedReference> matches = this.getResolvedReferences(SearchEngine.createWorkspaceScope(), monitor, false);
        Collection<BrokenReference> broken = BrokenReferenceStrategyService.getInstance().findBrokenReferences(this, matches);
        return broken;
    }

    @Override
    public List<String> getReferenceTypes() {
        return ReferenceGeneratorService.getInstance().getGenerableTypes(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        String s;
        if (InternalAPI.LOAD_DATA_FOR_TO_STRING) {
            Record record = this.record;
            synchronized (record) {
                this.record.loadData();
            }
        }
        if (this.record.isFullyLoaded()) {
            String string = this.getElementType() == null ? "null" : (s = String.valueOf(this.getElementType().name()) + " " + super.toString() + " Type: [" + (this.getSpecializedType() == null ? "null" : this.getSpecializedType().getId()) + "] LinkText: [" + this.getLinkText() + "] " + " Name: [" + this.getName() + "] Path: [" + (this.getPath() == null ? "null" : this.getPath().toString()) + "]");
            if (this.parameters != null) {
                s = String.valueOf(s) + " " + this.parameters.size() + " Parameters: ";
                for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
                    s = String.valueOf(s) + "[" + entry.getKey() + "]=[" + entry.getValue() + "], ";
                }
            }
            if (this.providerId >= 0) {
                s = String.valueOf(s) + " Provided by: " + Service.getProviderType(this.providerId);
            }
            return s;
        }
        s = this.getElementType() == null ? "null" : String.valueOf(this.getElementType().name()) + " " + "Proxy object: " + super.toString();
        return s;
    }

    @Override
    public String getName() {
        this.loadData();
        return this.name;
    }

    @Override
    public void getObjectGraph(IdentityLinkedSet<InternalReferenceObject> graph, Map<Object, Object> objMarkers) {
        graph.add(this);
    }

    public Map<String, String> getParameters() {
        this.loadData();
        return this.parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParameter(String key, String value) {
        Record record = this.record;
        synchronized (record) {
            this.loadData();
            if (this.parameters == null) {
                this.parameters = new HashMap<String, String>();
            }
            this.parameters.put(key, value);
            this.record.dirty = true;
        }
    }

    @Override
    public String getParameter(String key) {
        this.loadData();
        if (this.parameters != null) {
            return this.parameters.get(key);
        }
        return null;
    }

    private void saveOriginal() {
        this.loadData();
        if (this.frozen && this.originalKeys == null) {
            this.originalKeys = IndexManager.getKeys(this);
        }
    }

    @Override
    protected List<LinkKey> getOriginalKeys() {
        return this.originalKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContainer(LinkNode<IResource> container) {
        Record record = this.record;
        synchronized (record) {
            this.loadData();
            if (!Util.isEqualOrBothNull(this.container, container)) {
                Assert.isTrue((this.path == null ? 1 : 0) != 0, (String)"Path must be null when container is set");
                this.saveOriginal();
                this.container = container;
                this.resourceType = container.getResource().getType();
                this.record.dirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPath(IPath path) {
        Record record = this.record;
        synchronized (record) {
            this.loadData();
            if (!Util.isEqualOrBothNull(this.path, path)) {
                Assert.isTrue((this.container == null ? 1 : 0) != 0, (String)"Container must be null when path is set");
                this.saveOriginal();
                this.resourceType = 0;
                this.record.dirty = true;
                this.path = path;
            }
        }
    }

    @Override
    public IPath getPath() {
        this.loadData();
        if (this.resourceType == 0) {
            return this.path;
        }
        return this.getContainer().getResource().getFullPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSpecializedType(SpecializedType specializedType) {
        Record record = this.record;
        synchronized (record) {
            this.loadData();
            if (!Util.isEqualOrBothNull(this.specializedType, specializedType)) {
                this.saveOriginal();
                this.specializedType = specializedType;
                this.record.dirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setContextLocation(TextRange contextLocation) {
        Record record = this.record;
        synchronized (record) {
            block4: {
                this.loadData();
                if (Util.isEqualOrBothNull(this.contextLocation, contextLocation)) break block4;
                this.saveOriginal();
                this.contextLocation = contextLocation;
                this.record.dirty = true;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCrossProjectAddressable(boolean crossProjectAddressable) {
        Record record = this.record;
        synchronized (record) {
            this.loadData();
            if (!Util.isEqualOrBothNull(this.crossProjectAddressable, crossProjectAddressable)) {
                this.saveOriginal();
                this.crossProjectAddressable = crossProjectAddressable;
                this.record.dirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setLocation(TextRange location) {
        Record record = this.record;
        synchronized (record) {
            block4: {
                this.loadData();
                if (Util.isEqualOrBothNull(this.location, location)) break block4;
                this.saveOriginal();
                this.location = location;
                this.record.dirty = true;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setText(String text) {
        Record record = this.record;
        synchronized (record) {
            block4: {
                this.loadData();
                if (Util.isEqualOrBothNull(this.linktext, text)) break block4;
                this.saveOriginal();
                this.linktext = text;
                this.record.dirty = true;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setContextText(String contextText) {
        Record record = this.record;
        synchronized (record) {
            block6: {
                boolean equal;
                this.loadData();
                try {
                    equal = Util.isEqualOrBothNull(this.getContextText(), contextText);
                }
                catch (RuntimeException runtimeException) {
                    equal = false;
                }
                if (equal) break block6;
                this.saveOriginal();
                this.contextText = contextText;
                this.record.dirty = true;
                this.docContextRetriever = new FutureTask<String>(new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return Link.this.contextText;
                    }
                });
                this.docContextRetriever.run();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEndpoint(boolean endpoint) {
        Record record = this.record;
        synchronized (record) {
            this.loadData();
            if (this.endpoint != endpoint) {
                this.saveOriginal();
                this.endpoint = endpoint;
                this.record.dirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String name) {
        Record record = this.record;
        synchronized (record) {
            this.loadData();
            if (!Util.isEqualOrBothNull(this.name, name)) {
                this.saveOriginal();
                this.name = name;
                this.record.dirty = true;
            }
        }
    }

    @Override
    protected void clearOriginalKeys() {
        this.originalKeys = null;
    }

    public String getCachingKey() {
        this.loadData();
        StringBuilder b = new StringBuilder();
        b.append(this.getSpecializedType().getTypeid());
        b.append(this.getPath());
        b.append(this.getName());
        b.append("|");
        b.append(this.getLinkLocation().getLinenumber());
        b.append("|");
        b.append(this.getLinkLocation().getOffset());
        b.append("|");
        b.append(this.getLinkLocation().getLength());
        b.append("|");
        b.append(this.getContextLocation().getLinenumber());
        b.append("|");
        b.append(this.getContextLocation().getOffset());
        b.append("|");
        b.append(this.getContextLocation().getLength());
        b.append("|");
        b.append(this.getLinkText());
        b.append("|");
        b.append(this.getContextText());
        b.append("|");
        Map<String, String> params = this.getParameters();
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                String key = entry.getKey();
                String val = entry.getValue();
                b.append(key);
                b.append("|");
                b.append(val);
                b.append("|");
            }
        }
        return b.toString();
    }

    static class Record
    extends InternalReferenceRecord {
        private final Link link;
        boolean dirty;

        public Record(Link link) {
            super(link.getElementType().ordinal());
            this.link = link;
        }

        @Override
        protected void clean() {
            this.dirty = false;
        }

        @Override
        public boolean isDirty() {
            return this.dirty;
        }

        @Override
        public void doReadRecord(PooledByteBuffer bytes) {
            this.link.endpoint = ByteUtils.bytesToBoolean(bytes.buffer);
            this.link.crossProjectAddressable = ByteUtils.bytesToBoolean(bytes.buffer);
            this.link.resourceType = ByteUtils.bytesToUnsignedShort(bytes.buffer);
            String pathName = ByteUtils.bytesToString(bytes.buffer);
            if (this.link.resourceType == 0) {
                if (pathName != null) {
                    this.link.path = new Path(pathName);
                }
            } else {
                IFile file = null;
                if (this.link.resourceType == 1) {
                    file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(pathName));
                } else if (this.link.resourceType == 2) {
                    file = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(pathName));
                } else if (this.link.resourceType == 4) {
                    file = ResourcesPlugin.getWorkspace().getRoot().getProject(pathName);
                } else {
                    Assert.isLegal((boolean)false, (String)"Unknown resource type");
                }
                this.link.container = ReferenceManager.getReferenceManager().getLinkNode((IResource)file);
            }
            this.link.contextLocation = new TextRange(0, 0, 0);
            this.link.contextLocation.readRecord(new PooledByteBuffer(bytes.buffer));
            this.link.location = new TextRange(0, 0, 0);
            this.link.location.readRecord(new PooledByteBuffer(bytes.buffer));
            int typeId = ByteUtils.bytesToUnsignedShort(bytes.buffer);
            this.link.specializedType = LinkTypeRegistry.getInstance().getLinkByTypeId(typeId);
            if (this.link.resourceType == 0) {
                this.link.linktext = ByteUtils.bytesToString(bytes.buffer);
                this.link.contextText = ByteUtils.bytesToString(bytes.buffer);
            } else {
                this.link.linktext = ByteUtils.bytesToString(bytes.buffer);
            }
            this.link.name = ByteUtils.bytesToString(bytes.buffer);
            int parameterSize = ByteUtils.bytesToInt(bytes.buffer);
            this.link.parameters = new HashMap(parameterSize);
            int i = 0;
            while (i < parameterSize) {
                String e = ByteUtils.bytesToString(bytes.buffer);
                String v = ByteUtils.bytesToString(bytes.buffer);
                this.link.parameters.put(e, v);
                ++i;
            }
            this.link.providerId = ByteUtils.bytesToUnsignedShort(bytes.buffer);
            bytes.returnBuffer();
            this.clean();
            this.link.freeze();
        }

        @Override
        public PooledByteBuffer doWriteRecord() {
            TextRange range;
            ArrayList<ByteBuffer> savedBuffers = new ArrayList<ByteBuffer>();
            ByteBuffer tmp = ByteUtils.booleanToBytes(this.link.endpoint);
            savedBuffers.add(tmp);
            tmp = ByteUtils.booleanToBytes(this.link.crossProjectAddressable);
            savedBuffers.add(tmp);
            tmp = ByteUtils.unsignedShortToBytes(this.link.resourceType);
            savedBuffers.add(tmp);
            if (this.link.getPath() != null) {
                tmp = ByteUtils.stringToBytes(this.link.getPath().toPortableString());
                savedBuffers.add(tmp);
            } else {
                tmp = ByteUtils.stringToBytes(null);
                savedBuffers.add(tmp);
            }
            if (this.link.contextLocation != null) {
                PooledByteBuffer buffer2 = this.link.contextLocation.writeRecord();
                savedBuffers.add(buffer2.copy());
                buffer2.returnBuffer();
            } else {
                range = new TextRange(0, 0, 0);
                PooledByteBuffer pooledByteBuffer = range.writeRecord();
                savedBuffers.add(pooledByteBuffer.copy());
                pooledByteBuffer.returnBuffer();
            }
            if (this.link.location != null) {
                PooledByteBuffer buffer = this.link.location.writeRecord();
                savedBuffers.add(buffer.copy());
                buffer.returnBuffer();
            } else {
                range = new TextRange(0, 0, 0);
                PooledByteBuffer pooledByteBuffer = range.writeRecord();
                savedBuffers.add(pooledByteBuffer.copy());
                pooledByteBuffer.returnBuffer();
            }
            tmp = ByteUtils.unsignedShortToBytes(this.link.specializedType.getTypeid());
            savedBuffers.add(tmp);
            if (this.link.resourceType == 0) {
                tmp = ByteUtils.stringToBytes(this.link.linktext);
                savedBuffers.add(tmp);
                tmp = ByteUtils.stringToBytes(this.link.contextText);
                savedBuffers.add(tmp);
            } else {
                tmp = ByteUtils.stringToBytes(this.link.linktext);
                savedBuffers.add(tmp);
            }
            tmp = ByteUtils.stringToBytes(this.link.name);
            savedBuffers.add(tmp);
            if (this.link.parameters != null) {
                savedBuffers.add(ByteUtils.intToBytes(this.link.parameters.size()));
                for (Map.Entry entry : this.link.parameters.entrySet()) {
                    ByteBuffer byteBuffer = ByteUtils.stringToBytes((String)entry.getKey());
                    savedBuffers.add(byteBuffer);
                    ByteBuffer value = ByteUtils.stringToBytes((String)entry.getValue());
                    savedBuffers.add(value);
                }
            } else {
                savedBuffers.add(ByteUtils.intToBytes(0));
            }
            tmp = ByteUtils.unsignedShortToBytes(this.link.providerId);
            savedBuffers.add(tmp);
            int size = 0;
            for (ByteBuffer byteBuffer : savedBuffers) {
                size += byteBuffer.limit();
            }
            PooledByteBuffer pooledByteBuffer = PooledByteBuffer.INSTANCE.leaseByteBuffer(size);
            for (ByteBuffer byteBuffer : savedBuffers) {
                pooledByteBuffer.buffer.put(byteBuffer);
            }
            pooledByteBuffer.buffer.rewind();
            return pooledByteBuffer;
        }

        @Override
        public int getSize() {
            int size = 5 + ByteUtils.storageSize(this.link.getPath().toPortableString()) + this.link.contextLocation.storageSize() + this.link.location.storageSize() + ByteUtils.storageSize(this.link.name) + 4 + 2 + 1;
            if (this.link.resourceType == 0) {
                size += ByteUtils.storageSize(this.link.linktext);
                size += ByteUtils.storageSize(this.link.contextText);
            } else {
                size += ByteUtils.storageSize(this.link.linktext);
            }
            if (this.link.parameters != null) {
                for (Map.Entry entry : this.link.parameters.entrySet()) {
                    size += ByteUtils.storageSize((String)entry.getKey());
                    size += ByteUtils.storageSize((String)entry.getValue());
                }
            }
            return size;
        }

        @Override
        protected InternalReferenceObject getLinkArtifact() {
            return this.link;
        }

        @Override
        protected Collection<? extends IReferenceElement> getDeleteCascade() {
            SearchPattern pattern = InternalSearchPattern.createPattern(Integer.toString(this.link.getId()), IndexConstants.BY_SOURCELINKID, IReferenceElement.ElementType.REFERENCE, 0);
            SearchScope scope = SearchEngine.createWorkspaceScope();
            DefaultSearchRequestor req = new DefaultSearchRequestor();
            new SearchEngine().search(pattern, scope, req, null);
            return req.getMatches();
        }
    }
}

