/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.management;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.Logger;
import com.ibm.etools.references.events.ErrorEvent;
import com.ibm.etools.references.events.IErrorListener;
import com.ibm.etools.references.events.IJobCanceledListener;
import com.ibm.etools.references.events.IReferenceListener;
import com.ibm.etools.references.internal.Activator;
import com.ibm.etools.references.internal.ReferencesPreferencesAccess;
import com.ibm.etools.references.internal.index.IndexManager;
import com.ibm.etools.references.internal.index.ReferenceDatabase;
import com.ibm.etools.references.internal.management.ErrorRecovery;
import com.ibm.etools.references.internal.management.JobRunner;
import com.ibm.etools.references.internal.management.Link;
import com.ibm.etools.references.internal.management.MonitorPolicy;
import com.ibm.etools.references.internal.management.ReferenceProcessor;
import com.ibm.etools.references.internal.nls.Messages;
import com.ibm.etools.references.internal.resource.FileVisitor;
import com.ibm.etools.references.internal.resource.ReferenceManagerStartupJob;
import com.ibm.etools.references.internal.resource.ResourceVisitor;
import com.ibm.etools.references.internal.search.InternalSearchEngine;
import com.ibm.etools.references.internal.services.LinkDetectorService;
import com.ibm.etools.references.internal.services.LinkNodeModelService;
import com.ibm.etools.references.internal.services.LinkTransformerService;
import com.ibm.etools.references.internal.services.LinkTypeRegistry;
import com.ibm.etools.references.internal.services.ReferenceGeneratorService;
import com.ibm.etools.references.internal.services.ReferenceResolverService;
import com.ibm.etools.references.management.BrokenReference;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.LinkPositionInfo;
import com.ibm.etools.references.management.ResourceChange;
import com.ibm.etools.references.management.SpecializedType;
import com.ibm.etools.references.management.Statistics;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.references.services.providers.ProviderArguments;
import com.ibm.etools.references.services.providers.SharedModel;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;

public abstract class InternalReferenceManager {
    public static final QualifiedName ICON = new QualifiedName("org.eclipse.ui.workbench.progress", "icon");
    private final ILock LOCK = Job.getJobManager().newLock();
    private final List<IJobCanceledListener> jobCanceled;
    private final List<IErrorListener> errorListeners;
    protected final ListenerList listeners;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    protected boolean override;
    protected boolean overrideSet;
    private volatile boolean shutdown;
    private boolean error;
    private final Semaphore semaphore;
    private final List<Thread> waitingThreads;
    private final ReferenceProcessor referenceProcessor;
    private InternalAPI.AbstractAnnotationModelDocumentProvider provider;
    private final Runnable EMPTY = new Runnable(){

        @Override
        public void run() {
        }
    };

    protected InternalReferenceManager() {
        this.jobCanceled = new ArrayList<IJobCanceledListener>(1);
        this.listeners = new ListenerList();
        this.errorListeners = new ArrayList<IErrorListener>();
        this.semaphore = new Semaphore(0);
        this.waitingThreads = Collections.synchronizedList(new ArrayList());
        this.referenceProcessor = new ReferenceProcessor(this);
    }

    public void add(IErrorListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(Messages.errorMsg_listenercannotbenull);
        }
        this.errorListeners.add(listener);
    }

    public void add(IJobCanceledListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(Messages.errorMsg_listenercannotbenull);
        }
        this.jobCanceled.add(listener);
    }

    public Collection<ILink> addReferenceListener(IReferenceListener listener) {
        Assert.isNotNull((Object)listener, (String)"Parameter cannot be null");
        this.listeners.add((Object)listener);
        return Collections.emptyList();
    }

    public void boostPriority() {
        this.getReferenceProcessor().getScheduler().boostPriority();
        this.getReferenceProcessor().boostPriority();
    }

    public void cancelIndexing(IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        sub.subTask(Messages.ReferenceManager_4);
        this.getReferenceProcessor().cancelRequestIndexing((IProgressMonitor)sub.newChild(1));
        this.getReferenceProcessor().cancel();
        try {
            this.getReferenceProcessor().join();
        }
        catch (OperationCanceledException operationCanceledException) {
            sub.setCanceled(true);
        }
        catch (InterruptedException interruptedException) {
            sub.setCanceled(true);
            Thread.currentThread().interrupt();
        }
    }

    public void clearError() {
        this.clearOverride();
        this.error = false;
    }

    public void clearOverride() {
        this.overrideSet = false;
    }

    public String contractLinkText(ILink link, String prevText, Set<ProviderArguments> args) {
        try {
            SearchEngine.setSearchHint(EnumSet.of(SearchEngine.SearchHint.NOWAIT));
            String string = LinkTransformerService.getInstance().contract(link, prevText, args, LinkTransformerService.getInstance().newCache());
            return string;
        }
        finally {
            SearchEngine.clearSearchHint(EnumSet.of(SearchEngine.SearchHint.NOWAIT));
        }
    }

    public String contractLinkText(SpecializedType linkType, String linkText, IResource linkContainer, Set<ProviderArguments> args) {
        Assert.isNotNull((Object)linkType, (String)"linkType cannot be null");
        Assert.isNotNull((Object)linkType, (String)"linkText cannot be null");
        Assert.isNotNull((Object)linkType, (String)"linkContainer cannot be null");
        Assert.isNotNull((Object)linkType, (String)"args cannot be null");
        LinkNode<IResource> r = this.getLinkNode(linkContainer);
        Link link = ReferenceDatabase.getDefault().createNewLink();
        link.setContainer(r);
        link.setContextLocation(TextRange.EMPTY);
        link.setLocation(TextRange.EMPTY);
        link.setText(linkText);
        link.setEndpoint(false);
        link.setProviderId(-1);
        link.setSpecializedType(linkType);
        return this.contractLinkText(link, linkText, args);
    }

    public void createMarkersFor(List<BrokenReference> references) {
        this.getReferenceProcessor().getMarkerJob().createMarkersFor(references);
    }

    public void doRateLimit(int priority) {
        int delay = priority < 5 ? InternalAPI.Tweaks.INDEX_RATE_LIMIT_BACKGROUND : InternalAPI.Tweaks.INDEX_RATE_LIMIT_FOREGROUND;
        if (delay == -2) {
            Thread.yield();
        } else if (delay != -1) {
            this.rateLimit(delay);
        }
    }

    public void rateLimit(int nanos) {
        ScheduledFuture<?> future = InternalAPI.getScheduled().schedule(this.EMPTY, (long)nanos, TimeUnit.NANOSECONDS);
        try {
            future.get();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {}
    }

    public String expandLinkText(ILink link, Set<ProviderArguments> args) {
        if (link.getLinkText() == null) {
            return null;
        }
        try {
            SearchEngine.setSearchHint(EnumSet.of(SearchEngine.SearchHint.NOWAIT));
            String string = LinkTransformerService.getInstance().expand(link, link.getLinkText(), args, LinkTransformerService.getInstance().newCache());
            return string;
        }
        finally {
            SearchEngine.clearSearchHint(EnumSet.of(SearchEngine.SearchHint.NOWAIT));
        }
    }

    public String expandLinkText(SpecializedType linkType, String linkText, IResource linkContainer, Set<ProviderArguments> args) {
        Assert.isNotNull((Object)linkType, (String)"linkType cannot be null");
        Assert.isNotNull((Object)linkType, (String)"linkText cannot be null");
        Assert.isNotNull((Object)linkType, (String)"linkContainer cannot be null");
        Assert.isNotNull((Object)linkType, (String)"args cannot be null");
        LinkNode<IResource> r = this.getLinkNode(linkContainer);
        Link link = ReferenceDatabase.getDefault().createNewLink();
        link.setContainer(r);
        link.setContextLocation(TextRange.EMPTY);
        link.setLocation(TextRange.EMPTY);
        link.setText(linkText);
        link.setEndpoint(false);
        link.setProviderId(-1);
        link.setSpecializedType(linkType);
        return this.expandLinkText(link, args);
    }

    private IStatus forceInit(ISchedulingRule currentRule, SubMonitor sub, ReferenceManagerStartupJob startupJob) {
        IStatus status = Status.CANCEL_STATUS;
        if (!(currentRule != null && !currentRule.contains(startupJob.getRunNowRule()) || this.initialized.get() || startupJob.isStarted() || startupJob.isFinished())) {
            startupJob.cancel();
            status = startupJob.runNow((IProgressMonitor)sub.newChild(1));
            this.setInitialized();
        }
        return status;
    }

    public InternalAPI.AbstractAnnotationModelDocumentProvider getAnnotationModelDocumentProvider() {
        if (this.provider == null) {
            return InternalAPI.AbstractAnnotationModelDocumentProvider.NULL;
        }
        return this.provider;
    }

    public int getBrokenLinkSeverity() {
        IPreferencesService preferencesService = Platform.getPreferencesService();
        IScopeContext[] lookupOrder = new IScopeContext[]{new InstanceScope(), new DefaultScope()};
        int sev = preferencesService.getInt("com.ibm.etools.references", "referenceBrokenLinkSeverity", 1, lookupOrder);
        return sev;
    }

    public List<IErrorListener> getErrorListeners() {
        return Collections.unmodifiableList(this.errorListeners);
    }

    public abstract LinkNode<IFile> getLinkNode(IFile var1);

    public abstract LinkNode<IResource> getLinkNode(IResource var1);

    public SpecializedType getLinkType(String id) {
        return LinkTypeRegistry.getInstance().getLinkType(id);
    }

    public IJobCanceledListener getListener() {
        if (this.jobCanceled.size() >= 1) {
            return this.jobCanceled.get(0);
        }
        return null;
    }

    public List<IReferenceListener> getListeners() {
        Object[] list = this.listeners.getListeners();
        ArrayList<IReferenceListener> listener = new ArrayList<IReferenceListener>(list.length);
        Object[] objectArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            listener.add((IReferenceListener)o);
            ++n2;
        }
        return listener;
    }

    public Collection<SpecializedType> getMatchingLinkTypes(String propertyKey, String propertyValue) {
        return LinkTypeRegistry.getInstance().getMatchingLinks(propertyKey, propertyValue);
    }

    public ReferenceProcessor getReferenceProcessor() {
        return this.referenceProcessor;
    }

    private Collection<IResource> getResourcesAndChildren(Set<IResource> resources) {
        HashSet<IResource> allResources = new HashSet<IResource>();
        FileVisitor visitor = new FileVisitor();
        for (IResource resource : resources) {
            try {
                resource.accept((IResourceVisitor)visitor);
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
        allResources.addAll(visitor.getFiles());
        return allResources;
    }

    public Statistics getStatistics() {
        return new Statistics();
    }

    public boolean hasFatalError() {
        return this.error;
    }

    public void internalWaitForInit(IProgressMonitor monitor) {
        if (this.initialized.get()) {
            return;
        }
        Job currentJob = Job.getJobManager().currentJob();
        ISchedulingRule currentRule = currentJob != null ? currentJob.getRule() : null;
        boolean useWaitJobWithRule = currentJob == null || currentJob.getRule() == null;
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)-1);
        ReferenceManagerStartupJob startupJob = Activator.getDefault().getStartupJob();
        long start = System.currentTimeMillis();
        while (!this.initialized.get()) {
            boolean gotLock;
            block28: {
                IStatus didRun;
                gotLock = false;
                if (Job.getJobManager().isSuspended()) {
                    didRun = this.forceInit(currentRule, sub, startupJob);
                    if (didRun.getSeverity() == 8) {
                        long delta = System.currentTimeMillis() - start;
                        if (delta > 10000L) {
                            throw new RuntimeException("Could not initialize link indexer (after waiting 10 seconds) and the WorkspaceRoot rule was not available. This exception is being thrown to prevent deadlock.");
                        }
                        sub.subTask(Messages.errorMsg_waiting_for_init);
                        gotLock = this.tryLock();
                    }
                } else if (this.waitingThreads.contains(Thread.currentThread())) {
                    sub.subTask(Messages.errorMsg_waiting_for_init);
                    gotLock = this.tryLock();
                } else if (!startupJob.isStarted() && !startupJob.isFinished()) {
                    didRun = this.forceInit(currentRule, sub, startupJob);
                    if (didRun.getSeverity() == 8) {
                        sub.subTask(Messages.errorMsg_waiting_for_init);
                        gotLock = this.tryLock();
                    } else if (didRun.getSeverity() == 4) {
                        InternalAPI.handleFrameworkException(ErrorRecovery.STARTUP_ERROR, Messages.errorMsg_errorsduringstartup, (Exception)didRun.getException(), EnumSet.of(ErrorEvent.PresentationHints.LOG, ErrorEvent.PresentationHints.BLOCK), true);
                    }
                } else {
                    try {
                        this.waitingThreads.add(Thread.currentThread());
                        if (useWaitJobWithRule) {
                            OperationCanceledException canceled;
                            block27: {
                                canceled = null;
                                JobRunner runner = new JobRunner(startupJob);
                                runner.runJob();
                                runner.waitForJobStart();
                                try {
                                    Job.getJobManager().beginRule(startupJob.getRule(), MonitorPolicy.monitorFor(monitor, (IProgressMonitor)sub.newChild(1)));
                                }
                                catch (IllegalArgumentException e) {
                                    Logger.logWarning(Logger.Category.DEBUG, Logger.Mode.DEV_MANDATORY, String.valueOf(this.getClass().getSimpleName()) + " is recovering from illegalPush: " + e.getMessage());
                                    sub.subTask(Messages.errorMsg_waiting_for_init);
                                    runner.cancel();
                                    gotLock = this.tryLock();
                                    Job.getJobManager().endRule(startupJob.getRule());
                                    break block27;
                                }
                                catch (OperationCanceledException e) {
                                    try {
                                        canceled = e;
                                        runner.cancel();
                                        break block27;
                                    }
                                    catch (Throwable throwable) {
                                        throw throwable;
                                    }
                                    finally {
                                        Job.getJobManager().endRule(startupJob.getRule());
                                    }
                                }
                                Job.getJobManager().endRule(startupJob.getRule());
                            }
                            if (canceled != null) {
                                throw canceled;
                            }
                            break block28;
                        }
                        sub.subTask(Messages.errorMsg_waiting_for_init);
                        gotLock = this.tryLock();
                    }
                    finally {
                        this.waitingThreads.remove(Thread.currentThread());
                    }
                }
            }
            if (gotLock) {
                this.semaphore.release();
            }
            if (sub.isCanceled()) break;
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    public boolean isBuiltIn(ILink link) {
        return "builtin.file.nodeid".equals(link.getSpecializedType().getId()) || "builtin.folder.nodeid".equals(link.getSpecializedType().getId()) || "builtin.project.nodeid".equals(link.getSpecializedType().getId());
    }

    public boolean isIgnored(IResource resource) {
        return this.getReferenceProcessor().getScheduler().containsLinks(resource);
    }

    public boolean isScopeReady(IProgressMonitor monitor, SearchScope scope) {
        return this.getReferenceProcessor().getScheduler().isScopeReady(monitor, scope);
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public boolean isSuspended() {
        if (this.overrideSet) {
            return this.override;
        }
        return InternalAPI.Tweaks.IS_SUSPENDED || ReferencesPreferencesAccess.INSTANCE.isSuspended();
    }

    public boolean isTestParseSpeedOnly() {
        return false;
    }

    @Deprecated
    public boolean isTrackingChanges() {
        return true;
    }

    @Deprecated
    public Collection<ILink> parseLinksOnly(IResource resource, Collection<String> modelIds, IProgressMonitor monitor) {
        if (resource == null) {
            return Collections.emptyList();
        }
        if (modelIds == null || modelIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ILink> links = new ArrayList<ILink>();
        LinkNodeModelService MODELSERVICE = LinkNodeModelService.getInstance();
        LinkDetectorService LINKDETECTOR = LinkDetectorService.getInstance();
        for (String id : modelIds) {
            SharedModel model = MODELSERVICE.getSharedModels(id, resource, Collections.<IResolvedReference>emptySet());
            if (model == null) continue;
            try {
                links.addAll(LINKDETECTOR.detectLinks(model, Collections.<IResolvedReference>emptySet(), Collections.<LinkPositionInfo>emptySet(), true));
            }
            finally {
                model.release();
            }
        }
        return links;
    }

    @Deprecated
    public Collection<ILink> parseLinksOnly(IResource resource, IProgressMonitor monitor) {
        if (resource == null) {
            return Collections.emptyList();
        }
        LinkNodeModelService MODELSERVICE = LinkNodeModelService.getInstance();
        Set<String> modelIds = MODELSERVICE.getNodeModelIds(resource);
        return this.parseLinksOnly(resource, modelIds, monitor);
    }

    public Collection<ILink> parseLinksOnly(Set<String> linkTypesFilter, SharedModel model, IProgressMonitor monitor) {
        Assert.isNotNull(linkTypesFilter, (String)Messages.ReferenceManager_0);
        Assert.isLegal((model != null ? 1 : 0) != 0, (String)Messages.ReferenceManager_1);
        LinkDetectorService LINKDETECTOR = LinkDetectorService.getInstance();
        List<ILink> links = LINKDETECTOR.detectLinks(model, Collections.<IResolvedReference>emptySet(), Collections.<LinkPositionInfo>emptySet(), true);
        if (!linkTypesFilter.isEmpty()) {
            Iterator<ILink> iterator = links.iterator();
            while (iterator.hasNext()) {
                ILink link = iterator.next();
                boolean found = false;
                for (String id : linkTypesFilter) {
                    if (!id.equals(link.getSpecializedType().getId())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                iterator.remove();
            }
        }
        return links;
    }

    public void processLinkDeltas(List<InternalAPI.LinkDelta> deltas) {
        this.getReferenceProcessor().getScheduler().processLinkDeltas(deltas);
    }

    public void reload() {
        this.waitUntilUptodate((IProgressMonitor)new NullProgressMonitor());
        ReferenceDatabase.getDefault().reload();
        IndexManager.reloadIndexes();
    }

    public void removeMarkerFor(IFile file) {
        this.getReferenceProcessor().getMarkerJob().removeMarkersFor(file);
        this.getReferenceProcessor().getMarkerJob().doSchedule();
    }

    public void removeMarkerFor(List<BrokenReference> references) {
        if (references.size() > 0) {
            this.getReferenceProcessor().getMarkerJob().removeMarkersFor(references);
            this.getReferenceProcessor().getMarkerJob().doSchedule();
        }
    }

    public void removeMarkerForLinks(List<ILink> links) {
        if (links.size() > 0) {
            this.getReferenceProcessor().getMarkerJob().removeMarkersForLinks(links);
            this.getReferenceProcessor().getMarkerJob().doSchedule();
        }
    }

    public void removeMarkers() {
        this.getReferenceProcessor().getMarkerJob().clear();
    }

    public void removeReferenceListener(IReferenceListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Deprecated
    public void requestAnalysis(IResource resource) {
        this.requestAnalysis(Collections.singleton(resource), null);
    }

    @Deprecated
    public void requestAnalysis(Set<? extends IResource> resources, IProgressMonitor monitor) {
        Assert.isNotNull(resources, (String)"Parameter resource cannot be null");
        if (this.isSuspended()) {
            return;
        }
        if (resources.size() > 0) {
            if (Logger.SHOULD_TRACE_REFERENCE_MANAGER) {
                if (resources.size() == 1) {
                    Logger.trace(Logger.Category.REFERENCE_MANAGER, "Request deprecated analysis on " + resources.size() + " resources", new Throwable[]{null});
                } else {
                    Logger.trace(Logger.Category.REFERENCE_MANAGER, "Request deprecated analysis on " + resources.iterator().next().getFullPath(), new Throwable[]{null});
                }
            }
            ArrayList<ResourceChange> change = new ArrayList<ResourceChange>();
            for (IResource iResource : resources) {
                change.add(new ResourceChange(iResource, 4));
            }
            this.getReferenceProcessor().getScheduler().requestChangeAnalysis(change, monitor);
        }
    }

    public void requestChangeAnalysis(List<ResourceChange> changes, IProgressMonitor monitor) {
        Assert.isNotNull(changes, (String)"Parameter resource cannot be null");
        if (this.isSuspended()) {
            return;
        }
        if (changes.size() > 0) {
            if (Logger.SHOULD_TRACE_REFERENCE_MANAGER) {
                if (changes.size() == 1) {
                    Logger.trace(Logger.Category.REFERENCE_MANAGER, "Request change analysis on " + changes.iterator().next().getResource().getFullPath(), new Throwable[]{null});
                } else {
                    Logger.trace(Logger.Category.REFERENCE_MANAGER, "Request change analysis on " + changes.size() + " resources", new Throwable[]{null});
                }
            }
            this.getReferenceProcessor().getScheduler().requestChangeAnalysis(changes, monitor);
        }
    }

    public void requestChangeAnalysis(ResourceChange change, IProgressMonitor monitor) {
        Assert.isNotNull((Object)change, (String)Messages.ReferenceManager_3);
        this.requestChangeAnalysis(Collections.singletonList(change), monitor);
    }

    public void requestRebuildAllMarkers() {
        this.getReferenceProcessor().getMarkerJob().rebuildAllMarkers();
    }

    public void requestRebuildIndex(IProgressMonitor monitor) {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor);
        try {
            try {
                mon.beginTask("", 4);
                this.getAnnotationModelDocumentProvider().flushChanges((IProgressMonitor)mon.newChild(1));
                this.cancelIndexing((IProgressMonitor)mon.newChild(1));
                this.reset((IProgressMonitor)mon.newChild(1));
                this.clearError();
                if (this.isSuspended()) {
                    this.setOverrideSuspendedFlag(false);
                }
                if (Logger.SHOULD_TRACE_REFERENCE_MANAGER) {
                    Logger.trace(Logger.Category.REFERENCE_MANAGER, "FULL analysis", new Throwable[]{null});
                }
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                ResourceVisitor visitor = new ResourceVisitor();
                try {
                    workspace.getRoot().accept((IResourceVisitor)visitor);
                }
                catch (CoreException e) {
                    Logger.log(e.getStatus());
                }
                List<ResourceChange> changes = visitor.getChanges();
                this.requestChangeAnalysis(changes, (IProgressMonitor)mon.newChild(1));
            }
            catch (Exception e) {
                InternalAPI.handleFrameworkException(InternalAPI.REBUILD_DB_ERROR, Messages.ReferenceManager_2, e, EnumSet.of(ErrorEvent.PresentationHints.LOG, ErrorEvent.PresentationHints.BLOCK), true);
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public void requestTriggeredEnablement(Set<IResource> affectedResources, String triggerPoint, Map<String, String> arguments, IProgressMonitor monitor) {
        Assert.isNotNull(affectedResources, (String)Messages.ReferenceManager_5);
        if (this.isSuspended()) {
            return;
        }
        if (Logger.SHOULD_TRACE_REFERENCE_MANAGER) {
            Logger.trace(Logger.Category.REFERENCE_MANAGER, "TRIGGERED analysis by " + triggerPoint + " on " + affectedResources.size(), new Throwable[]{null});
        }
        if (triggerPoint == null) {
            Collection<IResource> resources = this.getResourcesAndChildren(affectedResources);
            ArrayList<ResourceChange> changes = new ArrayList<ResourceChange>(resources.size());
            for (IResource r : resources) {
                changes.add(new ResourceChange(r, 12));
            }
            this.requestChangeAnalysis(changes, monitor);
        } else {
            List<String> modelIds = LinkNodeModelService.getInstance().getTriggeredIds(triggerPoint, arguments);
            if (!modelIds.isEmpty()) {
                Collection<IResource> resources = this.getResourcesAndChildren(affectedResources);
                ArrayList<ResourceChange> changes = new ArrayList<ResourceChange>(resources.size());
                for (IResource r : resources) {
                    changes.add(new ResourceChange(r, 12));
                }
                this.requestChangeAnalysis(changes, monitor);
                return;
            }
            Set<String> linkTypes = LinkDetectorService.getInstance().getTriggeredLinkTypes(triggerPoint, arguments);
            linkTypes.addAll(LinkTransformerService.getInstance().getTriggeredLinkTypes(triggerPoint, arguments));
            Set<String> refTypes = ReferenceGeneratorService.getInstance().getTriggeredReferenceTypes(triggerPoint, arguments);
            refTypes.addAll(ReferenceResolverService.getInstance().getTriggeredReferenceTypes(triggerPoint, arguments));
            for (String refType : refTypes) {
                List<SpecializedType> specialTypes = ReferenceGeneratorService.getInstance().getLinkTypesForRef(refType);
                for (SpecializedType specializedType : specialTypes) {
                    linkTypes.add(specializedType.getId());
                }
            }
            modelIds.addAll(LinkDetectorService.getInstance().getModelProvidersIds(linkTypes));
            if (!modelIds.isEmpty()) {
                Collection<IResource> resources = this.getResourcesAndChildren(affectedResources);
                Iterator<IResource> iterator = resources.iterator();
                while (iterator.hasNext()) {
                    IResource r = iterator.next();
                    Set<String> mIds = LinkNodeModelService.getInstance().getNodeModelIds(r);
                    boolean found = false;
                    for (String m : mIds) {
                        if (!modelIds.contains(m)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    iterator.remove();
                }
                ArrayList<ResourceChange> changes = new ArrayList<ResourceChange>(resources.size());
                for (IResource r : resources) {
                    changes.add(new ResourceChange(r, 12));
                }
                this.requestChangeAnalysis(changes, monitor);
            }
        }
    }

    public void reset(IProgressMonitor monitor) {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        this.getAnnotationModelDocumentProvider().flushChanges((IProgressMonitor)mon.newChild(1));
        this.getReferenceProcessor().reset((IProgressMonitor)mon.newChild(1));
        if (monitor != null) {
            monitor.done();
        }
        InternalSearchEngine.COUNT.set(0);
    }

    public void scheduleMarkerJob() {
        this.getReferenceProcessor().getMarkerJob().doSchedule();
    }

    public void setAnnotationModelDocumentProvider(InternalAPI.AbstractAnnotationModelDocumentProvider provider) {
        if (this.provider != null) {
            Assert.isLegal((boolean)false, (String)"Provider already set");
        }
        this.provider = provider;
    }

    public void setFatalError() {
        this.setOverrideSuspendedFlag(true);
        this.error = true;
        InternalSearchEngine.removeCache();
    }

    public void setInitialized() {
        this.initialized.set(true);
        this.semaphore.release();
    }

    public void setOverrideSuspendedFlag(boolean override) {
        this.override = override;
        this.overrideSet = true;
    }

    protected void checkShutdown() {
        if (this.isShutdown()) {
            throw new RuntimeException("Indexer framework is shutting down");
        }
    }

    public void setShutdown(boolean shutdown) {
        this.shutdown = shutdown;
    }

    public void initiateShutdown() {
        this.shutdown(null);
    }

    public boolean shutdown(IProgressMonitor monitor) {
        File directory;
        File marker;
        IPath location;
        boolean cleanShutdown = true;
        try {
            cleanShutdown = this.getReferenceProcessor().shutdown(monitor);
        }
        catch (RuntimeException runtimeException) {
            cleanShutdown = false;
        }
        if (cleanShutdown) {
            try {
                ReferenceDatabase.getDefault().shutdown();
            }
            catch (RuntimeException runtimeException) {
                cleanShutdown = false;
            }
        }
        this.shutdown = true;
        if (cleanShutdown && this.isSuspended()) {
            cleanShutdown = false;
        }
        if (cleanShutdown && (location = Activator.getDefault().getStateLocation()) != null && (marker = new File(directory = location.toFile(), "workbench_crash_detector.marker")).exists()) {
            marker.delete();
        }
        InternalAPI.getExecutor().shutdown();
        try {
            boolean terminated = InternalAPI.getExecutor().awaitTermination(10L, TimeUnit.SECONDS);
            if (!terminated) {
                Logger.logWarning(Logger.Category.REFERENCE_MANAGER, Logger.Mode.USER, "Threads were still active at shutdown");
                cleanShutdown = false;
            }
        }
        catch (InterruptedException interruptedException) {
            Logger.logWarning(Logger.Category.REFERENCE_MANAGER, Logger.Mode.USER, "Shutdown process was interrupted");
            cleanShutdown = false;
        }
        if (Logger.SHOULD_TRACE_DEBUG) {
            Logger.trace(Logger.Category.DEBUG, "Database shutdown cleanly: " + cleanShutdown, new Throwable[]{null});
        }
        return cleanShutdown;
    }

    public void startQueue() {
        this.getReferenceProcessor().doSchedule(false);
    }

    private boolean tryLock() {
        boolean gotLock = false;
        boolean gotUIlock = false;
        try {
            try {
                gotUIlock = this.LOCK.acquire((long)InternalAPI.Tweaks.WAIT_TIME);
                gotLock = this.semaphore.tryAcquire(InternalAPI.Tweaks.WAIT_TIME, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                OperationCanceledException canceled = new OperationCanceledException();
                canceled.initCause((Throwable)e);
                throw canceled;
            }
        }
        finally {
            if (gotUIlock) {
                this.LOCK.release();
            }
        }
        return gotLock;
    }

    public void userInitiatedAccess() {
        this.getReferenceProcessor().setUserInitiated();
    }

    public void waitForIndexing(IProgressMonitor monitor, SearchScope scope) {
        if (!InternalSearchEngine.getHint().contains((Object)SearchEngine.SearchHint.NOWAIT)) {
            ReferenceDatabase.getDefault().cancelConvertIndexes();
            this.getReferenceProcessor().getScheduler().waitForIndexing(monitor, scope);
        }
    }

    @Deprecated
    public void waitUntilUptodate(IProgressMonitor monitor) {
        SearchScope scope = SearchEngine.createWorkspaceScope();
        this.getReferenceProcessor().getScheduler().waitForIndexing(monitor, scope);
    }

    @Deprecated
    public void waitUtilReady(IProgressMonitor monitor) {
        throw new RuntimeException("seriously, don't use this");
    }
}

